/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.livebizwrapper.utils;

import android.app.Activity;
import android.content.Context;
import android.content.res.Resources;
import android.os.Build;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.widget.LinearLayout;
import androidx.appcompat.widget.FitWindowsLinearLayout;
import com.yy.mobile.util.log.MLog;
import java.lang.reflect.Method;

public class NavigationBarUtils {
    public static final String TAG = "NavigationBarUtils";

    public static int getNavigationBarHeight(Context context) {
        int navigationBarHeight = 0;
        Resources rs = context.getResources();
        int id2 = rs.getIdentifier("navigation_bar_height", "dimen", "android");
        if (id2 > 0 && NavigationBarUtils.checkDeviceHasNavigationBar(context)) {
            navigationBarHeight = rs.getDimensionPixelSize(id2);
        }
        return navigationBarHeight;
    }

    public static boolean checkDeviceHasNavigationBar(Context context) {
        if (Build.VERSION.SDK_INT < 21) {
            return false;
        }
        boolean hasNavigationBar = false;
        Resources rs = context.getResources();
        int id2 = rs.getIdentifier("config_showNavigationBar", "bool", "android");
        if (id2 > 0) {
            hasNavigationBar = rs.getBoolean(id2);
        }
        try {
            Class<?> systemPropertiesClass = Class.forName("android.os.SystemProperties");
            Method m = systemPropertiesClass.getMethod("get", String.class);
            String navBarOverride = (String)m.invoke(systemPropertiesClass, "qemu.hw.mainkeys");
            if ("1".equals(navBarOverride)) {
                hasNavigationBar = false;
            } else if ("0".equals(navBarOverride)) {
                hasNavigationBar = true;
            }
        }
        catch (Exception e) {
            MLog.error((Object)TAG, (Throwable)e);
        }
        return hasNavigationBar;
    }

    public static boolean isNavigationBarOpen(Activity activity) {
        ViewGroup rootLinearLayout = NavigationBarUtils.findRootLinearLayout(activity);
        int navigationBarHeight = 0;
        if (rootLinearLayout != null) {
            ViewGroup.MarginLayoutParams layoutParams = (ViewGroup.MarginLayoutParams)rootLinearLayout.getLayoutParams();
            navigationBarHeight = layoutParams.bottomMargin;
        }
        return navigationBarHeight != 0;
    }

    private static ViewGroup findRootLinearLayout(Activity activity) {
        ViewGroup onlyLinearLayout;
        block6: {
            if (activity == null) {
                return null;
            }
            onlyLinearLayout = null;
            try {
                Window window = activity.getWindow();
                if (window == null) break block6;
                ViewGroup decorView = (ViewGroup)window.getDecorView();
                View contentView = activity.findViewById(0x1020002);
                if (contentView == null) break block6;
                View tempView = contentView;
                while (tempView.getParent() != decorView) {
                    ViewGroup parent = (ViewGroup)tempView.getParent();
                    if (parent instanceof LinearLayout) {
                        if (parent instanceof FitWindowsLinearLayout) {
                            tempView = parent;
                            continue;
                        }
                        onlyLinearLayout = parent;
                        break;
                    }
                    tempView = parent;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return onlyLinearLayout;
    }

    public static void solveNavigationBar(Window window) {
        MLog.info((String)TAG, (String)"solveNavigationBar:");
        int uiOptions = 1798;
        uiOptions = Build.VERSION.SDK_INT >= 19 ? (uiOptions |= 0x1000) : (uiOptions |= 1);
        window.getDecorView().setSystemUiVisibility(uiOptions);
    }
}

