/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.livebizwrapper.utils;

import android.app.ActivityManager;
import android.content.Context;
import android.content.pm.ConfigurationInfo;
import android.content.res.Resources;
import android.os.Build;
import com.yy.mobile.util.log.MLog;
import java.lang.reflect.Method;

public class CommonUtils {
    private static final String TAG = "CommonUtils";

    public static int length(String value) {
        int valueLength = 0;
        String chinese = "[\u0391-\uffe5]";
        for (int i = 0; i < value.length(); ++i) {
            String temp = value.substring(i, i + 1);
            if (temp.matches(chinese)) {
                valueLength += 2;
                continue;
            }
            ++valueLength;
        }
        return valueLength;
    }

    public static boolean isContainerChinese(String value) {
        String chinese = "[\u0391-\uffe5]";
        for (int i = 0; i < value.length(); ++i) {
            String temp = value.substring(i, i + 1);
            if (!temp.matches(chinese)) continue;
            return true;
        }
        return false;
    }

    public static boolean checkDeviceHasNavigationBar(Context context) {
        if (Build.VERSION.SDK_INT < 21) {
            return false;
        }
        boolean hasNavigationBar = false;
        Resources rs = context.getResources();
        int id2 = rs.getIdentifier("config_showNavigationBar", "bool", "android");
        if (id2 > 0) {
            hasNavigationBar = rs.getBoolean(id2);
        }
        try {
            Class<?> systemPropertiesClass = Class.forName("android.os.SystemProperties");
            Method m = systemPropertiesClass.getMethod("get", String.class);
            String navBarOverride = (String)m.invoke(systemPropertiesClass, "qemu.hw.mainkeys");
            if ("1".equals(navBarOverride)) {
                hasNavigationBar = false;
            } else if ("0".equals(navBarOverride)) {
                hasNavigationBar = true;
            }
        }
        catch (Exception e) {
            MLog.error((Object)TAG, (Throwable)e);
        }
        return hasNavigationBar;
    }

    public static int getNavigationBarHeight(Context context) {
        int navigationBarHeight = 0;
        Resources rs = context.getResources();
        int id2 = rs.getIdentifier("navigation_bar_height", "dimen", "android");
        if (id2 > 0 && CommonUtils.checkDeviceHasNavigationBar(context)) {
            navigationBarHeight = rs.getDimensionPixelSize(id2);
        }
        return navigationBarHeight;
    }

    public static int holdGLVersion(Context ctx) {
        ActivityManager am = (ActivityManager)ctx.getSystemService("activity");
        if (am != null) {
            ConfigurationInfo info = am.getDeviceConfigurationInfo();
            return info.reqGlEsVersion;
        }
        return 0;
    }
}

