/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.livebizwrapper.touch.swipeloadingview.subthread;

import android.content.Context;
import android.util.AttributeSet;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import com.yy.mobile.livebizwrapper.touch.swipeloadingview.subthread.CoverDrawThread;
import com.yy.mobile.livebizwrapper.touch.swipeloadingview.subthread.CoverPosInfo;
import com.yy.mobile.livebizwrapper.touch.swipeloadingview.subthread.ICoverDrawer;
import com.yy.mobile.livebizwrapper.touch.swipeloadingview.subthread.SwipeCoverDrawer;
import com.yy.mobile.util.log.MLog;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;

public class SwipeSurfaceView
extends SurfaceView
implements ICoverDrawer {
    private static final String TAG = "SwipeSurfaceView";
    private SurfaceHolder mSurfaceHolder;
    @Nullable
    private static CoverDrawThread mCoverDrawThread;
    private SwipeCoverDrawer mSwipeCoverDrawer;
    private final AtomicBoolean mIsSurfaceValid = new AtomicBoolean(false);

    public SwipeSurfaceView(Context context) {
        super(context);
        this.init(context);
    }

    public SwipeSurfaceView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    public SwipeSurfaceView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context);
    }

    public void hideCover() {
        MLog.info((String)TAG, (String)"hideCover");
        if (mCoverDrawThread != null) {
            mCoverDrawThread.hideCover();
        }
    }

    public void resetCover() {
        MLog.info((String)TAG, (String)"resetCover:");
        if (mCoverDrawThread != null) {
            mCoverDrawThread.resetCover();
        }
    }

    public void scrollSlide(CoverPosInfo posInfo) {
        if (mCoverDrawThread != null) {
            mCoverDrawThread.scrollSlide(posInfo);
        }
    }

    public void autoSlide(int velocity, int direction) {
        MLog.info((Object)TAG, (String)"autoSlide: velocity:%d, direction:%d", (Object[])new Object[]{velocity, direction});
        if (mCoverDrawThread != null) {
            mCoverDrawThread.autoSlide(velocity, direction);
        }
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        if (w > 0 && h > 0) {
            this.mSwipeCoverDrawer.setWidthHeight(w, h);
        }
    }

    private void init(Context context) {
        this.mSwipeCoverDrawer = new SwipeCoverDrawer(context);
        this.setZOrderOnTop(true);
        this.mSurfaceHolder = this.getHolder();
        this.mSurfaceHolder.setFormat(-3);
        this.mSurfaceHolder.addCallback(new SurfaceHolder.Callback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void surfaceCreated(SurfaceHolder surfaceHolder) {
                MLog.info((String)SwipeSurfaceView.TAG, (String)"initSurfaceHolder surfaceCreated");
                1 var2_2 = this;
                synchronized (var2_2) {
                    SwipeSurfaceView.this.mIsSurfaceValid.set(true);
                    if (mCoverDrawThread == null) {
                        MLog.info((String)SwipeSurfaceView.TAG, (String)"initSurfaceHolder surfaceCreated start CoverDrawThread");
                        mCoverDrawThread = new CoverDrawThread("SwipeSurfaceThread");
                        mCoverDrawThread.start();
                    }
                    mCoverDrawThread.setDrawer(SwipeSurfaceView.this);
                }
            }

            public void surfaceChanged(SurfaceHolder surfaceHolder, int i, int i1, int i2) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void surfaceDestroyed(SurfaceHolder surfaceHolder) {
                MLog.info((String)SwipeSurfaceView.TAG, (String)"initSurfaceHolder surfaceDestroyed");
                1 var2_2 = this;
                synchronized (var2_2) {
                    SwipeSurfaceView.this.mIsSurfaceValid.set(false);
                    if (mCoverDrawThread != null) {
                        MLog.info((String)SwipeSurfaceView.TAG, (String)"initSurfaceHolder surfaceDestroyed reset CoverDrawThread");
                        mCoverDrawThread.setDrawer(null);
                    }
                }
            }
        });
    }

    @Override
    public SwipeCoverDrawer getDrawer() {
        return this.mSwipeCoverDrawer;
    }

    @Override
    public SurfaceHolder getSurfaceHolder() {
        return this.mSurfaceHolder;
    }

    @Override
    public Object getCanvasLock() {
        return this;
    }

    @Override
    public boolean isSurfaceValid() {
        return this.mIsSurfaceValid.get();
    }
}

