/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.livebizwrapper.touch.swipeloadingview.subthread;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PorterDuff;
import android.graphics.Rect;
import com.yy.mobile.config.BasicConfig;
import com.yy.mobile.livebizwrapper.R;
import com.yy.mobile.livebizwrapper.touch.swipeloadingview.subthread.CoverPosInfo;
import com.yy.mobile.util.ResolutionUtils;
import com.yy.mobile.util.log.MLog;
import com.yy.mobile.util.taskexecutor.YYTaskExecutor;
import tv.athena.util.common.SizeUtils;

public class SwipeCoverDrawer {
    private static final String TAG = "SwipeCoverDrawer";
    public static final int DIRECTION_TO_TOP = 1;
    public static final int DIRECTION_TO_BOTTOM = 2;
    private CoverPosInfo mCurrentPos;
    private int mCoverWidth;
    private int mCoverHeight;
    private Context mContext;
    private Paint mCoverPaint;
    private Matrix coverMatrix = new Matrix();
    private Bitmap mCoverBitmap;
    private Paint mTextPaint;
    private int topTitleWidth = 0;
    private int bottomTitleWidth = 0;
    private float titleMargin = SizeUtils.dp2px((float)85.0f);
    private static final String topTitle = "\u4e0a\u62c9\u6362\u4e2a\u76f4\u64ad\u770b\u770b\uff5e";
    private static final String bottomTitle = "\u4e0b\u62c9\u6362\u4e2a\u76f4\u64ad\u770b\u770b\uff5e";
    private Paint mArrowPaint;
    private Path topArrowPath = new Path();
    private Path bottomArrowPath = new Path();
    private float arrowMargin = SizeUtils.dp2px((float)45.0f);
    private Paint mCirclePaint;
    private int mCircleAnimationTime = 0;
    private float circleMargin = SizeUtils.dp2px((float)30.0f);

    SwipeCoverDrawer(Context context) {
        this.mContext = context;
        this.initPaint();
        this.initTextWidth();
    }

    private void initPaint() {
        this.mCoverPaint = new Paint();
        this.mCoverPaint.setAntiAlias(true);
        this.mTextPaint = new Paint();
        this.mTextPaint.setDither(true);
        this.mTextPaint.setAntiAlias(true);
        this.mTextPaint.setColor(-1);
        this.mTextPaint.setTextSize((float)SizeUtils.dp2px((float)12.0f));
        this.mArrowPaint = new Paint();
        this.mArrowPaint.setStrokeWidth(2.0f);
        int color2 = BasicConfig.getInstance().getAppContext().getResources().getColor(R.color.main_theme_color);
        this.mArrowPaint.setColor(color2);
        this.mArrowPaint.setStyle(Paint.Style.STROKE);
        this.mArrowPaint.setStrokeCap(Paint.Cap.ROUND);
        this.mCirclePaint = new Paint();
        this.mCirclePaint.setStrokeWidth(5.0f);
        this.mCirclePaint.setColor(color2);
        this.mCirclePaint.setStrokeCap(Paint.Cap.ROUND);
    }

    private void initTextWidth() {
        Rect rect;
        if (this.topTitleWidth == 0) {
            rect = new Rect();
            this.mTextPaint.getTextBounds(topTitle, 0, topTitle.length(), rect);
            this.topTitleWidth = rect.width();
        }
        if (this.bottomTitleWidth == 0) {
            rect = new Rect();
            this.mTextPaint.getTextBounds(bottomTitle, 0, bottomTitle.length(), rect);
            this.bottomTitleWidth = rect.width();
        }
    }

    void setWidthHeight(int width, int height) {
        this.mCoverWidth = width;
        this.mCoverHeight = height;
        this.setupBitmap(width, height);
    }

    public int getCoverHeight() {
        if (this.mCoverHeight > 0) {
            return this.mCoverHeight;
        }
        return ResolutionUtils.getScreenHeight((Context)this.mContext);
    }

    CoverPosInfo getCurrentPos() {
        return this.mCurrentPos;
    }

    void hideCover(Canvas canvas) {
        MLog.info((String)TAG, (String)"hideCover: draw transparent");
        this.mCurrentPos = null;
        canvas.drawColor(0, PorterDuff.Mode.CLEAR);
    }

    void drawCover(Canvas canvas, CoverPosInfo posInfo) {
        if (posInfo == null) {
            return;
        }
        this.mCurrentPos = posInfo;
        canvas.concat(this.coverMatrix);
        if (posInfo.direction == 1) {
            float dy = posInfo.positionY;
            float center = (float)this.mCoverWidth / 2.0f;
            float titleDy = posInfo.positionY + this.titleMargin;
            float titleDx = (float)(this.mCoverWidth - this.topTitleWidth) / 2.0f;
            float arrowDy = posInfo.positionY + this.arrowMargin;
            float circleDy = posInfo.positionY + this.circleMargin;
            this.drawCover(canvas, dy);
            this.drawText(canvas, titleDx, titleDy, true);
            this.drawArrow(canvas, center, arrowDy, true);
            this.drawCircle(canvas, center, circleDy, true);
        } else if (posInfo.direction == 2) {
            float dy = (float)(-this.mCoverHeight) + posInfo.positionY;
            float center = (float)this.mCoverWidth / 2.0f;
            float titleDy = posInfo.positionY - this.titleMargin;
            float titleDx = (float)(this.mCoverWidth - this.bottomTitleWidth) / 2.0f;
            float arrowDy = posInfo.positionY - this.arrowMargin;
            float circleDy = posInfo.positionY - this.circleMargin + 5.0f;
            this.drawCover(canvas, dy);
            this.drawText(canvas, titleDx, titleDy, false);
            this.drawArrow(canvas, center, arrowDy, false);
            this.drawCircle(canvas, center, circleDy, false);
        }
        this.coverMatrix.reset();
    }

    private void setupBitmap(final int width, final int height) {
        if (this.mCoverBitmap != null) {
            MLog.info((String)TAG, (String)"setupBitmap: already setup");
            return;
        }
        if (width <= 0 || height <= 0) {
            MLog.info((String)TAG, (String)"setupBitmap: invalid width or height");
            return;
        }
        YYTaskExecutor.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                if (SwipeCoverDrawer.this.mCoverBitmap == null) {
                    try {
                        SwipeCoverDrawer.this.mCoverBitmap = BitmapFactory.decodeResource((Resources)SwipeCoverDrawer.this.mContext.getResources(), (int)R.drawable.live_room_swipe_bg);
                        SwipeCoverDrawer.this.mCoverBitmap = SwipeCoverDrawer.this.resizeImage(SwipeCoverDrawer.this.mCoverBitmap, width, height);
                        MLog.info((String)SwipeCoverDrawer.TAG, (String)"setupBitmap: bitmap setup finish");
                    }
                    catch (Throwable throwable) {
                        MLog.error((Object)SwipeCoverDrawer.TAG, (String)"setupBitmap decode or create bitmap fail ", (Throwable)throwable, (Object[])new Object[0]);
                    }
                }
            }
        });
    }

    public Bitmap resizeImage(Bitmap bitmap, int width, int height) {
        int bmpWidth = bitmap.getWidth();
        int bmpHeight = bitmap.getHeight();
        float scaleWidth = (float)width / (float)bmpWidth;
        float scaleHeight = (float)height / (float)bmpHeight;
        Matrix matrix = new Matrix();
        matrix.postScale(scaleWidth, scaleHeight);
        return Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bmpWidth, (int)bmpHeight, (Matrix)matrix, (boolean)true);
    }

    public void drawCover(Canvas canvas, float dy) {
        this.coverMatrix.postTranslate(0.0f, dy);
        if (this.mCoverBitmap != null) {
            canvas.drawBitmap(this.mCoverBitmap, this.coverMatrix, this.mCoverPaint);
        }
    }

    public void drawText(Canvas canvas, float dx, float dy, boolean isTop) {
        if (isTop) {
            canvas.drawText(topTitle, dx, dy, this.mTextPaint);
        } else {
            canvas.drawText(bottomTitle, dx, dy, this.mTextPaint);
        }
    }

    public void drawArrow(Canvas canvas, float dx, float dy, boolean isTop) {
        if (isTop) {
            this.topArrowPath.reset();
            this.topArrowPath.moveTo(dx, dy);
            this.topArrowPath.rLineTo(-11.0f, 11.0f);
            this.topArrowPath.moveTo(dx, dy);
            this.topArrowPath.rLineTo(11.0f, 11.0f);
            canvas.drawPath(this.topArrowPath, this.mArrowPaint);
        } else {
            this.bottomArrowPath.reset();
            this.bottomArrowPath.moveTo(dx, dy);
            this.bottomArrowPath.rLineTo(-11.0f, -11.0f);
            this.bottomArrowPath.moveTo(dx, dy);
            this.bottomArrowPath.rLineTo(11.0f, -11.0f);
            canvas.drawPath(this.bottomArrowPath, this.mArrowPaint);
        }
    }

    public void drawCircle(Canvas canvas, float dx, float dy, boolean isTop) {
        if (isTop) {
            int time = this.mCircleAnimationTime % 60;
            if (time >= 0 && time < 12) {
                this.mCirclePaint.setAlpha(76);
                canvas.drawCircle(dx, dy + 30.0f, 2.0f, this.mCirclePaint);
            } else if (time >= 12 && time < 24) {
                this.mCirclePaint.setAlpha(153);
                canvas.drawCircle(dx, dy + 30.0f, 2.0f, this.mCirclePaint);
                this.mCirclePaint.setAlpha(76);
                canvas.drawCircle(dx, dy + 15.0f, 2.0f, this.mCirclePaint);
            } else if (time >= 24 && time < 36) {
                this.mCirclePaint.setAlpha(229);
                canvas.drawCircle(dx, dy + 30.0f, 2.0f, this.mCirclePaint);
                this.mCirclePaint.setAlpha(153);
                canvas.drawCircle(dx, dy + 15.0f, 2.0f, this.mCirclePaint);
                this.mCirclePaint.setAlpha(76);
                canvas.drawCircle(dx, dy, 2.0f, this.mCirclePaint);
            } else if (time >= 36 && time < 48) {
                this.mCirclePaint.setAlpha(153);
                canvas.drawCircle(dx, dy + 30.0f, 2.0f, this.mCirclePaint);
                this.mCirclePaint.setAlpha(229);
                canvas.drawCircle(dx, dy + 15.0f, 2.0f, this.mCirclePaint);
                this.mCirclePaint.setAlpha(153);
                canvas.drawCircle(dx, dy, 2.0f, this.mCirclePaint);
            } else if (time >= 48) {
                this.mCirclePaint.setAlpha(76);
                canvas.drawCircle(dx, dy + 30.0f, 2.0f, this.mCirclePaint);
                this.mCirclePaint.setAlpha(153);
                canvas.drawCircle(dx, dy + 15.0f, 2.0f, this.mCirclePaint);
                this.mCirclePaint.setAlpha(229);
                canvas.drawCircle(dx, dy, 2.0f, this.mCirclePaint);
            }
        } else {
            int time = this.mCircleAnimationTime % 60;
            if (time >= 0 && time < 12) {
                this.mCirclePaint.setAlpha(76);
                canvas.drawCircle(dx, dy - 30.0f, 2.0f, this.mCirclePaint);
            } else if (time >= 12 && time < 24) {
                this.mCirclePaint.setAlpha(153);
                canvas.drawCircle(dx, dy - 30.0f, 2.0f, this.mCirclePaint);
                this.mCirclePaint.setAlpha(76);
                canvas.drawCircle(dx, dy - 15.0f, 2.0f, this.mCirclePaint);
            } else if (time >= 24 && time < 36) {
                this.mCirclePaint.setAlpha(229);
                canvas.drawCircle(dx, dy - 30.0f, 2.0f, this.mCirclePaint);
                this.mCirclePaint.setAlpha(153);
                canvas.drawCircle(dx, dy - 15.0f, 2.0f, this.mCirclePaint);
                this.mCirclePaint.setAlpha(76);
                canvas.drawCircle(dx, dy, 2.0f, this.mCirclePaint);
            } else if (time >= 36 && time < 48) {
                this.mCirclePaint.setAlpha(153);
                canvas.drawCircle(dx, dy - 30.0f, 2.0f, this.mCirclePaint);
                this.mCirclePaint.setAlpha(229);
                canvas.drawCircle(dx, dy - 15.0f, 2.0f, this.mCirclePaint);
                this.mCirclePaint.setAlpha(153);
                canvas.drawCircle(dx, dy, 2.0f, this.mCirclePaint);
            } else if (time >= 48) {
                this.mCirclePaint.setAlpha(76);
                canvas.drawCircle(dx, dy - 30.0f, 2.0f, this.mCirclePaint);
                this.mCirclePaint.setAlpha(153);
                canvas.drawCircle(dx, dy - 15.0f, 2.0f, this.mCirclePaint);
                this.mCirclePaint.setAlpha(229);
                canvas.drawCircle(dx, dy, 2.0f, this.mCirclePaint);
            }
        }
        ++this.mCircleAnimationTime;
        if (this.mCircleAnimationTime >= 2147483347) {
            this.mCircleAnimationTime = 0;
        }
    }
}

