/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.livebizwrapper.touch.swipeloadingview.subthread;

import android.animation.Animator;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.graphics.Canvas;
import android.graphics.PorterDuff;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Message;
import android.view.animation.LinearInterpolator;
import com.yy.mobile.livebizwrapper.touch.swipeloadingview.subthread.CoverActionState;
import com.yy.mobile.livebizwrapper.touch.swipeloadingview.subthread.CoverPosInfo;
import com.yy.mobile.livebizwrapper.touch.swipeloadingview.subthread.ICoverDrawer;
import com.yy.mobile.livebizwrapper.touch.swipeloadingview.subthread.SwipeCoverDrawer;
import com.yy.mobile.util.exception.ExceptionUtil;
import com.yy.mobile.util.log.MLog;
import java.util.concurrent.atomic.AtomicReference;

public class CoverDrawThread
extends HandlerThread {
    private static final String TAG = "CoverDrawThread";
    private static final int MSG_SCROLL_COVER = 3;
    private static final int MSG_UPDATE_SWIPE_POS = 4;
    private static final int MSG_AUTO_SLIDE = 5;
    private static final int MSG_HIDE_COVER = 6;
    private static final int MSG_RESET_COVER = 7;
    private static final int MSG_SURFACE_DESTROY = 8;
    private static final int MAX_AUTO_SLIDE_MILLIS = 100;
    private Handler mDrawThreadHandler;
    private ValueAnimator mUpdateAnimator;
    private float autoSlideVelocity;
    private int autoSlideDirection;
    private boolean isReset;
    private CoverPosInfo mCurScrollPosInfo;
    private AtomicReference<CoverActionState> mActionState = new AtomicReference<CoverActionState>(CoverActionState.HIDE);
    private volatile ICoverDrawer mICoverDrawer;
    private int animFrameCount;

    CoverDrawThread(String name) {
        super(name, 19);
        MLog.info((String)TAG, (String)("CoverDrawThread called with: name = [" + name + "]"));
        this.setCoverState(CoverActionState.HIDE);
        this.initUpdateAnimator();
    }

    void setDrawer(ICoverDrawer coverDrawer) {
        this.mICoverDrawer = coverDrawer;
        if (coverDrawer == null && this.mDrawThreadHandler != null) {
            this.setCoverState(CoverActionState.HIDE);
            Message msg = Message.obtain();
            msg.what = 8;
            this.mDrawThreadHandler.sendMessage(msg);
        }
    }

    void scrollSlide(CoverPosInfo posInfo) {
        if (this.mDrawThreadHandler != null) {
            if (CoverActionState.SCROLL.equals((Object)this.mActionState.get())) {
                this.mCurScrollPosInfo = posInfo;
            } else if (CoverActionState.HIDE.equals((Object)this.mActionState.get())) {
                MLog.info((String)TAG, (String)"scrollSlide: begin scroll");
                Message msg = Message.obtain();
                msg.what = 3;
                msg.obj = posInfo;
                this.mDrawThreadHandler.sendMessage(msg);
            } else {
                MLog.error((Object)TAG, (String)"scrollSlide: error state:%s", (Object[])new Object[]{this.mActionState.get()});
            }
        }
    }

    void autoSlide(int velocity, int direction) {
        if (this.mDrawThreadHandler != null) {
            this.mCurScrollPosInfo = null;
            Message msg = Message.obtain();
            msg.what = 5;
            msg.arg1 = velocity;
            msg.arg2 = direction;
            this.mDrawThreadHandler.sendMessage(msg);
        }
    }

    void hideCover() {
        if (CoverActionState.HIDE.equals((Object)this.mActionState.get())) {
            return;
        }
        if (this.mDrawThreadHandler != null) {
            this.setCoverState(CoverActionState.HIDE);
            Message msg = Message.obtain();
            msg.what = 6;
            this.mDrawThreadHandler.sendMessage(msg);
        }
    }

    void resetCover() {
        if (CoverActionState.HIDE.equals((Object)this.mActionState.get())) {
            return;
        }
        if (this.mDrawThreadHandler != null) {
            this.mCurScrollPosInfo = null;
            Message msg = Message.obtain();
            msg.what = 7;
            this.mDrawThreadHandler.sendMessage(msg);
        }
    }

    private void updateSwipePos(CoverPosInfo posInfo) {
        if (posInfo == null) {
            return;
        }
        if (CoverActionState.HIDE.equals((Object)this.mActionState.get())) {
            MLog.info((String)TAG, (String)"updateSwipePos: do nothing on hide state");
            return;
        }
        if (this.mDrawThreadHandler != null) {
            Message msg = Message.obtain();
            msg.what = 4;
            msg.obj = posInfo;
            this.mDrawThreadHandler.sendMessage(msg);
        }
    }

    private void setCoverState(CoverActionState state) {
        if (!this.mActionState.get().equals((Object)state)) {
            MLog.info((Object)TAG, (String)"setCoverState: %s to %s", (Object[])new Object[]{this.mActionState.get(), state});
        }
        this.mActionState.getAndSet(state);
    }

    protected void onLooperPrepared() {
        super.onLooperPrepared();
        this.initHandler();
    }

    private void initUpdateAnimator() {
        this.mUpdateAnimator = ValueAnimator.ofFloat((float[])new float[]{0.0f, 1.0f});
        this.mUpdateAnimator.setInterpolator((TimeInterpolator)new LinearInterpolator());
        this.mUpdateAnimator.setDuration(1000L);
        this.mUpdateAnimator.setRepeatCount(-1);
        this.mUpdateAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator valueAnimator) {
                CoverDrawThread.this.animFrameCount++;
                if (CoverDrawThread.this.animFrameCount % 3 == 1) {
                    return;
                }
                if (CoverDrawThread.this.surfaceValid()) {
                    CoverDrawThread.this.doFrame();
                }
            }
        });
        this.mUpdateAnimator.addListener(new Animator.AnimatorListener(){

            public void onAnimationStart(Animator animation) {
                MLog.info((String)CoverDrawThread.TAG, (String)"onAnimationStart: ");
            }

            public void onAnimationEnd(Animator animation) {
                MLog.info((String)CoverDrawThread.TAG, (String)"onAnimationEnd: ");
            }

            public void onAnimationCancel(Animator animation) {
                MLog.info((String)CoverDrawThread.TAG, (String)"onAnimationCancel: ");
            }

            public void onAnimationRepeat(Animator animation) {
            }
        });
    }

    private void initHandler() {
        MLog.info((String)TAG, (String)"initHandler: ");
        this.mDrawThreadHandler = new Handler(this.getLooper()){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             * Converted monitor instructions to comments
             * Lifted jumps to return sites
             */
            public void handleMessage(Message msg) {
                ICoverDrawer iCoverDrawer;
                super.handleMessage(msg);
                MLog.debug((String)CoverDrawThread.TAG, (String)("handleMessage: what:" + msg.what));
                if (msg.what == 8) {
                    MLog.info((String)CoverDrawThread.TAG, (String)"handleMessage: cancel mUpdateAnimator");
                    CoverDrawThread.this.setCoverState(CoverActionState.HIDE);
                    CoverDrawThread.this.mUpdateAnimator.cancel();
                }
                if (!CoverDrawThread.this.surfaceValid(iCoverDrawer = CoverDrawThread.this.mICoverDrawer)) {
                    return;
                }
                Object object = iCoverDrawer.getCanvasLock();
                // MONITORENTER : object
                if (!CoverDrawThread.this.surfaceValid(iCoverDrawer)) {
                    // MONITOREXIT : object
                    return;
                }
                Canvas canvas = null;
                try {
                    canvas = iCoverDrawer.getSurfaceHolder().lockCanvas();
                    SwipeCoverDrawer drawer = iCoverDrawer.getDrawer();
                    if (canvas == null) return;
                    canvas.drawColor(0, PorterDuff.Mode.CLEAR);
                    switch (msg.what) {
                        case 3: {
                            CoverDrawThread.this.setCoverState(CoverActionState.SCROLL);
                            if (!CoverDrawThread.this.mUpdateAnimator.isStarted()) {
                                MLog.info((String)CoverDrawThread.TAG, (String)"handleMessage1: start anim");
                                CoverDrawThread.this.mUpdateAnimator.start();
                            }
                            drawer.drawCover(canvas, (CoverPosInfo)msg.obj);
                            return;
                        }
                        case 4: {
                            if (!CoverActionState.HIDE.equals(CoverDrawThread.this.mActionState.get())) {
                                drawer.drawCover(canvas, (CoverPosInfo)msg.obj);
                                return;
                            }
                            MLog.error((String)CoverDrawThread.TAG, (String)"handleMessage: ignore MSG_UPDATE_SWIPE_POS, current is hide state");
                            return;
                        }
                        case 5: {
                            if (CoverActionState.HIDE.equals(CoverDrawThread.this.mActionState.get())) {
                                MLog.info((String)CoverDrawThread.TAG, (String)"MSG_AUTO_SLIDE no scroll");
                                if (!CoverDrawThread.this.mUpdateAnimator.isStarted()) {
                                    MLog.info((String)CoverDrawThread.TAG, (String)"handleMessage2: start anim");
                                    CoverDrawThread.this.mUpdateAnimator.start();
                                }
                            }
                            CoverDrawThread.this.setCoverState(CoverActionState.FLING);
                            CoverPosInfo pos = drawer.getCurrentPos();
                            if (pos == null) {
                                int positionY = msg.arg2 == 1 ? drawer.getCoverHeight() : 0;
                                pos = new CoverPosInfo(positionY, msg.arg2);
                            }
                            drawer.drawCover(canvas, pos);
                            CoverDrawThread.this.autoSlideDraw(false, drawer, msg.arg1, msg.arg2);
                            return;
                        }
                        case 6: {
                            CoverDrawThread.this.setCoverState(CoverActionState.HIDE);
                            drawer.hideCover(canvas);
                            CoverDrawThread.this.mUpdateAnimator.cancel();
                            return;
                        }
                        case 7: {
                            CoverDrawThread.this.setCoverState(CoverActionState.RESET);
                            CoverPosInfo pos = drawer.getCurrentPos();
                            drawer.drawCover(canvas, pos);
                            if (pos == null) return;
                            CoverDrawThread.this.autoSlideDraw(true, drawer, 0, pos.direction);
                            return;
                        }
                    }
                    return;
                }
                catch (Exception ex) {
                    ExceptionUtil.throwOrWriteLog((String)CoverDrawThread.TAG, (String)"handleMessage:%d, exception:%s", (Object[])new Object[]{msg.what, ex});
                    return;
                }
                finally {
                    try {
                        if (canvas != null) {
                            iCoverDrawer.getSurfaceHolder().unlockCanvasAndPost(canvas);
                        }
                    }
                    catch (Exception ex) {
                        MLog.error((Object)CoverDrawThread.TAG, (String)"unlockCanvasAndPost failed", (Throwable)ex, (Object[])new Object[0]);
                    }
                }
            }
        };
    }

    public void doFrame() {
        MLog.debug((Object)TAG, (String)"doFrame: mCurScrollPosInfo:%s, state:%s", (Object[])new Object[]{this.mCurScrollPosInfo, this.mActionState.get()});
        if (CoverActionState.SCROLL.equals((Object)this.mActionState.get())) {
            this.updateSwipePos(this.mCurScrollPosInfo);
        } else if (CoverActionState.FLING.equals((Object)this.mActionState.get()) || CoverActionState.RESET.equals((Object)this.mActionState.get())) {
            ICoverDrawer iCoverDrawer = this.mICoverDrawer;
            if (!this.surfaceValid(iCoverDrawer)) {
                MLog.debug((String)TAG, (String)"doFrame: null mICoverDrawer");
                return;
            }
            SwipeCoverDrawer drawer = iCoverDrawer.getDrawer();
            float legalVelocity = Math.abs(this.autoSlideVelocity);
            float velocityPerFps = legalVelocity * 16.0f;
            if (velocityPerFps <= 0.0f) {
                velocityPerFps = 1.0f;
            }
            int coverHeight = drawer.getCoverHeight();
            CoverPosInfo pos = drawer.getCurrentPos();
            float positionY = pos != null ? pos.positionY : (this.autoSlideDirection == 1 ? (float)coverHeight : 0.0f);
            MLog.debug((Object)TAG, (String)"doFrame: coverPos:%s, positionY:%f, direction:%d, velocityPerFps:%f", (Object[])new Object[]{pos, Float.valueOf(positionY), this.autoSlideDirection, Float.valueOf(velocityPerFps)});
            CoverPosInfo newPos = new CoverPosInfo(positionY, this.autoSlideDirection);
            boolean hasHideCover = false;
            if (newPos.direction == 1) {
                if (this.isReset) {
                    newPos.positionY += velocityPerFps;
                    if (newPos.positionY > (float)coverHeight) {
                        newPos.positionY = coverHeight;
                        this.hideCover();
                        hasHideCover = true;
                    }
                } else {
                    newPos.positionY -= velocityPerFps;
                    if (newPos.positionY < 0.0f) {
                        newPos.positionY = 0.0f;
                    }
                }
            } else if (this.isReset) {
                newPos.positionY -= velocityPerFps;
                if (newPos.positionY < 0.0f) {
                    newPos.positionY = 0.0f;
                    this.hideCover();
                    hasHideCover = true;
                }
            } else {
                newPos.positionY += velocityPerFps;
                if (newPos.positionY > (float)coverHeight) {
                    newPos.positionY = coverHeight;
                }
            }
            if (!hasHideCover) {
                this.updateSwipePos(newPos);
            } else {
                MLog.error((Object)TAG, (String)"doFrame: has hide cover, ignore update swipe pos, new pos: %s", (Object[])new Object[]{newPos});
            }
        }
    }

    private void autoSlideDraw(boolean reset, SwipeCoverDrawer drawer, int velocity, int direction) {
        this.autoSlideDirection = direction;
        this.isReset = reset;
        this.autoSlideVelocity = reset ? this.getResetVelocity(drawer, direction) : (float)this.modifyVelocity(drawer, velocity, direction);
        MLog.debug((Object)TAG, (String)"autoSlideDraw: reset:%b, velocity:%d, modifiedVelocity:%f, direction:%d", (Object[])new Object[]{reset, velocity, Float.valueOf(this.autoSlideVelocity), direction});
    }

    private int modifyVelocity(SwipeCoverDrawer drawer, int velocity, int direction) {
        if (drawer == null) {
            MLog.info((String)TAG, (String)"modifyVelocity: null drawer");
            return 0;
        }
        CoverPosInfo pos = drawer.getCurrentPos();
        float slideDistance = direction == 1 ? (pos != null ? pos.positionY : (float)drawer.getCoverHeight()) : (pos != null ? (float)drawer.getCoverHeight() - pos.positionY : (float)drawer.getCoverHeight());
        float minVelocity = slideDistance / 100.0f;
        float fingerVelocity = (float)Math.abs(velocity) / 1000.0f;
        return (int)Math.max(minVelocity, fingerVelocity);
    }

    private float getResetVelocity(SwipeCoverDrawer drawer, int direction) {
        if (drawer == null) {
            MLog.info((String)TAG, (String)"getResetVelocity: null drawer");
            return 0.0f;
        }
        CoverPosInfo pos = drawer.getCurrentPos();
        float slideDistance = direction == 1 ? (pos != null ? (float)drawer.getCoverHeight() - pos.positionY : (float)drawer.getCoverHeight() / 3.0f) : (pos != null ? pos.positionY : (float)drawer.getCoverHeight() / 3.0f);
        float disRatio = slideDistance / (float)drawer.getCoverHeight();
        int duration = (int)((disRatio + 1.0f) * 100.0f);
        return slideDistance / (float)duration;
    }

    private boolean surfaceValid(ICoverDrawer drawer) {
        return drawer != null && drawer.isSurfaceValid();
    }

    private boolean surfaceValid() {
        ICoverDrawer drawer = this.mICoverDrawer;
        return drawer != null && drawer.isSurfaceValid();
    }
}

