/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.livebizwrapper.touch.swipeloadingview;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ObjectAnimator;
import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.content.res.Configuration;
import android.graphics.Canvas;
import android.util.AttributeSet;
import android.util.Log;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.View;
import android.widget.TextView;
import androidx.core.view.ViewCompat;
import com.yy.mobile.livebizwrapper.R;
import com.yy.mobile.livebizwrapper.touch.BrightnessAndVolumnSetter;
import com.yy.mobile.livebizwrapper.touch.ITouchCore;
import com.yy.mobile.livebizwrapper.touch.swipeloadingview.OnSwipeListener;
import com.yy.mobile.ui.widget.toast.Toast;
import com.yy.mobile.util.ResolutionUtils;
import com.yy.mobile.util.log.MLog;
import com.yymobile.core.CoreFactory;
import java.util.concurrent.atomic.AtomicBoolean;

public class SwipeDetectorView
extends View {
    public static final String TAG = "SwipeDetectorLayout";
    private ITouchEventProxy iTouchEventProxy;
    private OnSwipeListener mOnSwipeListener;
    private AtomicBoolean isCreated = new AtomicBoolean();
    private View mMaskView;
    private View mTranslateView;
    private float mSwipeXRatio;
    private float mSwipeYRatio;
    private int mMinimumThreshold = 100;
    private int mMaximumThreshold = 200;
    private int mTopLimitSwipeHeight = 0;
    private int mBottomLimitSwipeHeight = 0;
    private int mMinimumLandScapeThreshold = 20;
    private int mMaximumLandScapeThreshold = 1080;
    private int screenWidth = 1080;
    private int screenHeight = 1920;
    private int vTrackerThreshold = 3000;
    private float mYpre = 0.0f;
    private float mXpre = 0.0f;
    private float mYdown = 0.0f;
    private float mXdown = 0.0f;
    private int mDirection = -1;
    private boolean isBeginSwipe = false;
    private boolean isMultiTouch = false;
    private boolean isHasActionDown = false;
    private boolean isBeginSwipeLandScape = false;
    private View mTipContainer;
    private TextView mTipTextView;
    private float mSwipeXRatioThreshold = 0.2f;
    private float mSwipeRatioThreshold;
    private int mDuration = 200;
    private int mWorkingMode = 2;
    private boolean mIsEnable = true;
    private boolean mHorizontalTouchEnable = true;
    private boolean mVerticalTouchEnable = true;
    private int currentPosition = -1;
    private VelocityTracker vTracker = null;
    private boolean ismIsIntercept = false;
    private GestureDetector mGestureDetector;
    private Animator.AnimatorListener mTranslationXLeftAnimatorListener;
    private Animator.AnimatorListener mTranslationXRightAnimatorListener;
    private boolean disableSwipeToRight = false;
    private boolean disableSwipeToUpOrDown = false;
    private boolean isLandscape = false;
    private boolean mEnableSwipe = true;
    private BrightnessAndVolumnSetter.VolumeSetter mVolumeSetter;
    private BrightnessAndVolumnSetter.BrightnessSetter mBrightnessSetter;
    private float mMaxDistance = 0.0f;

    public SwipeDetectorView(Context context) {
        super(context);
        this.init();
    }

    public SwipeDetectorView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public SwipeDetectorView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    @TargetApi(value=21)
    public SwipeDetectorView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init();
    }

    public void setDisableSwipeToRight(boolean mDisable) {
        this.disableSwipeToRight = mDisable;
    }

    public void setDisableSwipeToUpOrDown(boolean disableSwipeToUpOrDown) {
        this.disableSwipeToUpOrDown = disableSwipeToUpOrDown;
    }

    private void init() {
        this.isCreated.set(false);
        this.mSwipeRatioThreshold = 0.25f;
        this.mTopLimitSwipeHeight = this.getResources().getDimensionPixelSize(R.dimen.biz_basic_func_program_info_height);
        boolean bl = this.isLandscape = this.getResources().getConfiguration().orientation == 2;
        if (this.getContext() != null) {
            this.mMinimumThreshold = (int)ResolutionUtils.convertDpToPixel((float)20.0f, (Context)this.getContext());
            this.mMaximumThreshold = (int)ResolutionUtils.convertDpToPixel((float)70.0f, (Context)this.getContext());
            this.mBottomLimitSwipeHeight = ResolutionUtils.getScreenHeight((Context)this.getContext()) - this.getResources().getDimensionPixelSize(R.dimen.biz_basic_interactive_expand_height);
            this.screenWidth = this.getScreenWidth(this.getContext());
            this.screenHeight = ResolutionUtils.getScreenHeight((Context)this.getContext());
        }
        this.iTouchEventProxy = new ITouchEventProxy(){

            @Override
            public int getMinimumThreshold() {
                Log.i((String)SwipeDetectorView.TAG, (String)("[getThreshold] mMinimumThreshold =" + SwipeDetectorView.this.mMinimumThreshold));
                return SwipeDetectorView.this.mMinimumThreshold;
            }

            @Override
            public int getMaximumThreshold() {
                Log.i((String)SwipeDetectorView.TAG, (String)("[getThreshold] threshold =" + SwipeDetectorView.this.mMaximumThreshold));
                return SwipeDetectorView.this.mMaximumThreshold;
            }

            @Override
            public void onPreTouch(int direction) {
                if (SwipeDetectorView.this.isLandscape && (direction == 1 || direction == 3) && SwipeDetectorView.this.mTipTextView != null) {
                    return;
                }
                Log.i((String)SwipeDetectorView.TAG, (String)("[onPreTouch] start swipe, direction = " + direction));
                if (direction == 1) {
                    SwipeDetectorView.this.resetLoadingViewPosition(2);
                }
                if (direction == 3) {
                    SwipeDetectorView.this.resetLoadingViewPosition(0);
                }
                if (SwipeDetectorView.this.mOnSwipeListener != null) {
                    SwipeDetectorView.this.mOnSwipeListener.setSwipeIntercetpTouch(true);
                    SwipeDetectorView.this.mOnSwipeListener.onSwipeStart(SwipeDetectorView.this.mDirection);
                }
            }

            @Override
            public void onTouchOffsetY(float offsetY, int direction) {
                if (SwipeDetectorView.this.mMaskView == null) {
                    Log.w((String)SwipeDetectorView.TAG, (String)"[onTouchOffsetY] mMaskView is null");
                    return;
                }
                if (SwipeDetectorView.this.isLandscape && SwipeDetectorView.this.mTipTextView != null) {
                    SwipeDetectorView.this.volumeAndBrightnessChange(offsetY);
                    return;
                }
                float targetTranslationY = SwipeDetectorView.this.mMaskView.getTranslationY() + offsetY;
                if (direction == 1) {
                    SwipeDetectorView.this.mSwipeYRatio = 1.0f - targetTranslationY / (float)SwipeDetectorView.this.getTotalHeight();
                    Log.d((String)SwipeDetectorView.TAG, (String)("[onTouchOffsetY] direction =" + direction));
                    Log.d((String)SwipeDetectorView.TAG, (String)("[onTouchOffsetY] mSwipeRatio =" + SwipeDetectorView.this.mSwipeYRatio));
                    Log.d((String)SwipeDetectorView.TAG, (String)("[onTouchOffsetY] offsetY =" + offsetY + " mMaskView.getTranslationY() = " + SwipeDetectorView.this.mMaskView.getTranslationY() + " targetTranslationY=" + targetTranslationY));
                    if (!SwipeDetectorView.this.isCanTouchOffsetY(targetTranslationY)) {
                        return;
                    }
                    if (offsetY < 0.0f && targetTranslationY < 0.0f) {
                        Log.i((String)SwipeDetectorView.TAG, (String)"[onTouchOffsetY] can not continue swipe up!");
                        SwipeDetectorView.this.resetLoadingViewPosition(1);
                        return;
                    }
                } else {
                    SwipeDetectorView.this.mSwipeYRatio = targetTranslationY / (float)SwipeDetectorView.this.getTotalHeight() + 1.0f;
                    Log.d((String)SwipeDetectorView.TAG, (String)("[onTouchOffsetY] direction =" + direction));
                    Log.d((String)SwipeDetectorView.TAG, (String)("[onTouchOffsetY] mSwipeRatio =" + SwipeDetectorView.this.mSwipeYRatio));
                    Log.d((String)SwipeDetectorView.TAG, (String)("[onTouchOffsetY] offsetY =" + offsetY + " mMaskView.getTranslationY() = " + SwipeDetectorView.this.mMaskView.getTranslationY() + " targetTranslationY=" + targetTranslationY));
                    if (!SwipeDetectorView.this.isCanTouchOffsetY(targetTranslationY)) {
                        return;
                    }
                    if (offsetY > 0.0f && targetTranslationY > (float)SwipeDetectorView.this.getTotalHeight()) {
                        Log.i((String)SwipeDetectorView.TAG, (String)"[onTouchOffsetY] can not continue swipe down!");
                        SwipeDetectorView.this.resetLoadingViewPosition(1);
                        return;
                    }
                }
                SwipeDetectorView.this.translateLoadingView(targetTranslationY);
                Log.d((String)SwipeDetectorView.TAG, (String)"[onTouchOffsetY] Notify swipe event's progress.");
                if (SwipeDetectorView.this.mOnSwipeListener != null) {
                    SwipeDetectorView.this.mOnSwipeListener.onSwiping(SwipeDetectorView.this.mSwipeYRatio, SwipeDetectorView.this.mDirection);
                }
            }

            @Override
            public void onPostTouch(int direction) {
                if (SwipeDetectorView.this.mMaskView == null) {
                    Log.w((String)SwipeDetectorView.TAG, (String)"[onPostTouch] mMaskView is null");
                    return;
                }
                if (SwipeDetectorView.this.isLandscape && (direction == 1 || direction == 3) && SwipeDetectorView.this.mTipTextView != null) {
                    SwipeDetectorView.this.mTipContainer.setVisibility(8);
                    return;
                }
                if (SwipeDetectorView.this.mOnSwipeListener != null) {
                    SwipeDetectorView.this.mOnSwipeListener.setSwipeIntercetpTouch(false);
                }
                if (SwipeDetectorView.this.mMaskView.getTranslationY() > (float)SwipeDetectorView.this.getTotalHeight()) {
                    Log.i((String)SwipeDetectorView.TAG, (String)"[onPostTouch] below the bottom end");
                    SwipeDetectorView.this.resetLoadingViewPosition(2);
                    if (SwipeDetectorView.this.mOnSwipeListener != null) {
                        SwipeDetectorView.this.mOnSwipeListener.onSwipeCanceled(SwipeDetectorView.this.mDirection);
                    }
                } else if (SwipeDetectorView.this.mMaskView.getTranslationY() < (float)(-SwipeDetectorView.this.getTotalHeight())) {
                    Log.i((String)SwipeDetectorView.TAG, (String)"[onPostTouch] above the top end");
                    SwipeDetectorView.this.resetLoadingViewPosition(0);
                    if (SwipeDetectorView.this.mOnSwipeListener != null) {
                        SwipeDetectorView.this.mOnSwipeListener.onSwipeCanceled(SwipeDetectorView.this.mDirection);
                    }
                } else if (SwipeDetectorView.this.mSwipeYRatio >= SwipeDetectorView.this.mSwipeRatioThreshold || SwipeDetectorView.this.vTracker != null && Math.abs(SwipeDetectorView.this.vTracker.getYVelocity()) >= (float)SwipeDetectorView.this.vTrackerThreshold && !SwipeDetectorView.this.disableSwipeToRight) {
                    if (SwipeDetectorView.this.mOnSwipeListener != null) {
                        SwipeDetectorView.this.mOnSwipeListener.onPostSwipe(SwipeDetectorView.this.mDirection);
                    }
                    SwipeDetectorView.this.showLoadingView(true, direction, (Animator.AnimatorListener)new AnimatorListenerAdapter(){

                        public void onAnimationEnd(Animator animation) {
                            SwipeDetectorView.this.ismIsIntercept = false;
                            Log.i((String)SwipeDetectorView.TAG, (String)"[onPostTouch] Swipe Finish");
                        }

                        public void onAnimationStart(Animator animation) {
                            SwipeDetectorView.this.ismIsIntercept = true;
                            super.onAnimationStart(animation);
                        }
                    });
                } else {
                    SwipeDetectorView.this.hideLoadingView(true, direction, (Animator.AnimatorListener)new AnimatorListenerAdapter(){

                        public void onAnimationEnd(Animator animation) {
                            SwipeDetectorView.this.ismIsIntercept = false;
                            Log.i((String)SwipeDetectorView.TAG, (String)"[onPostTouch] Swipe Cancel");
                            if (SwipeDetectorView.this.mOnSwipeListener != null) {
                                SwipeDetectorView.this.mOnSwipeListener.onSwipeCanceled(SwipeDetectorView.this.mDirection);
                            }
                        }

                        public void onAnimationStart(Animator animation) {
                            SwipeDetectorView.this.ismIsIntercept = true;
                            super.onAnimationStart(animation);
                        }
                    });
                }
            }

            @Override
            public void onSwipeToLeft() {
                if (SwipeDetectorView.this.mOnSwipeListener != null) {
                    SwipeDetectorView.this.mOnSwipeListener.onSwipeLandScape(0);
                }
            }

            @Override
            public void onSwipeToRight() {
                if (SwipeDetectorView.this.mOnSwipeListener != null) {
                    SwipeDetectorView.this.mOnSwipeListener.onSwipeLandScape(2);
                }
            }

            @Override
            public void onPreTouchX(int direction) {
                if (SwipeDetectorView.this.mTranslateView == null) {
                    return;
                }
                if (SwipeDetectorView.this.mOnSwipeListener != null) {
                    SwipeDetectorView.this.mOnSwipeListener.setSwipeIntercetpTouch(true);
                }
                if (SwipeDetectorView.this.getContext() != null) {
                    SwipeDetectorView.this.screenWidth = SwipeDetectorView.this.getScreenWidth(SwipeDetectorView.this.getContext());
                    SwipeDetectorView.this.screenHeight = ResolutionUtils.getScreenHeight((Context)SwipeDetectorView.this.getContext());
                } else {
                    SwipeDetectorView.this.screenWidth = SwipeDetectorView.this.getMeasuredWidth();
                    SwipeDetectorView.this.screenHeight = SwipeDetectorView.this.getMeasuredHeight();
                }
                if (direction == 0) {
                    if (SwipeDetectorView.this.mTranslateView != null && (SwipeDetectorView.this.mTranslateView.getVisibility() == 4 || SwipeDetectorView.this.mTranslateView.getVisibility() == 8) && ((ITouchCore)CoreFactory.getCore(ITouchCore.class)).getClearScreenSate()) {
                        SwipeDetectorView.this.currentPosition = 2;
                        SwipeDetectorView.this.resetTraslateViewPosition(3, false);
                        SwipeDetectorView.this.mTranslateView.setVisibility(0);
                        Log.d((String)SwipeDetectorView.TAG, (String)"resetTraslateViewPosition");
                    }
                    if (SwipeDetectorView.this.currentPosition != direction && SwipeDetectorView.this.mTranslateView != null && SwipeDetectorView.this.mTranslateView.getTranslationX() > 0.0f) {
                        SwipeDetectorView.this.resetTraslateViewPosition(3, false);
                        Log.d((String)SwipeDetectorView.TAG, (String)"resetTraslateViewPosition");
                    }
                }
                if (direction == 2) {
                    if (SwipeDetectorView.this.mTranslateView != null && (SwipeDetectorView.this.mTranslateView.getVisibility() == 4 || SwipeDetectorView.this.mTranslateView.getVisibility() == 8)) {
                        SwipeDetectorView.this.mTranslateView.setVisibility(0);
                    }
                    if (SwipeDetectorView.this.currentPosition != direction && SwipeDetectorView.this.mTranslateView != null && SwipeDetectorView.this.mTranslateView.getTranslationX() <= (float)SwipeDetectorView.this.screenWidth) {
                        SwipeDetectorView.this.resetTraslateViewPosition(4, false);
                    }
                }
                Log.d((String)SwipeDetectorView.TAG, (String)("[onPreTouchX] translate mTranslateView direction = " + direction));
                if (SwipeDetectorView.this.mOnSwipeListener != null) {
                    SwipeDetectorView.this.mOnSwipeListener.onSwipeStart(SwipeDetectorView.this.mDirection);
                }
            }

            @Override
            public void onTouchOffsetX(float offsetX, int direction) {
                if (SwipeDetectorView.this.mTranslateView == null) {
                    return;
                }
                if (direction == 0) {
                    SwipeDetectorView.this.mSwipeXRatio = 1.0f - Math.abs(SwipeDetectorView.this.mTranslateView.getTranslationX() + offsetX) / (float)SwipeDetectorView.this.screenWidth;
                    if (SwipeDetectorView.this.mTranslateView.getTranslationX() <= 0.0f) {
                        return;
                    }
                    SwipeDetectorView.this.translateView(SwipeDetectorView.this.mTranslateView, SwipeDetectorView.this.mTranslateView.getTranslationX() + offsetX, direction);
                    if (SwipeDetectorView.this.mOnSwipeListener != null && Math.abs(offsetX) > 2.0f) {
                        SwipeDetectorView.this.mOnSwipeListener.onSwipeDistance(SwipeDetectorView.this.mTranslateView.getTranslationX() + offsetX);
                    }
                }
                if (direction == 2) {
                    SwipeDetectorView.this.mSwipeXRatio = Math.abs(SwipeDetectorView.this.mTranslateView.getTranslationX() + offsetX) / (float)SwipeDetectorView.this.screenWidth;
                    if (SwipeDetectorView.this.disableSwipeToRight) {
                        return;
                    }
                    if (SwipeDetectorView.this.mTranslateView.getTranslationX() >= (float)SwipeDetectorView.this.screenWidth) {
                        return;
                    }
                    SwipeDetectorView.this.translateView(SwipeDetectorView.this.mTranslateView, SwipeDetectorView.this.mTranslateView.getTranslationX() + offsetX, direction);
                    if (SwipeDetectorView.this.mOnSwipeListener != null && Math.abs(offsetX) > 2.0f) {
                        SwipeDetectorView.this.mOnSwipeListener.onSwipeDistance(SwipeDetectorView.this.mTranslateView.getTranslationX() + offsetX);
                    }
                }
            }

            @Override
            public void onPostXTouch(int direction) {
                if (direction == 0) {
                    if (SwipeDetectorView.this.mSwipeXRatio < SwipeDetectorView.this.mSwipeXRatioThreshold) {
                        Log.d((String)SwipeDetectorView.TAG, (String)("[onPostXTouch] [4] translate mTranslateView, direction== " + direction + "mSwipeXRatio< mSwipeXRatioThreshold"));
                        if (SwipeDetectorView.this.mOnSwipeListener != null) {
                            SwipeDetectorView.this.mOnSwipeListener.setSwipeIntercetpTouch(false);
                        }
                        if (SwipeDetectorView.this.mOnSwipeListener != null) {
                            SwipeDetectorView.this.mOnSwipeListener.onSwipeDistance(SwipeDetectorView.this.screenWidth);
                        }
                        SwipeDetectorView.this.resetTraslateViewPosition(3, true);
                    } else {
                        Log.d((String)SwipeDetectorView.TAG, (String)("[onPostXTouch] [4] translate mTranslateView, direction== " + direction + "mSwipeXRatio > mSwipeXRatioThreshold"));
                        SwipeDetectorView.this.resetTraslateViewPosition(4, true);
                        SwipeDetectorView.this.iTouchEventProxy.onSwipeToLeft();
                        SwipeDetectorView.this.currentPosition = SwipeDetectorView.this.mDirection;
                    }
                }
                if (direction == 2) {
                    if (SwipeDetectorView.this.mSwipeXRatio < SwipeDetectorView.this.mSwipeXRatioThreshold) {
                        if (SwipeDetectorView.this.mOnSwipeListener != null) {
                            SwipeDetectorView.this.mOnSwipeListener.setSwipeIntercetpTouch(false);
                        }
                        if (SwipeDetectorView.this.mOnSwipeListener != null) {
                            SwipeDetectorView.this.mOnSwipeListener.onSwipeDistance(0.0f);
                        }
                        Log.d((String)SwipeDetectorView.TAG, (String)("[onPostXTouch] [4] translate mTranslateView, direction== " + direction + "mSwipeXRatio< mSwipeXRatioThreshold"));
                        SwipeDetectorView.this.resetTraslateViewPosition(4, true);
                        if (SwipeDetectorView.this.disableSwipeToRight) {
                            Toast.makeText((Context)SwipeDetectorView.this.getContext(), (CharSequence)"\u8be5\u76f4\u64ad\u95f4\u6682\u65f6\u4e0d\u652f\u6301\u6e05\u5c4f\u54e6", (int)0).show();
                        }
                    } else {
                        if (SwipeDetectorView.this.disableSwipeToRight) {
                            SwipeDetectorView.this.resetTraslateViewPosition(4, true);
                            Toast.makeText((Context)SwipeDetectorView.this.getContext(), (CharSequence)"\u8be5\u76f4\u64ad\u95f4\u6682\u65f6\u4e0d\u652f\u6301\u6e05\u5c4f\u54e6", (int)0).show();
                            return;
                        }
                        Log.d((String)SwipeDetectorView.TAG, (String)("[onPostXTouch] [4] translate mTranslateView, direction== " + direction + "mSwipeXRatio > mSwipeXRatioThreshold"));
                        SwipeDetectorView.this.resetTraslateViewPosition(3, true);
                        SwipeDetectorView.this.iTouchEventProxy.onSwipeToRight();
                        SwipeDetectorView.this.currentPosition = SwipeDetectorView.this.mDirection;
                    }
                }
            }

            @Override
            public void onPostYTouch(int direction) {
                if (SwipeDetectorView.this.isLandscape && (direction == 1 || direction == 3) && SwipeDetectorView.this.mTipTextView != null) {
                    return;
                }
                Log.d((String)SwipeDetectorView.TAG, (String)("onPostYTouch:" + direction));
                if (SwipeDetectorView.this.mOnSwipeListener != null) {
                    SwipeDetectorView.this.mOnSwipeListener.setSwipeIntercetpTouch(false);
                    SwipeDetectorView.this.mOnSwipeListener.onSwipeCanceled(direction);
                }
                if (direction == 1) {
                    SwipeDetectorView.this.resetLoadingViewPosition(2);
                } else if (direction == 3) {
                    SwipeDetectorView.this.resetLoadingViewPosition(0);
                }
                Toast.makeText((Context)SwipeDetectorView.this.getContext(), (CharSequence)"\u8be5\u76f4\u64ad\u95f4\u6682\u65f6\u4e0d\u652f\u6301\u4e0a\u4e0b\u6ed1\u52a8\u54e6", (int)0).show();
            }
        };
    }

    private int getScreenWidth(Context context) {
        int width = this.getWidth();
        if (width == 0) {
            width = ResolutionUtils.getScreenWidth((Context)context);
            Log.i((String)TAG, (String)(" width : " + width));
        }
        return width;
    }

    public void setCurrentPosition(int currentPosition) {
        this.currentPosition = currentPosition;
    }

    private void translateLoadingView(float translate) {
        if (this.mMaskView == null) {
            Log.w((String)TAG, (String)"[translateLoadingView] mMaskView is null");
            return;
        }
        Log.d((String)TAG, (String)("[translateLoadingView] translate mMaskView, translate= " + translate));
        ViewCompat.setTranslationY((View)this.mMaskView, (float)translate);
    }

    public void translateView(View view, float translate, int direction) {
        if (view == null) {
            Log.w((String)TAG, (String)"[translateView] translateView is null");
            return;
        }
        if (translate >= 0.0f && translate <= (float)this.screenWidth) {
            ViewCompat.setTranslationX((View)view, (float)translate);
            Log.d((String)TAG, (String)("[translateView] [3] translate translateView, translate= " + translate + " direction == " + direction));
        }
    }

    public void translateViewByAnim(View mTranslateView, float translate, int direction) {
        ObjectAnimator objectAnimator;
        if (mTranslateView == null) {
            Log.w((String)TAG, (String)"[translateView] translateView is null");
            return;
        }
        Log.d((String)TAG, (String)("[translateView] [3] translate translateView, translate= " + translate + " direction == " + direction));
        if (direction == 2) {
            objectAnimator = ObjectAnimator.ofFloat((Object)mTranslateView, (String)"translationX", (float[])new float[]{mTranslateView.getTranslationX(), 0.0f});
            objectAnimator.setDuration(180L);
            if (this.mTranslationXRightAnimatorListener != null) {
                objectAnimator.addListener(this.mTranslationXRightAnimatorListener);
            }
            objectAnimator.start();
        }
        if (direction == 0) {
            objectAnimator = ObjectAnimator.ofFloat((Object)mTranslateView, (String)"translationX", (float[])new float[]{mTranslateView.getTranslationX(), this.screenWidth});
            objectAnimator.setDuration(180L);
            if (this.mTranslationXLeftAnimatorListener != null) {
                objectAnimator.addListener(this.mTranslationXLeftAnimatorListener);
            }
            objectAnimator.start();
        }
    }

    public void hideLoadingView(boolean isShowAnimation, int direction, Animator.AnimatorListener listener2) {
        float targetTranslateY;
        if (this.mMaskView == null) {
            Log.w((String)TAG, (String)"[hideLoadingView] mMaskView is null");
            return;
        }
        Log.d((String)TAG, (String)("[hideLoadingView] isShowAnimation = " + isShowAnimation + " direction= " + direction));
        if (direction == -1) {
            if (listener2 != null) {
                listener2.onAnimationStart(null);
            }
            this.resetLoadingViewPosition(2);
            if (listener2 != null) {
                listener2.onAnimationEnd(null);
            }
            return;
        }
        if (direction == 1) {
            if (!isShowAnimation) {
                if (listener2 != null) {
                    listener2.onAnimationStart(null);
                }
                this.resetLoadingViewPosition(2);
                if (listener2 != null) {
                    listener2.onAnimationEnd(null);
                }
                return;
            }
            targetTranslateY = this.getTotalHeight();
        } else {
            if (!isShowAnimation) {
                if (listener2 != null) {
                    listener2.onAnimationStart(null);
                }
                this.resetLoadingViewPosition(0);
                if (listener2 != null) {
                    listener2.onAnimationEnd(null);
                }
                return;
            }
            targetTranslateY = -this.getTotalHeight();
        }
        ObjectAnimator objectAnimator = ObjectAnimator.ofFloat((Object)this.mMaskView, (String)"translationY", (float[])new float[]{this.mMaskView.getTranslationY(), targetTranslateY});
        objectAnimator.setDuration((long)this.mDuration);
        if (listener2 != null) {
            objectAnimator.addListener(listener2);
        }
        objectAnimator.start();
    }

    public void showLoadingView(boolean isShowAnimation, int direction, Animator.AnimatorListener listener2) {
        if (this.mMaskView == null) {
            Log.w((String)TAG, (String)"[showLoadingView] mMaskView is null");
            return;
        }
        Log.d((String)TAG, (String)("[showLoadingView] isShowAnimation = " + isShowAnimation + " direction= " + direction));
        if (direction == -1) {
            if (listener2 != null) {
                listener2.onAnimationStart(null);
            }
            this.resetLoadingViewPosition(1);
            if (listener2 != null) {
                listener2.onAnimationEnd(null);
            }
        }
        if (!isShowAnimation) {
            if (listener2 != null) {
                listener2.onAnimationStart(null);
            }
            this.resetLoadingViewPosition(1);
            if (listener2 != null) {
                listener2.onAnimationEnd(null);
            }
            return;
        }
        ObjectAnimator objectAnimator = ObjectAnimator.ofFloat((Object)this.mMaskView, (String)"translationY", (float[])new float[]{this.mMaskView.getTranslationY(), 0.0f});
        objectAnimator.setDuration((long)this.mDuration);
        if (listener2 != null) {
            objectAnimator.addListener(listener2);
        }
        objectAnimator.start();
    }

    private boolean isCanTouchOffsetY(float targetTranslationY) {
        if (this.disableSwipeToUpOrDown) {
            if (this.mSwipeYRatio > 0.15f) {
                return false;
            }
            this.translateLoadingView(targetTranslationY);
            Log.d((String)TAG, (String)"[onTouchOffsetY] Notify swipe event's progress.");
            if (this.mOnSwipeListener != null) {
                this.mOnSwipeListener.onSwiping(this.mSwipeYRatio, this.mDirection);
            }
            return false;
        }
        return true;
    }

    public void resetLoadingViewPosition() {
        this.resetLoadingViewPosition(0);
        if (this.currentPosition == 2) {
            this.screenWidth = this.getMeasuredWidth();
            this.screenHeight = this.getMeasuredHeight();
            Log.d((String)TAG, (String)("resetLoadingViewPosition  screenWidth ==" + this.screenWidth));
            this.resetTraslateViewPosition(3, false);
        }
    }

    private void resetLoadingViewPosition(int mode) {
        if (this.mMaskView == null) {
            Log.w((String)TAG, (String)"[resetLoadingViewPosition] mMaskView is null");
            return;
        }
        switch (mode) {
            case 0: {
                ViewCompat.setTranslationY((View)this.mMaskView, (float)(-this.getTotalHeight()));
                break;
            }
            case 1: {
                ViewCompat.setTranslationY((View)this.mMaskView, (float)0.0f);
                break;
            }
            case 2: {
                ViewCompat.setTranslationY((View)this.mMaskView, (float)this.getTotalHeight());
                break;
            }
        }
    }

    private void resetTraslateViewPosition(int mode, boolean isShowAnim) {
        if (this.mTranslateView == null) {
            Log.w((String)TAG, (String)"[resetTraslateViewPosition] mTranslateView is null");
            return;
        }
        Log.d((String)TAG, (String)("[resetTraslateViewPosition] [5] mode == " + mode + "isShowAnim == " + isShowAnim + "mTranslateView.getTranslationX() ==" + this.mTranslateView.getTranslationX()));
        switch (mode) {
            case 3: {
                if (isShowAnim) {
                    this.translateViewByAnim(this.mTranslateView, this.screenWidth, 0);
                    break;
                }
                this.translateView(this.mTranslateView, this.screenWidth, 0);
                break;
            }
            case 4: {
                if (isShowAnim) {
                    this.translateViewByAnim(this.mTranslateView, 0.0f, 2);
                    break;
                }
                this.translateView(this.mTranslateView, 0.0f, 2);
                break;
            }
        }
    }

    private int getTotalHeight() {
        return this.getMeasuredHeight();
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (!this.isCreated.get()) {
            this.hideLoadingView(false, -1, null);
            this.isCreated.set(true);
        }
    }

    public void setEnableSwipe(boolean enableSwipe) {
        this.mEnableSwipe = enableSwipe;
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (!this.mEnableSwipe) {
            this.iTouchEventProxy = null;
        }
        if (this.mGestureDetector != null) {
            this.mGestureDetector.onTouchEvent(event);
        }
        if (event.getPointerCount() > 1) {
            return true;
        }
        if (!this.mIsEnable) {
            return super.onTouchEvent(event);
        }
        if (this.iTouchEventProxy == null) {
            return super.onTouchEvent(event);
        }
        switch (event.getAction()) {
            case 0: {
                this.logEventInfo("ACTION_DOWN", event);
                this.mYdown = event.getY(0);
                this.mYpre = event.getY(0);
                this.mXdown = event.getX(0);
                this.mXpre = event.getX(0);
                if (this.mYdown <= (float)this.getTopLimitSwipeHeight() || this.mYdown > (float)this.getBottomLimitSwipeHeight()) {
                    return true;
                }
                if (this.vTracker == null) {
                    this.vTracker = VelocityTracker.obtain();
                } else {
                    this.vTracker.clear();
                    this.vTracker.addMovement(event);
                }
                this.mDirection = -1;
                this.isBeginSwipe = false;
                this.isHasActionDown = true;
                this.isBeginSwipeLandScape = false;
                break;
            }
            case 2: {
                this.logEventInfo("ACTION_MOVE", event);
                if (this.vTracker != null) {
                    this.vTracker.addMovement(event);
                    this.vTracker.computeCurrentVelocity(1000);
                }
                if (this.isBeginSwipe && !this.isBeginSwipeLandScape && !this.ismIsIntercept) {
                    if (!this.mVerticalTouchEnable) {
                        Log.d((String)TAG, (String)("[mVerticalTouchEnable] mVerticalTouchEnable = " + this.mVerticalTouchEnable));
                        break;
                    }
                    this.iTouchEventProxy.onTouchOffsetY(event.getY(0) - this.mYpre, this.mDirection);
                } else if (Math.abs(event.getY(0) - this.mYdown) >= (float)this.iTouchEventProxy.getMinimumThreshold() && Math.abs(event.getY(0) - this.mYdown) <= (float)this.iTouchEventProxy.getMaximumThreshold() && !this.isBeginSwipeLandScape && !this.ismIsIntercept) {
                    if (!this.mVerticalTouchEnable) {
                        Log.d((String)TAG, (String)("[mVerticalTouchEnable] first mVerticalTouchEnable == " + this.mVerticalTouchEnable));
                        break;
                    }
                    this.isBeginSwipeLandScape = false;
                    if (this.mWorkingMode == 2) {
                        this.mDirection = event.getY(0) <= this.mYdown ? 1 : 3;
                        this.iTouchEventProxy.onPreTouch(this.mDirection);
                        this.isBeginSwipe = true;
                        this.iTouchEventProxy.onTouchOffsetY(event.getY(0) - this.mYpre, this.mDirection);
                    } else if (this.mWorkingMode == 0) {
                        if (event.getY(0) <= this.mYdown) {
                            this.mDirection = 1;
                            this.iTouchEventProxy.onPreTouch(this.mDirection);
                            this.isBeginSwipe = true;
                            this.iTouchEventProxy.onTouchOffsetY(event.getY(0) - this.mYpre, this.mDirection);
                        }
                    } else if (event.getY(0) > this.mYdown) {
                        this.mDirection = 3;
                        this.iTouchEventProxy.onPreTouch(this.mDirection);
                        this.isBeginSwipe = true;
                        this.iTouchEventProxy.onTouchOffsetY(event.getY(0) - this.mYpre, this.mDirection);
                    }
                }
                if (!this.isBeginSwipe && this.isBeginSwipeLandScape) {
                    if (!this.mHorizontalTouchEnable) {
                        Log.d((String)TAG, (String)("[mHorizontalTouchEnable] mHorizontalTouchEnable = " + this.mHorizontalTouchEnable));
                        break;
                    }
                    if (this.mDirection == 2) {
                        this.iTouchEventProxy.onTouchOffsetX(event.getX(0) - this.mXpre, this.mDirection);
                    } else if (this.currentPosition != this.mDirection) {
                        this.iTouchEventProxy.onTouchOffsetX(event.getX(0) - this.mXpre, this.mDirection);
                    }
                } else if (Math.abs(event.getX(0) - this.mXdown) >= (float)this.mMinimumLandScapeThreshold && Math.abs(event.getX(0) - this.mXdown) <= (float)this.mMaximumLandScapeThreshold && !this.isBeginSwipe) {
                    if (!this.mHorizontalTouchEnable) {
                        Log.d((String)TAG, (String)("[mHorizontalTouchEnable] first mHorizontalTouchEnable == " + this.mHorizontalTouchEnable));
                        break;
                    }
                    if (event.getX(0) > this.mXdown) {
                        this.mDirection = 2;
                        this.iTouchEventProxy.onPreTouchX(this.mDirection);
                        this.isBeginSwipeLandScape = true;
                        this.iTouchEventProxy.onTouchOffsetX(event.getX(0) - this.mXpre, this.mDirection);
                    }
                    if (event.getX(0) <= this.mXdown) {
                        this.mDirection = 0;
                        this.iTouchEventProxy.onPreTouchX(this.mDirection);
                        this.isBeginSwipeLandScape = true;
                        this.iTouchEventProxy.onTouchOffsetX(event.getX(0) - this.mXpre, this.mDirection);
                    }
                }
                this.mXpre = event.getX(0);
                this.mYpre = event.getY(0);
                break;
            }
            default: {
                Log.i((String)TAG, (String)("Action = " + event.getAction()));
                this.logEventInfo("ACTION_OTHERS", event);
                if ((this.mDirection == 2 || this.mDirection == 0) && this.isBeginSwipeLandScape) {
                    this.iTouchEventProxy.onPostXTouch(this.mDirection);
                }
                this.mYdown = 0.0f;
                this.mYpre = 0.0f;
                this.mXdown = 0.0f;
                this.isHasActionDown = false;
                if ((this.mDirection == 1 || this.mDirection == 3) && this.disableSwipeToUpOrDown) {
                    this.iTouchEventProxy.onPostYTouch(this.mDirection);
                    if (this.vTracker != null) {
                        this.vTracker.clear();
                    }
                    return true;
                }
                if (this.isBeginSwipe) {
                    this.isBeginSwipe = false;
                    this.iTouchEventProxy.onPostTouch(this.mDirection);
                    return true;
                }
                if (this.isBeginSwipeLandScape) {
                    this.isBeginSwipeLandScape = false;
                    return true;
                }
                if (this.vTracker == null) break;
                this.vTracker.clear();
            }
        }
        return super.onTouchEvent(event);
    }

    public GestureDetector getGestureDetector() {
        return this.mGestureDetector;
    }

    public void setGestureDetector(GestureDetector mGestureDetector) {
        this.mGestureDetector = mGestureDetector;
    }

    private void logEventInfo(String type, MotionEvent event) {
        Log.d((String)TAG, (String)("[onTouchEvent][logEventInfo] " + type + " getY= " + event.getY(0) + "; getRawY=" + event.getRawY()));
    }

    public void onDestroyView() {
        this.resetLoadingViewPosition(2);
        this.mOnSwipeListener = null;
        this.mMaskView = null;
        this.mTranslateView = null;
        this.mTranslationXLeftAnimatorListener = null;
        this.mTranslationXRightAnimatorListener = null;
    }

    private void volumeAndBrightnessChange(float offset) {
        int value;
        float distance = this.mYpre + offset - this.mYdown;
        if (this.mXdown > (float)this.screenWidth / 2.0f) {
            if (this.mVolumeSetter == null) {
                this.mVolumeSetter = new BrightnessAndVolumnSetter.VolumeSetter(this.getContext());
            }
            value = Math.round(this.mVolumeSetter.changeVolume(this.mYdown, this.convertPix2Value(distance)) * 100.0f);
        } else {
            if (this.mBrightnessSetter == null) {
                this.mBrightnessSetter = new BrightnessAndVolumnSetter.BrightnessSetter((Activity)this.getContext());
            }
            value = Math.round(this.mBrightnessSetter.changeBrightness(this.mYdown, this.convertPix2Value(distance)) * 100.0f);
        }
        Log.d((String)TAG, (String)("TouchChange distance " + distance + " value = " + value));
        if (this.mTipTextView != null) {
            this.mTipContainer.setVisibility(0);
            this.mTipTextView.setCompoundDrawablesWithIntrinsicBounds(this.mXdown > (float)this.screenWidth / 2.0f ? R.drawable.icon_voice : R.drawable.icon_brigh, 0, 0, 0);
            this.mTipTextView.setText((CharSequence)String.format("%s%%", value));
        }
    }

    private float convertPix2Value(float f) {
        float rv;
        if (this.mMaxDistance == 0.0f) {
            this.mMaxDistance = (float)this.screenHeight * 1.5f;
        }
        return (rv = -f / this.mMaxDistance) > 1.0f ? 1.0f : (rv < -1.0f ? -1.0f : rv);
    }

    public void initTipView(View view) {
        this.mTipContainer = view;
        this.mTipTextView = (TextView)view.findViewById(R.id.swipe_text_control_tip);
    }

    public void setIsVolumeBrightness() {
        this.isLandscape = true;
    }

    public void setLoadingView(View loadingView) {
        this.mMaskView = loadingView;
    }

    public void setmTranslateView(View translateView) {
        this.mTranslateView = translateView;
        if (this.mTranslateView != null && ((ITouchCore)CoreFactory.getCore(ITouchCore.class)).getClearScreenSate()) {
            this.currentPosition = 2;
            this.mTranslateView.setVisibility(0);
            this.resetTraslateViewPosition(3, false);
        }
    }

    public void setTranslateXLeftAnimatorListener(Animator.AnimatorListener listener2) {
        this.mTranslationXLeftAnimatorListener = listener2;
    }

    public void setTranslateXRightAnimatorListener(Animator.AnimatorListener listener2) {
        this.mTranslationXRightAnimatorListener = listener2;
    }

    public int getDirection() {
        return this.mDirection;
    }

    public void setDirection(int direction) {
        this.mDirection = direction;
    }

    public void setAnimationDuration(int duration) {
        this.mDuration = duration;
    }

    public void setWorkingMode(int workingMode) {
        this.mWorkingMode = workingMode;
    }

    public void setEnable(boolean isEnable) {
        this.mIsEnable = isEnable;
    }

    public void setHorizontalTouchEnable(boolean mHorizontalTouchEnable) {
        this.mHorizontalTouchEnable = mHorizontalTouchEnable;
    }

    public void setVerticalTouchEnable(boolean mVerticalTouchEnable) {
        this.mVerticalTouchEnable = mVerticalTouchEnable;
    }

    public void setMinimumLandScapeThreshold(int minimumLandScapeThreshold) {
        this.mMinimumLandScapeThreshold = minimumLandScapeThreshold;
    }

    public void setMaximumLandScapeThreshold(int maximumLandScapeThreshold) {
        this.mMaximumLandScapeThreshold = maximumLandScapeThreshold;
    }

    public ITouchEventProxy getTouchEventProxy() {
        return this.iTouchEventProxy;
    }

    public OnSwipeListener getOnSwipeListener() {
        return this.mOnSwipeListener;
    }

    public void setOnSwipeListener(OnSwipeListener onSwipeListener) {
        this.mOnSwipeListener = onSwipeListener;
    }

    public int getTopLimitSwipeHeight() {
        Log.i((String)TAG, (String)("[getLimitSwipeHeight] mTopLimitSwipeHeight =" + this.mTopLimitSwipeHeight));
        return this.mTopLimitSwipeHeight;
    }

    public void setTopLimitSwipeHeight(int topLimitSwipeHeight) {
        this.mTopLimitSwipeHeight = topLimitSwipeHeight;
    }

    public int getBottomLimitSwipeHeight() {
        Log.i((String)TAG, (String)("[getLimitSwipeHeight] mBottomLimitSwipeHeight =" + this.mBottomLimitSwipeHeight));
        return this.mBottomLimitSwipeHeight;
    }

    public void setBottomLimitSwipeHeight(int topBottomSwipeHeight) {
        this.mBottomLimitSwipeHeight = topBottomSwipeHeight;
    }

    protected void onConfigurationChanged(Configuration newConfig) {
        try {
            super.onConfigurationChanged(newConfig);
            if (this.getResources().getConfiguration().orientation == 2) {
                this.isLandscape = true;
                if (this.getContext() != null) {
                    this.screenWidth = this.getScreenWidth(this.getContext());
                    this.screenHeight = ResolutionUtils.getScreenHeight((Context)this.getContext());
                    this.mTopLimitSwipeHeight = this.getResources().getDimensionPixelSize(R.dimen.biz_basic_func_program_info_height) / 4;
                    this.mBottomLimitSwipeHeight = ResolutionUtils.getScreenHeight((Context)this.getContext());
                } else {
                    this.screenWidth = this.getMeasuredWidth();
                    this.screenHeight = this.getMeasuredHeight();
                    this.mTopLimitSwipeHeight = this.getResources().getDimensionPixelSize(R.dimen.biz_basic_func_program_info_height) / 4;
                    this.mBottomLimitSwipeHeight = this.getMeasuredHeight();
                }
                Log.d((String)TAG, (String)("onConfigurationChanged Configuration.ORIENTATION_LANDSCAPE screenWidth = " + this.screenWidth));
            } else if (this.getResources().getConfiguration().orientation == 1) {
                this.isLandscape = false;
                if (this.getContext() != null) {
                    this.screenWidth = this.getScreenWidth(this.getContext());
                    this.screenHeight = ResolutionUtils.getScreenHeight((Context)this.getContext());
                    this.mTopLimitSwipeHeight = this.getResources().getDimensionPixelSize(R.dimen.biz_basic_func_program_info_height) / 3;
                    this.mBottomLimitSwipeHeight = ResolutionUtils.getScreenHeight((Context)this.getContext()) - this.getResources().getDimensionPixelSize(R.dimen.biz_basic_interactive_expand_height);
                } else {
                    this.screenWidth = this.getMeasuredWidth();
                    this.screenHeight = this.getMeasuredHeight();
                    this.mTopLimitSwipeHeight = this.getResources().getDimensionPixelSize(R.dimen.biz_basic_func_program_info_height) / 3;
                    this.mBottomLimitSwipeHeight = this.getMeasuredHeight() - this.getResources().getDimensionPixelSize(R.dimen.biz_basic_interactive_expand_height);
                }
                if (MLog.isLogLevelAboveDebug()) {
                    Log.d((String)TAG, (String)("onConfigurationChanged Configuration.ORIENTATION_PORTRAIT screenWidth = " + this.screenWidth));
                }
            }
        }
        catch (Throwable throwable) {
            Log.e((String)TAG, (String)"onConfigurationChanged error", (Throwable)throwable);
        }
    }

    public static interface ITouchEventProxy {
        public int getMinimumThreshold();

        public int getMaximumThreshold();

        public void onPreTouch(int var1);

        public void onTouchOffsetY(float var1, int var2);

        public void onPostTouch(int var1);

        public void onSwipeToLeft();

        public void onSwipeToRight();

        public void onPreTouchX(int var1);

        public void onTouchOffsetX(float var1, int var2);

        public void onPostXTouch(int var1);

        public void onPostYTouch(int var1);
    }
}

