/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.livebizwrapper.touch.swipeloadingview;

import android.content.Context;
import android.util.AttributeSet;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import android.view.animation.Interpolator;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.view.ViewCompat;
import com.yy.mobile.livebizwrapper.touch.swipeloadingview.ISwipe;
import com.yy.mobile.livebizwrapper.touch.swipeloadingview.SwipeDetector;
import com.yy.mobile.livebizwrapper.touch.swipeloadingview.SwipeViewDelegate;
import com.yy.mobile.livebizwrapper.touch.swipeloadingview.YYScroller;
import com.yy.mobile.util.log.MLog;

public class SwipeContentView
extends View
implements ISwipe {
    private static final String TAG = "[\u76f4\u64ad\u95f4\u6ed1\u52a8-SwipeContentView]";
    private static final int MAX_SETTLE_DURATION = 350;
    private static final int CENTER_POS = 1;
    private SwipeDetector swipeDetector;
    private YYScroller mScroller;
    private SwipeViewDelegate swipeViewDelegate;
    private GestureDetector.OnDoubleTapListener doubleTapListener;
    private boolean canScroll;
    private boolean isDraging;
    private boolean isFling;
    private boolean isFirstScrollAfterDown;
    private int mTouchDownScreen;
    private int currentHorizontalIndex = 1;
    private int currentVerticalIndex = 1;
    private Direction from;
    private Direction to;
    private View toView;
    private int fromEdge;
    private int toEdge;
    private int privateFlag = 15;
    private Direction originalFrom;
    private boolean mNeedAnimation = true;
    private int scrollCount = 0;
    private boolean isHasAdvancedChannel = false;
    private static final Interpolator sInterpolator = new Interpolator(){

        public float getInterpolation(float t) {
            return (t -= 1.0f) * t * t * t * t + 1.0f;
        }
    };

    public boolean onDoubleTapEvent(MotionEvent e) {
        if (this.doubleTapListener != null) {
            return this.doubleTapListener.onDoubleTapEvent(e);
        }
        return false;
    }

    public boolean onDoubleTap(MotionEvent e) {
        if (this.doubleTapListener != null) {
            return this.doubleTapListener.onDoubleTap(e);
        }
        return false;
    }

    public boolean onSingleTapConfirmed(MotionEvent e) {
        if (this.doubleTapListener != null) {
            return this.doubleTapListener.onSingleTapConfirmed(e);
        }
        return false;
    }

    public void enableDirection(Direction direction) {
        this.privateFlag |= direction.enableBitMask;
    }

    public void disableDirection(Direction direction) {
        this.privateFlag &= ~direction.enableBitMask;
    }

    public boolean isEnable(Direction direction) {
        if (direction != null) {
            return (this.privateFlag & direction.enableBitMask) == direction.enableBitMask;
        }
        return false;
    }

    public SwipeContentView(@NonNull Context context) {
        super(context);
        this.swipeDetector = new SwipeDetector(context, this);
        this.mScroller = new YYScroller(context, sInterpolator);
    }

    public SwipeContentView(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.swipeDetector = new SwipeDetector(context, this);
        this.mScroller = new YYScroller(context, sInterpolator);
    }

    public SwipeContentView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.swipeDetector = new SwipeDetector(context, this);
        this.mScroller = new YYScroller(context, sInterpolator);
    }

    public boolean onTouchEvent(MotionEvent event) {
        return this.swipeDetector.onTouchEvent(event);
    }

    @Override
    public void interuptByScrollOrientationChange(boolean isVertical) {
        MLog.debug((String)TAG, (String)"[\u7528\u6237\u8f6c\u5c4f\u6253\u65ad\u6ed1\u52a8]");
        this.mScroller.abortAnimation();
        this.computeScroll();
    }

    @Override
    public boolean onDragStart() {
        MLog.debug((String)TAG, (String)("[\u7528\u6237\u5f00\u59cb\u62d6\u62fd] from = " + (Object)((Object)this.from)));
        this.originalFrom = this.from;
        this.isDraging = true;
        return true;
    }

    @Override
    public void onDragCancel(int dragDiraction) {
        this.isDraging = false;
        if (!this.isFling) {
            MLog.debug((String)TAG, (String)("[\u7528\u6237\u53d6\u6d88\u62d6\u62fd] from = " + (Object)((Object)this.from)));
            int index = this.swipeDetector.isVerticalScroll() ? this.currentVerticalIndex : this.currentHorizontalIndex;
            this.flingToScreen(index, 0);
            this.isFling = true;
        }
    }

    @Override
    public boolean isFling() {
        return this.isFling;
    }

    @Override
    public void swipeDirection(int direction, boolean canScroll) {
        if (this.swipeViewDelegate != null) {
            this.swipeViewDelegate.swipeDirection(direction, canScroll);
        }
    }

    public boolean onDown(MotionEvent e) {
        this.isFirstScrollAfterDown = true;
        return true;
    }

    public void onShowPress(MotionEvent e) {
    }

    public boolean onSingleTapUp(MotionEvent e) {
        return false;
    }

    public boolean onScroll(MotionEvent currentDownEvent, MotionEvent e2, float distanceX, float distanceY) {
        if (this.isFirstScrollAfterDown) {
            int currentIndex;
            this.isFirstScrollAfterDown = false;
            this.mTouchDownScreen = currentIndex = this.swipeDetector.isVerticalScroll() ? this.currentVerticalIndex : this.currentHorizontalIndex;
            this.from = this.swipeDetector.isVerticalScroll() ? Direction.getVerticalDirection(currentIndex) : Direction.getHorizontalDirection(currentIndex);
            this.setupEdge();
        }
        this.canScroll = this.tryScroll(currentDownEvent, e2);
        if (this.canScroll) {
            this.isFling = false;
            this.smoothScrollBy((int)distanceX, (int)distanceY);
        }
        return this.canScroll;
    }

    private void setupEdge() {
        this.fromEdge = 0;
        this.toEdge = 0;
        if (this.swipeDetector.isVerticalScroll()) {
            this.fromEdge = this.isEnable(Direction.TOP) ? -this.getMeasuredHeight() : 0;
            this.toEdge = this.isEnable(Direction.BOTTOM) ? this.getMeasuredHeight() : 0;
        } else {
            this.fromEdge = this.isEnable(Direction.LEFT) ? -this.getMeasuredWidth() : 0;
            this.toEdge = this.isEnable(Direction.RIGHT) ? this.getMeasuredWidth() : 0;
        }
    }

    private boolean tryScroll(MotionEvent currentDownEvent, MotionEvent e2) {
        Direction newTo;
        int startScrollDownPos = (int)(this.swipeDetector.isVerticalScroll() ? currentDownEvent.getY() : currentDownEvent.getX());
        int newPos = (int)(this.swipeDetector.isVerticalScroll() ? e2.getY() : e2.getX());
        int currentIndex = this.mTouchDownScreen;
        int nextIndex = newPos > startScrollDownPos ? currentIndex - 1 : currentIndex + 1;
        Direction direction = newTo = this.swipeDetector.isVerticalScroll() ? Direction.getVerticalDirection(nextIndex) : Direction.getHorizontalDirection(nextIndex);
        if (!this.isEnable(newTo) && this.originalFrom == Direction.CENTER) {
            newTo = null;
        }
        if (newTo != null) {
            if (newTo != this.to) {
                View newToView = null;
                if (this.swipeViewDelegate != null) {
                    newToView = this.swipeViewDelegate.getDragView(newTo);
                }
                if (newToView != null) {
                    this.toView = newToView;
                    this.to = newTo;
                    return true;
                }
                return false;
            }
            return this.toView != null;
        }
        return false;
    }

    public void onLongPress(MotionEvent e) {
    }

    public boolean onFling(MotionEvent currentDownEvent, MotionEvent e2, float velocityX, float velocityY) {
        this.isDraging = false;
        if (this.canScroll) {
            float mFlingVelocity = this.swipeDetector.isVerticalScroll() ? velocityY : velocityX;
            int startScrollDownPos = (int)(this.swipeDetector.isVerticalScroll() ? currentDownEvent.getY() : currentDownEvent.getX());
            int newPos = (int)(this.swipeDetector.isVerticalScroll() ? e2.getY() : e2.getX());
            int velocity = (int)(this.swipeDetector.isVerticalScroll() ? velocityY : velocityX);
            MLog.info((Object)TAG, (String)"[\u5feb\u901f\u6ed1\u52a8][onFling] startScrollDownPos:%d, newPos:%d, velocityX:%f, velocityY:%f", (Object[])new Object[]{startScrollDownPos, newPos, Float.valueOf(velocityX), Float.valueOf(velocityY)});
            if (mFlingVelocity > 0.0f && startScrollDownPos <= newPos) {
                this.flingToScreen(this.mTouchDownScreen - 1, velocity);
            } else if (mFlingVelocity < 0.0f && startScrollDownPos >= newPos) {
                this.flingToScreen(this.mTouchDownScreen + 1, velocity);
            } else {
                this.flingToScreen(this.mTouchDownScreen, velocity);
            }
            return true;
        }
        return false;
    }

    private int getDirectionPos(View view, Direction direction) {
        if (view == null) {
            return 0;
        }
        switch (direction) {
            case TOP: {
                return -view.getMeasuredHeight() == 0 ? -this.getMeasuredHeight() : -view.getMeasuredHeight();
            }
            case LEFT: {
                return -view.getMeasuredWidth() == 0 ? -this.getMeasuredWidth() : -view.getMeasuredWidth();
            }
            case RIGHT: {
                return view.getMeasuredWidth() == 0 ? this.getMeasuredWidth() : view.getMeasuredWidth();
            }
            case BOTTOM: {
                return view.getMeasuredHeight() == 0 ? this.getMeasuredHeight() : view.getMeasuredHeight();
            }
        }
        return 0;
    }

    private void flingToScreen(int targetScreen, int velocity) {
        MLog.info((String)TAG, (String)("[\u6ed1\u52a8\u5230\u5c4f\u5e55] targetScreen=" + targetScreen + ",velocity=" + velocity));
        Direction newTo = this.swipeDetector.isVerticalScroll() ? Direction.getVerticalDirection(targetScreen) : Direction.getHorizontalDirection(targetScreen);
        this.flingToDirection(newTo, velocity, this.swipeDetector.isVerticalScroll(), true);
    }

    public void flingToDirection(Direction fromDirection, Direction toDirection, int velocity, boolean needAnimation) {
        this.from = fromDirection;
        this.originalFrom = fromDirection;
        boolean isVertical = toDirection == Direction.TOP || toDirection == Direction.BOTTOM ? true : (toDirection == Direction.CENTER ? fromDirection != Direction.LEFT && fromDirection != Direction.RIGHT : false);
        this.swipeDetector.setVerticalScroll(isVertical);
        this.flingToDirection(toDirection, velocity, isVertical, needAnimation);
    }

    private void flingToDirection(Direction toDirection, int velocity, boolean isVertical, boolean needAnimation) {
        MLog.debug((String)TAG, (String)("[\u51c6\u5907\u6ed1\u52a8] originalFrom\uff1a " + (Object)((Object)this.originalFrom) + " toDirection\uff1a" + (Object)((Object)toDirection) + " needAnimation\uff1a" + needAnimation));
        if (toDirection != null) {
            this.mNeedAnimation = needAnimation;
            this.to = toDirection;
            this.isFling = true;
            View view = null;
            if (this.swipeViewDelegate != null) {
                view = this.swipeViewDelegate.getDragView(toDirection);
                this.swipeViewDelegate.onFling(this.originalFrom, toDirection, velocity);
            }
            if (view != null) {
                this.toView = view;
            }
            int dstPos = this.getDirectionPos(this.toView, this.to);
            if (isVertical) {
                this.smoothScrollTo(this.getScrollX(), dstPos, velocity);
            } else {
                this.smoothScrollTo(dstPos, this.getScrollY(), velocity);
            }
            if (!needAnimation) {
                this.mScroller.abortAnimation();
                this.doScroll();
                this.from = this.to;
            }
        }
    }

    void smoothScrollTo(int x, int y, int velocity) {
        MLog.debug((String)TAG, (String)("[\u6ed1\u52a8To] x\uff1a " + x + " y\uff1a" + y + " velocity\uff1a" + velocity));
        int sx = this.getScrollX();
        int sy = this.getScrollY();
        int dx = x - sx;
        int dy = y - sy;
        int delta = dx != 0 ? dx : dy;
        int width = dx != 0 ? this.getPaddedWidth() : this.getPaddedHeight();
        int halfWidth = width / 2;
        float distanceRatio = Math.min(1.0f, 1.0f * (float)Math.abs(delta) / (float)width);
        float distance = (float)halfWidth + (float)halfWidth * this.distanceInfluenceForSnapDuration(distanceRatio);
        int duration = 0;
        velocity = Math.abs(velocity);
        if (velocity > 0) {
            duration = 4 * Math.round(1000.0f * Math.abs(distance / (float)velocity));
        } else {
            float pageWidth = width;
            float pageDelta = (float)Math.abs(delta) / pageWidth;
            duration = (int)((pageDelta + 1.0f) * 100.0f);
        }
        duration = Math.min(duration, 350);
        this.mScroller.startScroll(sx, sy, dx, dy, duration);
        ViewCompat.postInvalidateOnAnimation((View)this);
    }

    private int getPaddedWidth() {
        return this.getMeasuredWidth() - this.getPaddingLeft() - this.getPaddingRight();
    }

    private int getPaddedHeight() {
        return this.getMeasuredHeight() - this.getPaddingTop() - this.getPaddingBottom();
    }

    float distanceInfluenceForSnapDuration(float f) {
        f -= 0.5f;
        f = (float)((double)f * 0.4712389167638204);
        return (float)Math.sin(f);
    }

    public void computeScroll() {
        boolean isAdvancedChannel;
        ++this.scrollCount;
        boolean bl = isAdvancedChannel = this.scrollCount == 24;
        if (isAdvancedChannel && this.swipeViewDelegate != null && !this.isDraging) {
            this.isHasAdvancedChannel = true;
            this.swipeViewDelegate.advancedChannel(this.originalFrom, this.to);
        }
        MLog.debug((Object)TAG, (String)"[\u89e6\u53d1\u8ba1\u7b97\u6ed1\u52a8] scrollCostTime = %d, isAdvancedChannel = %s, isDraging = %s", (Object[])new Object[]{this.scrollCount, isAdvancedChannel, this.isDraging});
        if (!this.mScroller.isFinished() && this.mScroller.computeScrollOffset()) {
            this.doScroll();
            ViewCompat.postInvalidateOnAnimation((View)this);
        } else {
            if (!this.isHasAdvancedChannel && this.swipeViewDelegate != null && !this.isDraging) {
                this.isHasAdvancedChannel = true;
                this.swipeViewDelegate.advancedChannel(this.originalFrom, this.to);
            }
            this.isHasAdvancedChannel = false;
            this.scrollCount = 0;
            if (this.isFling && !this.isDraging) {
                this.isFling = false;
                this.doScroll();
                this.from = this.to;
                this.swipeDetector.onFlingFinish();
                MLog.info((String)TAG, (String)("[\u6ed1\u52a8\u5b8c\u6210] originalFrom: " + (Object)((Object)this.originalFrom) + " to: " + (Object)((Object)this.to) + " mNeedAnimation: " + this.mNeedAnimation));
                if (this.swipeViewDelegate != null) {
                    this.swipeViewDelegate.onScrollFinish(this.originalFrom, this.to);
                }
            }
        }
    }

    private void doScroll() {
        MLog.debug((String)TAG, (String)"[\u6267\u884c\u6ed1\u52a8]");
        int oldX = this.getScrollX();
        int oldY = this.getScrollY();
        int x = this.mScroller.getCurrX();
        int y = this.mScroller.getCurrY();
        if (oldX != x || oldY != y) {
            this.scrollTo(x, y);
            int target = this.getDirectionPos(this.toView, this.to);
            int distance = this.swipeDetector.isVerticalScroll() ? this.toView.getMeasuredHeight() : this.toView.getMeasuredWidth();
            int scroll = this.swipeDetector.isVerticalScroll() ? y : x;
            int index = this.computeScreenIndex(scroll, target, distance);
            if (this.swipeViewDelegate != null) {
                float percent = 0.0f;
                if (distance != 0) {
                    percent = (float)scroll / (float)distance;
                }
                this.swipeViewDelegate.onScroll(this.from, this.to, x, y, Math.abs(percent), this.swipeDetector.isVerticalScroll());
            }
            if (this.swipeDetector.isVerticalScroll()) {
                this.currentVerticalIndex = index;
            } else {
                this.currentHorizontalIndex = index;
            }
        }
    }

    private void smoothScrollTo(int fx, int fy) {
        this.smoothScrollTo(fx, fy, 0);
    }

    private void smoothScrollBy(int dx, int dy) {
        MLog.debug((String)TAG, (String)("[\u6ed1\u52a8By] dx\uff1a " + dx + " dy\uff1a" + dy));
        if (this.swipeDetector.isVerticalScroll()) {
            int y = this.mScroller.getFinalY() + dy;
            if (this.fromEdge > y) {
                dy = this.fromEdge - this.mScroller.getFinalY();
            } else if (y > this.toEdge) {
                dy = this.toEdge - this.mScroller.getFinalY();
            }
        } else {
            int x = this.mScroller.getFinalX() + dx;
            if (this.fromEdge > x) {
                dx = this.fromEdge - this.mScroller.getFinalX();
            } else if (x > this.toEdge) {
                dx = this.toEdge - this.mScroller.getFinalX();
            }
        }
        if (dx != 0 || dy != 0) {
            this.mScroller.startScroll(this.mScroller.getFinalX(), this.mScroller.getFinalY(), dx, dy, 350);
            ViewCompat.postInvalidateOnAnimation((View)this);
        }
    }

    public void setSwipeViewDelegate(SwipeViewDelegate swipeViewDelegate) {
        this.swipeViewDelegate = swipeViewDelegate;
    }

    public void setDoubleTapListener(GestureDetector.OnDoubleTapListener doubleTapListener) {
        this.doubleTapListener = doubleTapListener;
    }

    protected int computeScreenIndex(int scroll, int target, int distance) {
        int startEdge = target - distance / 3 * 2;
        int endEdge = target + distance / 3 * 2;
        int index = startEdge < scroll && scroll < endEdge ? this.to.index : this.from.index;
        return index;
    }

    public static enum Direction {
        CENTER(1, 0),
        LEFT(0, 1),
        TOP(0, 2),
        RIGHT(2, 4),
        BOTTOM(2, 8);

        private int index;
        private int enableBitMask;

        private Direction(int index, int enableBitMask) {
            this.index = index;
            this.enableBitMask = enableBitMask;
        }

        public static Direction getVerticalDirection(int index) {
            Direction[] directions = new Direction[]{TOP, CENTER, BOTTOM};
            for (int i = 0; i < directions.length; ++i) {
                if (directions[i].index != index) continue;
                return directions[i];
            }
            return null;
        }

        public static Direction getHorizontalDirection(int index) {
            Direction[] directions = new Direction[]{LEFT, CENTER, RIGHT};
            for (int i = 0; i < directions.length; ++i) {
                if (directions[i].index != index) continue;
                return directions[i];
            }
            return null;
        }
    }
}

