/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.livebizwrapper.touch.slipchannel;

import androidx.annotation.NonNull;
import com.duowan.mobile.basemedia.api.channel.ChannelApi;
import com.yy.mobile.bizmodel.login.LoginUtilHomeApi;
import com.yy.mobile.http.RequestError;
import com.yy.mobile.http.RequestManager;
import com.yy.mobile.http.RequestParam;
import com.yy.mobile.http.ResponseErrorListener;
import com.yy.mobile.http.ResponseListener;
import com.yy.mobile.livebasebiz.ISlipChannelDiversity;
import com.yy.mobile.livebizwrapper.touch.slipchannel.RepositoryUtils;
import com.yy.mobile.livebizwrapper.touch.slipchannel.ShareStack;
import com.yy.mobile.livebizwrapper.touch.slipchannel.SlipNetInfo;
import com.yy.mobile.plugin.homeapi.core.direct2live.IDirect2LiveCore;
import com.yy.mobile.plugin.homepage.core.live.livecore.IHomepageLiveCore;
import com.yy.mobile.util.FP;
import com.yy.mobile.util.StringUtils;
import com.yy.mobile.util.json.JsonParser;
import com.yy.mobile.util.log.MLog;
import com.yymobile.core.CoreFactory;
import com.yymobile.core.EnvUriSetting;
import com.yymobile.core.ICoreManagerBase;
import com.yymobile.core.LinkUriProvider;
import com.yymobile.core.LivingCoreConstant;
import com.yymobile.core.UrlSettings;
import com.yymobile.core.channel.slipchannel.ISlipChannelCore;
import com.yymobile.core.channel.slipchannel.SlipChannelInfo;
import com.yymobile.core.channel.slipchannel.SlipParam;
import com.yymobile.core.foundation.ILocationCore;
import com.yymobile.core.foundation.LocationCache;
import com.yymobile.core.utils.CommonParamUtil;
import io.reactivex.Observable;
import io.reactivex.ObservableEmitter;
import io.reactivex.ObservableOnSubscribe;
import io.reactivex.functions.Function;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class SlipChannel {
    private static final String TAG = "SlipChannel";
    private static final String TAG_PAGE = "page";
    private String mRequestUrl = LinkUriProvider.SLIP_CHANNEL_RECOMMEND_URL;
    private RequestParam mParam = CommonParamUtil.fillCommonParam();
    private SlipParam mSlipParam;
    private ShareStack<SlipChannelInfo> mInfoShareStack;
    private Set<SlipChannelInfo> checkDuplicatedSet = new HashSet<SlipChannelInfo>();
    private boolean mCanRequestDataAfterNoChannel = true;
    private int fromId;
    private int page = 1;

    public SlipChannel(@NonNull SlipChannelInfo currentWatchingChannel, int fromId, SlipParam slipParam) {
        MLog.info((String)TAG, (String)"init");
        this.setSlipInfo(currentWatchingChannel, fromId, slipParam);
        this.mRequestUrl = ((ISlipChannelDiversity)ICoreManagerBase.getCore(ISlipChannelDiversity.class)).getRecommendUrl();
    }

    public void checkSlipInfo(@NonNull SlipChannelInfo currentWatchingChannel, int fromId, SlipParam slipParam) {
        if (this.fromId == fromId) {
            return;
        }
        this.setSlipInfo(currentWatchingChannel, fromId, slipParam);
    }

    private void setSlipInfo(@NonNull SlipChannelInfo currentWatchingChannel, int fromId, SlipParam slipParam) {
        MLog.info((String)TAG, (String)("setSlipInfo sid = " + currentWatchingChannel.sid + " ssid = " + currentWatchingChannel.ssid + ",uid=" + currentWatchingChannel.uid + " tpl = " + currentWatchingChannel.tpl + " fromId = " + fromId));
        this.fromId = fromId;
        this.setSlipParam(fromId, slipParam);
        this.mInfoShareStack = new ShareStack<SlipChannelInfo>(currentWatchingChannel);
        currentWatchingChannel.watched = true;
        this.mSlipParam = slipParam;
        if (slipParam != null && slipParam.slipChannelInfos != null && !slipParam.slipChannelInfos.isEmpty()) {
            this.setupBaseData(slipParam.slipChannelInfos);
        } else {
            this.checkDuplicatedSet.clear();
            this.checkDuplicatedSet.add(currentWatchingChannel);
        }
    }

    public SlipChannelInfo getNext(boolean isNext) {
        return isNext ? this.mInfoShareStack.getNext() : this.mInfoShareStack.getPrev();
    }

    public Observable<SlipChannelInfo> moveToNextOrPrev(final boolean isNext) {
        SlipChannelInfo data = this.innerMove(isNext);
        if (data != null) {
            return Observable.just((Object)data);
        }
        return this.requestData(this.mRequestUrl, this.mParam).map((Function)new Function<List<SlipChannelInfo>, SlipChannelInfo>(){

            public SlipChannelInfo apply(List<SlipChannelInfo> slipChannelInfos) throws Exception {
                if (!slipChannelInfos.isEmpty()) {
                    if (SlipChannel.this.mInfoShareStack.size() <= 1) {
                        SlipChannelInfo slipChannelInfo = (SlipChannelInfo)SlipChannel.this.mInfoShareStack.getIndexItem();
                        if (null != slipChannelInfo && slipChannelInfos.indexOf(slipChannelInfo) >= 0) {
                            slipChannelInfos.remove(slipChannelInfo);
                        }
                        MLog.info((String)SlipChannel.TAG, (String)("requestData setupBaseData size:" + slipChannelInfos.size()));
                        SlipChannel.this.setupBaseData(slipChannelInfos);
                    } else {
                        SlipChannel.this.filterDuplicated(slipChannelInfos);
                        MLog.info((String)SlipChannel.TAG, (String)("moveToNextOrPrev requestData slipChannelInfos size " + slipChannelInfos.size()));
                        if (isNext) {
                            SlipChannel.this.mInfoShareStack.addLastAll(slipChannelInfos);
                        } else {
                            SlipChannel.this.mInfoShareStack.addFirstAll(slipChannelInfos);
                        }
                    }
                } else {
                    MLog.info((String)SlipChannel.TAG, (String)"moveToNextOrPrev requestData slipChannelInfos is null");
                }
                return SlipChannel.this.innerMove(isNext);
            }
        });
    }

    private SlipChannelInfo innerMove(boolean isNext) {
        if (isNext) {
            return this.mInfoShareStack.moveToNext();
        }
        return this.mInfoShareStack.moveToPrev();
    }

    private SlipChannelInfo getNextChannelInfo(boolean isNext) {
        if (isNext) {
            return this.mInfoShareStack.getNext();
        }
        return this.mInfoShareStack.getPrev();
    }

    private void setupBaseData(List<SlipChannelInfo> datas) {
        if (datas != null && !datas.isEmpty()) {
            this.filterDuplicated(datas);
            if (!datas.isEmpty()) {
                int index = datas.indexOf(this.mInfoShareStack.getIndexItem());
                if (index == -1) {
                    index = datas.size() / 2;
                }
                List<SlipChannelInfo> prevData = datas.subList(0, index);
                this.mInfoShareStack.addFirstAll(prevData);
                List<SlipChannelInfo> nextData = datas.subList(index, datas.size());
                this.mInfoShareStack.addLastAll(nextData);
            }
        }
    }

    private synchronized void filterDuplicated(List<SlipChannelInfo> datas) {
        Iterator<SlipChannelInfo> iterator = datas.iterator();
        while (iterator.hasNext()) {
            SlipChannelInfo data = iterator.next();
            if (this.checkDuplicatedSet.contains(data) || "33554521".equals(String.valueOf(data.tpl))) {
                iterator.remove();
                continue;
            }
            this.checkDuplicatedSet.add(data);
        }
    }

    public void setSlipParam(int fromId, SlipParam param) {
        ISlipChannelDiversity iChannelDiversity;
        if (param == null) {
            MLog.info((String)TAG, (String)"setSlipParam return");
            return;
        }
        this.mCanRequestDataAfterNoChannel = true;
        this.mParam = CommonParamUtil.fillCommonParam();
        LocationCache bdLocation = null;
        if (CoreFactory.getCore(ILocationCore.class) != null && (bdLocation = ((ILocationCore)CoreFactory.getCore(ILocationCore.class)).getCacheRecentLocationInfo()) != null) {
            this.mParam.put("lng", String.valueOf(bdLocation.longitude));
            this.mParam.put("lat", String.valueOf(bdLocation.latitude));
            this.mParam.put("cty", bdLocation.country);
            this.mParam.put("prv", bdLocation.province);
            this.mParam.put("city", bdLocation.city);
        }
        if ((iChannelDiversity = (ISlipChannelDiversity)ICoreManagerBase.getCore(ISlipChannelDiversity.class)) != null && iChannelDiversity.isForceOnlyRecommend()) {
            this.mRequestUrl = ((ISlipChannelDiversity)ICoreManagerBase.getCore(ISlipChannelDiversity.class)).getRecommendUrl();
            return;
        }
        switch (fromId) {
            case 14: {
                int servType = param.servType;
                if (FP.empty((CharSequence)param.biz) || FP.empty((CharSequence)param.subBiz) || servType == 7) {
                    param.biz = "index";
                    param.subBiz = "idx";
                }
                if (servType == 6 || servType == 7) {
                    servType = 2;
                }
                this.mRequestUrl = LivingCoreConstant.getServ((int)servType) + "/" + EnvUriSetting.getUriAppType() + "/shake2/" + param.biz + "/" + param.subBiz;
                this.mParam.put("moduleId", String.valueOf(param.moduleId));
                break;
            }
            case 15: {
                if (param.biz == null) break;
                this.mRequestUrl = LivingCoreConstant.getServ((int)param.servType) + "/" + EnvUriSetting.getUriAppType() + "/shake2/" + param.biz + "/" + param.subBiz;
                this.mParam.put("moduleId", String.valueOf(param.moduleId));
                break;
            }
            case 2: {
                this.mRequestUrl = LinkUriProvider.SLIP_CHANNEL_SEARCH_URL;
                this.mParam.put("searchKey", param.keyWords);
                break;
            }
            case 1: 
            case 16: {
                this.mRequestUrl = LinkUriProvider.SLIP_CHANNEL_TREND_URL;
                break;
            }
            case 20: {
                this.mRequestUrl = UrlSettings.LOLLIPOP_MOBILE_LIVE + "/social/" + EnvUriSetting.getUriAppType() + "/near2/shake%s";
                this.mRequestUrl = String.format(this.mRequestUrl, "");
                MLog.info((String)TAG, (String)("[setSlipParam NEARBYLIVE] RequestLocation=" + param.selLocation));
                break;
            }
            case 21: {
                this.mRequestUrl = UrlSettings.LOLLIPOP_MOBILE_LIVE + "/social/" + EnvUriSetting.getUriAppType() + "/square/shake?%s";
                this.mRequestUrl = bdLocation == null && param.selLocation != null && !param.selLocation.equals("\u9644\u8fd1") ? String.format(this.mRequestUrl, param.selLocation) : String.format(this.mRequestUrl, "");
                MLog.info((String)TAG, (String)("[setSlipParam SQUARE] RequestLocation=" + param.selLocation));
                break;
            }
            case 25: {
                this.mCanRequestDataAfterNoChannel = false;
                break;
            }
            case 26: {
                IDirect2LiveCore core = (IDirect2LiveCore)CoreFactory.getCore(IDirect2LiveCore.class);
                this.page = 2;
                this.mParam.put("actionVal", core.getABTestAction() + "");
                this.mRequestUrl = core.getRequestUrl();
                break;
            }
            default: {
                this.mRequestUrl = iChannelDiversity != null ? iChannelDiversity.getRecommendUrl() : LinkUriProvider.SLIP_CHANNEL_RECOMMEND_URL;
            }
        }
    }

    private boolean isAsyncABTest() {
        int joinChannelSource = 0;
        ChannelApi channelApi = ChannelApi.Factory.get();
        if (channelApi != null && channelApi.getExtendInfo() != null && channelApi.getExtendInfo().containsKey("channel_from")) {
            joinChannelSource = StringUtils.safeParseInt((String)((String)channelApi.getExtendInfo().get("channel_from")));
        }
        return joinChannelSource == 26;
    }

    private Observable<List<SlipChannelInfo>> requestData(final String requestUrl, final RequestParam param) {
        if (!this.mCanRequestDataAfterNoChannel) {
            return Observable.error((Throwable)new Throwable("current biz cannot requestData fromId = " + this.fromId));
        }
        if (this.isAsyncABTest()) {
            param.put("fromTM", "1");
        }
        param.put(TAG_PAGE, String.valueOf(this.page));
        param.put("uid", LoginUtilHomeApi.isLogined() ? String.valueOf(LoginUtilHomeApi.getUid()) : "0");
        Observable netInfoObservable = Observable.create((ObservableOnSubscribe)new ObservableOnSubscribe<SlipNetInfo>(){

            public void subscribe(final ObservableEmitter<SlipNetInfo> emitter) throws Exception {
                RequestManager.instance().submitStringQueryRequest(requestUrl, param, (ResponseListener)new ResponseListener<String>(){

                    public void onResponse(String response) {
                        MLog.info((String)SlipChannel.TAG, (String)("requestData response = " + response + ""));
                        SlipNetInfo netResponse = (SlipNetInfo)((Object)JsonParser.parseJsonObject((String)response, SlipNetInfo.class));
                        SlipChannel.this.page++;
                        emitter.onNext((Object)netResponse);
                    }
                }, new ResponseErrorListener(){

                    public void onErrorResponse(RequestError error) {
                        emitter.onError((Throwable)error);
                    }
                });
                MLog.info((Object)SlipChannel.TAG, (String)"requestData url = %s", (Object[])new Object[]{RequestManager.getUrlWithQueryString((String)requestUrl, (RequestParam)param)});
            }
        });
        return RepositoryUtils.extractData(netInfoObservable);
    }

    public void reportNotWatchedChannel() {
        ArrayList<Long> uids = new ArrayList<Long>();
        for (SlipChannelInfo info : this.checkDuplicatedSet) {
            if (info.watched) continue;
            uids.add(info.uid);
        }
        if (this.mSlipParam != null && this.mSlipParam.recommend == 1 && ((IHomepageLiveCore)CoreFactory.getCore(IHomepageLiveCore.class)).getReportNoView() == 1) {
            ((ISlipChannelCore)CoreFactory.getCore(ISlipChannelCore.class)).sendLiveUids(uids, this.mSlipParam.biz, this.mSlipParam.moduleId, "2");
        }
    }
}

