/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.livebizwrapper.touch.slipchannel;

import com.yy.mobile.livebizwrapper.touch.slipchannel.DuLinkedList;
import java.util.Collection;

public class ShareStack<T>
extends DuLinkedList<T> {
    private int maxSize = 1000;
    private DuLinkedList.Node<T> indexNode;

    public ShareStack(T head) {
        this.add(head);
        this.indexNode = this.first;
    }

    public ShareStack(int maxSize, T head) {
        this.maxSize = maxSize;
        this.add(head);
        this.indexNode = this.first;
    }

    public T getIndexItem() {
        return (T)this.indexNode.item;
    }

    public void addFirstAll(Collection<T> collection) {
        this.addAll(0, collection);
        if (this.size() > this.maxSize) {
            int over = this.size() - this.maxSize;
            for (int i = 0; i < over && this.indexNode != this.peekLastNode(); ++i) {
                this.pollLast();
            }
        }
    }

    public void addLastAll(Collection<T> collection) {
        this.addAll(this.size(), collection);
        if (this.size() > this.maxSize) {
            int over = this.size() - this.maxSize;
            for (int i = 0; i < over && this.indexNode != this.peekFristNode(); ++i) {
                this.pollFirst();
            }
        }
    }

    public T getNext() {
        if (this.indexNode.next != null) {
            return (T)this.indexNode.next.item;
        }
        return null;
    }

    public T getPrev() {
        if (this.indexNode.prev != null) {
            return (T)this.indexNode.prev.item;
        }
        return null;
    }

    public T moveToNext() {
        if (this.indexNode.next != null) {
            this.indexNode = this.indexNode.next;
            return (T)this.indexNode.item;
        }
        return null;
    }

    public T moveToPrev() {
        if (this.indexNode.prev != null) {
            this.indexNode = this.indexNode.prev;
            return (T)this.indexNode.item;
        }
        return null;
    }
}

