/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.livebizwrapper.touch.slipchannel;

import com.yy.mobile.http.BaseNetData;
import com.yy.mobile.livebizwrapper.touch.slipchannel.ResponseException;
import io.reactivex.Observable;
import io.reactivex.ObservableSource;
import io.reactivex.functions.Function;

public final class RepositoryUtils {
    public static <T> Observable<T> extractData(Observable<? extends BaseNetData<T>> observable) {
        return observable.flatMap(new Function<BaseNetData, ObservableSource<T>>(){

            public ObservableSource<T> apply(BaseNetData response) throws Exception {
                if (response == null) {
                    return Observable.error((Throwable)new NetworkConnectionException());
                }
                if (response.getCode() == 0) {
                    return Observable.just((Object)response.getData());
                }
                return Observable.error((Throwable)new ResponseException(response));
            }
        });
    }

    public static class NetworkConnectionException
    extends Exception {
    }
}

