/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.livebizwrapper.statistic;

import android.content.Context;
import android.os.Build;
import androidx.fragment.app.FragmentActivity;
import com.duowan.mobile.basemedia.api.channel.ChannelApi;
import com.duowan.mobile.basemedia.api.channel.basechannel.ChannelInfoSupportUtil;
import com.yy.mobile.bizmodel.login.LoginUtil;
import com.yy.mobile.util.log.MLog;
import com.yymobile.core.CoreFactory;
import com.yymobile.core.channel.ChannelInfo;
import com.yymobile.core.statistic.IHiidoStatisticCore;
import java.util.HashMap;

public class GameTplStatisticModel {
    private static String TAG = "GameTplStatisticModel";
    private static GameTplStatisticModel statisticModel = null;
    private String mStartTime = "0";
    private boolean isLandscape = false;

    private GameTplStatisticModel() {
    }

    public static GameTplStatisticModel instance() {
        if (statisticModel == null) {
            statisticModel = new GameTplStatisticModel();
        }
        return statisticModel;
    }

    public void initModel() {
        MLog.debug((String)TAG, (String)"[initModel]");
        this.mStartTime = this.getCurrentTimeSecond();
    }

    private String getCurrentTimeSecond() {
        long timeStampSec = System.currentTimeMillis() / 1000L;
        String tempTime = String.format("%010d", timeStampSec);
        return tempTime;
    }

    public void orientationChangeReport(Context context) {
        ChannelInfo channelInfo;
        if (this.checkActivityValid(context) && (channelInfo = ChannelApi.Factory.get().getCurrentChannelInfo()) != null && ChannelInfoSupportUtil.isSupportBusinessId()) {
            MLog.debug((String)TAG, (String)("[orientationChangeReport] isLandscape=" + this.isLandscape(context)));
            HashMap<String, String> properties = new HashMap<String, String>();
            this.isLandscape = this.isLandscape(context);
            if (this.isLandscape) {
                properties.put("key1", "2");
            } else {
                properties.put("key1", "1");
            }
            properties.put("key2", ChannelApi.Factory.get().getTemplateId());
            String tempTime = this.getCurrentTimeSecond();
            properties.put("key3", this.mStartTime);
            properties.put("key4", tempTime);
            this.mStartTime = tempTime;
            ((IHiidoStatisticCore)CoreFactory.getCore(IHiidoStatisticCore.class)).sendEventStatistic(LoginUtil.getUid(), "51039", "0002", properties);
        }
    }

    public void componentDestroyReport(Context context) {
        ChannelInfo channelInfo;
        MLog.debug((String)TAG, (String)"[componentDestroyReport]");
        if (this.checkActivityValid(context) && (channelInfo = ChannelApi.Factory.get().getCurrentChannelInfo()) != null && ChannelInfoSupportUtil.isSupportBusinessId()) {
            HashMap<String, String> properties = new HashMap<String, String>();
            if (this.isLandscape) {
                properties.put("key1", "1");
            } else {
                properties.put("key1", "2");
            }
            String tempTime = this.getCurrentTimeSecond();
            properties.put("key2", ChannelApi.Factory.get().getTemplateId());
            properties.put("key3", this.mStartTime);
            properties.put("key4", tempTime);
            ((IHiidoStatisticCore)CoreFactory.getCore(IHiidoStatisticCore.class)).sendEventStatistic(LoginUtil.getUid(), "51039", "0002", properties);
        }
    }

    private boolean isLandscape(Context context) {
        if (this.checkActivityValid(context)) {
            return 2 == context.getResources().getConfiguration().orientation;
        }
        return false;
    }

    private boolean checkActivityValid(Context context) {
        if (context == null) {
            return false;
        }
        if (((FragmentActivity)context).isFinishing()) {
            return false;
        }
        return Build.VERSION.SDK_INT < 17 || !((FragmentActivity)context).isDestroyed();
    }

    public void destroy() {
        if (statisticModel != null) {
            statisticModel = null;
        }
    }
}

