/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.livebizwrapper.slidefunction;

import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.content.pm.ProviderInfo;
import android.content.pm.ResolveInfo;
import android.database.Cursor;
import android.net.Uri;
import android.os.Build;
import android.text.TextUtils;
import java.util.List;

public class LuancherUtil {
    private static String AUTHORITY = null;

    public static boolean isShortCutExist(Context context, String title) {
        boolean isInstallShortcut = false;
        if (null == context || TextUtils.isEmpty((CharSequence)title)) {
            return isInstallShortcut;
        }
        if (TextUtils.isEmpty((CharSequence)AUTHORITY)) {
            AUTHORITY = LuancherUtil.getAuthorityFromPermission(context);
        }
        ContentResolver cr = context.getContentResolver();
        if (!TextUtils.isEmpty((CharSequence)AUTHORITY)) {
            try {
                Uri contentUri = Uri.parse((String)AUTHORITY);
                Cursor c = cr.query(contentUri, new String[]{"title", "iconResource"}, "title=?", new String[]{title}, null);
                if (c != null && c.getCount() > 0) {
                    isInstallShortcut = true;
                }
                if (null != c && !c.isClosed()) {
                    c.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return isInstallShortcut;
    }

    public static String getCurrentLauncherPackageName(Context context) {
        Intent intent = new Intent("android.intent.action.MAIN");
        intent.addCategory("android.intent.category.HOME");
        ResolveInfo res = context.getPackageManager().resolveActivity(intent, 0);
        if (res == null || res.activityInfo == null) {
            return "";
        }
        if (res.activityInfo.packageName.equals("android")) {
            return "";
        }
        return res.activityInfo.packageName;
    }

    public static String getAuthorityFromPermissionDefault(Context context) {
        return LuancherUtil.getThirdAuthorityFromPermission(context, "com.android.launcher.permission.READ_SETTINGS");
    }

    public static String getThirdAuthorityFromPermission(Context context, String permission) {
        if (TextUtils.isEmpty((CharSequence)permission)) {
            return "";
        }
        try {
            List packs = context.getPackageManager().getInstalledPackages(8);
            if (packs == null) {
                return "";
            }
            for (PackageInfo pack : packs) {
                ProviderInfo[] providers = pack.providers;
                if (providers == null) continue;
                for (ProviderInfo provider : providers) {
                    String authority;
                    if (!permission.equals(provider.readPermission) && !permission.equals(provider.writePermission) || TextUtils.isEmpty((CharSequence)(authority = provider.authority)) || !authority.contains(".launcher.settings") && !authority.contains(".twlauncher.settings") && !authority.contains(".launcher2.settings")) continue;
                    return authority;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "";
    }

    public static String getAuthorityFromPermission(Context context) {
        String authority = LuancherUtil.getAuthorityFromPermissionDefault(context);
        if (authority == null || authority.trim().equals("")) {
            String packageName = LuancherUtil.getCurrentLauncherPackageName(context);
            packageName = packageName + ".permission.READ_SETTINGS";
            authority = LuancherUtil.getThirdAuthorityFromPermission(context, packageName);
        }
        if (TextUtils.isEmpty((CharSequence)authority)) {
            int sdkInt = Build.VERSION.SDK_INT;
            authority = sdkInt < 8 ? "com.android.launcher.settings" : (sdkInt < 19 ? "com.android.launcher2.settings" : "com.android.launcher3.settings");
        }
        authority = "content://" + authority + "/favorites?notify=true";
        return authority;
    }
}

