/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.livebizwrapper.programinfo.widget;

import android.app.Activity;
import android.content.ClipData;
import android.content.ClipboardManager;
import android.content.Context;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.duowan.mobile.basemedia.api.channel.ChannelApi;
import com.duowan.mobile.basemedia.api.channel.hiidoStatistic.IHiddoStatisticChannelCore;
import com.duowan.mobile.basemedia.api.template.ViewingRoomApi;
import com.duowan.mobile.basemedia.watchlive.template.BaseViewScene;
import com.yy.android.sniper.annotation.inject.BusEvent;
import com.yy.android.sniper.api.event.EventBinder;
import com.yy.android.sniper.api.event.EventCompat;
import com.yy.mobile.bizmodel.login.LoginUtil;
import com.yy.mobile.livebizwrapper.R;
import com.yy.mobile.livebizwrapper.programinfo.widget.ChannelIdView$$EventBinder;
import com.yy.mobile.plugin.main.events.IChannelLinkClient_onJoinChannelSuccess_EventArgs;
import com.yy.mobile.sdkwrapper.flowmanagement.base.util.ActivityCheckUtils;
import com.yy.mobile.ui.utils.SingleToastUtil;
import com.yy.mobile.util.DimenConverter;
import com.yy.mobile.util.log.MLog;
import com.yymobile.core.CoreFactory;
import com.yymobile.core.channel.ChannelInfo;

public class ChannelIdView
extends RelativeLayout
implements EventCompat {
    private static final String TAG = "ChannelIdView";
    private Context mCtx;
    private View mChannelIdLayout;
    private TextView mChannelTxtView;
    private TextView mChannelIdView;
    private long mChannelId;
    private boolean mChannelIdShowEnable = true;
    private EventBinder mEventBinder;

    public ChannelIdView(Context context, AttributeSet attrs) {
        super(context, attrs, 0);
        this.mCtx = context;
    }

    private boolean isShowEnable() {
        return this.mChannelIdShowEnable;
    }

    public void setShowEnable(boolean enable) {
        this.mChannelIdShowEnable = enable;
    }

    public void show() {
        MLog.info((Object)TAG, (String)"show: mChannelIdShowEnable=%s", (Object[])new Object[]{this.mChannelIdShowEnable});
        if (this.isShowEnable()) {
            this.setVisibility(0);
        }
    }

    public void hide() {
        MLog.info((String)TAG, (String)"hide:");
        this.setVisibility(8);
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        LayoutInflater.from((Context)this.mCtx).inflate(R.layout.channel_id_info, (ViewGroup)this);
        this.mChannelIdLayout = this.findViewById(R.id.channel_id_layout);
        this.mChannelTxtView = (TextView)this.findViewById(R.id.tv_channel_txt);
        this.mChannelIdView = (TextView)this.findViewById(R.id.tv_channel_id);
        this.init();
    }

    public void init() {
        MLog.info((String)TAG, (String)"init:");
        this.updateShowStyle();
        if (ViewingRoomApi.Factory.get().getCurrentScene() != BaseViewScene.ENTERTAINMENT) {
            this.mChannelIdView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    try {
                        if (ActivityCheckUtils.checkActivityValid((Activity)((Activity)ChannelIdView.this.mCtx))) {
                            ClipboardManager clipboard = (ClipboardManager)ChannelIdView.this.mCtx.getSystemService("clipboard");
                            if (clipboard != null) {
                                clipboard.setPrimaryClip(ClipData.newPlainText((CharSequence)"content", (CharSequence)String.valueOf(ChannelIdView.this.mChannelId)));
                            }
                            SingleToastUtil.showToast((String)ChannelIdView.this.mCtx.getString(R.string.str_channel_copy_tips));
                            ((IHiddoStatisticChannelCore)CoreFactory.getCore(IHiddoStatisticChannelCore.class)).sendEventStatistic_Channel_5_2(LoginUtil.getUid(), "51019", "0005");
                        }
                    }
                    catch (Throwable e) {
                        MLog.error((Object)ChannelIdView.TAG, (Throwable)e);
                    }
                }
            });
        }
        ChannelInfo info = ChannelApi.Factory.get().getCurrentChannelInfo();
        this.updateChannelID(info);
    }

    public void updateShowStyle() {
        if (this.mChannelIdView != null) {
            if (!this.isShowEnable()) {
                this.hide();
                return;
            }
            MLog.debug((String)TAG, (String)("updateShowStyle: isEntTemplate=" + this.isEntTemplate()));
            if (this.isEntTemplate()) {
                this.mChannelIdLayout.setBackgroundResource(0);
                this.mChannelIdLayout.setPadding(4, 0, 0, 0);
                this.mChannelIdView.setTextColor(0x64FFFFFF);
                this.mChannelIdView.setTextSize(10.0f);
                this.mChannelTxtView.setText((CharSequence)"\u76f4\u64ad\u95f4\u53f7 ");
                this.mChannelTxtView.setTextSize(10.0f);
                this.mChannelTxtView.setTextColor(0x64FFFFFF);
                this.mChannelTxtView.setShadowLayer(0.6f, 0.6f, 0.6f, 0x33000000);
                this.mChannelIdView.setShadowLayer(0.6f, 0.6f, 0.6f, 0x33000000);
            } else {
                this.mChannelIdLayout.setBackgroundResource(R.drawable.bg_channel_id);
                this.mChannelIdLayout.setPadding(8, 0, 8, 0);
                this.mChannelIdView.setTextColor(-1728053248);
                this.mChannelIdView.setTextSize(9.0f);
                this.mChannelTxtView.setText((CharSequence)"\u76f4\u64ad\u95f4\u53f7\uff1a");
                this.mChannelTxtView.setTextColor(-1728053248);
                this.mChannelTxtView.setTextSize(9.0f);
                this.mChannelTxtView.setShadowLayer(0.0f, 0.0f, 0.0f, 0);
                this.mChannelIdView.setShadowLayer(0.0f, 0.0f, 0.0f, 0);
            }
            this.show();
        }
    }

    private boolean isEntTemplate() {
        return "entertainment".equals(ChannelApi.Factory.get().getBusinessId());
    }

    public void updateTopMargin(int dp) {
        RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-2, -2);
        layoutParams.setMargins(0, DimenConverter.dip2px((Context)this.mCtx, (float)dp), 0, 0);
        this.mChannelIdLayout.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
    }

    public void updateChannelID(ChannelInfo info) {
        if (this.mChannelIdView != null && this.mChannelIdView.getVisibility() == 0) {
            if (info != null) {
                long l = this.mChannelId = info.topASid == 0L ? info.topSid : info.topASid;
            }
            if (this.mChannelId == 0L) {
                MLog.info((String)TAG, (String)"getJoiningTopSid:");
                this.mChannelId = ChannelApi.Factory.get().getJoiningTopSid();
            }
            MLog.info((Object)TAG, (String)"updateChannelID: %s", (Object[])new Object[]{this.mChannelId});
            this.mChannelIdView.setText((CharSequence)String.valueOf(this.mChannelId));
        }
    }

    @BusEvent
    public void onJoinChannelSuccess(IChannelLinkClient_onJoinChannelSuccess_EventArgs busEventArgs) {
        ChannelInfo channelInfo = busEventArgs.getInfo();
        MLog.debug((String)TAG, (String)("onJoinChannelSuccess: " + channelInfo));
        this.updateShowStyle();
        this.updateChannelID(channelInfo);
    }

    public void onEventBind() {
        if (this.mEventBinder == null) {
            this.mEventBinder = new ChannelIdView$$EventBinder();
        }
        this.mEventBinder.bindEvent((Object)this);
    }

    public void onEventUnBind() {
        if (this.mEventBinder != null) {
            this.mEventBinder.unBindEvent();
        }
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.onEventBind();
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.onEventUnBind();
    }

    public void onDestroy() {
        this.mCtx = null;
    }
}

