/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.livebizwrapper.programinfo.presenter;

import android.text.TextUtils;
import androidx.fragment.app.FragmentManager;
import com.duowan.mobile.basemedia.api.channel.ChannelApi;
import com.duowan.mobile.basemedia.api.channel.config.ILiveFilterCore;
import com.yy.android.sniper.annotation.inject.BusEvent;
import com.yy.android.sniper.api.event.EventBinder;
import com.yy.mobile.livebizwrapper.advertisement.Advertisement;
import com.yy.mobile.livebizwrapper.events.IAdvertisementClient_updateAd_EventArgs;
import com.yy.mobile.livebizwrapper.events.IProgramInfoClient_showContributionNms_EventArgs;
import com.yy.mobile.livebizwrapper.officialchannel.IChannelOfficialInfoCore;
import com.yy.mobile.livebizwrapper.programinfo.core.IProgramInfoCore;
import com.yy.mobile.livebizwrapper.programinfo.presenter.CommonLiveInfoPresenter;
import com.yy.mobile.livebizwrapper.programinfo.presenter.OfficialLiveInfoPresenter$$EventBinder;
import com.yy.mobile.livebizwrapper.programinfo.view.IOfficialLiveInfoView;
import com.yy.mobile.plugin.main.events.IChannelLinkClient_leaveCurrentChannel_EventArgs;
import com.yy.mobile.util.log.MLog;
import com.yymobile.core.CoreFactory;
import com.yymobile.core.channel.ChannelInfo;

public class OfficialLiveInfoPresenter
extends CommonLiveInfoPresenter<IOfficialLiveInfoView> {
    private static final String TAG = "OfficialLiveInfoPresenter";
    protected IProgramInfoCore.OnContributionListener mOnContributionListener;
    protected String mContributionNms;
    private EventBinder mEventBinder;

    public boolean isOfficialChannel() {
        long topSid = ChannelApi.Factory.get().getCurrentChannelInfo().topSid;
        long joiningTopSid = ChannelApi.Factory.get().getJoiningTopSid();
        if (topSid == 0L) {
            topSid = joiningTopSid;
        }
        boolean isOfficial = ((IChannelOfficialInfoCore)CoreFactory.getCore(IChannelOfficialInfoCore.class)).isOfficialProgram(topSid);
        MLog.info((Object)TAG, (String)"isOfficialChannel: isOfficial=%s", (Object[])new Object[]{isOfficial});
        return isOfficial;
    }

    @Override
    public long getLatestAnchorUid() {
        return this.getCurrentChannelTopMicId();
    }

    public long getCurrentOwUid() {
        long owUid;
        boolean ret = this.isGameWhiteListRoom();
        long l = owUid = this.getUsingAnchorUid() == 0L ? ChannelApi.Factory.get().getChannelOwUid() : this.getUsingAnchorUid();
        if (ret) {
            return owUid;
        }
        return this.getCurrentChannelTopMicId();
    }

    @Override
    protected void updatePureFollowState(boolean hasFollow) {
        super.updatePureFollowState(hasFollow);
        MLog.info((Object)TAG, (String)"updatePureFollowState: hasFollow:%b", (Object[])new Object[]{hasFollow});
        if (this.getView() != null) {
            ((IOfficialLiveInfoView)this.getView()).setHasFollowed(hasFollow);
        }
    }

    public long getCurrentChannelTopMicId() {
        return ChannelApi.Factory.get().getCurrentTopMicId();
    }

    public boolean isGameWhiteListRoom() {
        ILiveFilterCore liveFilterCore;
        ChannelInfo info = ChannelApi.Factory.get().getCurrentChannelInfo();
        long topSid = info.topASid == 0L ? info.topSid : info.topASid;
        long joiningTopSid = ChannelApi.Factory.get().getJoiningTopSid();
        if (topSid == 0L) {
            topSid = joiningTopSid;
        }
        return (liveFilterCore = (ILiveFilterCore)CoreFactory.getCore(ILiveFilterCore.class)) != null && liveFilterCore.isGameWhiteListRoom(String.valueOf(topSid));
    }

    @Override
    public void initReqData() {
        MLog.info((String)TAG, (String)"initReqData:");
        this.requestSubscribe("initReqData");
        this.reqUserDetailInfo("initReqData");
    }

    @Override
    public void onClickAnchorInfo(FragmentManager fragmentManager) {
        MLog.info((String)TAG, (String)("onClickAnchorInfo\uff1amEntUserInfo=" + this.mEntUserInfo));
        if (this.checkActivityValid() && this.mEntUserInfo != null && this.mEntUserInfo.uid != 0L && null != this.getProgramInfoHolder()) {
            this.getProgramInfoHolder().showPersonalCardComponent(this.mEntUserInfo.uid, this.mEntUserInfo.userType == 1, this.mIconUrlCache);
        } else {
            this.onClickAnchorInfoError();
        }
    }

    @BusEvent(busType=1, busName="Live")
    public void updateAdvertisementPic(IAdvertisementClient_updateAd_EventArgs busEventArgs) {
        Advertisement ad = busEventArgs.mAd;
        MLog.info((String)TAG, (String)("loadAdvertisementPic ad=" + ad));
        if (this.getView() != null) {
            ((IOfficialLiveInfoView)this.getView()).loadAdvertisementPic(ad);
        }
    }

    public void initContributionListen() {
        this.mOnContributionListener = new IProgramInfoCore.OnContributionListener(){

            @Override
            public void setContributionNms(long sid, long ssid, String contributionNms) {
                String value = "0 \u8d21\u732e\u503c";
                if (!TextUtils.isEmpty((CharSequence)contributionNms) && sid >= 0L && ssid >= 0L) {
                    OfficialLiveInfoPresenter.this.mContributionNms = contributionNms;
                    value = contributionNms + " \u8d21\u732e\u503c";
                }
                if (OfficialLiveInfoPresenter.this.getView() != null) {
                    ((IOfficialLiveInfoView)OfficialLiveInfoPresenter.this.getView()).setContributionData(value);
                }
            }
        };
        ((IProgramInfoCore)CoreFactory.getCore(IProgramInfoCore.class)).setOnContributionListener(this.mOnContributionListener);
    }

    @BusEvent(busType=1, busName="Live")
    public void showContributionNms(IProgramInfoClient_showContributionNms_EventArgs busEventArgs) {
        boolean isShowContributionNms = busEventArgs.mIsShowContributionNms;
        MLog.info((String)TAG, (String)("showContributionNms mContributionNms = " + this.mContributionNms));
        if (isShowContributionNms && !TextUtils.isEmpty((CharSequence)this.mContributionNms) && this.getView() != null) {
            ((IOfficialLiveInfoView)this.getView()).setContributionData(this.mContributionNms + " \u8d21\u732e\u503c");
        }
    }

    @Override
    public void leaveCurrentChannel(IChannelLinkClient_leaveCurrentChannel_EventArgs busEventArgs) {
        super.leaveCurrentChannel(busEventArgs);
        if (this.getView() != null) {
            ((IOfficialLiveInfoView)this.getView()).resetLayoutData();
        }
    }

    @Override
    public void onEventBind() {
        super.onEventBind();
        if (this.mEventBinder == null) {
            this.mEventBinder = new OfficialLiveInfoPresenter$$EventBinder();
        }
        this.mEventBinder.bindEvent((Object)this);
    }

    @Override
    public void onEventUnBind() {
        super.onEventUnBind();
        if (this.mEventBinder != null) {
            this.mEventBinder.unBindEvent();
        }
    }
}

