/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.livebizwrapper.programinfo.presenter;

import android.graphics.drawable.Drawable;
import android.view.View;
import com.duowan.mobile.basemedia.api.LiveRoomRxBus;
import com.duowan.mobile.basemedia.api.channel.ChannelApi;
import com.duowan.mobile.basemedia.api.statistic.audiencevideo.IUnionReportCore;
import com.duowan.mobile.basemedia.api.statistic.audiencevideo.SubscribeType;
import com.duowan.mobile.basemedia.api.template.ViewingRoomApi;
import com.duowan.mobile.basemedia.watchlive.template.BaseViewScene;
import com.duowan.mobile.basemedia.watchlive.template.IViewScene;
import com.yy.android.sniper.annotation.inject.BusEvent;
import com.yy.android.sniper.api.event.EventBinder;
import com.yy.mobile.bizmodel.login.LoginUtil;
import com.yy.mobile.livebizwrapper.R;
import com.yy.mobile.livebizwrapper.events.IProgramInfoClient_onAddRealLoveInviteView_EventArgs;
import com.yy.mobile.livebizwrapper.events.IProgramInfoClient_onAddRealLoveView_EventArgs;
import com.yy.mobile.livebizwrapper.events.IProgramInfoClient_onFollowResult_EventArgs;
import com.yy.mobile.livebizwrapper.events.IProgramInfoClient_onRemoveRealLoveInviteView_EventArgs;
import com.yy.mobile.livebizwrapper.events.IProgramInfoClient_onRemoveRealLoveView_EventArgs;
import com.yy.mobile.livebizwrapper.events.IProgramInfoClient_onSetAuthVBackground_EventArgs;
import com.yy.mobile.livebizwrapper.events.IProgramInfoClient_onSetAuthVImgHidden_EventArgs;
import com.yy.mobile.livebizwrapper.programinfo.core.IProgramInfoCore;
import com.yy.mobile.livebizwrapper.programinfo.presenter.BaseLiveInfoCompPresenter;
import com.yy.mobile.livebizwrapper.programinfo.presenter.CommonLiveInfoPresenter$$EventBinder;
import com.yy.mobile.livebizwrapper.programinfo.view.IBaseLiveInfoCompView;
import com.yy.mobile.plugin.main.events.IAttentionFriendClient_onQueryBookAnchorBatchResult_EventArgs;
import com.yy.mobile.plugin.main.events.IChannelLinkClient_onJoinChannelSuccess_EventArgs;
import com.yy.mobile.plugin.main.events.IProfileClient_onRequestProfile_EventArgs;
import com.yy.mobile.plugin.main.events.ISubscribeClient_onSubscribeResult_EventArgs;
import com.yy.mobile.plugin.main.events.ISubscribeClient_onUnSubscribeResult_EventArgs;
import com.yy.mobile.plugin.main.events.IUserClient_onRequestDetailUserInfo_EventArgs;
import com.yy.mobile.util.RxUtils;
import com.yy.mobile.util.StringUtils;
import com.yy.mobile.util.log.MLog;
import com.yymobile.core.CoreError;
import com.yymobile.core.CoreFactory;
import com.yymobile.core.ICoreManagerBase;
import com.yymobile.core.channel.ChannelInfo;
import com.yymobile.core.channel.ChannelState;
import com.yymobile.core.profile.EntUserInfo;
import com.yymobile.core.profile.IProfileCore;
import com.yymobile.core.subscribe.IHpSubscribeCore;
import com.yymobile.core.subscribe.ISubscribeCore;
import com.yymobile.core.user.IUserCore;
import com.yymobile.core.user.UserInfo;
import io.reactivex.Flowable;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.Consumer;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class CommonLiveInfoPresenter<V extends IBaseLiveInfoCompView>
extends BaseLiveInfoCompPresenter<V> {
    private static final String TAG = "CommonLiveInfoPresenter";
    private Disposable followDelayCheckDisposable = null;
    private EventBinder mEventBinder;

    @Override
    public void onCreateFinished() {
        MLog.info((String)TAG, (String)"onCreateFinished:");
    }

    @Override
    public void onStartFinish() {
        boolean reStart = this.getReStart();
        MLog.debug((String)TAG, (String)("onStartFinish: reStart = " + reStart));
        if (reStart) {
            this.requestSubscribe("onStartFinish");
        }
    }

    @Override
    public void onViewCreated() {
        super.onViewCreated();
        this.initFollowState();
    }

    @Override
    public void initReqData() {
        this.requestSubscribe("initReqData");
        this.initSetAuthV();
        this.reqUserDetailInfo("initReqData");
    }

    @Override
    public long getLatestAnchorUid() {
        if (this.channelLinkCore != null) {
            return this.channelLinkCore.getCurrentTopMicId();
        }
        return 0L;
    }

    @Override
    public boolean canRefreshAnchorInfo() {
        return true;
    }

    private void initSetAuthV() {
        if (this.programInfoCore != null && this.programInfoCore.getAuthVBackground() != null && this.getView() != null) {
            ((IBaseLiveInfoCompView)this.getView()).setAuthVBackground(this.programInfoCore.getAuthVBackground());
        }
    }

    @BusEvent(busType=1, busName="Live")
    public void onSetAuthVBackground(IProgramInfoClient_onSetAuthVBackground_EventArgs busEventArgs) {
        Drawable drawable2 = busEventArgs.mDrawable;
        if (this.getView() != null) {
            ((IBaseLiveInfoCompView)this.getView()).setAuthVBackground(drawable2);
        }
    }

    @BusEvent(busType=1, busName="Live")
    public void onSetAuthVImgHidden(IProgramInfoClient_onSetAuthVImgHidden_EventArgs busEventArgs) {
        boolean isHidden = busEventArgs.mIsHidden;
        MLog.info((String)TAG, (String)("onSetAuthVImgHidden:" + isHidden));
        if (this.getView() != null) {
            ((IBaseLiveInfoCompView)this.getView()).setAuthVImgHidden(isHidden);
        }
    }

    protected void reqUserDetailInfo(String from) {
        long usingAnchorUid = this.getUsingAnchorUid();
        MLog.info((Object)TAG, (String)"reqUserDetailInfo requestDetailUserInfo usingAnchorUid: %s, from: %s", (Object[])new Object[]{usingAnchorUid, from});
        if (usingAnchorUid != 0L) {
            boolean refreshOnly = ((IUserCore)CoreFactory.getCore(IUserCore.class)).getCacheUserInfoByUid(usingAnchorUid) == null;
            ((IUserCore)CoreFactory.getCore(IUserCore.class)).requestDetailUserInfo(usingAnchorUid, refreshOnly);
            EntUserInfo profileInfo = ((IProfileCore)CoreFactory.getCore(IProfileCore.class)).getCachedProfileInfo(usingAnchorUid);
            if (profileInfo != null && profileInfo.uid == usingAnchorUid) {
                this.mEntUserInfo = profileInfo;
            } else {
                ((IProfileCore)CoreFactory.getCore(IProfileCore.class)).requestProfile(usingAnchorUid);
            }
        } else if (!this.isCurrentMicMode() && this.inChannel() && this.getView() != null) {
            ((IBaseLiveInfoCompView)this.getView()).updateAnchorName(this.channelLinkCore.getCurrentChannelInfo().channelName);
            ((IBaseLiveInfoCompView)this.getView()).setHeadIconAsChannelLogo(this.channelLinkCore.getCurrentChannelInfo().channelLogo);
        }
    }

    @BusEvent
    public void onRequestDetailUserInfo(IUserClient_onRequestDetailUserInfo_EventArgs busEventArgs) {
        long userId = busEventArgs.getUserId();
        UserInfo info = busEventArgs.getInfo();
        boolean isLocalData = busEventArgs.getIsLocalData();
        CoreError error = busEventArgs.getError();
        if (userId == this.getUsingAnchorUid()) {
            MLog.info((String)TAG, (String)("onRequestDetailUserInfo info=" + info + " isLocalData=" + isLocalData + " error = " + error));
            if (!(error != null || info == null || userId <= 0L || StringUtils.isNullOrEmpty((String)info.nickName) && StringUtils.isNullOrEmpty((String)info.reserve1))) {
                String iconUrl = "";
                if (!StringUtils.isNullOrEmpty((String)info.iconUrl_100_100)) {
                    iconUrl = info.iconUrl_100_100;
                } else if (!StringUtils.isNullOrEmpty((String)info.iconUrl_144_144)) {
                    iconUrl = info.iconUrl_144_144;
                } else if (!StringUtils.isNullOrEmpty((String)info.iconUrl_640_640)) {
                    iconUrl = info.iconUrl_640_640;
                }
                this.mIconUrlCache = iconUrl;
                if (this.getView() != null) {
                    ((IBaseLiveInfoCompView)this.getView()).updateAnchorAvatar(iconUrl, info.iconIndex, R.drawable.default_portrait);
                }
                this.mNameCache = this.parseNickName(info);
                ((IBaseLiveInfoCompView)this.getView()).updateAnchorName(this.mNameCache);
            }
        }
    }

    @BusEvent
    public void onRequestProfile(IProfileClient_onRequestProfile_EventArgs busEventArgs) {
        EntUserInfo info = busEventArgs.getInfo();
        if (MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)TAG, (String)"onRequestProfile info = %s", (Object[])new Object[]{info});
        }
        if (info != null && info.uid == this.getUsingAnchorUid() && this.getUsingAnchorUid() != 0L) {
            this.mEntUserInfo = info;
            if (!StringUtils.isNullOrEmpty((String)this.mEntUserInfo.nickName) && !StringUtils.isNullOrEmpty((String)this.mNameCache) && this.isCurrentMicMode() && this.getView() != null) {
                this.mNameCache = this.mEntUserInfo.nickName;
                ((IBaseLiveInfoCompView)this.getView()).updateAnchorName(this.mNameCache);
            }
        }
    }

    private void initFollowState() {
        if (LoginUtil.isLogined() && this.isFollowed) {
            if (this.getView() != null) {
                ((IBaseLiveInfoCompView)this.getView()).updateFollowState(false);
            }
        } else {
            long anchorUid = this.getUsingAnchorUid();
            MLog.info((Object)TAG, (String)"initFollowState: anchorUid=%s, isFollowed=%s", (Object[])new Object[]{anchorUid, this.isFollowed});
            if (this.getView() != null) {
                ((IBaseLiveInfoCompView)this.getView()).updateFollowState(anchorUid != 0L);
            }
        }
    }

    protected void requestSubscribe(String form) {
        long usingAnchorUid = this.getUsingAnchorUid();
        MLog.info((Object)TAG, (String)"requestSubscribe anchorUid:%s, form: %s", (Object[])new Object[]{usingAnchorUid, form});
        if (LoginUtil.isLogined() && usingAnchorUid > 0L) {
            ArrayList<Long> uids = new ArrayList<Long>();
            uids.add(usingAnchorUid);
            this.isMyFollowQueryReq = true;
            if (CoreFactory.getCore(IHpSubscribeCore.class) != null) {
                ((ISubscribeCore)CoreFactory.getCore(ISubscribeCore.class)).queryBookAnchorBatchReq(LoginUtil.getUid(), uids);
            }
        } else if (usingAnchorUid <= 0L) {
            if (ChannelApi.Factory.get().getCurrentChannelInfo().channelType != ChannelInfo.ChannelType.NULL_TYPE) {
                this.initMicModeEmptyInfo();
                if (!LoginUtil.isLogined() && this.getView() != null) {
                    ((IBaseLiveInfoCompView)this.getView()).updateFollowState(true);
                }
            }
        } else if (null != this.getView()) {
            ((IBaseLiveInfoCompView)this.getView()).updateFollowState(true);
        }
    }

    protected void updatePureFollowState(boolean hasFollow) {
    }

    @Override
    public boolean canPopupMomentComponent() {
        return !this.isLandScapeMode() && this.isSceneSupportMomentPop();
    }

    public boolean isSceneSupportMomentPop() {
        IViewScene scene = ViewingRoomApi.Factory.get().getCurrentScene();
        if (scene == BaseViewScene.ENTERTAINMENT) {
            return true;
        }
        if (scene == BaseViewScene.ONEPIECE) {
            return true;
        }
        if (MLog.isLogLevelAboveDebug()) {
            MLog.debug((String)TAG, (String)"the sence not support pop");
        }
        return false;
    }

    @Override
    public void onClickAnchorInfoError() {
        MLog.error((String)TAG, (String)"onClickAnchorInfoError:");
    }

    @Override
    public void onClickFollow() {
        MLog.info((Object)TAG, (String)"onClickFollow: isFollowing=%s, isFollowed=%s", (Object[])new Object[]{this.isFollowing, this.isFollowed});
        if (!this.isFollowing && !this.isFollowed) {
            this.isMyClickFollow = true;
            if (CoreFactory.getCore(ISubscribeCore.class) != null) {
                ((ISubscribeCore)CoreFactory.getCore(ISubscribeCore.class)).subscribe(this.getUsingAnchorUid());
            }
            if (ICoreManagerBase.getCore(IUnionReportCore.class) != null) {
                ((IUnionReportCore)ICoreManagerBase.getCore(IUnionReportCore.class)).setSubscribeType(SubscribeType.SUBSCRIBE_LEFT_HEAD);
            }
            this.isFollowing = true;
            this.delayUpdateFollowState();
        }
    }

    private void delayUpdateFollowState() {
        this.followDelayCheckDisposable = Flowable.timer((long)500L, (TimeUnit)TimeUnit.MILLISECONDS).observeOn(AndroidSchedulers.mainThread()).subscribe((Consumer)new Consumer<Object>(){

            public void accept(Object result) throws Exception {
                if (CommonLiveInfoPresenter.this.getView() != null) {
                    ((IBaseLiveInfoCompView)CommonLiveInfoPresenter.this.getView()).updateFollowState(!CommonLiveInfoPresenter.this.isFollowed);
                }
            }
        }, RxUtils.errorConsumer((String)TAG));
    }

    @BusEvent
    public void onSubscribeResult(ISubscribeClient_onSubscribeResult_EventArgs busEventArgs) {
        long anchorUid = busEventArgs.getAnchorUid();
        boolean success = busEventArgs.getSuccess();
        String errorMsg = busEventArgs.getErrorMsg();
        MLog.info((String)TAG, (String)("onSubscribeResult anchorUid=" + anchorUid + ",success=" + success));
        if (this.getView() == null || !((IBaseLiveInfoCompView)this.getView()).isPageStarted()) {
            return;
        }
        if (this.getUsingAnchorUid() != 0L && anchorUid == this.getUsingAnchorUid() && this.checkActivityValid()) {
            this.isFollowing = false;
            if (success) {
                if (ICoreManagerBase.getCore(IUnionReportCore.class) != null) {
                    ((IUnionReportCore)ICoreManagerBase.getCore(IUnionReportCore.class)).subscribe(anchorUid);
                }
                if (!this.isFollowed) {
                    if (this.isMyClickFollow) {
                        ((IBaseLiveInfoCompView)this.getView()).onFollowResult(true, "");
                    }
                    this.isFollowed = true;
                    if (null != this.getProgramInfoHolder()) {
                        this.getProgramInfoHolder().addSubscribePublicChat(String.valueOf(this.getUsingAnchorUid()));
                    }
                }
            } else if (this.isMyClickFollow) {
                ((IBaseLiveInfoCompView)this.getView()).onFollowResult(false, errorMsg);
            }
            this.updatePureFollowState(this.isFollowed);
            ((IBaseLiveInfoCompView)this.getView()).updateFollowState(!this.isFollowed);
            if (this.isMyClickFollow) {
                LiveRoomRxBus.getInstance().post((Object)new IProgramInfoClient_onFollowResult_EventArgs(anchorUid, "REAL_LOVE_NOTIFY_FROM_ID", true, success));
            } else {
                LiveRoomRxBus.getInstance().post((Object)new IProgramInfoClient_onFollowResult_EventArgs(anchorUid, "", true, success));
            }
            this.isMyClickFollow = false;
            ((IProgramInfoCore)CoreFactory.getCore(IProgramInfoCore.class)).setProfileInfo(anchorUid, true, success);
        }
    }

    @BusEvent
    public void onUnSubscribeResult(ISubscribeClient_onUnSubscribeResult_EventArgs busEventArgs) {
        long anchorUid = busEventArgs.getAnchorUid();
        boolean success = busEventArgs.getSuccess();
        if (this.getView() == null || !((IBaseLiveInfoCompView)this.getView()).isPageStarted()) {
            return;
        }
        if (this.getUsingAnchorUid() != 0L && anchorUid == this.getUsingAnchorUid()) {
            MLog.info((String)TAG, (String)("onUnSubscribeResult anchorUid:" + anchorUid + ",success=" + success));
            if (success) {
                this.isFollowed = false;
                this.isFollowing = false;
                ((IBaseLiveInfoCompView)this.getView()).removeRealLoveView();
                this.updatePureFollowState(this.isFollowed);
                ((IBaseLiveInfoCompView)this.getView()).updateFollowState(!this.isFollowed);
            }
        }
    }

    @BusEvent
    public void onQueryBookAnchorBatchResult(IAttentionFriendClient_onQueryBookAnchorBatchResult_EventArgs busEventArgs) {
        long uid = busEventArgs.getAnchorUid();
        Map friendList = busEventArgs.getFriendList();
        MLog.info((String)TAG, (String)("onQueryBookAnchorBatchResult uid:" + uid + ",friendList=" + friendList));
        if (uid == LoginUtil.getUid() && !LoginUtil.isLogined()) {
            return;
        }
        if (this.getView() == null || !((IBaseLiveInfoCompView)this.getView()).isPageStarted()) {
            return;
        }
        if (uid != 0L && uid == this.getUsingAnchorUid()) {
            ((IBaseLiveInfoCompView)this.getView()).updateFollowState(false);
            return;
        }
        if (uid != 0L && uid == LoginUtil.getUid() && friendList != null && uid != this.getUsingAnchorUid()) {
            for (Map.Entry entry : friendList.entrySet()) {
                if (this.getUsingAnchorUid() == 0L || ((Long)entry.getKey()).longValue() != this.getUsingAnchorUid()) continue;
                this.isFollowed = (Boolean)entry.getValue();
                this.updatePureFollowState(this.isFollowed);
                ((IBaseLiveInfoCompView)this.getView()).updateFollowState(!this.isFollowed);
                if (this.isMyFollowQueryReq) {
                    LiveRoomRxBus.getInstance().post((Object)new IProgramInfoClient_onFollowResult_EventArgs(this.getUsingAnchorUid(), TAG, false, (Boolean)entry.getValue()));
                } else {
                    LiveRoomRxBus.getInstance().post((Object)new IProgramInfoClient_onFollowResult_EventArgs(this.getUsingAnchorUid(), "", false, (Boolean)entry.getValue()));
                }
                this.isMyFollowQueryReq = false;
                ((IProgramInfoCore)CoreFactory.getCore(IProgramInfoCore.class)).setProfileInfo(this.getUsingAnchorUid(), false, (Boolean)entry.getValue());
                break;
            }
        }
    }

    @BusEvent(busType=1, busName="Live")
    public void onAddRealLoveView(IProgramInfoClient_onAddRealLoveView_EventArgs busEventArgs) {
        View view = busEventArgs.mView;
        MLog.info((String)TAG, (String)"onAddRealLoveView");
        if (this.channelLinkCore != null && this.channelLinkCore.getChannelState() == ChannelState.In_Channel && this.isFollowed) {
            ((IBaseLiveInfoCompView)this.getView()).updateFollowState(false);
            ((IBaseLiveInfoCompView)this.getView()).addRealLoveView(view);
        }
    }

    @BusEvent(busType=1, busName="Live")
    public void onRemoveRealLoveView(IProgramInfoClient_onRemoveRealLoveView_EventArgs busEventArgs) {
        MLog.info((String)TAG, (String)"onRemoveRealLoveView:");
        if (this.getView() != null) {
            ((IBaseLiveInfoCompView)this.getView()).removeRealLoveView();
        }
    }

    @BusEvent(busType=1, busName="Live")
    public void addRealLoveInviteView(IProgramInfoClient_onAddRealLoveInviteView_EventArgs busEventArgs) {
        MLog.info((String)TAG, (String)"addRealLoveInviteView:");
        if (this.getView() != null) {
            ((IBaseLiveInfoCompView)this.getView()).addRealLoveInviteView(busEventArgs.mView);
        }
    }

    @BusEvent(busType=1, busName="Live")
    public void removeRealLoveInviteView(IProgramInfoClient_onRemoveRealLoveInviteView_EventArgs busEventArgs) {
        MLog.info((String)TAG, (String)"removeRealLoveInviteView:");
        if (this.getView() != null) {
            ((IBaseLiveInfoCompView)this.getView()).removeRealLoveInviteView();
        }
    }

    @BusEvent
    public void onJoinChannelSuccess(IChannelLinkClient_onJoinChannelSuccess_EventArgs busEventArgs) {
        MLog.info((String)TAG, (String)"onJoinChannelSuccess queryChannelTitleReq start");
        this.queryChannelTitleReq();
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        RxUtils.dispose((Disposable)this.followDelayCheckDisposable);
        this.followDelayCheckDisposable = null;
    }

    @Override
    public void onEventBind() {
        super.onEventBind();
        if (this.mEventBinder == null) {
            this.mEventBinder = new CommonLiveInfoPresenter$$EventBinder();
        }
        this.mEventBinder.bindEvent((Object)this);
    }

    @Override
    public void onEventUnBind() {
        super.onEventUnBind();
        if (this.mEventBinder != null) {
            this.mEventBinder.unBindEvent();
        }
    }
}

