/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.livebizwrapper.programinfo.presenter;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.os.Build;
import android.os.Bundle;
import androidx.fragment.app.FragmentManager;
import com.duowan.mobile.basemedia.api.channel.ChannelApi;
import com.duowan.mobile.basemedia.api.template.ViewingRoomApi;
import com.duowan.mobile.basemedia.watchlive.template.BaseViewScene;
import com.duowan.mobile.basemedia.watchlive.template.IViewScene;
import com.duowan.mobile.livebasebiz.event.IChatEmotionClient_onChatInputSwitch_EventArgs;
import com.yy.android.sniper.annotation.inject.BusEvent;
import com.yy.android.sniper.api.event.EventBinder;
import com.yy.ent.mobile.live.base.common.pb.nano.LiveBase;
import com.yy.mobile.bizmodel.login.LoginUtil;
import com.yy.mobile.livebizwrapper.R;
import com.yy.mobile.livebizwrapper.programinfo.IProgramInfoBizHolder;
import com.yy.mobile.livebizwrapper.programinfo.core.IProgramInfoCore;
import com.yy.mobile.livebizwrapper.programinfo.presenter.BaseLiveInfoCompPresenter$$EventBinder;
import com.yy.mobile.livebizwrapper.programinfo.presenter.ChannelOnlineCountHandler;
import com.yy.mobile.livebizwrapper.programinfo.view.IBaseLiveInfoCompView;
import com.yy.mobile.mvp.MvpPresenter;
import com.yy.mobile.plugin.main.events.IAuthClient_onLoginSucceed_EventArgs;
import com.yy.mobile.plugin.main.events.IChannelLinkClient_leaveCurrentChannel_EventArgs;
import com.yy.mobile.plugin.main.events.IChannelLinkClient_onJoinChannelProgress_EventArgs;
import com.yy.mobile.plugin.main.events.IChannelLinkClient_onRequestJoinChannelError_EventArgs;
import com.yy.mobile.plugin.main.events.IChannelLinkClient_onRequestJoinChannelNoChannel_EventArgs;
import com.yy.mobile.plugin.main.events.IChannelLinkClient_onRequestJoinChannelTimeout_EventArgs;
import com.yy.mobile.plugin.main.events.IChannelLinkClient_updateCurrentChannelInfo_EventArgs;
import com.yy.mobile.plugin.main.events.IChannelLinkClient_updateCurrentChannelMicQueue_EventArgs;
import com.yy.mobile.sdkwrapper.flowmanagement.event.audience.NoVideoStreamEvent;
import com.yy.mobile.sdkwrapper.flowmanagement.event.audience.streamcompat.VideoStreamArriveCompatEvent;
import com.yy.mobile.sdkwrapper.flowmanagement.event.audience.streamcompat.VideoStreamStopCompatEvent;
import com.yy.mobile.sdkwrapper.flowmanagement.internal.audience.nolive.NoLiveManager;
import com.yy.mobile.ui.basicchanneltemplate.component.Component;
import com.yy.mobile.util.FP;
import com.yy.mobile.util.RxUtils;
import com.yy.mobile.util.log.MLog;
import com.yy.mobile.util.valid.BlankUtil;
import com.yymobile.core.CoreFactory;
import com.yymobile.core.channel.ChannelInfo;
import com.yymobile.core.channel.ChannelState;
import com.yymobile.core.ent.protos.IEntProtocol;
import com.yymobile.core.profile.EntUserInfo;
import com.yymobile.core.user.UserInfo;
import com.yymobile.event.programinfo.ChangeProgramInfoVisibilityArgs;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.Consumer;
import io.reactivex.schedulers.Schedulers;

public abstract class BaseLiveInfoCompPresenter<V extends IBaseLiveInfoCompView>
extends MvpPresenter<V> {
    private static final String TAG = "BaseLiveInfoCompPresenter";
    protected static final String REAL_LOVE_NOTIFY_FROM_ID = "REAL_LOVE_NOTIFY_FROM_ID";
    protected Context mContext;
    protected IProgramInfoCore programInfoCore;
    protected ChannelApi channelLinkCore;
    protected EntUserInfo mEntUserInfo = null;
    protected boolean isFollowing = false;
    protected boolean isFollowed = false;
    protected boolean isMyClickFollow = false;
    protected boolean isMyFollowQueryReq = false;
    protected String mIconUrlCache;
    protected String mNameCache;
    private long mUsingAnchorUid = 0L;
    protected ChannelOnlineCountHandler mChannelOnlineCountHandler;
    protected ExtVisibilityOption mExtVisibilityOption = ExtVisibilityOption.INIT;
    protected boolean isReStart = false;
    private Disposable mQueryChannelTitleReqDisposable = null;
    private ChannelOnlineCountHandler.CountCallBack countCallBack = new ChannelOnlineCountHandler.CountCallBack(){

        @Override
        public void onUpdate(int count) {
            if (BaseLiveInfoCompPresenter.this.getView() != null) {
                String c = "...";
                if (count > 0) {
                    c = String.valueOf(count);
                }
                if (BaseLiveInfoCompPresenter.this.getView() != null) {
                    ((IBaseLiveInfoCompView)BaseLiveInfoCompPresenter.this.getView()).updateOnlineCount(c);
                }
            }
        }
    };
    private EventBinder mEventBinder;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.onEventBind();
        this.isFollowing = false;
        this.isFollowed = false;
        this.onCreateFinished();
    }

    protected void attachView(V view) {
        super.attachView(view);
        this.mContext = ((Component)this.getView()).getActivity();
        this.programInfoCore = (IProgramInfoCore)CoreFactory.getCore(IProgramInfoCore.class);
        this.channelLinkCore = ChannelApi.Factory.get();
        this.mChannelOnlineCountHandler = new ChannelOnlineCountHandler();
        this.mChannelOnlineCountHandler.setCountCallBack(this.countCallBack);
        long initUid = this.getLatestAnchorUid();
        MLog.info((Object)TAG, (String)"attachView: initUid=%s", (Object[])new Object[]{initUid});
        this.updateUsingAnchorUid(initUid);
    }

    public void onViewCreated() {
    }

    protected void onStart() {
        super.onStart();
        this.onStartFinish();
        this.handleJoinChannelError();
        if (this.mChannelOnlineCountHandler != null) {
            this.mChannelOnlineCountHandler.initOnlineAudienceNum();
        }
        this.isReStart = false;
    }

    protected void onStop() {
        super.onStop();
        this.isReStart = true;
    }

    protected boolean getReStart() {
        return this.isReStart;
    }

    public abstract void onStartFinish();

    public abstract void onCreateFinished();

    public abstract void initReqData();

    public long getUsingAnchorUid() {
        return this.mUsingAnchorUid;
    }

    protected void updateUsingAnchorUid(long uid) {
        MLog.info((Object)TAG, (String)"updateUsingAnchorUid: from mUsingAnchorUid=%s, to target uid=%s", (Object[])new Object[]{this.mUsingAnchorUid, uid});
        this.mUsingAnchorUid = uid;
    }

    public abstract long getLatestAnchorUid();

    public abstract boolean canPopupMomentComponent();

    public abstract void onClickAnchorInfoError();

    public abstract void onClickFollow();

    public void setFollowingFinished() {
        this.isFollowing = false;
    }

    public abstract boolean canRefreshAnchorInfo();

    public void onClickAnchorInfo(FragmentManager fragmentManager) {
        MLog.info((String)TAG, (String)("onClickAnchorInfo\uff1amEntUserInfo=" + this.mEntUserInfo));
        if (this.checkActivityValid() && null != this.getProgramInfoHolder()) {
            if (this.canPopupMomentComponent()) {
                this.getProgramInfoHolder().showAnchorMomentComponent();
            } else if (this.mEntUserInfo != null && this.mEntUserInfo.uid != 0L) {
                this.getProgramInfoHolder().showPersonalCardComponent(this.mEntUserInfo.uid, this.mEntUserInfo.userType == 1, this.mIconUrlCache);
            }
        } else {
            this.onClickAnchorInfoError();
        }
    }

    @TargetApi(value=17)
    protected boolean checkActivityValid() {
        if (this.mContext == null) {
            return false;
        }
        if (this.mContext instanceof Activity && ((Activity)this.mContext).isFinishing()) {
            return false;
        }
        return Build.VERSION.SDK_INT < 17 || !(this.mContext instanceof Activity) || !((Activity)this.mContext).isDestroyed();
    }

    private void handleJoinChannelError() {
        if (this.programInfoCore.getJoinChannelError() && this.getView() != null) {
            ((IBaseLiveInfoCompView)this.getView()).updateAnchorName("");
            ((IBaseLiveInfoCompView)this.getView()).updateOnlineCount("");
            ((IBaseLiveInfoCompView)this.getView()).updateFollowState(false);
        }
    }

    protected String parseNickName(UserInfo info) {
        if (info == null) {
            return "";
        }
        if (!FP.empty((CharSequence)info.reserve1)) {
            return info.reserve1;
        }
        return info.nickName;
    }

    protected ChannelInfo.ChannelMode getChannelMode() {
        ChannelApi channelLinkCore = ChannelApi.Factory.get();
        if (channelLinkCore.getCurrentChannelInfo() != null && channelLinkCore.getCurrentChannelInfo().channelMode != null) {
            return channelLinkCore.getCurrentChannelInfo().channelMode;
        }
        return ChannelInfo.ChannelMode.MicQueue_Mode;
    }

    protected boolean isCurrentMicMode() {
        ChannelApi channelLinkCore = ChannelApi.Factory.get();
        return channelLinkCore.getChannelState() == ChannelState.In_Channel && this.getChannelMode() == ChannelInfo.ChannelMode.MicQueue_Mode;
    }

    protected boolean inChannel() {
        ChannelApi channelLinkCore = ChannelApi.Factory.get();
        return channelLinkCore.getChannelState() == ChannelState.In_Channel;
    }

    public boolean isLandScapeMode() {
        if (this.checkActivityValid() && this.mContext.getResources() != null) {
            return this.mContext.getResources().getConfiguration().orientation == 2;
        }
        return false;
    }

    @BusEvent(sync=true)
    public void onJoinChannelProgress(IChannelLinkClient_onJoinChannelProgress_EventArgs busEventArgs) {
        if (this.checkActivityValid()) {
            MLog.info((String)TAG, (String)"onJoinChannelProgress");
            if (this.getView() != null) {
                ((IBaseLiveInfoCompView)this.getView()).updateAnchorName(this.mContext.getString(R.string.str_default_loading_nick));
                ((IBaseLiveInfoCompView)this.getView()).updateAnchorAvatar("", 0, R.drawable.default_portrait);
                ((IBaseLiveInfoCompView)this.getView()).updateFollowState(false);
                ((IBaseLiveInfoCompView)this.getView()).updateOnlineCount("...");
                ((IBaseLiveInfoCompView)this.getView()).clearAuthV();
            }
            this.resetData();
            this.onJoinChannelProgressEvent();
        }
    }

    protected void onJoinChannelProgressEvent() {
    }

    @BusEvent
    public void onRequestJoinChannelNoChannel(IChannelLinkClient_onRequestJoinChannelNoChannel_EventArgs busEventArgs) {
        this.handleJoinChannelError();
    }

    @BusEvent
    public void onRequestJoinChannelError(IChannelLinkClient_onRequestJoinChannelError_EventArgs busEventArgs) {
        this.handleJoinChannelError();
    }

    @BusEvent
    public void onRequestJoinChannelTimeout(IChannelLinkClient_onRequestJoinChannelTimeout_EventArgs busEventArgs) {
        this.handleJoinChannelError();
    }

    @BusEvent
    public void updateCurrentChannelInfo(IChannelLinkClient_updateCurrentChannelInfo_EventArgs busEventArgs) {
        ChannelInfo info = busEventArgs.getChannelInfo();
        this.updateCurrentChannelInfoEvent(info);
    }

    protected void updateCurrentChannelInfoEvent(ChannelInfo info) {
        long usingUid = this.getUsingAnchorUid();
        long latestUid = this.getLatestAnchorUid();
        MLog.info((Object)TAG, (String)"updateCurrentChannelInfoEvent: channelMode=%s, usingAnchorUid=%s, latestAnchorUid=%s", (Object[])new Object[]{this.getChannelMode(), usingUid, latestUid});
        if (!this.isCurrentMicMode() && this.inChannel() && this.getLatestAnchorUid() == 0L) {
            if (this.getView() != null) {
                ((IBaseLiveInfoCompView)this.getView()).updateFollowState(false);
                ((IBaseLiveInfoCompView)this.getView()).updateAnchorName(this.channelLinkCore.getCurrentChannelInfo().channelName);
                ((IBaseLiveInfoCompView)this.getView()).setHeadIconAsChannelLogo(this.channelLinkCore.getCurrentChannelInfo().channelLogo);
                ((IBaseLiveInfoCompView)this.getView()).removeRealLoveView();
            }
        } else {
            if (this.getView() != null) {
                ((IBaseLiveInfoCompView)this.getView()).updateFollowState(!this.isFollowed);
            }
            this.refreshAnchorInfo(usingUid != latestUid, latestUid, "updateCurrentChannelInfoEvent");
        }
    }

    protected synchronized void refreshAnchorInfo(boolean refresh, long latestUid, String from) {
        MLog.info((Object)TAG, (String)"refreshAnchorInfo: refresh=%s, latestUid=%s, from=%s", (Object[])new Object[]{refresh, latestUid, from});
        if (!this.canRefreshAnchorInfo()) {
            MLog.info((String)TAG, (String)"refreshAnchorInfo: canRefreshAnchorInfo false, return");
            return;
        }
        this.updateUsingAnchorUid(latestUid);
        if (!LoginUtil.isLogined() && this.getView() != null) {
            ((IBaseLiveInfoCompView)this.getView()).updateFollowState(latestUid != 0L);
        }
        if (this.getLatestAnchorUid() == 0L) {
            this.mEntUserInfo = null;
            this.initMicModeEmptyInfo();
        } else if (refresh) {
            this.initReqData();
        }
    }

    public void initMicModeEmptyInfo() {
        MLog.info((String)TAG, (String)"initMicModeEmptyInfo");
        if (this.getView() != null && this.checkActivityValid()) {
            ((IBaseLiveInfoCompView)this.getView()).updateAnchorName(this.mContext.getString(R.string.str_default_idle_nick));
            ((IBaseLiveInfoCompView)this.getView()).updateAnchorAvatar("", 0, R.drawable.default_portrait);
            ((IBaseLiveInfoCompView)this.getView()).updateFollowState(false);
            ((IBaseLiveInfoCompView)this.getView()).clearAuthV();
        }
        this.resetData();
    }

    @BusEvent(busType=1, busName="FlowRxBus")
    public void onMediaVideoArrive(VideoStreamArriveCompatEvent busEventArgs) {
        long usingUid = this.getUsingAnchorUid();
        long latestUid = this.getLatestAnchorUid();
        MLog.info((Object)TAG, (String)"onMediaVideoArrive: usingUid=%s, latestUid=%s, isFollowed=%s", (Object[])new Object[]{usingUid, latestUid, this.isFollowed});
        if (latestUid != 0L && latestUid != usingUid) {
            if (this.getView() != null) {
                ((IBaseLiveInfoCompView)this.getView()).updateFollowState(!this.isFollowed);
            }
            this.refreshAnchorInfo(usingUid != latestUid, latestUid, "onMediaVideoArrive");
        }
    }

    @BusEvent
    public void updateCurrentChannelMicQueue(IChannelLinkClient_updateCurrentChannelMicQueue_EventArgs busEventArgs) {
        long oldTopUid = busEventArgs.getOldTopUid();
        long newTopUid = busEventArgs.getNewTopUid();
        boolean changeTop = busEventArgs.getChangeTop();
        MLog.info((String)TAG, (String)("updateCurrentChannelMicQueue changeTop: " + changeTop + " newTopUid = " + newTopUid + " oldTopUid = " + oldTopUid));
        if (!this.isCurrentMicMode() || !this.inChannel()) {
            return;
        }
        long usingUid = this.getUsingAnchorUid();
        long latestUid = this.getLatestAnchorUid();
        MLog.info((Object)TAG, (String)"updateCurrentChannelMicQueue: usingUid=%s, latestUid=%s, isFollowed=%s", (Object[])new Object[]{usingUid, latestUid, this.isFollowed});
        if (latestUid != 0L && latestUid != usingUid) {
            if (this.getView() != null) {
                ((IBaseLiveInfoCompView)this.getView()).updateFollowState(!this.isFollowed);
                this.refreshAnchorInfo(usingUid != latestUid, latestUid, "updateCurrentChannelMicQueue");
            }
        } else if (latestUid == 0L) {
            this.updateUsingAnchorUid(0L);
            this.mEntUserInfo = null;
            this.initMicModeEmptyInfo();
        }
    }

    @BusEvent(busType=1, busName="FlowRxBus")
    public void onVideoStreamStopEvent(VideoStreamStopCompatEvent event) {
        if (ChannelApi.Factory.get().getChannelState() == ChannelState.No_Channel) {
            MLog.info((String)TAG, (String)"onVideoStreamStopEvent No_Channel");
            return;
        }
        long usingUid = this.getUsingAnchorUid();
        long latestUid = this.getLatestAnchorUid();
        MLog.info((Object)TAG, (String)"onVideoStreamStopEvent: usingUid=%s, latestUid=%s, isFollowed=%s", (Object[])new Object[]{usingUid, latestUid, this.isFollowed});
        if (this.inChannel()) {
            if (!this.isCurrentMicMode() && latestUid == 0L) {
                if (this.getView() != null) {
                    ((IBaseLiveInfoCompView)this.getView()).updateFollowState(false);
                    ((IBaseLiveInfoCompView)this.getView()).updateAnchorName(this.channelLinkCore.getCurrentChannelInfo().channelName);
                    ((IBaseLiveInfoCompView)this.getView()).setHeadIconAsChannelLogo(this.channelLinkCore.getCurrentChannelInfo().channelLogo);
                    ((IBaseLiveInfoCompView)this.getView()).removeRealLoveView();
                }
            } else {
                if (this.getView() != null) {
                    ((IBaseLiveInfoCompView)this.getView()).updateFollowState(!this.isFollowed);
                }
                this.refreshAnchorInfo(usingUid != latestUid, latestUid, "onVideoStreamStopEvent");
            }
        }
    }

    @BusEvent
    public void onNoVideoStreamEvent(NoVideoStreamEvent event) {
        MLog.info((String)TAG, (String)"onNoVideoStreamEvent: no live hide follow btn");
        if (this.getView() != null) {
            ((IBaseLiveInfoCompView)this.getView()).updateFollowState(false);
        }
    }

    @BusEvent
    public void onLoginSucceed(IAuthClient_onLoginSucceed_EventArgs busEventArgs) {
        MLog.info((String)TAG, (String)"onLoginSucceed:");
        this.initReqData();
    }

    @BusEvent
    public void onChatInputSwitch(IChatEmotionClient_onChatInputSwitch_EventArgs busEventArgs) {
        boolean chatInputSwitch = busEventArgs.getChatInputSwitch();
        MLog.info((String)TAG, (String)"onChatInputSwitch\uff1a");
        if (this.channelLinkCore != null && this.channelLinkCore.getChannelState() == ChannelState.In_Channel) {
            MLog.info((Object)TAG, (String)"onChatInputSwitch\uff1amChangeVisibilityValue=%s, chatInputSwitch=%s", (Object[])new Object[]{this.mExtVisibilityOption, chatInputSwitch});
            if (this.mExtVisibilityOption == ExtVisibilityOption.INVISIBIE && !chatInputSwitch) {
                return;
            }
            if (this.getView() != null) {
                ((IBaseLiveInfoCompView)this.getView()).updateComponentState(!chatInputSwitch);
            }
        }
    }

    @BusEvent
    public void onChangeProgramInfoVisibility(ChangeProgramInfoVisibilityArgs args) {
        MLog.info((String)TAG, (String)("onChangeProgramInfoVisibility: arg=" + args));
        if (this.getView() != null) {
            this.mExtVisibilityOption = args.isVisibile ? ExtVisibilityOption.VISIBLE : ExtVisibilityOption.INVISIBIE;
            ((IBaseLiveInfoCompView)this.getView()).updateComponentState(args.isVisibile);
        }
    }

    public void queryChannelTitleReq() {
        IViewScene viewScene = ViewingRoomApi.Factory.get().getCurrentScene();
        ChannelInfo info = ChannelApi.Factory.get().getCurrentChannelInfo();
        boolean isCurrentNoLive = NoLiveManager.getInstance().isCurrentNoLive();
        long topSid = info.topSid;
        long subSid = info.subSid;
        MLog.info((String)TAG, (String)("queryChannelTitleReq getCurrentScene = " + viewScene + " topSid = " + topSid + " subSid = " + subSid + " isCurrentNoLive = " + isCurrentNoLive));
        if (BaseViewScene.ENTERTAINMENT != viewScene || isCurrentNoLive) {
            return;
        }
        long currentTopMicId = this.getLatestAnchorUid();
        LiveBase.QueryChannelTitleReq queryChannelTitleReq = new LiveBase.QueryChannelTitleReq();
        queryChannelTitleReq.aid = currentTopMicId;
        queryChannelTitleReq.sid = topSid;
        queryChannelTitleReq.ssid = subSid;
        MLog.info((Object)TAG, (String)"queryChannelTitleReq currentTopMicId = %d", (Object[])new Object[]{currentTopMicId});
        RxUtils.dispose((Disposable)this.mQueryChannelTitleReqDisposable);
        this.mQueryChannelTitleReqDisposable = CoreFactory.getEntCore().sendAsFlowable(LiveBase.QueryChannelTitleRsp.class, (IEntProtocol)queryChannelTitleReq).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).subscribe((Consumer)new Consumer<LiveBase.QueryChannelTitleRsp>(){

            public void accept(LiveBase.QueryChannelTitleRsp queryChannelTitleRsp) throws Exception {
                int result = queryChannelTitleRsp.result;
                String msg = queryChannelTitleRsp.msg;
                String title = queryChannelTitleRsp.title;
                String bizName = queryChannelTitleRsp.bizName;
                boolean showBizName = queryChannelTitleRsp.showBizName;
                MLog.info((Object)BaseLiveInfoCompPresenter.TAG, (String)"queryChannelTitleReq result = %d , msg = %s , title = %s , bizName = %s , showBizName = %b", (Object[])new Object[]{result, msg, title, bizName, showBizName});
                if (result == 0 && showBizName && !BlankUtil.isBlank((String)bizName) && BaseLiveInfoCompPresenter.this.getView() != null) {
                    ((IBaseLiveInfoCompView)BaseLiveInfoCompPresenter.this.getView()).setBizName(bizName);
                }
            }
        }, RxUtils.errorConsumer((String)TAG, (String)"queryChannelTitleReq error"));
    }

    protected void detachView() {
        super.detachView();
        if (this.mChannelOnlineCountHandler != null) {
            this.mChannelOnlineCountHandler.release();
            this.mChannelOnlineCountHandler = null;
        }
    }

    protected void onDestroy() {
        super.onDestroy();
        this.onEventUnBind();
        this.resetData();
        RxUtils.dispose((Disposable)this.mQueryChannelTitleReqDisposable);
        this.mQueryChannelTitleReqDisposable = null;
    }

    @BusEvent(sync=true)
    public void leaveCurrentChannel(IChannelLinkClient_leaveCurrentChannel_EventArgs busEventArgs) {
        MLog.info((String)TAG, (String)"leaveCurrentChannel");
        this.resetData();
        this.updateUsingAnchorUid(0L);
        if (this.getView() != null) {
            ((IBaseLiveInfoCompView)this.getView()).setBizName("");
        }
    }

    protected void resetData() {
        MLog.info((String)TAG, (String)"resetData");
        this.mEntUserInfo = null;
        this.isFollowing = false;
        this.isFollowed = false;
        this.isMyClickFollow = false;
        this.isMyFollowQueryReq = false;
        this.mIconUrlCache = null;
        this.mNameCache = null;
        this.mExtVisibilityOption = ExtVisibilityOption.INIT;
    }

    public EntUserInfo getEntUserInfo() {
        return this.mEntUserInfo;
    }

    protected IProgramInfoBizHolder getProgramInfoHolder() {
        if (null == this.getView()) {
            return null;
        }
        return ((IBaseLiveInfoCompView)this.getView()).getProgrameInfoHolder();
    }

    public void onEventBind() {
        super.onEventBind();
        if (this.mEventBinder == null) {
            this.mEventBinder = new BaseLiveInfoCompPresenter$$EventBinder();
        }
        this.mEventBinder.bindEvent((Object)this);
    }

    public void onEventUnBind() {
        super.onEventUnBind();
        if (this.mEventBinder != null) {
            this.mEventBinder.unBindEvent();
        }
    }

    private static enum ExtVisibilityOption {
        INIT,
        INVISIBIE,
        VISIBLE;

    }
}

