/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.livebizwrapper.programinfo.component;

import android.graphics.drawable.Drawable;
import android.graphics.drawable.StateListDrawable;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.PopupWindow;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.FragmentActivity;
import com.bumptech.glide.Glide;
import com.bumptech.glide.request.RequestOptions;
import com.duowan.mobile.basemedia.api.channel.ChannelApi;
import com.duowan.mobile.livebasebiz.event.LiveTaskTipsEventArgs;
import com.duowan.mobile.main.kinds.Kinds;
import com.yy.android.sniper.annotation.inject.BusEvent;
import com.yy.android.sniper.annotation.mvp.DelegateBind;
import com.yy.android.sniper.api.event.EventBinder;
import com.yy.hiidostatis.defs.obj.Property;
import com.yy.mobile.abtest.newuserguide.NewUserGuide2ABTest;
import com.yy.mobile.bizmodel.login.LoginUtil;
import com.yy.mobile.image.RecycleImageView;
import com.yy.mobile.livebizwrapper.R;
import com.yy.mobile.livebizwrapper.advertisement.Advertisement;
import com.yy.mobile.livebizwrapper.advertisement.IAdvertisementCore;
import com.yy.mobile.livebizwrapper.chatscreen.LiveStatistic;
import com.yy.mobile.livebizwrapper.component.LiveBizComponentLinkProvider;
import com.yy.mobile.livebizwrapper.guideview.event.IsFollowGuideEvent;
import com.yy.mobile.livebizwrapper.officialchannel.IChannelInfoOfficialUICore;
import com.yy.mobile.livebizwrapper.programinfo.DefaultProgramInfoBizHolder;
import com.yy.mobile.livebizwrapper.programinfo.IProgramInfoBizHolder;
import com.yy.mobile.livebizwrapper.programinfo.component.OfficialLiveInfoComponent$$EventBinder;
import com.yy.mobile.livebizwrapper.programinfo.core.IProgramInfoCore;
import com.yy.mobile.livebizwrapper.programinfo.presenter.OfficialLiveInfoPresenter;
import com.yy.mobile.livebizwrapper.programinfo.presenter.OnlineUsersHandle;
import com.yy.mobile.livebizwrapper.programinfo.util.ChannelInfoMobuleUtil;
import com.yy.mobile.livebizwrapper.programinfo.view.IOfficialLiveInfoView;
import com.yy.mobile.livebizwrapper.programinfo.widget.ChannelIdView;
import com.yy.mobile.livebizwrapper.utils.NoRepeatClickListener;
import com.yy.mobile.login.LoginEntranceType;
import com.yy.mobile.ui.basicchanneltemplate.component.Component;
import com.yy.mobile.ui.liveinfo.ChangeOfficialLiveRoomPositionArg;
import com.yy.mobile.ui.liveinfo.ClickFollowListener;
import com.yy.mobile.ui.liveinfo.LiveInfoApi;
import com.yy.mobile.ui.liveinfo.LiveInfoUiApiHolder;
import com.yy.mobile.ui.widget.bubblelayout.ArrowDirection;
import com.yy.mobile.ui.widget.bubblelayout.TextBubblePopupWindow;
import com.yy.mobile.util.FP;
import com.yy.mobile.util.RxUtils;
import com.yy.mobile.util.ScreenUtil;
import com.yy.mobile.util.log.MLog;
import com.yy.mobile.util.pref.CommonPref;
import com.yy.mobile.util.valid.BlankUtil;
import com.yymobile.core.CoreFactory;
import com.yymobile.core.channel.ChannelInfo;
import com.yymobile.core.statistic.IHiidoStatisticCore;
import io.reactivex.Observable;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.Consumer;
import io.reactivex.subjects.BehaviorSubject;
import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

@DelegateBind(presenter=OfficialLiveInfoPresenter.class)
public class OfficialLiveInfoComponent
extends Component<OfficialLiveInfoPresenter, IOfficialLiveInfoView>
implements IOfficialLiveInfoView,
View.OnClickListener,
LiveInfoApi,
LiveBizComponentLinkProvider.OnHolderCreatedWithDefaultListener<IProgramInfoBizHolder> {
    private static final String TAG = "OfficialLiveInfoComponent";
    protected View mRootView;
    protected RelativeLayout rlLiveOfficialInfoLayout;
    protected RecycleImageView imgAdImage;
    protected TextView tvOnlineCount;
    protected ImageView onlineIcon;
    protected TextView tvContribution;
    protected TextView tvLiveInfoEntrance;
    protected RelativeLayout rlTrueLoveInviteAnimatorLayout;
    protected TextView tvNickName;
    protected RecycleImageView imgAttentionIcon;
    protected RelativeLayout rlRealLoveLayout;
    protected FrameLayout flAnchorInfoLayout;
    private FrameLayout flAnchorInfoReplacement;
    private ChannelIdView mChannelIdView;
    private boolean hasReplaceLiveInfoLayout;
    protected boolean isStarted;
    private Boolean hasFollowed = null;
    private ClickFollowListener clickFollowListener;
    private BehaviorSubject<Boolean> hasFollowedSubject = BehaviorSubject.create();
    private IProgramInfoBizHolder programInfoBizHolder;
    private Disposable hideGuideDisposable;
    private TextBubblePopupWindow bubblePopupWindow;
    private Disposable hideTaskGuideDisposable;
    private TextBubblePopupWindow taskPopupWindow;
    private View channelBizLayout;
    private TextView channelBizName;
    protected NoRepeatClickListener mAnchorInfoClickListener = new NoRepeatClickListener(){

        @Override
        public void onNoRepeatClick(View view) {
            ChannelInfo channelInfo;
            MLog.info((String)OfficialLiveInfoComponent.TAG, (String)"AnchorInfoClick:");
            if (OfficialLiveInfoComponent.this.checkActivityValid()) {
                ((OfficialLiveInfoPresenter)OfficialLiveInfoComponent.this.getPresenter()).onClickAnchorInfo(OfficialLiveInfoComponent.this.getChildFragmentManager());
            }
            if (null == (channelInfo = ChannelApi.Factory.get().getCurrentChannelInfo())) {
                channelInfo = new ChannelInfo();
            }
            Property property = new Property();
            property.putString("key1", "" + channelInfo.topSid);
            property.putString("key2", "" + ((OfficialLiveInfoPresenter)OfficialLiveInfoComponent.this.getPresenter()).getUsingAnchorUid());
            property.putString("key3", "" + channelInfo.channelMode.ordinal());
            ((IHiidoStatisticCore)CoreFactory.getCore(IHiidoStatisticCore.class)).sendEventStatistic("51001", "0001", (Serializable)property);
        }
    };
    protected View.OnClickListener mFollowBtnClickListener = new View.OnClickListener(){

        public void onClick(View view) {
            if (OfficialLiveInfoComponent.this.isNetworkAvailable()) {
                MLog.info((String)OfficialLiveInfoComponent.TAG, (String)"FollowBtnClick:");
                if (!LoginUtil.isLogined()) {
                    if (null != OfficialLiveInfoComponent.this.programInfoBizHolder) {
                        OfficialLiveInfoComponent.this.programInfoBizHolder.showLogin(LoginEntranceType.LIVE_FOLLOW, ((OfficialLiveInfoPresenter)OfficialLiveInfoComponent.this.getPresenter()).getLatestAnchorUid());
                    }
                } else {
                    ((OfficialLiveInfoPresenter)OfficialLiveInfoComponent.this.getPresenter()).onClickFollow();
                    if (OfficialLiveInfoComponent.this.clickFollowListener != null) {
                        MLog.info((String)OfficialLiveInfoComponent.TAG, (String)"FollowBtnClick: click and req");
                        OfficialLiveInfoComponent.this.clickFollowListener.onClickFollowAndReq();
                    }
                }
                ChannelInfo channelInfo = ChannelApi.Factory.get().getCurrentChannelInfo();
                Map<String, String> property = LiveStatistic.createliveChannelBaseProperty();
                property.put("key4", String.valueOf(channelInfo.subSid));
                property.put("key5", String.valueOf(((OfficialLiveInfoPresenter)OfficialLiveInfoComponent.this.getPresenter()).getUsingAnchorUid()));
                ((IHiidoStatisticCore)CoreFactory.getCore(IHiidoStatisticCore.class)).sendEventStatistic(LoginUtil.getUid(), "51001", "0002", property);
            } else {
                OfficialLiveInfoComponent.this.toast("\u7f51\u7edc\u4e0d\u7ed9\u529b");
            }
        }
    };
    private EventBinder mEventBinder;

    public static OfficialLiveInfoComponent newInstance() {
        OfficialLiveInfoComponent component = new OfficialLiveInfoComponent();
        return component;
    }

    @Nullable
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        this.mRootView = inflater.inflate(R.layout.fragment_official_live_info_component, container, false);
        this.rlLiveOfficialInfoLayout = (RelativeLayout)this.mRootView.findViewById(R.id.live_offical_info_container);
        this.flAnchorInfoReplacement = (FrameLayout)this.mRootView.findViewById(R.id.fl_anchor_info_replacement);
        this.imgAdImage = (RecycleImageView)this.mRootView.findViewById(R.id.img_ad_image);
        this.tvOnlineCount = (TextView)this.mRootView.findViewById(R.id.online_count);
        this.onlineIcon = (ImageView)this.mRootView.findViewById(R.id.online_icon);
        this.tvContribution = (TextView)this.mRootView.findViewById(R.id.contribution);
        this.tvLiveInfoEntrance = (TextView)this.mRootView.findViewById(R.id.tv_live_info_entrance);
        this.rlLiveOfficialInfoLayout.setOnClickListener((View.OnClickListener)this);
        this.tvLiveInfoEntrance.setOnClickListener((View.OnClickListener)this);
        this.channelBizLayout = this.mRootView.findViewById(R.id.channel_biz_layout);
        this.channelBizName = (TextView)this.mRootView.findViewById(R.id.channel_biz_name);
        this.mChannelIdView = (ChannelIdView)this.mRootView.findViewById(R.id.view_official_channel_id_layout);
        this.flAnchorInfoLayout = (FrameLayout)this.mRootView.findViewById(R.id.rl_anchor_info_layout);
        this.tvNickName = (TextView)this.mRootView.findViewById(R.id.tv_nick_name);
        this.imgAttentionIcon = (RecycleImageView)this.mRootView.findViewById(R.id.img_attention_icon);
        this.imgAttentionIcon.setImageResource(R.drawable.bg_live_room_follow);
        this.rlRealLoveLayout = (RelativeLayout)this.mRootView.findViewById(R.id.rl_real_love_layout);
        this.rlTrueLoveInviteAnimatorLayout = (RelativeLayout)this.mRootView.findViewById(R.id.rl_true_love_invite_animator);
        if (((IAdvertisementCore)CoreFactory.getCore(IAdvertisementCore.class)).getCurrentAd() != null) {
            this.loadAdvertisementPic(((IAdvertisementCore)CoreFactory.getCore(IAdvertisementCore.class)).getCurrentAd());
        }
        if (this.needUpdateOnlineIcon() && this.onlineIcon != null) {
            this.onlineIcon.setImageResource(OnlineUsersHandle.Companion.instance().getOnlineIconRes());
        }
        return this.mRootView;
    }

    public void onViewCreated(View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        MLog.debug((String)TAG, (String)"onViewCreated:");
        this.initSetBgDrwable();
        ((OfficialLiveInfoPresenter)this.getPresenter()).initReqData();
        ((OfficialLiveInfoPresenter)this.getPresenter()).queryChannelTitleReq();
        this.flAnchorInfoLayout.setOnClickListener((View.OnClickListener)this.mAnchorInfoClickListener);
        this.imgAttentionIcon.setOnClickListener(this.mFollowBtnClickListener);
        ((OfficialLiveInfoPresenter)this.getPresenter()).initContributionListen();
        LiveInfoUiApiHolder.INSTANCE.setApi((LiveInfoApi)this);
        LiveBizComponentLinkProvider.INSTANCE.callCreateHolder(this, DefaultProgramInfoBizHolder.class);
    }

    @BusEvent
    public void isFollowEvent(IsFollowGuideEvent busEventArgs) {
        this.isShowFollowGuide();
    }

    @BusEvent
    public void onShowLiveTaskGuideEventArgs(LiveTaskTipsEventArgs busEventArgs) {
        MLog.info((String)TAG, (String)("onShowLiveTaskGuideEventArgs busEventArgs: %s" + busEventArgs));
        String taskValue = busEventArgs.taskValue;
        if (busEventArgs.taskType == 1) {
            this.isShowTaskFollowGuide(taskValue);
        }
    }

    private void isShowTaskFollowGuide(String tips) {
        if (this.imgAttentionIcon != null && this.imgAttentionIcon.getVisibility() == 0) {
            this.taskPopupWindow = new TextBubblePopupWindow(this.getContext());
            this.taskPopupWindow.setText(tips);
            this.taskPopupWindow.setOnDismissListener(new PopupWindow.OnDismissListener(){

                public void onDismiss() {
                    MLog.info((String)OfficialLiveInfoComponent.TAG, (String)"isShowTaskFollowGuide onDismiss");
                }
            });
            this.getHandler().postDelayed(new Runnable(){

                @Override
                public void run() {
                    OfficialLiveInfoComponent.this.taskPopupWindow.showByArrowDirection((View)OfficialLiveInfoComponent.this.imgAttentionIcon, ScreenUtil.getInstance().dip2px(4), ArrowDirection.TOP);
                    ((IHiidoStatisticCore)CoreFactory.getCore(IHiidoStatisticCore.class)).sendEventStatistic("51028", "0024");
                }
            }, 500L);
            RxUtils.dispose((Disposable)this.hideTaskGuideDisposable);
            this.hideTaskGuideDisposable = Observable.timer((long)5L, (TimeUnit)TimeUnit.SECONDS).observeOn(AndroidSchedulers.mainThread()).subscribe((Consumer)new Consumer<Long>(){

                public void accept(Long aLong) {
                    if (OfficialLiveInfoComponent.this.taskPopupWindow != null) {
                        OfficialLiveInfoComponent.this.taskPopupWindow.dismiss();
                    }
                }
            }, (Consumer)new Consumer<Throwable>(){

                public void accept(Throwable throwable) {
                    MLog.error((String)OfficialLiveInfoComponent.TAG, (String)("isShowTaskFollowGuide error=" + throwable));
                }
            });
        }
    }

    private void isShowFollowGuide() {
        boolean followGuideAB = ((NewUserGuide2ABTest)Kinds.of(NewUserGuide2ABTest.class)).showFollowGuide();
        boolean isShowFollow = CommonPref.instance().getBoolean("is_follow_show_sp_key", false);
        boolean isShowGuide = CommonPref.instance().getBoolean("is_follow_sp_key", false);
        MLog.info((Object)TAG, (String)"isShowFollowGuide followGuideAB: %b, isShowFollow: %b, isShowGuide: %b", (Object[])new Object[]{followGuideAB, isShowFollow, isShowGuide});
        if (followGuideAB && !isShowFollow && isShowGuide && this.imgAttentionIcon != null && this.imgAttentionIcon.getVisibility() == 0) {
            this.bubblePopupWindow = new TextBubblePopupWindow(this.getContext());
            this.bubblePopupWindow.setText("\u7acb\u5373\u5173\u6ce8\u8fd8\u6709\u597d\u793c");
            this.bubblePopupWindow.setOnDismissListener(new PopupWindow.OnDismissListener(){

                public void onDismiss() {
                    MLog.info((String)OfficialLiveInfoComponent.TAG, (String)"isShowFollowGuide onDismiss");
                }
            });
            this.bubblePopupWindow.showByArrowDirection((View)this.imgAttentionIcon, ScreenUtil.getInstance().dip2px(4), ArrowDirection.TOP);
            CommonPref.instance().putBoolean("is_follow_show_sp_key", true);
            ((IHiidoStatisticCore)CoreFactory.getCore(IHiidoStatisticCore.class)).sendEventStatistic("53703", "0012");
            RxUtils.dispose((Disposable)this.hideGuideDisposable);
            this.hideGuideDisposable = Observable.timer((long)5L, (TimeUnit)TimeUnit.SECONDS).observeOn(AndroidSchedulers.mainThread()).subscribe((Consumer)new Consumer<Long>(){

                public void accept(Long aLong) {
                    if (OfficialLiveInfoComponent.this.bubblePopupWindow != null) {
                        OfficialLiveInfoComponent.this.bubblePopupWindow.dismiss();
                    }
                }
            }, (Consumer)new Consumer<Throwable>(){

                public void accept(Throwable throwable) {
                    MLog.error((String)OfficialLiveInfoComponent.TAG, (String)("hideGuideDisposable error=" + throwable));
                }
            });
        }
    }

    @BusEvent
    public void changeLiveRoomPosition(ChangeOfficialLiveRoomPositionArg event) {
        MLog.info((String)TAG, (String)("event = " + event));
        if (event.show) {
            this.mChannelIdView.setVisibility(0);
        } else {
            this.mChannelIdView.setVisibility(8);
            this.setBizName("");
        }
    }

    private void initSetBgDrwable() {
        long topSid = ChannelApi.Factory.get().getCurrentChannelInfo().topSid;
        if (topSid == 0L) {
            topSid = ChannelApi.Factory.get().getJoiningTopSid();
        }
        int chnResId = ChannelInfoMobuleUtil.getSidToModuleResource(topSid);
        StateListDrawable bg = new StateListDrawable();
        Drawable normal = this.getResources().getDrawable(chnResId);
        Drawable pressed = this.getResources().getDrawable(R.drawable.official_liveroom_logobg_press);
        bg.addState(new int[]{16842919, 16842910}, pressed);
        bg.addState(new int[]{16842910}, normal);
        if (this.rlLiveOfficialInfoLayout != null) {
            this.rlLiveOfficialInfoLayout.setBackgroundDrawable((Drawable)bg);
        }
    }

    private void setDefaultLayoutDrawable() {
        if (this.checkActivityValid() && this.rlLiveOfficialInfoLayout != null) {
            StateListDrawable bg = new StateListDrawable();
            Drawable normal = this.getResources().getDrawable(R.drawable.channel_info_bg_2);
            Drawable pressed = this.getResources().getDrawable(R.drawable.official_liveroom_logobg_press);
            bg.addState(new int[]{16842919, 16842910}, pressed);
            bg.addState(new int[]{16842910}, normal);
            this.rlLiveOfficialInfoLayout.setBackgroundDrawable((Drawable)bg);
        }
    }

    @Override
    public void loadAdvertisementPic(Advertisement ad) {
        if (ad == null || !((OfficialLiveInfoPresenter)this.getPresenter()).isOfficialChannel()) {
            MLog.error((String)TAG, (String)("loadAdvertisementPic: invalid data, ad==null ? " + (ad == null)));
            return;
        }
        MLog.info((String)TAG, (String)("loadAdvertisementPic: " + ad));
        if (this.imgAdImage != null && this.checkActivityValid()) {
            Glide.with((FragmentActivity)this.getActivity()).load((Object)ad.adIcon).apply(new RequestOptions().centerCrop().error(R.drawable.lr_official_live_room_default_logo).placeholder(R.drawable.lr_official_live_room_default_logo)).into((ImageView)this.imgAdImage);
        }
    }

    @Override
    public void setContributionData(String value) {
        if (this.tvContribution != null) {
            this.tvContribution.setText((CharSequence)value);
        }
    }

    @Override
    public void resetLayoutData() {
        MLog.info((String)TAG, (String)"resetLayoutData:");
        if (this.tvContribution != null) {
            this.tvContribution.setText((CharSequence)"");
        }
        if (this.rlRealLoveLayout != null) {
            this.rlRealLoveLayout.removeAllViews();
        }
        if (this.imgAdImage != null) {
            this.imgAdImage.setImageResource(R.drawable.lr_official_live_room_default_logo);
        }
        if (this.tvOnlineCount != null) {
            this.tvOnlineCount.setText((CharSequence)"...");
        }
        this.setDefaultLayoutDrawable();
        ((IChannelInfoOfficialUICore)CoreFactory.getCore(IChannelInfoOfficialUICore.class)).setOfficialProgramLogo(null);
    }

    @Override
    public void setHasFollowed(boolean hasFollow) {
        MLog.info((Object)TAG, (String)"setHasFollowed: hasFollow:%b, hasFollowed:%b", (Object[])new Object[]{hasFollow, this.hasFollowed});
        if (this.hasFollowed == null || this.hasFollowed != hasFollow) {
            this.hasFollowed = hasFollow;
            this.hasFollowedSubject.onNext((Object)hasFollow);
        }
    }

    public void onClick(View v) {
        if (v.getId() == R.id.live_offical_info_container) {
            this.startChannelInfoComponent();
        } else if (v.getId() == R.id.tv_live_info_entrance) {
            this.startChannelInfoComponent();
        }
    }

    public void startChannelInfoComponent() {
        MLog.info((String)TAG, (String)"startChannelInfoComponent:");
        if (null != this.programInfoBizHolder) {
            this.programInfoBizHolder.showChannelInfoComponent();
        }
    }

    @Override
    public void updateAnchorAvatar(String url, int idx, int defResId) {
    }

    @Override
    public void updateAnchorName(String name) {
        MLog.info((Object)TAG, (String)"updateAnchorName: name=%s", (Object[])new Object[]{name});
        if (this.tvNickName != null && !FP.empty((CharSequence)name)) {
            this.tvNickName.setText((CharSequence)name);
        }
    }

    @Override
    public void setBizName(String name) {
        MLog.info((Object)TAG, (String)"setBizName: name=%s", (Object[])new Object[]{name});
        if (BlankUtil.isBlank((String)name) && this.channelBizLayout != null) {
            this.channelBizLayout.setVisibility(8);
            return;
        }
        if (this.channelBizLayout != null) {
            this.channelBizLayout.setVisibility(0);
        }
        if (this.channelBizName != null) {
            this.channelBizName.setText((CharSequence)name);
        }
    }

    @Override
    public void updateOnlineCount(String count) {
        if (this.tvOnlineCount != null) {
            this.tvOnlineCount.setText((CharSequence)count);
        }
        OnlineUsersHandle.Companion.instance().updateHeatValue(count);
    }

    protected boolean needUpdateOnlineIcon() {
        return true;
    }

    @Override
    public void updateFollowState(boolean show) {
        MLog.info((String)TAG, (String)("updateFollowState: show=" + show));
        if (this.imgAttentionIcon != null) {
            if (show) {
                this.imgAttentionIcon.setVisibility(0);
                if (this.rlRealLoveLayout != null && this.rlRealLoveLayout.getVisibility() == 0) {
                    this.rlRealLoveLayout.removeAllViews();
                    this.rlRealLoveLayout.setVisibility(8);
                }
                if (this.imgAttentionIcon != null) {
                    this.imgAttentionIcon.setPadding(0, 0, 0, 0);
                }
            } else {
                this.hideFollowIcon();
                this.updateFollowingFinished();
            }
        }
    }

    private void hideFollowIcon() {
        if (this.imgAttentionIcon != null) {
            this.imgAttentionIcon.setVisibility(8);
        }
        RxUtils.dispose((Disposable)this.hideGuideDisposable);
        this.hideGuideDisposable = null;
        if (this.bubblePopupWindow != null) {
            this.bubblePopupWindow.dismiss();
        }
        RxUtils.dispose((Disposable)this.hideTaskGuideDisposable);
        this.hideTaskGuideDisposable = null;
        if (this.taskPopupWindow != null) {
            this.taskPopupWindow.dismiss();
        }
    }

    private void clearFollowBtnAnim() {
        if (this.imgAttentionIcon != null) {
            this.imgAttentionIcon.clearAnimation();
        }
    }

    private void updateFollowingFinished() {
        if (this.getPresenter() != null) {
            ((OfficialLiveInfoPresenter)this.getPresenter()).setFollowingFinished();
        }
    }

    @Override
    public void setAuthVBackground(Drawable drawable2) {
    }

    @Override
    public void setAuthVImgHidden(boolean hidden) {
    }

    @Override
    public void clearAuthV() {
    }

    @Override
    public void setHeadIconAsChannelLogo(String channelLogoUrl) {
    }

    @Override
    public void onFollowResult(boolean isSuccess, String errorMsg) {
        if (null != this.programInfoBizHolder) {
            this.programInfoBizHolder.onSubscribeResult(((OfficialLiveInfoPresenter)this.getPresenter()).getUsingAnchorUid(), true, isSuccess, errorMsg);
        }
    }

    @Override
    public void onUnFollowedResult(boolean isSuccess) {
        if (null != this.programInfoBizHolder) {
            this.programInfoBizHolder.onSubscribeResult(((OfficialLiveInfoPresenter)this.getPresenter()).getUsingAnchorUid(), false, isSuccess, null);
        }
    }

    @Override
    public void addRealLoveView(View view) {
        this.hideFollowIcon();
        this.clearFollowBtnAnim();
        this.updateFollowingFinished();
        if (view != null && this.rlRealLoveLayout != null) {
            if (view.getParent() != null) {
                ((ViewGroup)view.getParent()).removeView(view);
            }
            this.rlRealLoveLayout.addView(view);
            this.rlRealLoveLayout.setVisibility(0);
        }
    }

    @Override
    public void removeRealLoveView() {
        if (this.rlRealLoveLayout != null) {
            this.rlRealLoveLayout.removeAllViews();
            this.rlRealLoveLayout.setVisibility(8);
        }
        if (this.tvNickName != null) {
            this.tvNickName.setPadding(0, 0, 0, 0);
        }
    }

    @Override
    public void addRealLoveInviteView(View view) {
        if (view != null && this.rlTrueLoveInviteAnimatorLayout != null) {
            if (view.getParent() != null) {
                ((ViewGroup)view.getParent()).removeView(view);
            }
            this.rlTrueLoveInviteAnimatorLayout.removeAllViews();
            this.rlTrueLoveInviteAnimatorLayout.addView(view);
            this.rlTrueLoveInviteAnimatorLayout.setVisibility(0);
        }
    }

    @Override
    public void removeRealLoveInviteView() {
        if (this.rlTrueLoveInviteAnimatorLayout != null) {
            this.rlTrueLoveInviteAnimatorLayout.removeAllViews();
            this.rlTrueLoveInviteAnimatorLayout.setVisibility(8);
        }
    }

    @Override
    public void updateComponentState(boolean show) {
        MLog.info((Object)TAG, (String)"updateComponentState: show=%s", (Object[])new Object[]{show});
        if (this.mRootView != null) {
            if (show) {
                this.mRootView.setVisibility(0);
            } else {
                this.mRootView.setVisibility(8);
            }
        }
    }

    @Override
    public IProgramInfoBizHolder getProgrameInfoHolder() {
        return this.programInfoBizHolder;
    }

    public void onStart() {
        super.onStart();
        this.isStarted = true;
    }

    @Override
    public boolean isPageStarted() {
        return this.isStarted;
    }

    public void onStop() {
        super.onStop();
        this.isStarted = false;
        MLog.info((String)TAG, (String)"onStop\uff1a");
    }

    public void onDestroyView() {
        LiveInfoUiApiHolder.INSTANCE.setApi(null);
        super.onDestroyView();
    }

    public void onDestroy() {
        super.onDestroy();
        LiveBizComponentLinkProvider.INSTANCE.cancelCreateHolder(this);
        if (null != this.programInfoBizHolder) {
            this.programInfoBizHolder.unBindLifecycle(this.getLifecycle());
        }
        this.mChannelIdView = null;
        this.clearFollowBtnAnim();
        ((IProgramInfoCore)CoreFactory.getCore(IProgramInfoCore.class)).clearOfficialInfo();
        RxUtils.dispose((Disposable)this.hideGuideDisposable);
        this.hideGuideDisposable = null;
        RxUtils.dispose((Disposable)this.hideTaskGuideDisposable);
        this.hideTaskGuideDisposable = null;
    }

    public void replaceLiveInfoUi(@NotNull View view) {
        MLog.info((Object)TAG, (String)"replaceLiveInfoUi, hasReplaceLiveInfoLayout:%b, this:%s", (Object[])new Object[]{this.hasReplaceLiveInfoLayout, this});
        if (!this.hasReplaceLiveInfoLayout) {
            this.hasReplaceLiveInfoLayout = true;
            this.flAnchorInfoLayout.setVisibility(8);
            this.flAnchorInfoReplacement.setVisibility(0);
            this.flAnchorInfoReplacement.removeAllViews();
            this.flAnchorInfoReplacement.addView(view);
        }
    }

    public void restoreLiveInfoUi() {
        MLog.info((Object)TAG, (String)"restoreLiveInfoUi, hasReplaceLiveInfoLayout:%b, this:%s", (Object[])new Object[]{this.hasReplaceLiveInfoLayout, this});
        if (this.hasReplaceLiveInfoLayout) {
            this.hasReplaceLiveInfoLayout = false;
            this.flAnchorInfoReplacement.removeAllViews();
            this.flAnchorInfoReplacement.setVisibility(8);
            this.flAnchorInfoLayout.setVisibility(0);
        }
    }

    public boolean hasFollowedFirstMic() {
        return this.hasFollowed;
    }

    @NotNull
    public BehaviorSubject<Boolean> getHasFollowedFirstMicSubject() {
        return this.hasFollowedSubject;
    }

    public void setClickFollowListener(@org.jetbrains.annotations.Nullable ClickFollowListener listener2) {
        MLog.info((Object)TAG, (String)"setClickFollowListener: listener:%s", (Object[])new Object[]{listener2});
        this.clickFollowListener = listener2;
    }

    @Override
    public void onDefaultHolderCreated(@NonNull IProgramInfoBizHolder holder) {
        this.programInfoBizHolder = holder;
        holder.bindLifecycle(this.getActivity(), this.getLifecycle());
    }

    @Override
    public void onHolderCreated(@NonNull IProgramInfoBizHolder holder) {
        if (null != this.programInfoBizHolder) {
            this.programInfoBizHolder.unBindLifecycle(this.getLifecycle());
        }
        this.programInfoBizHolder = holder;
        this.programInfoBizHolder.bindLifecycle(this.getActivity(), this.getLifecycle());
    }

    @Override
    public Class<IProgramInfoBizHolder> getHolderClass() {
        return IProgramInfoBizHolder.class;
    }

    public void onEventBind() {
        super.onEventBind();
        if (this.mEventBinder == null) {
            this.mEventBinder = new OfficialLiveInfoComponent$$EventBinder();
        }
        this.mEventBinder.bindEvent((Object)this);
    }

    public void onEventUnBind() {
        super.onEventUnBind();
        if (this.mEventBinder != null) {
            this.mEventBinder.unBindEvent();
        }
    }
}

