/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.livebizwrapper.programinfo.component;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.PopupWindow;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.duowan.mobile.basemedia.api.channel.ChannelApi;
import com.duowan.mobile.livebasebiz.event.LiveTaskTipsEventArgs;
import com.duowan.mobile.main.kinds.Kinds;
import com.yy.android.sniper.annotation.inject.BusEvent;
import com.yy.android.sniper.api.event.EventBinder;
import com.yy.hiidostatis.defs.obj.Property;
import com.yy.mobile.abtest.newuserguide.NewUserGuide2ABTest;
import com.yy.mobile.bizmodel.login.LoginUtil;
import com.yy.mobile.image.CircleImageView;
import com.yy.mobile.image.ImageConfig;
import com.yy.mobile.image.RecycleImageView;
import com.yy.mobile.imageloader.ImageLoader;
import com.yy.mobile.livebizwrapper.R;
import com.yy.mobile.livebizwrapper.chatscreen.LiveStatistic;
import com.yy.mobile.livebizwrapper.component.LiveBizComponentLinkProvider;
import com.yy.mobile.livebizwrapper.guideview.event.IsFollowGuideEvent;
import com.yy.mobile.livebizwrapper.programinfo.DefaultProgramInfoBizHolder;
import com.yy.mobile.livebizwrapper.programinfo.IProgramInfoBizHolder;
import com.yy.mobile.livebizwrapper.programinfo.component.BaseLiveInfoComponent$$EventBinder;
import com.yy.mobile.livebizwrapper.programinfo.presenter.BaseLiveInfoCompPresenter;
import com.yy.mobile.livebizwrapper.programinfo.presenter.OnlineUsersHandle;
import com.yy.mobile.livebizwrapper.programinfo.view.IBaseLiveInfoCompView;
import com.yy.mobile.livebizwrapper.programinfo.widget.ChannelIdView;
import com.yy.mobile.livebizwrapper.utils.NoRepeatClickListener;
import com.yy.mobile.login.LoginEntranceType;
import com.yy.mobile.ui.basicchanneltemplate.component.Component;
import com.yy.mobile.ui.home.FaceHelperFactory;
import com.yy.mobile.ui.widget.bubblelayout.ArrowDirection;
import com.yy.mobile.ui.widget.bubblelayout.TextBubblePopupWindow;
import com.yy.mobile.util.ResolutionUtils;
import com.yy.mobile.util.RxUtils;
import com.yy.mobile.util.ScreenUtil;
import com.yy.mobile.util.StringUtils;
import com.yy.mobile.util.log.MLog;
import com.yy.mobile.util.pref.CommonPref;
import com.yy.mobile.util.valid.BlankUtil;
import com.yymobile.core.CoreFactory;
import com.yymobile.core.channel.ChannelInfo;
import com.yymobile.core.statistic.IHiidoStatisticCore;
import io.reactivex.Observable;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.Consumer;
import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class BaseLiveInfoComponent<P extends BaseLiveInfoCompPresenter, V extends IBaseLiveInfoCompView>
extends Component<BaseLiveInfoCompPresenter<V>, V>
implements IBaseLiveInfoCompView,
LiveBizComponentLinkProvider.OnHolderCreatedWithDefaultListener<IProgramInfoBizHolder> {
    private static final String TAG = "BaseLiveInfoComponent";
    protected View mRootView;
    protected CircleImageView mAnchorImg;
    protected RecycleImageView mIvAttentionIcon;
    protected RecycleImageView mAuthVImg;
    protected TextView mAnchorName;
    protected TextView tvOnlineCount;
    protected ImageView onlineIcon;
    protected RelativeLayout rlAnchorInfoLayout;
    protected RelativeLayout rlNobleGradeView;
    protected RelativeLayout rlRealLoveLayout;
    protected RelativeLayout rlTrueLoveInviteAnimatorLayout;
    protected ChannelIdView mChannelIdView;
    private boolean mIsStarted = false;
    protected IProgramInfoBizHolder programInfoBizHolder;
    private Disposable hideGuideDisposable;
    private Disposable hideTaskGuideDisposable;
    private TextBubblePopupWindow bubblePopupWindow;
    private TextBubblePopupWindow taskPopupWindow;
    private View channelBizLayout;
    private TextView channelBizName;
    protected NoRepeatClickListener mAnchorInfoClickListener = new NoRepeatClickListener(){

        @Override
        public void onNoRepeatClick(View view) {
            ChannelInfo channelInfo;
            if (BaseLiveInfoComponent.this.checkActivityValid()) {
                ((BaseLiveInfoCompPresenter)BaseLiveInfoComponent.this.getPresenter()).onClickAnchorInfo(BaseLiveInfoComponent.this.getChildFragmentManager());
            }
            if (null == (channelInfo = ChannelApi.Factory.get().getCurrentChannelInfo())) {
                channelInfo = new ChannelInfo();
            }
            Property property = new Property();
            property.putString("key1", "" + channelInfo.topSid);
            property.putString("key2", "" + ((BaseLiveInfoCompPresenter)BaseLiveInfoComponent.this.getPresenter()).getUsingAnchorUid());
            property.putString("key3", "" + channelInfo.channelMode.ordinal());
            ((IHiidoStatisticCore)CoreFactory.getCore(IHiidoStatisticCore.class)).sendEventStatistic("51001", "0001", (Serializable)property);
        }
    };
    protected View.OnClickListener mFollowBtnClickListener = new View.OnClickListener(){

        public void onClick(View view) {
            if (BaseLiveInfoComponent.this.isNetworkAvailable()) {
                if (!LoginUtil.isLogined()) {
                    if (null != BaseLiveInfoComponent.this.programInfoBizHolder) {
                        BaseLiveInfoComponent.this.programInfoBizHolder.showLogin(LoginEntranceType.LIVE_FOLLOW, ((BaseLiveInfoCompPresenter)BaseLiveInfoComponent.this.getPresenter()).getLatestAnchorUid());
                    }
                } else {
                    ((BaseLiveInfoCompPresenter)BaseLiveInfoComponent.this.getPresenter()).onClickFollow();
                }
                ChannelInfo channelInfo = ChannelApi.Factory.get().getCurrentChannelInfo();
                Map<String, String> property = LiveStatistic.createliveChannelBaseProperty();
                property.put("key4", String.valueOf(channelInfo.subSid));
                property.put("key5", String.valueOf(((BaseLiveInfoCompPresenter)BaseLiveInfoComponent.this.getPresenter()).getUsingAnchorUid()));
                ((IHiidoStatisticCore)CoreFactory.getCore(IHiidoStatisticCore.class)).sendEventStatistic(LoginUtil.getUid(), "51001", "0002", property);
                ((IHiidoStatisticCore)CoreFactory.getCore(IHiidoStatisticCore.class)).sendEventStatistic("50020", "0018");
            } else {
                BaseLiveInfoComponent.this.toast("\u7f51\u7edc\u4e0d\u7ed9\u529b");
            }
        }
    };
    private EventBinder mEventBinder;

    @Nullable
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.fragment_live_info_component, container, false);
    }

    public void onViewCreated(View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.mRootView = view;
        this.initView(view);
        ((BaseLiveInfoCompPresenter)this.getPresenter()).onViewCreated();
        ((BaseLiveInfoCompPresenter)this.getPresenter()).initReqData();
        ((BaseLiveInfoCompPresenter)this.getPresenter()).queryChannelTitleReq();
        this.rlAnchorInfoLayout.setOnClickListener((View.OnClickListener)this.mAnchorInfoClickListener);
        this.mIvAttentionIcon.setOnClickListener(this.mFollowBtnClickListener);
        LiveBizComponentLinkProvider.INSTANCE.callCreateHolder(this, DefaultProgramInfoBizHolder.class);
    }

    private void initView(View rootView) {
        this.channelBizLayout = rootView.findViewById(R.id.channel_biz_layout);
        this.channelBizName = (TextView)rootView.findViewById(R.id.channel_biz_name);
        this.rlAnchorInfoLayout = (RelativeLayout)rootView.findViewById(R.id.rl_anchor_info_layout);
        this.mAnchorImg = (CircleImageView)rootView.findViewById(R.id.img_anchor_head_big);
        this.mAuthVImg = (RecycleImageView)rootView.findViewById(R.id.img_auth_v_big);
        this.mIvAttentionIcon = (RecycleImageView)rootView.findViewById(R.id.img_attention_icon);
        this.mIvAttentionIcon.setImageResource(R.drawable.bg_live_room_follow);
        this.mAnchorName = (TextView)rootView.findViewById(R.id.tv_nick_name);
        this.tvOnlineCount = (TextView)rootView.findViewById(R.id.tv_online_count);
        this.onlineIcon = (ImageView)rootView.findViewById(R.id.online_icon);
        this.rlRealLoveLayout = (RelativeLayout)rootView.findViewById(R.id.rl_real_love_layout);
        this.rlTrueLoveInviteAnimatorLayout = (RelativeLayout)rootView.findViewById(R.id.rl_true_love_invite_animator);
        this.rlNobleGradeView = (RelativeLayout)rootView.findViewById(R.id.rl_noble_grade);
        this.mChannelIdView = (ChannelIdView)rootView.findViewById(R.id.view_channel_id_layout);
        if (this.needUpdateOnlineIcon() && this.onlineIcon != null) {
            this.onlineIcon.setImageResource(OnlineUsersHandle.Companion.instance().getOnlineIconRes());
        }
    }

    public void onStart() {
        super.onStart();
        this.mIsStarted = true;
    }

    @Override
    public void updateAnchorAvatar(String url, int idx, int defResId) {
        if (defResId == 0) {
            defResId = R.drawable.default_portrait;
        }
        if (!TextUtils.isEmpty((CharSequence)url)) {
            FaceHelperFactory.loadFace((String)url, (int)idx, (FaceHelperFactory.FaceType)FaceHelperFactory.FaceType.FriendFace, (RecycleImageView)this.mAnchorImg, (ImageConfig)ImageConfig.defaultImageConfig(), (int)defResId);
        } else {
            ImageLoader.loadImageResource((int)defResId, (RecycleImageView)this.mAnchorImg, (ImageConfig)ImageConfig.defaultImageConfig());
        }
    }

    @Override
    public void updateAnchorName(String name) {
        MLog.info((Object)TAG, (String)"updateAnchorName: name=%s", (Object[])new Object[]{name});
        if (this.mAnchorName != null) {
            this.mAnchorName.setText((CharSequence)name);
        }
    }

    @Override
    public void setBizName(String name) {
        MLog.info((Object)TAG, (String)"setBizName: name=%s", (Object[])new Object[]{name});
        if (BlankUtil.isBlank((String)name) && this.channelBizLayout != null) {
            this.channelBizLayout.setVisibility(8);
            return;
        }
        if (this.channelBizLayout != null) {
            this.channelBizLayout.setVisibility(0);
        }
        if (this.channelBizName != null) {
            this.channelBizName.setText((CharSequence)name);
        }
    }

    @Override
    public void updateOnlineCount(String count) {
        try {
            if (this.tvOnlineCount != null) {
                this.tvOnlineCount.setText((CharSequence)count);
            }
            OnlineUsersHandle.Companion.instance().updateHeatValue(count);
        }
        catch (Throwable throwable) {
            MLog.error((Object)TAG, (Throwable)throwable);
        }
    }

    protected boolean needUpdateOnlineIcon() {
        return true;
    }

    @Override
    public void updateFollowState(boolean show) {
        MLog.info((Object)TAG, (String)"updateFollowState: show=%s", (Object[])new Object[]{show});
        if (this.mIvAttentionIcon != null) {
            if (show) {
                this.mIvAttentionIcon.setVisibility(0);
                if (this.rlRealLoveLayout != null && this.rlRealLoveLayout.getVisibility() == 0) {
                    this.rlRealLoveLayout.removeAllViews();
                    this.rlRealLoveLayout.setVisibility(8);
                }
                if (this.mAnchorName != null) {
                    this.mAnchorName.setPadding(0, 0, 0, 0);
                }
            } else {
                this.executeFollowedHide();
            }
        }
    }

    @BusEvent
    public void isFollowEvent(IsFollowGuideEvent busEventArgs) {
        this.isShowFollowGuide();
    }

    @BusEvent
    public void onShowLiveTaskGuideEventArgs(LiveTaskTipsEventArgs busEventArgs) {
        MLog.info((String)TAG, (String)("onShowLiveTaskGuideEventArgs busEventArgs: %s" + busEventArgs));
        String taskValue = busEventArgs.taskValue;
        if (busEventArgs.taskType == 1) {
            this.isShowTaskFollowGuide(taskValue);
        }
    }

    private void isShowTaskFollowGuide(String tips) {
        if (this.mIvAttentionIcon != null && this.mIvAttentionIcon.getVisibility() == 0) {
            this.taskPopupWindow = new TextBubblePopupWindow(this.getContext());
            this.taskPopupWindow.setText(tips);
            this.taskPopupWindow.setOnDismissListener(new PopupWindow.OnDismissListener(){

                public void onDismiss() {
                    MLog.info((String)BaseLiveInfoComponent.TAG, (String)"isShowTaskFollowGuide onDismiss");
                }
            });
            this.getHandler().postDelayed(new Runnable(){

                @Override
                public void run() {
                    BaseLiveInfoComponent.this.taskPopupWindow.showByArrowDirection((View)BaseLiveInfoComponent.this.mIvAttentionIcon, ScreenUtil.getInstance().dip2px(4), ArrowDirection.TOP);
                    ((IHiidoStatisticCore)CoreFactory.getCore(IHiidoStatisticCore.class)).sendEventStatistic("51028", "0024");
                }
            }, 500L);
            RxUtils.dispose((Disposable)this.hideTaskGuideDisposable);
            this.hideTaskGuideDisposable = Observable.timer((long)5L, (TimeUnit)TimeUnit.SECONDS).observeOn(AndroidSchedulers.mainThread()).subscribe((Consumer)new Consumer<Long>(){

                public void accept(Long aLong) {
                    if (BaseLiveInfoComponent.this.taskPopupWindow != null) {
                        BaseLiveInfoComponent.this.taskPopupWindow.dismiss();
                    }
                }
            }, (Consumer)new Consumer<Throwable>(){

                public void accept(Throwable throwable) {
                    MLog.error((String)BaseLiveInfoComponent.TAG, (String)("isShowTaskFollowGuide error=" + throwable));
                }
            });
        }
    }

    private void isShowFollowGuide() {
        boolean followGuideAB = ((NewUserGuide2ABTest)Kinds.of(NewUserGuide2ABTest.class)).showFollowGuide();
        boolean isShowFollow = CommonPref.instance().getBoolean("is_follow_show_sp_key", false);
        boolean isShowGuide = CommonPref.instance().getBoolean("is_follow_sp_key", false);
        MLog.info((Object)TAG, (String)"isShowFollowGuide followGuideAB: %b, isShowFollow: %b, isShowGuide: %b", (Object[])new Object[]{followGuideAB, isShowFollow, isShowGuide});
        if (followGuideAB && !isShowFollow && isShowGuide && this.mIvAttentionIcon != null && this.mIvAttentionIcon.getVisibility() == 0) {
            this.bubblePopupWindow = new TextBubblePopupWindow(this.getContext());
            this.bubblePopupWindow.setText("\u7acb\u5373\u5173\u6ce8\u8fd8\u6709\u597d\u793c");
            this.bubblePopupWindow.setOnDismissListener(new PopupWindow.OnDismissListener(){

                public void onDismiss() {
                    MLog.info((String)BaseLiveInfoComponent.TAG, (String)"isShowFollowGuide onDismiss");
                }
            });
            this.bubblePopupWindow.showByArrowDirection((View)this.mIvAttentionIcon, ScreenUtil.getInstance().dip2px(4), ArrowDirection.TOP);
            CommonPref.instance().putBoolean("is_follow_show_sp_key", true);
            ((IHiidoStatisticCore)CoreFactory.getCore(IHiidoStatisticCore.class)).sendEventStatistic("53703", "0012");
            RxUtils.dispose((Disposable)this.hideGuideDisposable);
            this.hideGuideDisposable = Observable.timer((long)5L, (TimeUnit)TimeUnit.SECONDS).observeOn(AndroidSchedulers.mainThread()).subscribe((Consumer)new Consumer<Long>(){

                public void accept(Long aLong) {
                    if (BaseLiveInfoComponent.this.bubblePopupWindow != null) {
                        BaseLiveInfoComponent.this.bubblePopupWindow.dismiss();
                    }
                }
            }, (Consumer)new Consumer<Throwable>(){

                public void accept(Throwable throwable) {
                    MLog.error((String)BaseLiveInfoComponent.TAG, (String)("hideGuideDisposable error=" + throwable));
                }
            });
        }
    }

    private void executeFollowedHide() {
        if (this.mIvAttentionIcon == null) {
            this.updateFollowingFinished();
            return;
        }
        this.hideFollowIcon();
        this.updateFollowingFinished();
    }

    private void hideFollowIcon() {
        if (this.mIvAttentionIcon != null) {
            this.mIvAttentionIcon.setVisibility(8);
        }
        RxUtils.dispose((Disposable)this.hideGuideDisposable);
        this.hideGuideDisposable = null;
        if (this.bubblePopupWindow != null) {
            this.bubblePopupWindow.dismiss();
        }
        RxUtils.dispose((Disposable)this.hideTaskGuideDisposable);
        this.hideTaskGuideDisposable = null;
        if (this.taskPopupWindow != null) {
            this.taskPopupWindow.dismiss();
        }
    }

    private void updateFollowingFinished() {
        if (this.getPresenter() != null) {
            ((BaseLiveInfoCompPresenter)this.getPresenter()).setFollowingFinished();
        }
    }

    @Override
    public void onFollowResult(boolean isSuccess, String errorMsg) {
        if (null != this.programInfoBizHolder) {
            this.programInfoBizHolder.onSubscribeResult(((BaseLiveInfoCompPresenter)this.getPresenter()).getUsingAnchorUid(), true, isSuccess, errorMsg);
        }
    }

    @Override
    public void onUnFollowedResult(boolean isSuccess) {
        if (null != this.programInfoBizHolder) {
            this.programInfoBizHolder.onSubscribeResult(((BaseLiveInfoCompPresenter)this.getPresenter()).getUsingAnchorUid(), false, isSuccess, null);
        }
    }

    @Override
    public void setAuthVBackground(Drawable drawable2) {
        try {
            this.mAuthVImg.setBackgroundDrawable(drawable2);
            if (this.mAuthVImg.getVisibility() != 0) {
                this.mAuthVImg.setVisibility(0);
            }
        }
        catch (Throwable ex) {
            MLog.error((Object)TAG, (String)"setAuthVBackground: throwable", (Throwable)ex, (Object[])new Object[0]);
        }
    }

    @Override
    public void setAuthVImgHidden(boolean isHidden) {
        if (this.mAuthVImg != null) {
            if (isHidden) {
                if (this.mAuthVImg.getVisibility() != 8) {
                    this.mAuthVImg.setVisibility(8);
                }
            } else if (this.mAuthVImg.getVisibility() != 0) {
                this.mAuthVImg.setVisibility(0);
            }
        }
    }

    @Override
    public void clearAuthV() {
        if (this.mAuthVImg != null) {
            this.mAuthVImg.setImageDrawable(null);
            this.mAuthVImg.setBackgroundResource(0);
            this.mAuthVImg.setVisibility(8);
        }
    }

    @Override
    public void setHeadIconAsChannelLogo(String channelLogoUrl) {
        MLog.info((String)TAG, (String)("setHeadIconAsChannelLogo: " + channelLogoUrl));
        if (this.checkActivityValid()) {
            if (!StringUtils.isNullOrEmpty((String)channelLogoUrl)) {
                ImageLoader.loadImage((String)channelLogoUrl, (RecycleImageView)this.mAnchorImg, (ImageConfig)new ImageConfig(this.mAnchorImg.getWidth(), this.mAnchorImg.getHeight()), (int)R.drawable.default_portrait, (int)R.drawable.default_portrait);
            } else {
                ImageLoader.loadImageResource((int)R.drawable.livebiz_channel_icon_default, (RecycleImageView)this.mAnchorImg, (ImageConfig)ImageConfig.defaultImageConfig());
            }
        }
    }

    protected void updateTopMargin(int dp) {
        if (this.mChannelIdView != null) {
            this.mChannelIdView.updateTopMargin(dp);
        }
    }

    @Override
    public void addRealLoveView(View view) {
        this.hideFollowIcon();
        this.updateFollowingFinished();
        if (this.mAnchorName != null) {
            this.mAnchorName.setPadding(0, 0, (int)ResolutionUtils.convertDpToPixel((float)30.0f, (Context)this.getContext()), 0);
        }
        if (view != null && this.rlRealLoveLayout != null) {
            if (view.getParent() != null) {
                ((ViewGroup)view.getParent()).removeView(view);
            }
            this.rlRealLoveLayout.addView(view);
            this.rlRealLoveLayout.setVisibility(0);
        }
    }

    @Override
    public void removeRealLoveView() {
        if (this.rlRealLoveLayout != null) {
            this.rlRealLoveLayout.removeAllViews();
            this.rlRealLoveLayout.setVisibility(8);
        }
        if (this.mAnchorName != null) {
            this.mAnchorName.setPadding(0, 0, 0, 0);
        }
    }

    @Override
    public void addRealLoveInviteView(View view) {
        if (view != null && this.rlTrueLoveInviteAnimatorLayout != null) {
            if (view.getParent() != null) {
                ((ViewGroup)view.getParent()).removeView(view);
            }
            this.rlTrueLoveInviteAnimatorLayout.removeAllViews();
            this.rlTrueLoveInviteAnimatorLayout.addView(view);
            this.rlTrueLoveInviteAnimatorLayout.setVisibility(0);
        }
    }

    @Override
    public void removeRealLoveInviteView() {
        if (this.rlTrueLoveInviteAnimatorLayout != null) {
            this.rlTrueLoveInviteAnimatorLayout.removeAllViews();
            this.rlTrueLoveInviteAnimatorLayout.setVisibility(8);
        }
    }

    @Override
    public void updateComponentState(boolean show) {
        MLog.info((Object)TAG, (String)"updateComponentState: show=%s", (Object[])new Object[]{show});
        if (this.mRootView != null) {
            if (show) {
                this.mRootView.setVisibility(0);
            } else {
                this.mRootView.setVisibility(4);
            }
        }
    }

    @Override
    public boolean isPageStarted() {
        return this.mIsStarted;
    }

    public void onStop() {
        super.onStop();
        this.mIsStarted = false;
        MLog.info((String)TAG, (String)"onStop\uff1a");
    }

    public void onDestroy() {
        super.onDestroy();
        LiveBizComponentLinkProvider.INSTANCE.cancelCreateHolder(this);
        if (null != this.programInfoBizHolder) {
            this.programInfoBizHolder.unBindLifecycle(this.getLifecycle());
        }
        RxUtils.dispose((Disposable)this.hideGuideDisposable);
        this.hideGuideDisposable = null;
        RxUtils.dispose((Disposable)this.hideTaskGuideDisposable);
        this.hideTaskGuideDisposable = null;
    }

    @Override
    public IProgramInfoBizHolder getProgrameInfoHolder() {
        return this.programInfoBizHolder;
    }

    @Override
    public void onDefaultHolderCreated(@NonNull IProgramInfoBizHolder holder) {
        this.programInfoBizHolder = holder;
        holder.bindLifecycle(this.getActivity(), this.getLifecycle());
    }

    @Override
    public void onHolderCreated(@NonNull IProgramInfoBizHolder holder) {
        if (null != this.programInfoBizHolder) {
            this.programInfoBizHolder.unBindLifecycle(this.getLifecycle());
        }
        this.programInfoBizHolder = holder;
        this.programInfoBizHolder.bindLifecycle(this.getActivity(), this.getLifecycle());
    }

    @Override
    public Class<IProgramInfoBizHolder> getHolderClass() {
        return IProgramInfoBizHolder.class;
    }

    public void onEventBind() {
        super.onEventBind();
        if (this.mEventBinder == null) {
            this.mEventBinder = new BaseLiveInfoComponent$$EventBinder();
        }
        this.mEventBinder.bindEvent((Object)this);
    }

    public void onEventUnBind() {
        super.onEventUnBind();
        if (this.mEventBinder != null) {
            this.mEventBinder.unBindEvent();
        }
    }
}

