/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.livebizwrapper.programinfo.component;

import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentManager;
import androidx.fragment.app.FragmentTransaction;
import com.duowan.mobile.basemedia.api.channel.ChannelApi;
import com.yy.android.sniper.annotation.inject.BusEvent;
import com.yy.android.sniper.api.event.EventBinder;
import com.yy.mobile.livebizwrapper.R;
import com.yy.mobile.livebizwrapper.officialchannel.IChannelOfficialInfoCore;
import com.yy.mobile.livebizwrapper.programinfo.component.AbsLiveInfoTransitionComponent$$EventBinder;
import com.yy.mobile.livebizwrapper.programinfo.component.OfficialLiveInfoComponent;
import com.yy.mobile.plugin.main.events.IChannelLinkClient_onJoinChannelProgress_EventArgs;
import com.yy.mobile.plugin.main.events.IChannelLinkClient_onJoinChannelSuccess_EventArgs;
import com.yy.mobile.ui.basicchanneltemplate.component.Component;
import com.yy.mobile.util.log.MLog;
import com.yymobile.core.CoreFactory;

public abstract class AbsLiveInfoTransitionComponent
extends Component {
    public static final String TAG = "AbsLiveInfoTransitionComponent";
    public static final String LOADED_LIVEINFO_COMP_TAG = "LOADED_LIVEINFO_COMP_TAG";
    private View mRootView;
    private LoadedCompType mLoadedCompType = LoadedCompType.INIT;
    private EventBinder mEventBinder;

    @Nullable
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        long t1 = System.currentTimeMillis();
        this.mRootView = inflater.inflate(R.layout.fragment_live_info_transition_component, container, false);
        MLog.info((String)TAG, (String)("inflate view time = " + (System.currentTimeMillis() - t1)));
        return this.mRootView;
    }

    public void onViewCreated(View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.loadLiveInfoComponent();
    }

    private void loadLiveInfoComponent() {
        FragmentManager fragmentManager = this.getChildFragmentManager();
        FragmentTransaction transaction = fragmentManager.beginTransaction();
        boolean isOfficial = this.isOfficialChannel();
        MLog.info((Object)TAG, (String)"loadLiveInfoComponent: isOfficial=%s, mLoadedCompType=%s", (Object[])new Object[]{isOfficial, this.mLoadedCompType});
        try {
            Fragment pendingLoadComp = null;
            if (this.mLoadedCompType == LoadedCompType.INIT) {
                pendingLoadComp = isOfficial ? this.createTemplateOfficialLiveInfoComponent() : this.createTemplateLiveInfoComponent();
                this.mLoadedCompType = isOfficial ? LoadedCompType.OFFOCIAL : LoadedCompType.GENERAL;
            } else if (isOfficial && this.mLoadedCompType != LoadedCompType.OFFOCIAL) {
                pendingLoadComp = this.createTemplateOfficialLiveInfoComponent();
                this.mLoadedCompType = LoadedCompType.OFFOCIAL;
            } else if (!isOfficial && this.mLoadedCompType != LoadedCompType.GENERAL) {
                pendingLoadComp = this.createTemplateLiveInfoComponent();
                this.mLoadedCompType = LoadedCompType.GENERAL;
            }
            MLog.info((String)TAG, (String)("loadLiveInfoComponent: pendingLoadComp=" + pendingLoadComp + "\uff0c fragmentManager=" + fragmentManager));
            if (pendingLoadComp != null) {
                MLog.warn((Object)TAG, (String)"loadLiveInfoComponent: pending load new LiveInfoComponent, mLoadedCompType=%s", (Object[])new Object[]{this.mLoadedCompType});
                transaction.replace(R.id.ll_live_info_component_container, pendingLoadComp, LOADED_LIVEINFO_COMP_TAG).commitAllowingStateLoss();
            }
        }
        catch (Throwable throwable) {
            MLog.error((String)TAG, (String)("loadLiveInfoComponent: error=" + throwable));
        }
    }

    protected abstract Fragment createTemplateLiveInfoComponent();

    protected Fragment createTemplateOfficialLiveInfoComponent() {
        return OfficialLiveInfoComponent.newInstance();
    }

    @BusEvent(sync=true)
    public void onJoinChannelProgress(IChannelLinkClient_onJoinChannelProgress_EventArgs busEventArgs) {
        MLog.info((Object)TAG, (String)"onJoinChannelProgress: topSid=%s, subSid=%s, templateId=%s", (Object[])new Object[]{busEventArgs.getTopSid(), busEventArgs.getSubSid(), busEventArgs.getTemplatesId()});
        if (this.checkActivityValid()) {
            this.loadLiveInfoComponent();
        }
    }

    @BusEvent
    public void onJoinChannelSuccess(IChannelLinkClient_onJoinChannelSuccess_EventArgs busEventArgs) {
        MLog.info((String)TAG, (String)"onJoinChannelSuccess:");
        if (this.checkActivityValid()) {
            this.loadLiveInfoComponent();
        }
    }

    private boolean isOfficialChannel() {
        long topSid = ChannelApi.Factory.get().getCurrentChannelInfo().topSid;
        long joiningTopSid = ChannelApi.Factory.get().getJoiningTopSid();
        MLog.info((Object)TAG, (String)"isOfficialChannel: topSid=%s, joiningSid=%s", (Object[])new Object[]{topSid, joiningTopSid});
        if (topSid == 0L) {
            topSid = joiningTopSid;
        }
        boolean isOfficial = ((IChannelOfficialInfoCore)CoreFactory.getCore(IChannelOfficialInfoCore.class)).isOfficialProgram(topSid);
        MLog.info((Object)TAG, (String)"isOfficialChannel: isOfficial=%s", (Object[])new Object[]{isOfficial});
        return isOfficial;
    }

    public void onDetach() {
        super.onDetach();
        this.mLoadedCompType = LoadedCompType.INIT;
    }

    public void onEventBind() {
        super.onEventBind();
        if (this.mEventBinder == null) {
            this.mEventBinder = new AbsLiveInfoTransitionComponent$$EventBinder();
        }
        this.mEventBinder.bindEvent((Object)this);
    }

    public void onEventUnBind() {
        super.onEventUnBind();
        if (this.mEventBinder != null) {
            this.mEventBinder.unBindEvent();
        }
    }

    private static enum LoadedCompType {
        INIT,
        GENERAL,
        OFFOCIAL;

    }
}

