/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.livebizwrapper.plugincenter.ui;

import android.app.Activity;
import android.os.Bundle;
import androidx.fragment.app.DialogFragment;
import androidx.fragment.app.FragmentActivity;
import com.duowan.mobile.livebasebiz.api.LiveBizPluginCenterApi;
import com.yy.mobile.livebizwrapper.R;
import com.yy.mobile.sdkwrapper.flowmanagement.base.util.ActivityCheckUtils;
import com.yy.mobile.ui.basicchanneltemplate.component.IComponentRoot;

public class PluginCenterBuilder {
    public static final String KEY_ISOW = "key_isowner";
    public static final String KEY_TEMPLATEID = "key_templateId";
    private static final String TAG = "PluginCenterBuilder";
    private boolean mIsOw;
    private long mTemplateId = 0L;

    public static PluginCenterBuilder create() {
        return new PluginCenterBuilder();
    }

    private PluginCenterBuilder() {
    }

    public PluginCenterBuilder setIsOw(boolean isOw) {
        this.mIsOw = isOw;
        return this;
    }

    public PluginCenterBuilder setTemplateIdString(String templateIdString) {
        try {
            this.mTemplateId = Long.parseLong(templateIdString);
        }
        catch (Exception e) {
            this.mTemplateId = 0L;
        }
        return this;
    }

    public PluginCenterBuilder setTemplateId(long templateId) {
        this.mTemplateId = templateId;
        return this;
    }

    public DialogFragment build(IComponentRoot root) {
        Bundle bundle = new Bundle();
        bundle.putBoolean(KEY_ISOW, this.mIsOw);
        bundle.putLong(KEY_TEMPLATEID, this.mTemplateId);
        DialogFragment component = LiveBizPluginCenterApi.Factory.get().getPluginCenterComponent(root);
        component.setArguments(bundle);
        if (component.getDialog() != null && component.getDialog().getWindow() != null && component.getDialog().getWindow().getDecorView() != null) {
            component.getDialog().getWindow().getDecorView().setBackgroundResource(R.drawable.half_bottom_dialog_dark_background);
        }
        return component;
    }

    public void show(Activity activity, IComponentRoot root) {
        if (!ActivityCheckUtils.checkActivityValid((Activity)activity) || !(activity instanceof FragmentActivity)) {
            return;
        }
        DialogFragment component = this.build(root);
        component.show(((FragmentActivity)activity).getSupportFragmentManager(), TAG);
    }
}

