/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.livebizwrapper.nobleseat.core;

import com.yy.mobile.yyprotocol.core.ByteString;
import com.yy.mobile.yyprotocol.core.MarshalContainer;
import com.yy.mobile.yyprotocol.core.Marshallable;
import com.yy.mobile.yyprotocol.core.Pack;
import com.yy.mobile.yyprotocol.core.Uint32;
import com.yy.mobile.yyprotocol.core.UnmarshalContainer;
import com.yy.mobile.yyprotocol.core.Unpack;
import com.yymobile.core.ent.ProtosMapper;
import com.yymobile.core.ent.protos.EntProtocolAdapter;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;

public class NobleSeatProtocol {
    public static void registerProtocols() {
        ProtosMapper.add((Class[])new Class[]{PMobileNobelVipStandReq.class, PMobileNobelVipStandRsp.class, PMobileNobelVipStandRemove.class, PMobileNobleTopMallReq.class, PMobileNobleTopMallRsp.class});
    }

    class MobileValidTime
    implements Marshallable {
        Uint32 toValidTime = new Uint32(0);
        Uint32 toUnValidTime = new Uint32(0);

        MobileValidTime() {
        }

        public void marshall(Pack pack) {
            pack.push(this.toValidTime);
            pack.push(this.toUnValidTime);
        }

        public void unmarshall(Unpack unpack) {
            this.toValidTime = unpack.popUint32();
            this.toUnValidTime = unpack.popUint32();
        }

        public String toString() {
            return String.format("MobileValidTime [toValidTime=%s,toUnValidTime=%s]", this.toValidTime, this.toUnValidTime);
        }
    }

    class MobileNobleMedalInfo
    implements Marshallable {
        Uint32 medalID;
        MobileValidTime validTime;
        Map<String, String> extend;

        MobileNobleMedalInfo() {
        }

        public void marshall(Pack pack) {
            pack.push(this.medalID);
            pack.push(this.validTime.toValidTime);
            pack.push(this.validTime.toUnValidTime);
            MarshalContainer.marshalMapStringString((Pack)pack, this.extend);
        }

        public void unmarshall(Unpack unpack) {
            this.medalID = unpack.popUint32();
            this.validTime.toValidTime = unpack.popUint32();
            this.validTime.toUnValidTime = unpack.popUint32();
            UnmarshalContainer.unmarshalMapStringString((Unpack)unpack, this.extend);
        }

        public String toString() {
            return String.format("MobileNobleMedalInfo [medalID=%s]", this.medalID);
        }
    }

    public static class MobileNobleInfo
    implements Marshallable {
        public static final String EXTEND_KEY_STRING_VALUE = "hasSeat2";
        public Uint32 uid = new Uint32(0);
        public Uint32 grade = new Uint32(0);
        public Uint32 curHonour = new Uint32(0);
        public Uint32 honourLevel = new Uint32(0);
        public Uint32 uXingxiang = new Uint32(0);
        public Uint32 uProperty = new Uint32(0);
        public Uint32 vipType = new Uint32(0);
        public String nickName = "";
        public Vector<MobileNobleMedalInfo> medals = new Vector();
        public Map<String, String> extend = new HashMap<String, String>();

        public boolean equals(Object o) {
            return null != o && o instanceof MobileNobleInfo && null != ((MobileNobleInfo)o).uid && ((MobileNobleInfo)o).uid.equals((Object)this.uid);
        }

        public boolean isNobleSeatNotChange(MobileNobleInfo mobileNobleInfo) {
            if (mobileNobleInfo == null) {
                return false;
            }
            String oldHasSeat = this.extend.get("hasSeat");
            String oldProductTotalValues = this.extend.get("productTotalValues");
            String oldCtbValue = this.extend.get("ctbValue");
            String newHasSeat = mobileNobleInfo.extend.get("hasSeat");
            String newProductTotalValues = mobileNobleInfo.extend.get("productTotalValues");
            String newCtbValue = mobileNobleInfo.extend.get("ctbValue");
            boolean isSameHasSeat = oldHasSeat == null && newHasSeat == null || oldHasSeat != null && oldHasSeat.equals(newHasSeat);
            boolean isProductTotalValues = oldProductTotalValues == null && newProductTotalValues == null || oldProductTotalValues != null && oldProductTotalValues.equals(newProductTotalValues);
            boolean isSameCtb = oldCtbValue == null && newCtbValue == null || oldCtbValue != null && oldCtbValue.equals(newCtbValue);
            return isSameCtb && isSameHasSeat && isProductTotalValues && this.grade.intValue() == mobileNobleInfo.grade.intValue() && this.curHonour.intValue() == mobileNobleInfo.curHonour.intValue();
        }

        public int hashCode() {
            return super.hashCode();
        }

        public void marshall(Pack pack) {
            pack.push(this.uid);
            pack.push(this.grade);
            pack.push(this.curHonour);
            pack.push(this.honourLevel);
            pack.push(this.uXingxiang);
            pack.push(this.uProperty);
            pack.push(this.vipType);
            pack.push(this.nickName);
            MarshalContainer.marshalColMarshallable((Pack)pack, this.medals);
            MarshalContainer.marshalMapStringString((Pack)pack, this.extend);
        }

        public void unmarshall(Unpack unpack) {
            this.uid = unpack.popUint32();
            this.grade = unpack.popUint32();
            this.curHonour = unpack.popUint32();
            this.honourLevel = unpack.popUint32();
            this.uXingxiang = unpack.popUint32();
            this.uProperty = unpack.popUint32();
            this.vipType = unpack.popUint32();
            this.nickName = unpack.popString();
            UnmarshalContainer.unmarshalColMarshallable((Unpack)unpack, this.medals, MobileNobleMedalInfo.class);
            UnmarshalContainer.unmarshalMapStringString((Unpack)unpack, this.extend);
        }

        public String toString() {
            return String.format("MobileNobleInfo [uid=%s, grade=%s, curHonour=%s, honourLevel=%s, uXingxiang=%s, uProperty=%s, vipType=%s, nickName=%s", this.uid, this.grade, this.curHonour, this.honourLevel, this.uXingxiang, this.uProperty, this.vipType, this.nickName);
        }
    }

    public static class PMobileNobelVipStandRemove
    extends EntProtocolAdapter {
        public Vector<Uint32> nobleList = new Vector();
        public Map<String, String> extendInfo = new HashMap<String, String>();

        public PMobileNobelVipStandRemove() {
            super(MsgMaxType.MOBENT_MAX, MsgMinType.MIN_TYPE_MOBILE_NOBLE_SEAT_REMOVE);
        }

        public void unString(ByteString bs) {
            Unpack unpack = new Unpack(bs.getBytes());
            UnmarshalContainer.unmarshalColUint32((Unpack)unpack, this.nobleList);
            UnmarshalContainer.unmarshalMapStringString((Unpack)unpack, this.extendInfo);
        }
    }

    public static class PMobileNobleTopMallRsp
    extends EntProtocolAdapter {
        public Vector<MobileNobleInfo> nobleList = new Vector();
        public Map<String, String> extendInfo = new HashMap<String, String>();

        public PMobileNobleTopMallRsp() {
            super(MsgMaxType.MOBENT_MAX, MsgMinType.MIN_TYPE_NOBLE_TOP_MALL_RSP);
        }

        public void unString(ByteString bs) {
            Unpack unpack = new Unpack(bs.getBytes());
            UnmarshalContainer.unmarshalColMarshallable((Unpack)unpack, this.nobleList, MobileNobleInfo.class);
            UnmarshalContainer.unmarshalMapStringString((Unpack)unpack, this.extendInfo);
        }
    }

    public static class PMobileNobleTopMallReq
    extends EntProtocolAdapter {
        public Map<String, String> extend = new HashMap<String, String>();

        public PMobileNobleTopMallReq() {
            super(MsgMaxType.MOBENT_MAX, MsgMinType.MIN_TYPE_NOBLE_TOP_MALL_REQ);
        }

        public void toString(ByteString bs) {
            Pack pack = new Pack();
            MarshalContainer.marshalMapStringString((Pack)pack, this.extend);
            bs.setBytes(pack.toBytes());
        }
    }

    public static class PMobileNobelVipStandRsp
    extends EntProtocolAdapter {
        public Vector<MobileNobleInfo> nobleList = new Vector();
        public Map<String, String> extendInfo = new HashMap<String, String>();

        public PMobileNobelVipStandRsp() {
            super(MsgMaxType.MOBENT_MAX, MsgMinType.MIN_TYPE_NOBLE_SEAT_RSP);
        }

        public void unString(ByteString bs) {
            Unpack unpack = new Unpack(bs.getBytes());
            UnmarshalContainer.unmarshalColMarshallable((Unpack)unpack, this.nobleList, MobileNobleInfo.class);
            UnmarshalContainer.unmarshalMapStringString((Unpack)unpack, this.extendInfo);
        }
    }

    public static class PMobileNobelVipStandReq
    extends EntProtocolAdapter {
        public Uint32 uid = new Uint32(0);
        public Map<String, String> extend = new HashMap<String, String>();

        public PMobileNobelVipStandReq() {
            super(MsgMaxType.MOBENT_MAX, MsgMinType.MIN_TYPE_NOBLE_SEAT_REQ);
        }

        public void toString(ByteString bs) {
            Pack pack = new Pack();
            pack.push(this.uid);
            MarshalContainer.marshalMapStringString((Pack)pack, this.extend);
            bs.setBytes(pack.toBytes());
        }
    }

    public static class MsgMinType {
        public static final Uint32 MIN_TYPE_NOBLE_SEAT_REQ = new Uint32(515);
        public static final Uint32 MIN_TYPE_NOBLE_SEAT_RSP = new Uint32(516);
        public static final Uint32 MIN_TYPE_MOBILE_NOBLE_SEAT_REMOVE = new Uint32(517);
        public static final Uint32 MIN_TYPE_NOBLE_TOP_MALL_REQ = new Uint32(523);
        public static final Uint32 MIN_TYPE_NOBLE_TOP_MALL_RSP = new Uint32(524);
    }

    public static final class MsgMaxType {
        public static final Uint32 MOBENT_MAX = new Uint32(3116);
    }
}

