/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.livebizwrapper.nobleseat;

import android.app.Activity;
import android.content.Context;
import android.graphics.Color;
import android.os.Build;
import android.os.Looper;
import android.os.Message;
import android.text.SpannableString;
import android.text.SpannableStringBuilder;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import androidx.annotation.NonNull;
import androidx.fragment.app.FragmentManager;
import androidx.recyclerview.widget.RecyclerView;
import com.duowan.mobile.basemedia.api.LiveRoomRxBus;
import com.duowan.mobile.basemedia.api.channel.ChannelApi;
import com.duowan.mobile.basemedia.api.channel.audience.AudienceInfo;
import com.duowan.mobile.basemedia.api.channel.audience.IAudienceCore;
import com.duowan.mobile.basemedia.api.event.IAudienceClient_onGetAudienceList_EventArgs;
import com.duowan.mobile.livebasebiz.publicmessage.CustomChatMessage;
import com.yy.android.sniper.annotation.inject.BusEvent;
import com.yy.android.sniper.api.event.EmptyEventCompat;
import com.yy.android.sniper.api.event.EventBinder;
import com.yy.hiidostatis.defs.obj.Property;
import com.yy.mobile.RxBus;
import com.yy.mobile.bizmodel.login.LoginUtil;
import com.yy.mobile.livebizwrapper.component.LiveBizComponentLinkProvider;
import com.yy.mobile.livebizwrapper.contribution.ContributionBean;
import com.yy.mobile.livebizwrapper.contribution.ContributionListRspEvent;
import com.yy.mobile.livebizwrapper.contribution.IContributionCore;
import com.yy.mobile.livebizwrapper.events.IMicAudienceClient_onOnlineAudienceSuccessedNotify_EventArgs;
import com.yy.mobile.livebizwrapper.events.INobleSeatClient_onNobleSeatInfoRemoveRsp_EventArgs;
import com.yy.mobile.livebizwrapper.events.INobleSeatClient_onNobleSeatInfoRsp_EventArgs;
import com.yy.mobile.livebizwrapper.micaudience.IMicAudienceCore;
import com.yy.mobile.livebizwrapper.nobleseat.DefaultNobleSeatBizHolder;
import com.yy.mobile.livebizwrapper.nobleseat.INobleSeatBizHolder;
import com.yy.mobile.livebizwrapper.nobleseat.NobleSeatController$$EventBinder;
import com.yy.mobile.livebizwrapper.nobleseat.core.INobleSeatCore;
import com.yy.mobile.livebizwrapper.nobleseat.core.NobleSeatProtocol;
import com.yy.mobile.livebizwrapper.nobleseat.core.SendGiftTipsEvent;
import com.yy.mobile.livebizwrapper.nobleseat.core.SpannableStringUtils;
import com.yy.mobile.livebizwrapper.nobleseat.ui.NobleSeatLayoutManager;
import com.yy.mobile.livebizwrapper.nobleseat.ui.NobleSeatV2Adapter;
import com.yy.mobile.plugin.main.event.IAnchorInfoCardClient_onShowAnchorCardWithTLove_EventArgs;
import com.yy.mobile.plugin.main.events.IChannelLinkClient_onJoinChannelSuccess_EventArgs;
import com.yy.mobile.plugin.main.events.IProfileClient_onRequestProfile_EventArgs;
import com.yy.mobile.plugin.main.events.IUserClient_onRequestBasicUserInfo_EventArgs;
import com.yy.mobile.sdkwrapper.flowmanagement.base.util.ActivityCheckUtils;
import com.yy.mobile.util.FP;
import com.yy.mobile.util.ResolutionUtils;
import com.yy.mobile.util.SafeDispatchHandler;
import com.yy.mobile.util.StringUtils;
import com.yy.mobile.util.log.MLog;
import com.yy.mobile.util.taskexecutor.YYTaskExecutor;
import com.yy.mobile.yyprotocol.core.Uint32;
import com.yymobile.core.CoreFactory;
import com.yymobile.core.channel.ChannelInfo;
import com.yymobile.core.channel.ChannelMessage;
import com.yymobile.core.channel.ChannelState;
import com.yymobile.core.mobilelive.IMobileLiveCore;
import com.yymobile.core.profile.EntUserInfo;
import com.yymobile.core.profile.IProfileCore;
import com.yymobile.core.statistic.IHiidoStatisticCore;
import com.yymobile.core.user.IUserCore;
import com.yymobile.core.user.UserInfo;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class NobleSeatController
extends EmptyEventCompat
implements NobleSeatV2Adapter.LoadIdentityIconResIdListener,
LiveBizComponentLinkProvider.OnHolderCreatedWithDefaultListener<INobleSeatBizHolder> {
    private static final String TAG = "NobleSeatController";
    public static final String KEY_CONTRIBUTION_VALUE = "contributionValue";
    public static final Property HIIDO_CHANNEL_PROPERTY = new Property();
    private static final long REQUEST_ONLINE_LIST_INTERVAL = 30000L;
    private static final long DEFAULT_UPDATE_UI_INTERVAL = 2500L;
    private static final long MIN_UPDATE_UI_INTERVAL = 800L;
    private static final long SHOW_TIPS_TIME_DELAY = 120000L;
    private static final int MESSAGE_UPDATE_UI = 1;
    private static final int MESSAGE_SHOW_SENDGIFT_TIPS = 2;
    private static final int MESSAGE_SHOW_NOBODY_SEAT = 3;
    private static final int MESSAGE_HIDE_NOBODY_SEAT = 4;
    private static final int MESSAGE_MARQUEE_SHOW_FINISHED = 5;
    private static final int MESSAGE_REVERT_LISTVIEW = 6;
    private static final int MESSAGE_PLAY_ANIMATION = 7;
    private static final int SHOW_LIMIT_COUNT = 20;
    private static final int NOBLELIST_SIZE_LIMIT = 88;
    private Activity mContext;
    private RecyclerView mRecyclerView;
    private NobleSeatV2Adapter mAdapter;
    private FragmentManager fragmentManager;
    private boolean isLandscapeState = false;
    private boolean hasClickItem = false;
    private long curUid = 0L;
    private String curIconUrl = "";
    private Vector<Uint32> mNobleSeatRemoveList = new Vector();
    private Vector<NobleSeatProtocol.MobileNobleInfo> mContributionList = new Vector();
    private Map<Long, NobleSeatProtocol.MobileNobleInfo> mNobleSeatList = Collections.synchronizedMap(new LinkedHashMap());
    private Map<Long, String> mPortraitUrlCacheMap = new HashMap<Long, String>();
    private volatile boolean isFirst = true;
    private volatile boolean isFirstRemove = true;
    private boolean isInit = false;
    private boolean canFlushData = true;
    private boolean isShowedSendGiftTips = false;
    private boolean isCanShowAnimation = true;
    private boolean isFirstContributionUser = true;
    private ChannelMessage marqueeMsg;
    private INobleSeatBizHolder nobleSeatBizHolder;
    private volatile int localContributionAndNobleCount = 0;
    private long topSid;
    private long subSid;
    private RecyclerView.OnScrollListener listScrollListener = new RecyclerView.OnScrollListener(){

        public void onScrollStateChanged(@NonNull RecyclerView recyclerView, int newState) {
            if (newState == 1 || newState == 2) {
                NobleSeatController.this.canFlushData = false;
            } else if (newState == 0) {
                NobleSeatController.this.canFlushData = true;
            }
        }
    };
    private NobleSeatV2Adapter.OnItemClickListener onItemClickListener = new NobleSeatV2Adapter.OnItemClickListener(){

        @Override
        public void onItemClick(int pos, View item, NobleSeatProtocol.MobileNobleInfo itemdata) {
            long topMicId;
            long uid = 0L;
            String iconUrl = "";
            if (itemdata != null) {
                uid = itemdata.uid.longValue();
                iconUrl = itemdata.extend.get("icon");
            }
            if ((topMicId = ChannelApi.Factory.get().getCurrentTopMicId()) == uid) {
                EntUserInfo userinfo = ((IProfileCore)CoreFactory.getCore(IProfileCore.class)).getCachedProfileInfo(uid);
                if (userinfo == null) {
                    NobleSeatController.this.hasClickItem = true;
                    NobleSeatController.this.curUid = uid;
                    NobleSeatController.this.curIconUrl = iconUrl;
                    ((IProfileCore)CoreFactory.getCore(IProfileCore.class)).requestProfile(NobleSeatController.this.curUid);
                } else if (null != NobleSeatController.this.nobleSeatBizHolder) {
                    NobleSeatController.this.nobleSeatBizHolder.showPersonalCardComponent(uid, iconUrl);
                }
            } else if (null != NobleSeatController.this.nobleSeatBizHolder) {
                NobleSeatController.this.nobleSeatBizHolder.showPersonalCardComponent(uid, iconUrl);
            }
            ((IHiidoStatisticCore)CoreFactory.getCore(IHiidoStatisticCore.class)).sendEventStatistic(LoginUtil.getUid(), "51001", "0020", (Serializable)HIIDO_CHANNEL_PROPERTY);
        }
    };
    private Vector<NobleSeatProtocol.MobileNobleInfo> userList = new Vector();
    private SafeDispatchHandler dataHandler = new SafeDispatchHandler(Looper.getMainLooper()){

        public void handleMessage(Message msg) {
            if (!NobleSeatController.this.isInit) {
                MLog.info((String)NobleSeatController.TAG, (String)"handleMessage not init");
                return;
            }
            if (msg.what == 1) {
                if (NobleSeatController.this.canFlushData) {
                    NobleSeatController.this.updateNobleSeatUI();
                }
                this.removeMessages(1);
            } else if (msg.what == 2) {
                if (!(NobleSeatController.this.isShowedSendGiftTips || NobleSeatController.this.isCanShowTipsTemplate() || ((IMobileLiveCore)CoreFactory.getCore(IMobileLiveCore.class)).isLoginUserMobileLive() || NobleSeatController.this.mContributionList.size() > 0)) {
                    NobleSeatController.this.isShowedSendGiftTips = true;
                    SendGiftTipsEvent event = new SendGiftTipsEvent();
                    SpannableStringBuilder ss = SpannableStringUtils.getBuilder("\u6210\u4e3a\u7b2c\u4e00\u4e2a\u7ed9\u4e3b\u64ad\u9001\u793c\u7269\u7684\u4eba").setForegroundColor(Color.parseColor((String)"#FBFFFFFF")).create();
                    event.showText = new SpannableString((CharSequence)ss);
                    event.delayTime = 5000;
                    LiveRoomRxBus.getInstance().post((Object)event);
                }
            } else if (msg.what == 3) {
                NobleSeatController.this.showNobodyContributionCeatView();
            } else if (msg.what == 4) {
                NobleSeatController.this.hideNobodyContributionCeatView();
            } else if (msg.what == 5) {
                if (NobleSeatController.this.marqueeMsg != null && null != NobleSeatController.this.nobleSeatBizHolder && NobleSeatController.this.nobleSeatBizHolder.showContributorMarquee(NobleSeatController.this.marqueeMsg)) {
                    NobleSeatController.this.marqueeMsg = null;
                }
            } else if (msg.what == 6) {
                if (NobleSeatController.this.mRecyclerView != null) {
                    NobleSeatController.this.mRecyclerView.smoothScrollToPosition(0);
                }
            } else if (msg.what == 7 && NobleSeatController.this.mRecyclerView != null) {
                NobleSeatController.this.playAnimation(msg.arg1);
            }
        }
    };
    private Runnable requestOnlineListTimerRunner = new Runnable(){

        @Override
        public void run() {
            MLog.info((String)NobleSeatController.TAG, (String)("[audienceComponentHide] onGetAudienceList isOnlineCopmonentShowState " + NobleSeatController.this.isOnlineCopmonentShowState()));
            if (!NobleSeatController.this.isOnlineCopmonentShowState() && NobleSeatController.this.localContributionAndNobleCount < 20) {
                NobleSeatController.this.topSid = ChannelApi.Factory.get().getCurrentChannelInfo().topSid;
                NobleSeatController.this.subSid = ChannelApi.Factory.get().getCurrentChannelInfo().subSid;
                if (NobleSeatController.this.topSid != 0L) {
                    ((IAudienceCore)CoreFactory.getCore(IAudienceCore.class)).getAudienceList(NobleSeatController.this.topSid, NobleSeatController.this.subSid, 1, 21, 0);
                }
            }
            NobleSeatController.this.startRunOnlineListRunnable(30000L);
        }
    };
    private EventBinder mEventBinder;

    public void init(Activity context, FragmentManager manager) {
        if (!((INobleSeatCore)CoreFactory.getCore(INobleSeatCore.class)).getNobleInit()) {
            ((INobleSeatCore)CoreFactory.getCore(INobleSeatCore.class)).setNobleMallInit(true);
        }
        if (!this.isInit) {
            this.isInit = true;
            if (context != null) {
                this.onEventBind();
                this.mContext = context;
                this.fragmentManager = manager;
            }
            this.topSid = ChannelApi.Factory.get().getCurrentChannelInfo().topSid;
            this.subSid = ChannelApi.Factory.get().getCurrentChannelInfo().subSid;
            HIIDO_CHANNEL_PROPERTY.putString("key1", String.valueOf(this.topSid));
            this.initView();
            if (((INobleSeatCore)CoreFactory.getCore(INobleSeatCore.class)).needLoadNobleListData()) {
                ((INobleSeatCore)CoreFactory.getCore(INobleSeatCore.class)).setLoadNobleListDataState(false);
                Vector<NobleSeatProtocol.MobileNobleInfo> nobleList = ((INobleSeatCore)CoreFactory.getCore(INobleSeatCore.class)).getMobileNobleInfos();
                if (nobleList.size() > 0) {
                    this.onNobleSeatInfoRsp(new INobleSeatClient_onNobleSeatInfoRsp_EventArgs(nobleList));
                }
            }
        }
    }

    private void initView() {
        if (MLog.isLogLevelAboveDebug()) {
            MLog.debug((String)"hsj", (String)"NobleSeatController initView>>>>");
        }
        try {
            this.mAdapter = new NobleSeatV2Adapter(this.mContext);
            this.mAdapter.setOnLoadIdentityIconResIdListener(this);
            this.mRecyclerView = new RecyclerView((Context)this.mContext);
            this.mRecyclerView.setOverScrollMode(2);
            RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-1, -1);
            this.mRecyclerView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
            NobleSeatLayoutManager nobleSeatLayoutManager = new NobleSeatLayoutManager((Context)this.mContext);
            nobleSeatLayoutManager.setOrientation(0);
            this.mRecyclerView.setLayoutManager((RecyclerView.LayoutManager)nobleSeatLayoutManager);
            this.mRecyclerView.setAdapter((RecyclerView.Adapter)this.mAdapter);
            this.disableClipOnParents((View)this.mRecyclerView);
            this.showNobodyContributionCeatView();
            this.setContributionIconVisibility();
            this.mAdapter.setOnItemClickListener(this.onItemClickListener);
            this.mRecyclerView.addOnScrollListener(this.listScrollListener);
            LiveBizComponentLinkProvider.INSTANCE.callCreateHolder(this, DefaultNobleSeatBizHolder.class);
            if (ChannelApi.Factory.get().getChannelState() == ChannelState.In_Channel) {
                this.isShowedSendGiftTips = false;
                this.isFirst = true;
                this.isFirstRemove = true;
                YYTaskExecutor.execute((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        ((INobleSeatCore)CoreFactory.getCore(INobleSeatCore.class)).queryNobleSeatInfo(0L);
                        ((IContributionCore)CoreFactory.getCore(IContributionCore.class)).queryContributionList();
                    }
                });
            }
            if (((IMicAudienceCore)CoreFactory.getCore(IMicAudienceCore.class)).isOnlineAudienceCreateSuccessed()) {
                this.onOnlineAudienceSuccessedNotify();
            }
            this.startRunOnlineListRunnable(100L);
            this.dataHandler.sendEmptyMessageDelayed(2, 120000L);
        }
        catch (Throwable throwable) {
            MLog.error((String)TAG, (String)("initListView error! " + throwable));
        }
    }

    private void setContributionIconVisibility() {
        if (this.isCanShowTipsTemplate()) {
            this.hideNobodyContributionCeatView();
        }
    }

    @BusEvent(busType=1, busName="Live")
    public void onOnlineAudienceSuccessedNotify(IMicAudienceClient_onOnlineAudienceSuccessedNotify_EventArgs busEventArgs) {
        this.onOnlineAudienceSuccessedNotify();
    }

    public void onOnlineAudienceSuccessedNotify() {
        if (this.mRecyclerView != null && this.mRecyclerView.getParent() == null) {
            MLog.info((String)TAG, (String)"onOnlineAudienceSuccessedNotify addAudienceListView");
            ((IMicAudienceCore)CoreFactory.getCore(IMicAudienceCore.class)).addAudienceListView((View)this.mRecyclerView);
        }
    }

    @BusEvent
    public void onRequestProfile(IProfileClient_onRequestProfile_EventArgs busEventArgs) {
        EntUserInfo info = busEventArgs.getInfo();
        if (info == null) {
            return;
        }
        if (info.uid == this.curUid && this.hasClickItem) {
            this.hasClickItem = false;
            if (info.userType == 1) {
                RxBus.getDefault().post((Object)new IAnchorInfoCardClient_onShowAnchorCardWithTLove_EventArgs(this.curUid, this.isLandscapeState, this.curIconUrl));
            } else if (null != this.nobleSeatBizHolder) {
                this.nobleSeatBizHolder.showPersonalCardComponent(this.curUid, this.curIconUrl);
            }
        }
    }

    public void onOrientationChanges(boolean isLandscape) {
        this.isLandscapeState = isLandscape;
    }

    public void onResume() {
        if (!this.isFirst) {
            this.startRunOnlineListRunnable(30000L);
        }
    }

    public void onPause() {
    }

    public void onDispose() {
        LiveBizComponentLinkProvider.INSTANCE.cancelCreateHolder(this);
        if (null != this.nobleSeatBizHolder) {
            this.nobleSeatBizHolder.unInit();
            this.nobleSeatBizHolder = null;
        }
        ((INobleSeatCore)CoreFactory.getCore(INobleSeatCore.class)).setNobleMallInit(false);
        ((INobleSeatCore)CoreFactory.getCore(INobleSeatCore.class)).clearMobileNobleInfos();
        if (MLog.isLogLevelAboveDebug()) {
            MLog.debug((String)TAG, (String)"onDispose");
        }
        this.onEventUnBind();
        if (this.mAdapter != null) {
            this.mAdapter.removeCacheDrawables();
        }
        this.stopRunOnlineListRunnable();
        if (null != this.dataHandler) {
            this.dataHandler.removeCallbacksAndMessages(null);
        }
        this.isInit = false;
        this.mNobleSeatList.clear();
        this.mNobleSeatRemoveList.clear();
        this.mPortraitUrlCacheMap.clear();
        this.mContext = null;
        this.fragmentManager = null;
        this.mRecyclerView = null;
        this.mAdapter = null;
    }

    @BusEvent
    public void onJoinChannelSuccess(IChannelLinkClient_onJoinChannelSuccess_EventArgs busEventArgs) {
        ChannelInfo channelInfo = busEventArgs.getInfo();
        MLog.info((String)TAG, (String)"onJoinChannelSuccess >>>>");
        if (ChannelApi.Factory.get().getChannelState() == ChannelState.In_Channel) {
            this.marqueeMsg = null;
            this.mNobleSeatList.clear();
            this.mContributionList.clear();
            this.mNobleSeatRemoveList.clear();
            if (this.mAdapter != null) {
                this.mAdapter.removeCacheDrawables();
                this.mAdapter.getData().clear();
                this.mAdapter.notifyDataSetChanged();
            }
            this.isFirst = true;
            this.isFirstContributionUser = true;
            this.stopRunOnlineListRunnable();
            this.isFirstRemove = true;
            this.isShowedSendGiftTips = false;
            this.isCanShowAnimation = true;
            ((INobleSeatCore)CoreFactory.getCore(INobleSeatCore.class)).queryNobleSeatInfo(0L);
            ((IContributionCore)CoreFactory.getCore(IContributionCore.class)).queryContributionList();
            this.startRunOnlineListRunnable(100L);
            HIIDO_CHANNEL_PROPERTY.putString("key1", String.valueOf(channelInfo.topSid));
            if (null != this.dataHandler && this.dataHandler.hasMessages(2)) {
                this.dataHandler.removeMessages(2);
                this.dataHandler.sendEmptyMessageDelayed(2, 120000L);
            }
            if (null != this.dataHandler && this.dataHandler.hasMessages(4)) {
                this.dataHandler.removeMessages(4);
            }
        }
    }

    private void sortNobleSeatList2() {
        ArrayList<NobleSeatProtocol.MobileNobleInfo> list = new ArrayList<NobleSeatProtocol.MobileNobleInfo>(this.mNobleSeatList.values());
        Collections.sort(list, (lhs, rhs) -> {
            int retFlag = 0;
            try {
                String lhsHasSeat = lhs.extend.get("hasSeat");
                String rhsHasSeat = rhs.extend.get("hasSeat");
                if ("1".equals(lhsHasSeat) && !"1".equals(rhsHasSeat)) {
                    retFlag = -1;
                } else if (!"1".equals(lhsHasSeat) && "1".equals(rhsHasSeat)) {
                    retFlag = 1;
                }
            }
            catch (Exception e) {
                MLog.warn((Object)TAG, (String)"compare seat exception", (Object[])new Object[]{e});
            }
            if (retFlag == 0) {
                try {
                    int lhsGrade = lhs.grade.intValue();
                    int rhsGrade = rhs.grade.intValue();
                    retFlag = lhsGrade > rhsGrade ? 1 : (lhsGrade < rhsGrade ? -1 : 0);
                }
                catch (Exception e) {
                    MLog.warn((Object)TAG, (String)"compare grade exception", (Object[])new Object[]{e});
                }
            }
            if (retFlag == 0) {
                try {
                    int lhsTotalValue = StringUtils.safeParseInt((String)lhs.extend.get("productTotalValues"));
                    int rhsTotalValue = StringUtils.safeParseInt((String)rhs.extend.get("productTotalValues"));
                    retFlag = lhsTotalValue > rhsTotalValue ? -1 : (lhsTotalValue < rhsTotalValue ? 1 : 0);
                }
                catch (Exception e) {
                    MLog.warn((Object)TAG, (String)"compare productTotalValues exception", (Object[])new Object[]{e});
                }
            }
            if (retFlag == 0) {
                try {
                    int lhsHonour = lhs.curHonour.intValue();
                    int rhsHonour = rhs.curHonour.intValue();
                    retFlag = lhsHonour > rhsHonour ? -1 : (lhsHonour < rhsHonour ? 1 : 0);
                }
                catch (Exception e) {
                    MLog.warn((Object)TAG, (String)"compare honour exception", (Object[])new Object[]{e});
                }
            }
            return retFlag;
        });
        this.mNobleSeatList.clear();
        int size = Math.min(list.size(), 88);
        for (int i = 0; i < size; ++i) {
            NobleSeatProtocol.MobileNobleInfo info = (NobleSeatProtocol.MobileNobleInfo)list.get(i);
            if (info == null) continue;
            this.mNobleSeatList.put(info.uid.longValue(), info);
        }
    }

    private void updateNobleSeatUI() {
        YYTaskExecutor.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                NobleSeatController.this.sortNobleSeatList2();
                final Vector list = new Vector();
                boolean isMyselfInRank = false;
                int myRank = 0;
                if (NobleSeatController.this.mContributionList.size() >= 20) {
                    list.addAll(NobleSeatController.this.mContributionList.subList(0, 20));
                    NobleSeatController.this.mContributionList.clear();
                    NobleSeatController.this.mContributionList.addAll(list);
                } else {
                    list.addAll(NobleSeatController.this.mContributionList);
                }
                int currentIndex = 0;
                for (NobleSeatProtocol.MobileNobleInfo mobileNobleInfo : list) {
                    if (mobileNobleInfo.uid.longValue() == LoginUtil.getUid()) {
                        isMyselfInRank = true;
                        myRank = currentIndex;
                        break;
                    }
                    ++currentIndex;
                }
                if (list.size() < 20 && !FP.empty((Map)NobleSeatController.this.mNobleSeatList)) {
                    for (Map.Entry entry : NobleSeatController.this.mNobleSeatList.entrySet()) {
                        NobleSeatProtocol.MobileNobleInfo nobleInfo = (NobleSeatProtocol.MobileNobleInfo)entry.getValue();
                        boolean isNew = true;
                        for (NobleSeatProtocol.MobileNobleInfo contributionInfo : list) {
                            if (contributionInfo.uid.longValue() != nobleInfo.uid.longValue()) continue;
                            isNew = false;
                            break;
                        }
                        if (isNew) {
                            list.add(nobleInfo);
                        }
                        if (list.size() < 20) continue;
                        break;
                    }
                }
                NobleSeatController.this.localContributionAndNobleCount = list.size();
                if (list.size() < 20 && !FP.empty((Collection)NobleSeatController.this.userList)) {
                    for (NobleSeatProtocol.MobileNobleInfo mobileNobleInfo : NobleSeatController.this.userList) {
                        boolean isNew = true;
                        for (NobleSeatProtocol.MobileNobleInfo contributionAndNobleInfo : list) {
                            if (contributionAndNobleInfo.uid.longValue() != mobileNobleInfo.uid.longValue()) continue;
                            isNew = false;
                            break;
                        }
                        if (isNew) {
                            list.add(mobileNobleInfo);
                        }
                        if (list.size() < 20) continue;
                        break;
                    }
                }
                if (NobleSeatController.this.isSameList(NobleSeatController.this.mAdapter.getData(), list)) {
                    MLog.info((String)NobleSeatController.TAG, (String)"isSameList, ignore");
                    return;
                }
                final boolean finalIsMyselfInRank = isMyselfInRank;
                final int n = myRank;
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (!ActivityCheckUtils.checkActivityValid((Activity)NobleSeatController.this.mContext)) {
                            MLog.info((String)NobleSeatController.TAG, (String)"updateUi checkActivity inValid ");
                            return;
                        }
                        if (!NobleSeatController.this.isInit) {
                            MLog.info((String)NobleSeatController.TAG, (String)"updateUi post to main error");
                            return;
                        }
                        NobleSeatController.this.mAdapter.setData(list);
                        if (finalIsMyselfInRank) {
                            if (NobleSeatController.this.isCanShowAnimation) {
                                Message message = new Message();
                                message.what = 7;
                                message.arg1 = n;
                                NobleSeatController.this.dataHandler.sendMessageDelayed(message, 1000L);
                                NobleSeatController.this.isCanShowAnimation = false;
                            }
                        } else {
                            NobleSeatController.this.isCanShowAnimation = true;
                        }
                        if (MLog.isLogLevelAboveDebug()) {
                            MLog.debug((String)NobleSeatController.TAG, (String)("update UI, Current cache mContributionList:" + NobleSeatController.this.mContributionList.size() + " mNobleSeatList:" + NobleSeatController.this.mNobleSeatList.size() + " userList:" + NobleSeatController.this.userList.size()));
                        }
                    }
                });
            }
        });
    }

    private boolean isSameList(Vector<NobleSeatProtocol.MobileNobleInfo> oldList, Vector<NobleSeatProtocol.MobileNobleInfo> newList) {
        if (oldList == null && newList == null) {
            return true;
        }
        if (oldList == null || newList == null) {
            return false;
        }
        if (oldList.size() != newList.size()) {
            return false;
        }
        Iterator<NobleSeatProtocol.MobileNobleInfo> oldIterator = oldList.iterator();
        Iterator<NobleSeatProtocol.MobileNobleInfo> newIterator = newList.iterator();
        while (oldIterator.hasNext() && newIterator.hasNext()) {
            NobleSeatProtocol.MobileNobleInfo newInfo;
            NobleSeatProtocol.MobileNobleInfo oldInfo = oldIterator.next();
            if (oldInfo.isNobleSeatNotChange(newInfo = newIterator.next())) continue;
            return false;
        }
        return true;
    }

    @BusEvent(busType=1, busName="Live", scheduler=3)
    public void onNobleSeatInfoRsp(INobleSeatClient_onNobleSeatInfoRsp_EventArgs busEventArgs) {
        Vector<NobleSeatProtocol.MobileNobleInfo> nobleList = busEventArgs.mNobleList;
        MLog.info((String)TAG, (String)("onNobleSeatInfoRsp:nobleList.size:" + nobleList.size()));
        if (!FP.empty(nobleList)) {
            for (int i = 0; i < nobleList.size(); ++i) {
                NobleSeatProtocol.MobileNobleInfo info = nobleList.get(i);
                this.mNobleSeatList.put(info.uid.longValue(), info);
            }
            long updateUITime = 2500L;
            if (this.isFirst) {
                this.isFirst = false;
                updateUITime = 800L;
            }
            if (!this.dataHandler.hasMessages(1)) {
                this.dataHandler.sendEmptyMessageDelayed(1, updateUITime);
            }
        }
    }

    @BusEvent(busType=1, busName="Live")
    public void onNobleSeatInfoRemoveRsp(INobleSeatClient_onNobleSeatInfoRemoveRsp_EventArgs busEventArgs) {
        final Vector<Uint32> nobleList = busEventArgs.mList;
        if (FP.empty(nobleList)) {
            return;
        }
        YYTaskExecutor.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                if (nobleList != null && nobleList.size() > 0) {
                    MLog.info((String)NobleSeatController.TAG, (String)("onNobleSeatInfoRemoveRsp:nobleList.size:" + nobleList.size()));
                    if (NobleSeatController.this.isFirstRemove && nobleList.size() == 1 && ((Uint32)nobleList.get(0)).longValue() == LoginUtil.getUid()) {
                        NobleSeatController.this.isFirstRemove = false;
                        return;
                    }
                    NobleSeatController.this.mNobleSeatRemoveList.addAll(nobleList);
                    NobleSeatController.this.removeNobleSeatData();
                    if (!NobleSeatController.this.dataHandler.hasMessages(1)) {
                        NobleSeatController.this.dataHandler.sendEmptyMessageDelayed(1, 2500L);
                    }
                }
            }
        });
    }

    private void removeNobleSeatData() {
        if (this.mAdapter != null) {
            for (Uint32 removeUid : this.mNobleSeatRemoveList) {
                if (!this.mNobleSeatList.containsKey(removeUid.longValue())) continue;
                this.mNobleSeatList.remove(removeUid.longValue());
            }
            if (MLog.isLogLevelAboveDebug()) {
                MLog.debug((String)TAG, (String)("remove before size :" + this.mNobleSeatList.size()));
            }
            if (this.mNobleSeatRemoveList != null) {
                this.mNobleSeatRemoveList.clear();
            }
        }
    }

    private void addUserListInfo(List<AudienceInfo> onlineList) {
        this.userList.clear();
        if (this.localContributionAndNobleCount < 20) {
            int nowSize = this.mNobleSeatList.size();
            Vector<Long> userUid = new Vector<Long>();
            int countSize = 0;
            for (int idx = 0; idx < onlineList.size(); ++idx) {
                AudienceInfo audienceInfo = onlineList.get(idx);
                Long uid = audienceInfo.uid;
                if (audienceInfo.portraitUrl != null && !audienceInfo.portraitUrl.isEmpty()) {
                    this.mPortraitUrlCacheMap.put(uid, audienceInfo.portraitUrl);
                }
                if (uid.longValue() == ChannelApi.Factory.get().getCurrentTopMicId()) continue;
                countSize = userUid.size() + nowSize;
                if (countSize > 20) break;
                userUid.add(uid);
            }
            if (countSize < 20) {
                List virtualList = ((IMobileLiveCore)CoreFactory.getCore(IMobileLiveCore.class)).getVirtualUserList();
                for (Long uid : virtualList) {
                    if (this.mNobleSeatList.containsKey(uid)) continue;
                    countSize = userUid.size() + nowSize;
                    if (countSize > 20) break;
                    userUid.add(uid);
                }
            }
            ArrayList<Long> needRequestUserSet = new ArrayList<Long>();
            for (Long uid : userUid) {
                Uint32 uuid;
                UserInfo userinfo = ((IUserCore)CoreFactory.getCore(IUserCore.class)).getCacheUserInfoByUid(uid.longValue());
                NobleSeatProtocol.MobileNobleInfo info = new NobleSeatProtocol.MobileNobleInfo();
                info.uid = uuid = new Uint32(uid.longValue());
                HashMap<String, String> extend = new HashMap<String, String>();
                if (userinfo == null) {
                    needRequestUserSet.add(uid);
                    String portraitUrl = this.mPortraitUrlCacheMap.get(uid);
                    if (portraitUrl != null && !portraitUrl.isEmpty()) {
                        extend.put("icon", portraitUrl);
                        extend.put("iconIndex", "0");
                    } else {
                        extend.put("icon", "");
                        extend.put("iconIndex", "0");
                    }
                } else if (userinfo.iconUrl == null) {
                    extend.put("icon", "");
                    extend.put("iconIndex", String.valueOf(userinfo.iconIndex));
                } else {
                    boolean needIconIndex;
                    boolean bl = needIconIndex = userinfo.iconUrl.equals("") || userinfo.iconUrl.equals("null");
                    if (needIconIndex) {
                        extend.put("icon", "");
                        extend.put("iconIndex", String.valueOf(userinfo.iconIndex));
                    } else {
                        extend.put("icon", userinfo.iconUrl);
                    }
                }
                info.extend = extend;
                this.userList.add(info);
            }
            if (needRequestUserSet.size() > 0) {
                ((IUserCore)CoreFactory.getCore(IUserCore.class)).requestBasicUserInfo(needRequestUserSet, false);
            }
            MLog.info((String)TAG, (String)("addUserListInfo result add userList.size:" + this.userList.size()));
            userUid.clear();
        }
    }

    @BusEvent
    public void onGetAudienceList(final IAudienceClient_onGetAudienceList_EventArgs busEventArgs) {
        YYTaskExecutor.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                long topSid = busEventArgs.getTopSid();
                long subSid = busEventArgs.getSubSid();
                List list = busEventArgs.getList();
                MLog.info((String)NobleSeatController.TAG, (String)("[onGetAudienceList] topSid = " + topSid + ", subSid = " + subSid + " System.currentTimeMillis() = " + System.currentTimeMillis()));
                if (topSid == NobleSeatController.this.topSid && subSid == NobleSeatController.this.subSid && list != null && !list.isEmpty()) {
                    MLog.info((String)NobleSeatController.TAG, (String)("[onGetAudienceList], NobleSeatController list.size() = " + list.size() + " list:\n" + list));
                    if (NobleSeatController.this.localContributionAndNobleCount < 20) {
                        NobleSeatController.this.addUserListInfo(list);
                        if (!NobleSeatController.this.dataHandler.hasMessages(1)) {
                            NobleSeatController.this.dataHandler.sendEmptyMessageDelayed(1, 2500L);
                        }
                    }
                }
            }
        });
    }

    @BusEvent
    public void onRequestBasicUserInfo(IUserClient_onRequestBasicUserInfo_EventArgs busEventArgs) {
        final List userInfoList = busEventArgs.getUserInfoList();
        if (FP.empty((Collection)userInfoList)) {
            return;
        }
        YYTaskExecutor.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                boolean flush = false;
                block0: for (NobleSeatProtocol.MobileNobleInfo nobleInfo : NobleSeatController.this.userList) {
                    if (nobleInfo == null) continue;
                    for (UserInfo userInfo : userInfoList) {
                        if (userInfo == null || nobleInfo.uid.longValue() != userInfo.userId) continue;
                        if (!StringUtils.isEmpty((String)userInfo.iconUrl).booleanValue()) {
                            nobleInfo.extend.put("icon", userInfo.iconUrl);
                        } else if (!StringUtils.isEmpty((String)userInfo.iconUrl_100_100).booleanValue()) {
                            nobleInfo.extend.put("icon", userInfo.iconUrl_100_100);
                        } else if (!StringUtils.isEmpty((String)userInfo.iconUrl_144_144).booleanValue()) {
                            nobleInfo.extend.put("icon", userInfo.iconUrl_144_144);
                        }
                        nobleInfo.extend.put("iconIndex", userInfo.iconIndex + "");
                        flush = true;
                        continue block0;
                    }
                }
                if (flush && !NobleSeatController.this.dataHandler.hasMessages(1)) {
                    NobleSeatController.this.dataHandler.sendEmptyMessageDelayed(1, 2500L);
                }
            }
        });
    }

    private boolean isOnlineCopmonentShowState() {
        if (CoreFactory.getCore(IMicAudienceCore.class) != null) {
            return ((IMicAudienceCore)CoreFactory.getCore(IMicAudienceCore.class)).isOnlineAudienComponentShowing();
        }
        return false;
    }

    public void stopRunOnlineListRunnable() {
        if (this.requestOnlineListTimerRunner != null) {
            YYTaskExecutor.removeTask((Runnable)this.requestOnlineListTimerRunner);
        }
    }

    public void startRunOnlineListRunnable(long time) {
        if (this.requestOnlineListTimerRunner != null) {
            YYTaskExecutor.removeTask((Runnable)this.requestOnlineListTimerRunner);
            YYTaskExecutor.execute((Runnable)this.requestOnlineListTimerRunner, (long)time);
        }
    }

    public void showContributorMarquee(String nickName, int nobleLevel) {
        this.marqueeMsg = new CustomChatMessage();
        this.marqueeMsg.nickname = this.getSafeNickName(nickName);
        this.marqueeMsg.nobleLevel = nobleLevel;
        this.showContributorMarquee();
    }

    String getSafeNickName(String nickName) {
        if (StringUtils.isEmpty((String)nickName).booleanValue()) {
            return "";
        }
        if (nickName.length() >= 9) {
            nickName = nickName.substring(0, 8) + "...";
            return nickName;
        }
        return nickName;
    }

    private void showContributorMarquee() {
        if (this.marqueeMsg == null) {
            MLog.info((String)TAG, (String)"showContributorMarquee but message is null");
            return;
        }
        if (null == this.nobleSeatBizHolder) {
            MLog.info((String)TAG, (String)"showContributorMarquee but holder is null");
            return;
        }
        if (!this.dataHandler.hasMessages(5) && this.nobleSeatBizHolder.showContributorMarquee(this.marqueeMsg)) {
            this.marqueeMsg = null;
            this.dataHandler.sendEmptyMessageDelayed(5, 4000L);
        }
    }

    @BusEvent(busType=1, busName="Live")
    public void onRecieveContributionRankList(ContributionListRspEvent event) {
        MLog.debug((String)TAG, (String)("onRecieveContributionRankList:" + event.toString()));
        if (event.rankData != null && event.rankData.size() > 0) {
            this.dataHandler.sendEmptyMessage(4);
        } else {
            this.dataHandler.sendEmptyMessage(3);
        }
        this.addContributionList(event.rankData);
        if (event.top1 != null) {
            this.showContributorMarquee(event.top1.nick, event.top1.nobleLevel);
        }
        if (!this.dataHandler.hasMessages(1)) {
            long updateTime = 800L;
            if (this.adapterLowPhone() && !this.isFirstContributionUser) {
                updateTime = 30000L;
            }
            if (this.isFirstContributionUser) {
                this.isFirstContributionUser = false;
            }
            this.dataHandler.sendEmptyMessageDelayed(1, updateTime);
        }
    }

    private void addContributionList(List<ContributionBean> beans) {
        this.mContributionList.clear();
        ArrayList<ContributionBean> beansAfterCut = new ArrayList<ContributionBean>();
        if (beans.size() >= 20) {
            beansAfterCut.addAll(beans.subList(0, 20));
        } else {
            beansAfterCut.addAll(beans);
        }
        for (ContributionBean bean : beansAfterCut) {
            NobleSeatProtocol.MobileNobleInfo nobleInfoNew = new NobleSeatProtocol.MobileNobleInfo();
            nobleInfoNew.nickName = bean.nick;
            nobleInfoNew.uid = new Uint32(bean.uid);
            nobleInfoNew.extend.put(KEY_CONTRIBUTION_VALUE, String.valueOf(bean.contributionValue));
            nobleInfoNew.extend.put("icon", bean.headUrl);
            nobleInfoNew.extend.put("ctbValue", String.valueOf(bean.contributionValue));
            this.mContributionList.add(nobleInfoNew);
        }
    }

    private void showNobodyContributionCeatView() {
        if (this.mAdapter == null) {
            return;
        }
        this.mAdapter.showHeaderView();
    }

    private void hideNobodyContributionCeatView() {
        if (this.mAdapter == null) {
            return;
        }
        this.mAdapter.hideHeaderView();
    }

    private void playAnimation(int myPosition) {
        if (this.mRecyclerView == null || this.mAdapter == null) {
            return;
        }
        if (myPosition < 3) {
            this.mRecyclerView.smoothScrollToPosition(0);
            this.mAdapter.playAnimation(myPosition);
        } else {
            this.mRecyclerView.smoothScrollToPosition(0);
            int distance = myPosition * (int)ResolutionUtils.convertDpToPixel((float)40.0f, (Context)this.mContext);
            int duringTime = (myPosition + 1) * 200;
            this.mRecyclerView.smoothScrollBy(distance, duringTime);
            this.mAdapter.playAnimation(myPosition);
            this.dataHandler.sendEmptyMessageDelayed(6, (long)(duringTime + 2500));
        }
    }

    public void disableClipOnParents(View v) {
        if (v == null) {
            return;
        }
        if (v.getParent() == null) {
            return;
        }
        if (v instanceof ViewGroup) {
            ((ViewGroup)v).setClipChildren(false);
        }
        if (v.getParent() instanceof View) {
            this.disableClipOnParents((View)v.getParent());
        }
    }

    private boolean isCanShowTipsTemplate() {
        boolean result = false;
        if ("social".equals(ChannelApi.Factory.get().getBusinessId()) || "onepiece".equals(ChannelApi.Factory.get().getBusinessId()) || "voiceroom".equals(ChannelApi.Factory.get().getBusinessId())) {
            MLog.info((String)TAG, (String)"current template can not show tips and seat");
            result = true;
        }
        return result;
    }

    private boolean adapterLowPhone() {
        boolean isRet = false;
        if (Build.VERSION.SDK_INT == 21 || Build.VERSION.SDK_INT == 22 || Build.VERSION.SDK_INT == 23) {
            isRet = true;
        }
        return isRet;
    }

    @Override
    public int loadIdentityIconResId(int level) {
        if (null == this.nobleSeatBizHolder) {
            return 0;
        }
        return this.nobleSeatBizHolder.getNobleIdentityIconResId(level);
    }

    @Override
    public void onDefaultHolderCreated(@NonNull INobleSeatBizHolder holder) {
        this.nobleSeatBizHolder = holder;
    }

    @Override
    public void onHolderCreated(@NonNull INobleSeatBizHolder holder) {
        this.nobleSeatBizHolder = holder;
        holder.onInit(this.mContext, this.fragmentManager);
        if (this.isInit) {
            this.showContributorMarquee();
        }
        if (null != this.mAdapter) {
            this.mAdapter.setNobleSeatBizHolder(this.nobleSeatBizHolder);
            this.mAdapter.notifyDataSetChanged();
        }
    }

    @Override
    public Class<INobleSeatBizHolder> getHolderClass() {
        return INobleSeatBizHolder.class;
    }

    public void onEventBind() {
        super.onEventBind();
        if (this.mEventBinder == null) {
            this.mEventBinder = new NobleSeatController$$EventBinder();
        }
        this.mEventBinder.bindEvent((Object)this);
    }

    public void onEventUnBind() {
        super.onEventUnBind();
        if (this.mEventBinder != null) {
            this.mEventBinder.unBindEvent();
        }
    }
}

