/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.livebizwrapper.newgeneral;

import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.duowan.mobile.basemedia.api.channel.ChannelApi;
import com.yy.android.sniper.annotation.inject.BusEvent;
import com.yy.android.sniper.api.event.EventBinder;
import com.yy.mobile.livebizwrapper.R;
import com.yy.mobile.livebizwrapper.audience.DefaultOnlineAudienceBizHolder;
import com.yy.mobile.livebizwrapper.audience.IOnlineAudienceBizHolder;
import com.yy.mobile.livebizwrapper.component.LiveBizComponentLinkProvider;
import com.yy.mobile.livebizwrapper.micaudience.event.IMicAudienceClient_onPreLeaveChannel_EventArgs;
import com.yy.mobile.livebizwrapper.newgeneral.GeneralLeaveChannelComponent$$EventBinder;
import com.yy.mobile.livebizwrapper.slidefunction.core.IActiveUserCore;
import com.yy.mobile.livebizwrapper.statistic.GameTplStatisticModel;
import com.yy.mobile.livebizwrapper.task.INewUserTaskInterceptCore;
import com.yy.mobile.ui.basicchanneltemplate.component.BasePopupComponent;
import com.yy.mobile.ui.basicchanneltemplate.component.Component;
import com.yy.mobile.util.log.MLog;
import com.yymobile.core.CoreFactory;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class GeneralLeaveChannelComponent
extends Component
implements View.OnClickListener,
LiveBizComponentLinkProvider.OnHolderCreatedWithDefaultListener<IOnlineAudienceBizHolder> {
    private static final String TAG = "GeneralLeaveChannelComponent";
    private IOnlineAudienceBizHolder onlineAudienceBizHolder;
    private Map<String, String> extendInfo = new HashMap<String, String>();
    private View mRootView = null;
    private ImageView mLeaveBtn;
    private EventBinder mEventBinder;

    public void onCreate(Bundle savedInstanceState) {
        Bundle bundle;
        super.onCreate(savedInstanceState);
        LiveBizComponentLinkProvider.INSTANCE.callCreateHolder(this, DefaultOnlineAudienceBizHolder.class);
        if (this.getActivity().getIntent() != null && (bundle = this.getActivity().getIntent().getExtras()) != null) {
            this.extendInfo = (Map)bundle.get("channel_mobile_extend_info");
        }
    }

    @Nullable
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        this.mRootView = inflater.inflate(this.getLayoutResId(), container, false);
        this.mLeaveBtn = (ImageView)this.mRootView.findViewById(R.id.channel_leave);
        this.mLeaveBtn.setOnClickListener((View.OnClickListener)this);
        return this.mRootView;
    }

    public void onClick(View v) {
        int id2 = v.getId();
        if (id2 == R.id.channel_leave) {
            MLog.info((String)TAG, (String)"click exit live room button");
            this.onLeaveChannel(false, true);
        }
    }

    @BusEvent(busType=1, busName="Live")
    public void onPreLeaveChannel(IMicAudienceClient_onPreLeaveChannel_EventArgs busEventArgs) {
        MLog.info((String)TAG, (String)("onLeaveChannel called with: busEventArgs = [" + busEventArgs + "]"));
        boolean param = busEventArgs.mParam;
        this.onLeaveChannel(param, true);
    }

    protected boolean onLeaveChannel(boolean showOnMicDialog, boolean resetSlipParamsAfterSuccess) {
        if (this.isLiveTaskInterceptExit()) {
            return true;
        }
        if (this.isInterceptExit()) {
            MLog.info((String)TAG, (String)"pop active user recommend");
            BasePopupComponent pop = ((IActiveUserCore)CoreFactory.getCore(IActiveUserCore.class)).createRecommendPopComponent();
            if (pop != null) {
                pop.show(this.getChildFragmentManager(), pop.getClass().getSimpleName());
                ((IActiveUserCore)CoreFactory.getCore(IActiveUserCore.class)).updateIsAlreadyPopInCurChannel(true);
            }
            return true;
        }
        if (((IActiveUserCore)CoreFactory.getCore(IActiveUserCore.class)).isAlreadyPopInCurChannel()) {
            MLog.info((String)TAG, (String)"isAlreadyPopInCurChannel Do not show other guides");
            this.leaveChannelDirect();
            return true;
        }
        if (null != this.onlineAudienceBizHolder && this.onlineAudienceBizHolder.isValid()) {
            return this.onlineAudienceBizHolder.onLeaveChannel(showOnMicDialog, resetSlipParamsAfterSuccess, this.extendInfo);
        }
        this.leaveChannelDirect();
        return true;
    }

    private boolean isLiveTaskInterceptExit() {
        if (CoreFactory.getCore(INewUserTaskInterceptCore.class) != null) {
            return ((INewUserTaskInterceptCore)CoreFactory.getCore(INewUserTaskInterceptCore.class)).canShowNewUserTaskPop();
        }
        return false;
    }

    private boolean isInterceptExit() {
        return ((IActiveUserCore)CoreFactory.getCore(IActiveUserCore.class)).allowPop();
    }

    private void leaveChannelDirect() {
        if (null != this.onlineAudienceBizHolder && this.onlineAudienceBizHolder.isValid()) {
            this.onlineAudienceBizHolder.leaveChannelDirect();
        } else {
            GameTplStatisticModel.instance().componentDestroyReport(this.getContext());
            if (this.checkActivityValid() && this.getActivity() != null) {
                this.getActivity().finish();
            }
            ChannelApi.Factory.get().leaveChannel();
        }
    }

    public void onDestroy() {
        super.onDestroy();
        LiveBizComponentLinkProvider.INSTANCE.cancelCreateHolder(this);
        if (null != this.onlineAudienceBizHolder) {
            this.onlineAudienceBizHolder.unBindLifecycle(this.getLifecycle());
        }
    }

    @Override
    public void onDefaultHolderCreated(@NonNull IOnlineAudienceBizHolder holder) {
        this.onlineAudienceBizHolder = holder;
    }

    @Override
    public void onHolderCreated(@NotNull IOnlineAudienceBizHolder holder) {
        this.onlineAudienceBizHolder = holder;
        holder.bindLifecycle(this.getActivity(), this.getLifecycle());
    }

    @Override
    public Class<IOnlineAudienceBizHolder> getHolderClass() {
        return IOnlineAudienceBizHolder.class;
    }

    protected int getLayoutResId() {
        return R.layout.fragment_general_leave_channnel;
    }

    public void onEventBind() {
        super.onEventBind();
        if (this.mEventBinder == null) {
            this.mEventBinder = new GeneralLeaveChannelComponent$$EventBinder();
        }
        this.mEventBinder.bindEvent((Object)this);
    }

    public void onEventUnBind() {
        super.onEventUnBind();
        if (this.mEventBinder != null) {
            this.mEventBinder.unBindEvent();
        }
    }
}

