/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.livebizwrapper.mobilelive;

import com.yy.mobile.util.FP;
import com.yy.mobile.util.log.MLog;

public class MobileLiveMsgSendFilter {
    private static final String TAG = "MobileLiveMsgSendFilter";
    public static final int MAX_PUNISH_RATIO = 16;
    private static volatile MobileLiveMsgSendFilter mInstance;
    private Message lastMessage;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static MobileLiveMsgSendFilter getInstance() {
        if (mInstance != null) return mInstance;
        Class<MobileLiveMsgSendFilter> clazz = MobileLiveMsgSendFilter.class;
        synchronized (MobileLiveMsgSendFilter.class) {
            if (mInstance != null) return mInstance;
            mInstance = new MobileLiveMsgSendFilter();
            // ** MonitorExit[var0] (shouldn't be in output)
            return mInstance;
        }
    }

    public boolean filter(long uid, String text, int intervalSecs) {
        long time;
        if (text == null || intervalSecs == 0) {
            return false;
        }
        if (this.lastMessage == null || this.lastMessage.uid != uid) {
            this.lastMessage = new Message();
            this.lastMessage.timeStamp = System.currentTimeMillis();
            this.lastMessage.uid = uid;
            this.lastMessage.text = text;
            this.lastMessage.punishRatio = 1;
            return false;
        }
        if (FP.eq((Object)text, (Object)this.lastMessage.text) && (time = System.currentTimeMillis() - this.lastMessage.timeStamp) < (long)(intervalSecs * 1000 * this.lastMessage.punishRatio)) {
            MLog.info((String)TAG, (String)("sendMessage filter msg:" + this.lastMessage + ", interval:" + intervalSecs));
            this.lastMessage.punishRatio = Math.min(this.lastMessage.punishRatio * 2, 16);
            return true;
        }
        this.lastMessage.timeStamp = System.currentTimeMillis();
        this.lastMessage.text = text;
        this.lastMessage.punishRatio = 1;
        return false;
    }

    public void reset() {
        this.lastMessage = null;
    }

    public static class Message {
        public long timeStamp;
        public long uid;
        public String text;
        public int punishRatio = 1;

        public String toString() {
            return "Message{timeStamp=" + this.timeStamp + ", uid=" + this.uid + ", punishRatio=" + this.punishRatio + '}';
        }
    }
}

