/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.livebizwrapper.media;

import androidx.annotation.Nullable;
import com.yy.android.sniper.annotation.inject.BusEvent;
import com.yy.android.sniper.api.event.EventBinder;
import com.yy.android.sniper.api.event.EventCompat;
import com.yy.mobile.RxBus;
import com.yy.mobile.livebizwrapper.media.PostVideoPtsController$$EventBinder;
import com.yy.mobile.plugin.main.events.IChannelLinkClient_leaveCurrentChannel_EventArgs;
import com.yy.mobile.util.log.MLog;
import com.yymobile.core.media.event.VideoPtsEventArgs;
import io.reactivex.annotations.NonNull;
import java.util.ArrayList;
import java.util.List;

public enum PostVideoPtsController implements EventCompat
{
    INSTANCE;

    private static final int PTS_FREQUENCY_LIMIT = 3;
    private static final int PTS_TIME_LIMIT = 100;
    private static final String TAG = "PostVideoPtsController";
    private final List<PostPtsEvent> mVideoPtsEventArgsList = new ArrayList<PostPtsEvent>(3);
    private EventBinder mEventBinder;

    public void onEventBind() {
        if (this.mEventBinder == null) {
            this.mEventBinder = new PostVideoPtsController$$EventBinder();
        }
        this.mEventBinder.bindEvent((Object)this);
    }

    public void onEventUnBind() {
        if (this.mEventBinder != null) {
            this.mEventBinder.unBindEvent();
        }
    }

    private PostVideoPtsController() {
        this.onEventBind();
    }

    @BusEvent
    public void leaveCurrentChannel(IChannelLinkClient_leaveCurrentChannel_EventArgs busEventArgs) {
        MLog.info((String)TAG, (String)"leaveCurrentChannel clear mVideoPtsEventArgsList");
        this.mVideoPtsEventArgsList.clear();
    }

    @NonNull
    private PostPtsEvent getVideoPtsEventArgs(long anchorUid, long pts) {
        PostPtsEvent postPtsEvent = null;
        for (PostPtsEvent event : this.mVideoPtsEventArgsList) {
            if (event == null || event.eventArgs == null || anchorUid != event.eventArgs.getAnchorUid()) continue;
            postPtsEvent = event;
        }
        if (postPtsEvent == null) {
            postPtsEvent = new PostPtsEvent(new VideoPtsEventArgs(anchorUid, pts));
            this.mVideoPtsEventArgsList.add(postPtsEvent);
            MLog.info((Object)TAG, (String)"getVideoPtsEventArgs create a new PostPtsEvent, mVideoPtsEventArgsList.size: %d, postPtsEvent: %s", (Object[])new Object[]{this.mVideoPtsEventArgsList.size(), postPtsEvent});
        } else {
            long lastPts = postPtsEvent.eventArgs.getPts();
            if (pts - lastPts > 100L) {
                postPtsEvent.count = 3;
            }
            postPtsEvent.eventArgs.setPts(pts);
        }
        return postPtsEvent;
    }

    @Nullable
    private void removeVideoPtsEventArgs(long anchorUid) {
        PostPtsEvent postPtsEvent = null;
        for (PostPtsEvent event : this.mVideoPtsEventArgsList) {
            if (event == null || event.eventArgs == null || anchorUid != event.eventArgs.getAnchorUid()) continue;
            postPtsEvent = event;
        }
        if (postPtsEvent != null) {
            postPtsEvent.eventArgs.setPts(-1L);
            RxBus.getDefault().post((Object)postPtsEvent.eventArgs);
            this.mVideoPtsEventArgsList.remove(postPtsEvent);
            MLog.info((Object)TAG, (String)"removeVideoPtsEventArgs success, mVideoPtsEventArgsList.size: %d,  postPtsEvent: %s", (Object[])new Object[]{this.mVideoPtsEventArgsList.size(), postPtsEvent});
        }
    }

    public void postPtsEvent(long anchorUid, long pts) {
        if (pts < 0L) {
            this.removeVideoPtsEventArgs(anchorUid);
        } else {
            PostPtsEvent event = this.getVideoPtsEventArgs(anchorUid, pts);
            if (event.count >= 3 && event.eventArgs != null) {
                RxBus.getDefault().post((Object)event.eventArgs);
                event.count = 0;
            } else {
                ++event.count;
            }
        }
    }

    private class PostPtsEvent {
        volatile int count = 3;
        VideoPtsEventArgs eventArgs;

        PostPtsEvent(VideoPtsEventArgs eventArgs) {
            this.eventArgs = eventArgs;
        }

        public String toString() {
            return "PostPtsEvent{count=" + this.count + ", anchorUid=" + this.eventArgs.getAnchorUid() + ", pts=" + this.eventArgs.getPts() + '}';
        }
    }
}

