/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.livebizwrapper.media;

import android.content.Context;
import android.os.Build;
import com.yy.mobile.bizmodel.login.LoginUtil;
import com.yy.mobile.config.BasicConfig;
import com.yy.mobile.http.RequestError;
import com.yy.mobile.http.RequestManager;
import com.yy.mobile.http.ResponseErrorListener;
import com.yy.mobile.http.ResponseListener;
import com.yy.mobile.sdkwrapper.yylive.media.H264DecRenderWrapper;
import com.yy.mobile.sdkwrapper.yylive.utils.ConstantsWrapper;
import com.yy.mobile.sdkwrapper.yylive.utils.LiveUtils;
import com.yy.mobile.util.StringUtils;
import com.yy.mobile.util.VersionUtil;
import com.yy.mobile.util.log.MLog;
import com.yy.mobile.util.pref.CommonPref;
import com.yymobile.core.CoreFactory;
import com.yymobile.core.media.MediaDecodeConstant;
import com.yymobile.core.statistic.IHiidoStatisticCore;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;

public class MediaDecodeUtils {
    private static final String TAG = "MediaDecodeUtils";
    private static MediaDecodeConstant.DecodeSwitchInfo mDecodeSwitchInfo = null;

    public static void initHardwareDecodeState(String url) {
        MLog.info((String)TAG, (String)"initHardwareDecodeState");
        if (!H264DecRenderWrapper.isAvailable()) {
            MediaDecodeConstant.isCodecOutOfWhiteList = H264DecRenderWrapper.upDateCodecIgnoreCodecWhiteList();
        }
        MediaDecodeUtils.queryMediaDecodeConfig(url);
    }

    public static void handleReportAndIllegalState(boolean switchInfoOk) {
        MLog.info((String)TAG, (String)("handleReportAndIllegalState " + switchInfoOk));
        ((IHiidoStatisticCore)CoreFactory.getCore(IHiidoStatisticCore.class)).sendHardwareDecodePrevCrashed(MediaDecodeUtils.capableHardwareDecode(), MediaDecodeUtils.shouldUseHardwareDecode(), LiveUtils.isPrevH264DecoderCrashed() && MediaDecodeUtils.isNewHardwareDecode());
        MediaDecodeUtils.checkHardwareDecodeIllegalState(true);
    }

    public static boolean capableHardwareDecode() {
        MLog.info((String)TAG, (String)("capableHardwareDecode HwCodecConfig.getH264DecoderSupport() = " + LiveUtils.getH264DecoderSupport() + ", SDK_INT:" + Build.VERSION.SDK_INT + ", H264DecRender.IsAvailable:" + H264DecRenderWrapper.isAvailable() + ", codecName:" + H264DecRenderWrapper.getCodecName()));
        return Build.VERSION.SDK_INT >= 16 && LiveUtils.getH264DecoderSupport() != ConstantsWrapper.SupportWrapper.UNSUPPORTED && H264DecRenderWrapper.isAvailable();
    }

    public static boolean shouldUseHardwareDecode() {
        MLog.info((String)TAG, (String)("shouldUseHardwareDecode IsPrevCrashed = " + LiveUtils.isPrevH264DecoderCrashed() + ", SDK_INT:" + Build.VERSION.SDK_INT));
        if (!MediaDecodeUtils.capableHardwareDecode()) {
            return false;
        }
        boolean isManualConfig = false;
        boolean isManualEnable = false;
        if (CommonPref.instance().contain("PREF_SETTING_MEDIA_HARDWARE_DECODE_V4")) {
            isManualConfig = true;
            isManualEnable = CommonPref.instance().getBoolean("PREF_SETTING_MEDIA_HARDWARE_DECODE_V4", false);
        }
        return isManualConfig ? isManualEnable : MediaDecodeUtils.isLoginUserDefaultEnableHardwareDecode();
    }

    public static boolean isLoginUserDefaultEnableHardwareDecode() {
        MLog.info((String)TAG, (String)("isLoginUserCanSwitchDecode uid:" + LoginUtil.getUid() + ", H264DecRender.IsAvailable:" + H264DecRenderWrapper.isAvailable() + ", HwCodecConfig.getH264DecoderSupport():" + LiveUtils.getH264DecoderSupport() + ", mDecodeSwitchInfo:" + mDecodeSwitchInfo));
        if (LiveUtils.getH264DecoderSupport() == ConstantsWrapper.SupportWrapper.UNSUPPORTED) {
            MLog.info((String)TAG, (String)"isLoginUserCanSwitchDecode false!");
            return false;
        }
        MLog.info((String)TAG, (String)"isLoginUserCanSwitchDecode true!");
        return true;
    }

    private static boolean isUidDefaultEnable() {
        MLog.info((String)TAG, (String)"isUidDefaultEnable");
        if (mDecodeSwitchInfo == null) {
            return true;
        }
        if (Build.VERSION.SDK_INT < MediaDecodeUtils.mDecodeSwitchInfo.osVersion) {
            return false;
        }
        VersionUtil.Ver localVer = VersionUtil.getLocalVer((Context)BasicConfig.getInstance().getAppContext());
        VersionUtil.Ver ver = VersionUtil.getVerFromStr((String)MediaDecodeUtils.mDecodeSwitchInfo.yyVersion);
        if (localVer == null || ver == null || localVer.smallThan(ver)) {
            return false;
        }
        long uid = LoginUtil.getUid();
        if (uid == 0L || !LoginUtil.isLogined()) {
            return MediaDecodeUtils.mDecodeSwitchInfo.guestEnable;
        }
        for (List list : MediaDecodeUtils.mDecodeSwitchInfo.uidList) {
            int temp;
            if (!list.contains(temp = (int)uid % 10)) {
                return false;
            }
            uid /= 10L;
        }
        MLog.info((String)TAG, (String)"isUidDefaultEnable true!");
        return true;
    }

    public static void queryMediaDecodeConfig(String url) {
        MLog.info((String)TAG, (String)"queryMediaDecodeConfig");
        RequestManager.instance().submitStringQueryRequest(url, null, (ResponseListener)new ResponseListener<String>(){

            public void onResponse(String response) {
                MediaDecodeUtils.parseHardwareDecodeJson(response);
                MediaDecodeUtils.handleReportAndIllegalState(true);
            }
        }, new ResponseErrorListener(){

            public void onErrorResponse(RequestError error) {
                MLog.error((String)MediaDecodeUtils.TAG, (String)("queryMediaDecodeConfig error!" + error));
                MediaDecodeUtils.handleReportAndIllegalState(false);
            }
        });
    }

    private static void parseHardwareDecodeJson(String response) {
        MLog.info((String)TAG, (String)("parseHardwareDecodeJson response:" + response));
        if (response == null || response.length() == 0) {
            return;
        }
        try {
            JSONObject jsonObject = new JSONObject(response);
            mDecodeSwitchInfo = new MediaDecodeConstant.DecodeSwitchInfo();
            MediaDecodeUtils.mDecodeSwitchInfo.osVersion = StringUtils.safeParseInt((String)jsonObject.optString("osVersion"));
            MediaDecodeUtils.mDecodeSwitchInfo.yyVersion = jsonObject.optString("yyVersion");
            MediaDecodeUtils.mDecodeSwitchInfo.guestEnable = jsonObject.optBoolean("guestEnable");
            JSONArray jsonArray = jsonObject.optJSONArray("uidEnable");
            for (int i = 0; i < jsonArray.length(); ++i) {
                ArrayList<Integer> list = new ArrayList<Integer>();
                for (int j = 0; j < jsonArray.getJSONArray(i).length(); ++j) {
                    list.add(jsonArray.getJSONArray(i).optInt(j));
                }
                MediaDecodeUtils.mDecodeSwitchInfo.uidList.add(list);
            }
        }
        catch (Throwable throwable) {
            MLog.error((String)TAG, (String)("parseHardwareDecodeJson error!" + throwable));
        }
    }

    public static boolean isNewHardwareDecode() {
        long lastHwDecodeTime = MediaDecodeUtils.getLastHardwareDecodeTime();
        long prefLastHwDecodeTime = CommonPref.instance().getLong("PREF_LAST_HARDWARE_DECODE_TIME_V3", -1L);
        MLog.info((String)TAG, (String)("isNewHardwareDecode lastHwDecodeTime:" + lastHwDecodeTime + ", prefLastHwDecodeTime:" + prefLastHwDecodeTime));
        return lastHwDecodeTime > 0L && lastHwDecodeTime > prefLastHwDecodeTime;
    }

    public static long getLastHardwareDecodeTime() {
        long time = 0L;
        try {
            time = LiveUtils.getRunTimeStamp((String)H264DecRenderWrapper.getCrashTsFirst());
        }
        catch (Throwable throwable) {
            MLog.error((String)TAG, (String)("getLastHardwareDecodeTime error! " + throwable));
        }
        return time;
    }

    public static void checkHardwareDecodeIllegalState(boolean isInit) {
        boolean showReset;
        long lastTime = MediaDecodeUtils.getLastHardwareDecodeTime();
        boolean isNewHardwareDecode = MediaDecodeUtils.isNewHardwareDecode();
        int noFrameCount = 0;
        MLog.info((String)TAG, (String)("checkHardwareDecodeIllegalState isInit:" + isInit + ", IsPrevCrashed:" + LiveUtils.isPrevH264DecoderCrashed() + ", getNoFrameCnt:" + noFrameCount + ", lastHardwareDecodeTime:" + lastTime + ", isNewHardwareDecode:" + isNewHardwareDecode));
        if (!isNewHardwareDecode) {
            return;
        }
        CommonPref.instance().putLong("PREF_LAST_HARDWARE_DECODE_TIME_V3", lastTime);
        if (BasicConfig.getInstance().isDebuggable() && CommonPref.instance().getInt("PREF_HARDWARE_DECODE_NO_FRAME_COUNT", 0) > 0) {
            noFrameCount = CommonPref.instance().getInt("PREF_HARDWARE_DECODE_NO_FRAME_COUNT", 0);
            MLog.info((String)TAG, (String)("checkHardwareDecodeIllegalState testNoFrameCount:" + noFrameCount));
        }
        boolean bl = isInit ? LiveUtils.isPrevH264DecoderCrashed() : (showReset = noFrameCount > 30);
        if (CommonPref.instance().getLong("PREF_PROGRAM_DISABLE_HARDWARE_TIME_V3", 0L) != lastTime && showReset) {
            int illegalStateCount = CommonPref.instance().getInt("PREF_ILLEGAL_STATE_COUNT_V3", 0) + 1;
            MLog.info((String)TAG, (String)("checkHardwareDecodeIllegalState illegalStateCount:" + illegalStateCount));
            CommonPref.instance().putInt("PREF_ILLEGAL_STATE_COUNT_V3", illegalStateCount);
            if (illegalStateCount >= 3) {
                CommonPref.instance().putBoolean("PREF_SETTING_MEDIA_HARDWARE_DECODE_V4", false);
                CommonPref.instance().putLong("PREF_PROGRAM_DISABLE_HARDWARE_TIME_V3", lastTime);
                CommonPref.instance().putInt("PREF_ILLEGAL_STATE_COUNT_V3", 0);
            }
        }
    }
}

