/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.livebizwrapper.media;

import android.app.Activity;
import android.content.Context;
import android.util.DisplayMetrics;
import com.yy.mobile.util.DimenConverter;
import com.yy.mobile.util.log.MLog;

public class DualCameraMaskInfo {
    public static final float SCALE_RATIO = 0.66f;
    private static DualCameraMaskInfo mMaskInfo;
    public int widthPx;
    public int heightPx;
    public float bottomRatio1;
    public float bottomRatio2;

    public static DualCameraMaskInfo getMaskInfo(Context context) {
        if (mMaskInfo == null) {
            float height2;
            float height1;
            mMaskInfo = new DualCameraMaskInfo();
            DisplayMetrics dm = new DisplayMetrics();
            ((Activity)context).getWindowManager().getDefaultDisplay().getMetrics(dm);
            if (dm.widthPixels < dm.heightPixels) {
                height1 = dm.heightPixels;
                height2 = dm.widthPixels;
            } else {
                height1 = dm.widthPixels;
                height2 = dm.heightPixels;
            }
            DualCameraMaskInfo.mMaskInfo.heightPx = (int)(height1 * 0.66f / 2.0f);
            DualCameraMaskInfo.mMaskInfo.widthPx = (int)(height2 * 0.66f / 2.0f);
            float bo = (float)DimenConverter.dip2px((Context)context, (float)60.0f) / height1 * 2.0f;
            DualCameraMaskInfo.mMaskInfo.bottomRatio1 = (float)Math.round(bo * 100.0f) / 100.0f;
            bo = (float)DimenConverter.dip2px((Context)context, (float)60.0f) / height2 * 2.0f;
            DualCameraMaskInfo.mMaskInfo.bottomRatio2 = (float)Math.round(bo * 100.0f) / 100.0f;
            MLog.info((String)"DualMaskInfo", (String)mMaskInfo.toString());
        }
        return mMaskInfo;
    }

    public String toString() {
        return "DualCameraMaskInfo{bottomRatio1=" + this.bottomRatio1 + ", bottomRatio2=" + this.bottomRatio2 + ", widthPx=" + this.widthPx + ", heightPx=" + this.heightPx + '}';
    }
}

