/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.livebizwrapper.guideview.followguide;

import android.app.Activity;
import com.duowan.mobile.basemedia.api.channel.ChannelApi;
import com.duowan.mobile.basemedia.api.template.ViewingRoomApi;
import com.duowan.mobile.basemedia.watchlive.activity.LiveTemplateActivity;
import com.duowan.mobile.basemedia.watchlive.template.BaseViewScene;
import com.duowan.mobile.basemedia.watchlive.template.IViewScene;
import com.yy.mobile.bizmodel.login.LoginUtil;
import com.yy.mobile.config.BasicConfig;
import com.yy.mobile.sdkwrapper.flowmanagement.base.util.ActivityCheckUtils;
import com.yy.mobile.ui.utils.SingleToastUtil;
import com.yy.mobile.util.activity.YYActivityManager;
import com.yy.mobile.util.log.MLog;
import com.yy.mobile.util.pref.CommonPref;
import com.yymobile.core.CoreFactory;
import com.yymobile.core.channel.ChannelInfo;
import com.yymobile.core.channel.ChannelState;
import com.yymobile.core.media.IMediaCoreForAudience;
import com.yymobile.core.subscribe.ISubscribeCore;
import com.yymobile.core.subscribe.QueryResult;
import com.yyproto.utils.FP;
import io.reactivex.Observable;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.functions.Function;
import io.reactivex.schedulers.Schedulers;
import java.util.Collection;
import java.util.concurrent.TimeUnit;

public class FollowGuideExpandHelper {
    private static final String TAG = "FollowGuideExpandHelper";

    public static boolean isPlayVideoStatus() {
        int streamListSize = ((IMediaCoreForAudience)CoreFactory.getCore(IMediaCoreForAudience.class)).getStreamListSize();
        ChannelApi channelLinkCore = ChannelApi.Factory.get();
        return streamListSize > 0 || channelLinkCore.getChannelState() != ChannelState.In_Channel;
    }

    public static long getSubscriberUid() {
        long owUid = FollowGuideExpandHelper.getCurrentOwUid();
        long topUid = FollowGuideExpandHelper.getCurrentChannelTopMicId();
        return topUid != 0L ? topUid : owUid;
    }

    public static Observable<Boolean> getSubscribeResultObservable(long uid) {
        QueryResult queryResult;
        MLog.debug((String)TAG, (String)("getSubscribeResultObservable : uid = " + uid));
        QueryResult queryResult2 = queryResult = CoreFactory.getCore(ISubscribeCore.class) == null ? QueryResult.NoSubscribe : ((ISubscribeCore)CoreFactory.getCore(ISubscribeCore.class)).getQuerySubscribeResultHashMap(uid);
        if (queryResult == QueryResult.Subscribe) {
            return Observable.just((Object)true);
        }
        if (queryResult == QueryResult.NoSubscribe) {
            return Observable.just((Object)false);
        }
        if (CoreFactory.getCore(ISubscribeCore.class) == null) {
            return Observable.just((Object)false);
        }
        return ((ISubscribeCore)CoreFactory.getCore(ISubscribeCore.class)).querySubscribeObservable(uid).subscribeOn(Schedulers.io()).timeout(3L, TimeUnit.SECONDS).observeOn(AndroidSchedulers.mainThread()).toObservable();
    }

    public static boolean isEntertainmentScene() {
        IViewScene scene = ViewingRoomApi.Factory.get().getCurrentScene();
        return scene == BaseViewScene.ENTERTAINMENT;
    }

    public static boolean isPortrait() {
        int orientation = BasicConfig.getInstance().getAppContext().getResources().getConfiguration().orientation;
        MLog.debug((String)TAG, (String)String.format("isRightScene: orientation = %s", orientation));
        return orientation == 1;
    }

    public static boolean isMicQueueEmpty() {
        return FP.empty((Collection)ChannelApi.Factory.get().getCurrentMicQueue());
    }

    public static long getCurrentChannelTopMicId() {
        return ChannelApi.Factory.get().getCurrentTopMicId();
    }

    public static long getCurrentOwUid() {
        return ChannelApi.Factory.get().getChannelOwUid();
    }

    public static Observable<Boolean> canShowGuideBtnView() {
        MLog.debug((String)TAG, (String)"canShowGuideBtnView ");
        int streamListSize = ((IMediaCoreForAudience)CoreFactory.getCore(IMediaCoreForAudience.class)).getStreamListSize();
        ChannelApi channelLinkCore = ChannelApi.Factory.get();
        if (streamListSize <= 0 && channelLinkCore.getChannelState() == ChannelState.In_Channel) {
            if (!LoginUtil.isLogined()) {
                return Observable.just((Object)true);
            }
            long topUid = FollowGuideExpandHelper.getCurrentChannelTopMicId();
            long owUid = FollowGuideExpandHelper.getCurrentOwUid();
            if (topUid == 0L && owUid == 0L) {
                MLog.debug((String)TAG, (String)"canShowGuideBtnView, maybe exception!");
                return Observable.just((Object)false);
            }
            if (!FP.empty((Collection)channelLinkCore.getCurrentMicQueue())) {
                MLog.debug((Object)TAG, (String)"canShowGuideBtnView : micQueue not empty! topUid = %s", (Object[])new Object[]{topUid});
                return FollowGuideExpandHelper.handleFollowResult(topUid);
            }
            MLog.debug((Object)TAG, (String)"canShowGuideBtnView : mic queue is empty! owUid = %s", (Object[])new Object[]{owUid});
            return FollowGuideExpandHelper.handleFollowResult(owUid);
        }
        MLog.info((String)TAG, (String)"canShowGuideBtnView : has video or not in channel!");
        return Observable.just((Object)false);
    }

    public static Observable<Boolean> canShowGuideBtnView2() {
        MLog.debug((String)TAG, (String)"canShowGuideBtnView2");
        int streamListSize = ((IMediaCoreForAudience)CoreFactory.getCore(IMediaCoreForAudience.class)).getStreamListSize();
        ChannelApi channelLinkCore = ChannelApi.Factory.get();
        if (streamListSize <= 0 && channelLinkCore.getChannelState() == ChannelState.In_Channel) {
            return Observable.just((Object)true);
        }
        MLog.info((String)TAG, (String)"canShowGuideBtnView2 : has video or not in channel!");
        return Observable.just((Object)false);
    }

    private static Observable<Boolean> handleFollowResult(long uid) {
        MLog.debug((String)TAG, (String)"handleFollowResult: ");
        if (LoginUtil.getUid() == uid) {
            MLog.debug((String)TAG, (String)"handleFollowResult: LoginUtil.getUid() == uid, return false!");
            return Observable.just((Object)false);
        }
        return FollowGuideExpandHelper.getSubscribeResultObservable(uid).map((Function)new Function<Boolean, Boolean>(){

            public Boolean apply(Boolean followed) throws Exception {
                MLog.debug((Object)FollowGuideExpandHelper.TAG, (String)"handleFollowResult apply: followed = %b", (Object[])new Object[]{followed});
                return followed == false;
            }
        });
    }

    public static boolean isFollowGuideBtnScene() {
        IViewScene scene = ViewingRoomApi.Factory.get().getCurrentScene();
        MLog.info((Object)TAG, (String)"isFollowGuideBtnScene: current scene is %s", (Object[])new Object[]{scene});
        return scene == BaseViewScene.GENERAL || scene == BaseViewScene.ENTERTAINMENT || scene == BaseViewScene.ONEPIECE || scene == BaseViewScene.PARTY;
    }

    public static boolean isFreeMode() {
        ChannelInfo.ChannelMode curMode = ChannelApi.Factory.get().getCurrentChannelInfo().channelMode;
        MLog.info((String)TAG, (String)("isMicCard: " + (curMode == ChannelInfo.ChannelMode.Free_Mode)));
        return curMode == ChannelInfo.ChannelMode.Free_Mode;
    }

    public static boolean notifyFirstFollow() {
        boolean firstTimeUse = CommonPref.instance().getBoolean("PERF_FRIST_TIME_USE_APP", true);
        MLog.debug((String)TAG, (String)("firstTimeUse = " + firstTimeUse));
        if (firstTimeUse) {
            SingleToastUtil.showToast((String)"\u5173\u6ce8\u6210\u529f\uff0c\u4e3b\u64ad\u5f00\u64ad\u4f1a\u7ed9\u4f60\u53d1\u901a\u77e5");
            CommonPref.instance().putBoolean("PERF_FRIST_TIME_USE_APP", false);
        }
        return firstTimeUse;
    }

    public static boolean isLiveTemplateActivity() {
        Activity currentActivity = YYActivityManager.INSTANCE.getCurrentActivity();
        if (ActivityCheckUtils.checkActivityValid((Activity)currentActivity)) {
            MLog.info((Object)TAG, (String)"activity = %s", (Object[])new Object[]{currentActivity});
            return currentActivity instanceof LiveTemplateActivity;
        }
        return false;
    }

    public static boolean isValidScene() {
        IViewScene scene = ViewingRoomApi.Factory.get().getCurrentScene();
        MLog.info((Object)TAG, (String)"isRightScene: current scene is %s", (Object[])new Object[]{scene});
        return scene == BaseViewScene.GENERAL || scene == BaseViewScene.ENTERTAINMENT || scene == BaseViewScene.ONEPIECE || scene == BaseViewScene.PARTY;
    }
}

