/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.livebizwrapper.guideview.followguide;

import android.text.format.DateUtils;
import com.yy.android.sniper.annotation.inject.BusEvent;
import com.yy.android.sniper.api.event.EventBinder;
import com.yy.mobile.RxBus;
import com.yy.mobile.livebizwrapper.guideview.event.ShowFollowGuideEventArgs;
import com.yy.mobile.livebizwrapper.guideview.followguide.AbsFollowGuideHandler;
import com.yy.mobile.livebizwrapper.guideview.followguide.ExpandFollowGuideHandler$$EventBinder;
import com.yy.mobile.livebizwrapper.guideview.followguide.FollowGuideExpandHelper;
import com.yy.mobile.livebizwrapper.guideview.followguide.LoginFollowGuideManager;
import com.yy.mobile.sdkwrapper.flowmanagement.event.audience.HasVideoStreamEvent;
import com.yy.mobile.util.RxUtils;
import com.yy.mobile.util.log.MLog;
import com.yy.mobile.util.pref.CommonPref;
import io.reactivex.Observable;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.Consumer;
import java.util.Date;
import java.util.concurrent.TimeUnit;

public class ExpandFollowGuideHandler
extends AbsFollowGuideHandler {
    public static final String TAG = "ExpandFollowGuideHandler";
    private static final String FIRST_IN_CHANNEL_DATE = "7_14_first_in_channel_date";
    private static final int SHOW_TIME_COUNT_DOWN_5 = 5;
    private static final int mShowDelayTime = 60;
    private Disposable mDelayShowTimer;
    private EventBinder mEventBinder;

    @Override
    public String getTAG() {
        return TAG;
    }

    @Override
    public void joinChannelSuccessEvent() {
        this.sceneInitDone();
    }

    private void initFirstInChannelTime() {
        long firstInChannelTime = CommonPref.instance().getLong(FIRST_IN_CHANNEL_DATE, 0L);
        MLog.debug((Object)TAG, (String)"initFirstInChannelTime: firstInChannelTime = %d", (Object[])new Object[]{firstInChannelTime});
        if (firstInChannelTime == 0L) {
            long curDate = new Date().getTime();
            MLog.info((String)TAG, (String)("firstInChannelTime == 0 ,curDate = " + curDate));
            CommonPref.instance().putLong(FIRST_IN_CHANNEL_DATE, curDate);
        }
    }

    @Override
    public void init() {
        super.init();
        if (FollowGuideExpandHelper.isPlayVideoStatus()) {
            this.initFirstInChannelTime();
        }
    }

    @BusEvent
    public void hasVideoStreamNotify(HasVideoStreamEvent event) {
        MLog.info((String)TAG, (String)"hasVideoStreamNotify ,so init FirstInChannelTime!");
        this.initFirstInChannelTime();
    }

    public void sceneInitDone() {
        MLog.info((String)TAG, (String)"sceneInitDone:");
        if (FollowGuideExpandHelper.isPlayVideoStatus()) {
            this.initFirstInChannelTime();
        }
        if (LoginFollowGuideManager.instance().isAbleToShowFollowGuide()) {
            MLog.info((String)TAG, (String)"sceneInitDone: isAbleToShowFollowGuide = true");
            if (this.isNewInstallUser()) {
                this.parseShowDelayTime();
                this.startDelayShowTimer();
            }
        }
    }

    private boolean isNewInstallUser() {
        long firstInChannelTime = CommonPref.instance().getLong(FIRST_IN_CHANNEL_DATE, 0L);
        MLog.info((Object)TAG, (String)"isNewInstallUser: firstInChannelTime = %d", (Object[])new Object[]{firstInChannelTime});
        if (firstInChannelTime != 0L) {
            MLog.info((Object)TAG, (String)"today time = %s", (Object[])new Object[]{new Date().getTime()});
            MLog.info((Object)TAG, (String)"isToday = %b", (Object[])new Object[]{DateUtils.isToday((long)firstInChannelTime)});
            return DateUtils.isToday((long)firstInChannelTime);
        }
        return false;
    }

    private void parseShowDelayTime() {
        MLog.info((Object)TAG, (String)"parseShowDelayTime:  mShowDelayTime=%s", (Object[])new Object[]{60});
    }

    private void startDelayShowTimer() {
        MLog.debug((String)TAG, (String)"startDelayShowTimer: ");
        if (this.mDelayShowTimer == null || this.mDelayShowTimer.isDisposed()) {
            this.mDelayShowTimer = Observable.timer((long)60L, (TimeUnit)TimeUnit.SECONDS).observeOn(AndroidSchedulers.mainThread()).subscribe((Consumer)new Consumer<Long>(){

                public void accept(Long aLong) throws Exception {
                    MLog.info((String)ExpandFollowGuideHandler.TAG, (String)"startDelayShowTimer: showFollowGuide:");
                    ExpandFollowGuideHandler.this.showFollowGuide();
                    ExpandFollowGuideHandler.this.resetDelayShowTimer();
                }
            }, RxUtils.errorConsumer((String)TAG, (String)"startDelayShowTimer: error"));
        }
    }

    @Override
    protected void onResetComponentCountDownTimer() {
        MLog.info((String)TAG, (String)"onResetComponentCountDownTimer:");
        this.resetDelayShowTimer();
    }

    @Override
    public int getType() {
        return 6;
    }

    @Override
    public int getShowDuration() {
        return 5;
    }

    @Override
    protected void finalNotifyShowFollowGuide() {
        MLog.info((String)TAG, (String)"finalNotifyShowFollowGuide: ");
        RxBus.getDefault().post((Object)new ShowFollowGuideEventArgs(this.getType(), true));
    }

    @Override
    protected void finalNotifyHideFollowGuide() {
        MLog.info((String)TAG, (String)"finalNotifyHideFollowGuide: ");
        RxBus.getDefault().post((Object)new ShowFollowGuideEventArgs(this.getType(), false));
    }

    private void resetDelayShowTimer() {
        if (this.mDelayShowTimer != null && !this.mDelayShowTimer.isDisposed()) {
            this.mDelayShowTimer.dispose();
        }
        this.mDelayShowTimer = null;
    }

    @Override
    public void release() {
        super.release();
    }

    @Override
    public void onEventBind() {
        super.onEventBind();
        if (this.mEventBinder == null) {
            this.mEventBinder = new ExpandFollowGuideHandler$$EventBinder();
        }
        this.mEventBinder.bindEvent((Object)this);
    }

    @Override
    public void onEventUnBind() {
        super.onEventUnBind();
        if (this.mEventBinder != null) {
            this.mEventBinder.unBindEvent();
        }
    }
}

