/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.livebizwrapper.guideview.followguide;

import com.duowan.mobile.basemedia.api.channel.ChannelApi;
import com.yy.android.sniper.annotation.inject.BusEvent;
import com.yy.android.sniper.api.event.EmptyEventCompat;
import com.yy.android.sniper.api.event.EventBinder;
import com.yy.mobile.bizmodel.login.LoginUtil;
import com.yy.mobile.livebizwrapper.guideview.followguide.AbsFollowGuideHandler$$EventBinder;
import com.yy.mobile.livebizwrapper.guideview.followguide.FollowGuideExpandHelper;
import com.yy.mobile.livebizwrapper.guideview.followguide.KeyBehaviorGuideStatistic;
import com.yy.mobile.livebizwrapper.guideview.followguide.LoginFollowGuideManager;
import com.yy.mobile.plugin.main.events.IAttentionFriendClient_onQueryBookAnchorBatchResult_EventArgs;
import com.yy.mobile.plugin.main.events.IChannelLinkClient_leaveCurrentChannel_EventArgs;
import com.yy.mobile.plugin.main.events.IChannelLinkClient_onJoinChannelSuccess_EventArgs;
import com.yy.mobile.util.RxUtils;
import com.yy.mobile.util.log.MLog;
import com.yymobile.core.CoreFactory;
import com.yymobile.core.subscribe.ISubscribeCore;
import com.yyproto.utils.FP;
import io.reactivex.Observable;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.Consumer;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public abstract class AbsFollowGuideHandler
extends EmptyEventCompat {
    private static final String TAG = "AbsFollowGuideHandler";
    private int mFollowGuideShowState = 0;
    private Disposable mHiddenTimer;
    private int mHiddenCountDown;
    private EventBinder mEventBinder;

    public void init() {
        this.onEventBind();
    }

    public void release() {
        this.onEventUnBind();
        if (this.mHiddenTimer != null && !this.mHiddenTimer.isDisposed()) {
            this.mHiddenTimer.dispose();
        }
        this.mHiddenTimer = null;
    }

    public abstract String getTAG();

    protected boolean isAnchorLiving() {
        long uid = ChannelApi.Factory.get().getCurrentTopMicId();
        return uid > 0L && FollowGuideExpandHelper.isPlayVideoStatus();
    }

    protected boolean isDisplayableState() {
        return this.mFollowGuideShowState == 0;
    }

    protected void checkCurrentFollowState() {
        if (LoginUtil.isLogined()) {
            this.mFollowGuideShowState = 1;
            long uid = ChannelApi.Factory.get().getCurrentTopMicId();
            ArrayList<Long> uids = new ArrayList<Long>();
            uids.add(uid);
            if (CoreFactory.getCore(ISubscribeCore.class) != null) {
                ((ISubscribeCore)CoreFactory.getCore(ISubscribeCore.class)).queryBookAnchorBatchReq(LoginUtil.getUid(), uids);
            }
        } else {
            this.mHiddenCountDown = this.getShowDuration();
            this.startFollowGuideShowTimer();
            this.finalNotifyShowFollowGuide();
        }
    }

    public void showFollowGuide() {
        if (LoginFollowGuideManager.isShowing) {
            MLog.warn((String)this.getTAG(), (String)"return, due other view is showing");
            return;
        }
        if (!FollowGuideExpandHelper.isLiveTemplateActivity()) {
            MLog.warn((String)this.getTAG(), (String)"cur activity is not live template activity");
            return;
        }
        if (!this.isAnchorLiving()) {
            MLog.warn((String)this.getTAG(), (String)"maybe bug, top mic uid not valid. or not living");
            return;
        }
        if (!this.isDisplayableState()) {
            MLog.warn((String)this.getTAG(), (String)("follow guide is in process, mFollowGuideShowState=" + this.mFollowGuideShowState));
            return;
        }
        if (!LoginFollowGuideManager.instance().isAbleToShowFollowGuide()) {
            MLog.warn((String)this.getTAG(), (String)"not isAbleToShowFollowGuide");
            return;
        }
        this.checkCurrentFollowState();
    }

    @BusEvent
    public void onQueryBookAnchorBatchResult(IAttentionFriendClient_onQueryBookAnchorBatchResult_EventArgs busEventArgs) {
        long uid = busEventArgs.getAnchorUid();
        Map friendList = busEventArgs.getFriendList();
        long anchorUid = ChannelApi.Factory.get().getCurrentTopMicId();
        MLog.debug((Object)this.getTAG(), (String)"onQueryBookAnchorBatchResult: uid=%s, anchorUid=%s", (Object[])new Object[]{uid, anchorUid});
        if (uid != 0L && uid == LoginUtil.getUid() && !FP.empty((Map)friendList) && uid != anchorUid) {
            for (Map.Entry entry : friendList.entrySet()) {
                if ((Long)entry.getKey() != anchorUid) continue;
                if (((Boolean)entry.getValue()).booleanValue()) {
                    MLog.info((String)this.getTAG(), (String)"onQueryBookAnchorBatchResult: anchor followed!");
                    this.mFollowGuideShowState = 3;
                    this.resetTimer();
                    break;
                }
                MLog.info((String)this.getTAG(), (String)"onQueryBookAnchorBatchResult: anchor unfollowed!");
                MLog.info((String)this.getTAG(), (String)("mFollowGuideShowState = " + this.mFollowGuideShowState));
                if (this.mFollowGuideShowState != 1) break;
                this.mHiddenCountDown = this.getShowDuration();
                this.startFollowGuideShowTimer();
                this.finalNotifyShowFollowGuide();
                break;
            }
        }
    }

    private void startFollowGuideShowTimer() {
        if (this.mHiddenTimer == null || this.mHiddenTimer.isDisposed()) {
            KeyBehaviorGuideStatistic.reportFollowGuideBarButtonExposureEvent(this.getType());
            this.mHiddenTimer = Observable.interval((long)1000L, (TimeUnit)TimeUnit.MILLISECONDS).observeOn(AndroidSchedulers.mainThread()).subscribe((Consumer)new Consumer<Long>(){

                public void accept(Long aLong) throws Exception {
                    MLog.debug((Object)AbsFollowGuideHandler.this.getTAG(), (String)"FollowGuideShowTimer: mFollowGuideShowState=%s, mHiddenCountDown=%s", (Object[])new Object[]{AbsFollowGuideHandler.this.mFollowGuideShowState, AbsFollowGuideHandler.this.mHiddenCountDown});
                    if (AbsFollowGuideHandler.this.mHiddenCountDown > 0) {
                        AbsFollowGuideHandler.this.mHiddenCountDown--;
                    } else {
                        AbsFollowGuideHandler.this.mFollowGuideShowState = 3;
                        AbsFollowGuideHandler.this.resetTimer();
                        AbsFollowGuideHandler.this.finalNotifyHideFollowGuide();
                    }
                }
            }, RxUtils.errorConsumer((String)TAG, (String)"FollowGuideShowTimer:  count down timer error !"));
        }
    }

    protected abstract void finalNotifyShowFollowGuide();

    protected abstract void finalNotifyHideFollowGuide();

    protected abstract void onResetComponentCountDownTimer();

    public void stopShowFollowGuide() {
        MLog.info((String)TAG, (String)"stopShowFollowGuide");
        this.mFollowGuideShowState = 3;
        this.resetTimer();
        this.finalNotifyHideFollowGuide();
    }

    protected void followAnchorSuccess() {
        MLog.debug((String)this.getTAG(), (String)"followAnchorSuccess: ");
        this.mFollowGuideShowState = 3;
        this.resetTimer();
    }

    public boolean shouldResumeShow() {
        return this.mHiddenCountDown > 0;
    }

    public void updateFollowGuideShownState(boolean isShown) {
        MLog.debug((Object)this.getTAG(), (String)"updateFollowGuideShownState: sIsShown=%s, mFollowGuideShowState=%s", (Object[])new Object[]{isShown, this.mFollowGuideShowState});
        if (this.mHiddenCountDown > 0 && isShown) {
            this.mFollowGuideShowState = 2;
        }
    }

    @BusEvent
    public void onJoinChannelSuccess(IChannelLinkClient_onJoinChannelSuccess_EventArgs busEventArgs) {
        this.mFollowGuideShowState = 0;
        this.joinChannelSuccessEvent();
    }

    public abstract void joinChannelSuccessEvent();

    @BusEvent
    public void leaveCurrentChannel(IChannelLinkClient_leaveCurrentChannel_EventArgs busEventArgs) {
        this.mFollowGuideShowState = 0;
        this.resetTimer();
    }

    private void resetTimer() {
        if (this.mHiddenTimer != null && !this.mHiddenTimer.isDisposed()) {
            this.mHiddenTimer.dispose();
        }
        this.mHiddenTimer = null;
        this.mHiddenCountDown = 0;
        this.onResetComponentCountDownTimer();
    }

    public void enterLiveRoom() {
        if (this.shouldResumeShow()) {
            this.finalNotifyShowFollowGuide();
        }
    }

    public abstract int getType();

    public abstract int getShowDuration();

    public void onEventBind() {
        super.onEventBind();
        if (this.mEventBinder == null) {
            this.mEventBinder = new AbsFollowGuideHandler$$EventBinder();
        }
        this.mEventBinder.bindEvent((Object)this);
    }

    public void onEventUnBind() {
        super.onEventUnBind();
        if (this.mEventBinder != null) {
            this.mEventBinder.unBindEvent();
        }
    }
}

