/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.livebizwrapper.guideview;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.content.Context;
import android.text.Editable;
import android.text.TextWatcher;
import android.util.AttributeSet;
import android.widget.TextView;
import com.yy.mobile.richtext.AirTicketFilter;
import com.yy.mobile.richtext.RichTextManager;
import java.util.ArrayList;
import java.util.List;

@SuppressLint(value={"AppCompatCustomView"})
public class EmotionTextView
extends TextView {
    private Context mContext;
    private List<RichTextManager.Feature> features = new ArrayList<RichTextManager.Feature>(){
        {
            this.add(RichTextManager.Feature.EMOTICON);
        }
    };
    private TextWatcher textChangedListener;

    public EmotionTextView(Context context) {
        super(context);
        this.init(context);
    }

    public EmotionTextView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    public EmotionTextView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context);
    }

    @TargetApi(value=21)
    public EmotionTextView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init(context);
    }

    private void init(Context context) {
        this.mContext = context;
        this.addTextChangedListener(this.getTextChangedListener());
    }

    private TextWatcher getTextChangedListener() {
        if (null != this.textChangedListener) {
            return this.textChangedListener;
        }
        this.textChangedListener = new TextWatcher(){

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }

            public void afterTextChanged(Editable editable) {
                for (AirTicketFilter.AirTicketSpan span : (AirTicketFilter.AirTicketSpan[])editable.getSpans(0, editable.length(), AirTicketFilter.AirTicketSpan.class)) {
                    editable.removeSpan((Object)span);
                }
                RichTextManager.getInstance().getSpannableString(EmotionTextView.this.mContext, (CharSequence)editable, EmotionTextView.this.features);
            }
        };
        return this.textChangedListener;
    }
}

