/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.livebizwrapper.flowmanagement.compatiblecore.anchor;

import android.os.Looper;
import android.text.TextUtils;
import com.duowan.mobile.livebasebiz.event.ILiveClient_onSoundEffectPlayEnd_EventArgs;
import com.google.gson.Gson;
import com.yy.mobile.RxBus;
import com.yy.mobile.livebizwrapper.flowmanagement.compatiblecore.BaseDelegate;
import com.yy.mobile.sdkwrapper.yylive.media.AudioFilePlayerWrapper;
import com.yy.mobile.sdkwrapper.yylive.media.MediaVideoProtocol;
import com.yy.mobile.sdkwrapper.yylive.media.PlayerEndNotifyWrapper;
import com.yy.mobile.sdkwrapper.yylive.media.SoundEffectModel;
import com.yy.mobile.startlive.api.manager.AudioFilterManager;
import com.yy.mobile.startlive.api.manager.MicManager;
import com.yy.mobile.util.SafeDispatchHandler;
import com.yy.mobile.util.log.MLog;
import com.yy.mobile.util.taskexecutor.YYTaskExecutor;
import java.util.ArrayList;

public class SoundEffectDelegate
extends BaseDelegate {
    private static final String TAG = "SoundEffectDelegate";
    private boolean isSoundEffectPlaying = false;
    private ArrayList<String> soundEffectPathList;
    private SafeDispatchHandler safeMediaCoreDispatchHandler;
    private AudioFilePlayerWrapper currentPlayer;
    private long volume = -1L;
    private Gson mGson = new Gson();

    public SoundEffectDelegate() {
        this.soundEffectPathList = new ArrayList();
        this.safeMediaCoreDispatchHandler = new SafeDispatchHandler(Looper.getMainLooper());
    }

    public void setSoundEffectParam(String param) {
        MLog.info((Object)TAG, (String)"#setSoundEffectParam param = %s", (Object[])new Object[]{param});
        MicManager.getInstance().startPublishAudioToGroup();
        MLog.info((Object)TAG, (String)"#setSoundEffectParam param = %s", (Object[])new Object[]{param});
        if (this.mGson == null || TextUtils.isEmpty((CharSequence)param)) {
            return;
        }
        SoundEffectModel model = (SoundEffectModel)this.mGson.fromJson(param, SoundEffectModel.class);
        if (model != null) {
            AudioFilterManager.getInstance().setSoundEffect(model.mReverbId);
        }
    }

    public boolean addAndPlaySoundEffect(String path) {
        int size = this.soundEffectPathList.size();
        MLog.info((Object)TAG, (String)"addAndPlaySoundEffect: path:%s, path list size:%d", (Object[])new Object[]{path, size});
        if (size >= 3) {
            return false;
        }
        this.soundEffectPathList.add(path);
        this.playSoundEffect();
        return true;
    }

    public void clearSoundEffectList() {
        MLog.info((String)TAG, (String)"clearSoundEffectList");
        this.soundEffectPathList.clear();
        this.isSoundEffectPlaying = false;
        if (this.currentPlayer != null) {
            this.currentPlayer.stop();
            YYTaskExecutor.execute((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (SoundEffectDelegate.this.currentPlayer != null) {
                        SoundEffectDelegate.this.currentPlayer = null;
                    }
                }
            }, (long)200L);
        } else {
            MLog.error((String)TAG, (String)"clearSoundEffectList: null currentPlayer");
        }
    }

    public boolean isSoundEffectPlaying() {
        return this.isSoundEffectPlaying;
    }

    public void pauseSoundEffect() {
        MLog.info((String)TAG, (String)"pauseSoundEffect");
        if (this.currentPlayer != null) {
            this.currentPlayer.pause();
        } else {
            MLog.error((String)TAG, (String)"pauseSoundEffect: currentPlayer null");
        }
    }

    public void setPlayerVolume(long volume) {
        this.volume = volume;
        if (this.currentPlayer != null) {
            this.currentPlayer.setPlayerVolume(volume);
        }
    }

    public void resumeSoundEffect() {
        MLog.info((String)TAG, (String)"resumeSoundEffect");
        if (this.currentPlayer != null) {
            this.currentPlayer.resume();
        } else {
            MLog.error((String)TAG, (String)"resumeSoundEffect: currentPlayer null");
        }
    }

    public boolean setVirtualMicVolume(int volume) {
        MLog.info((Object)TAG, (String)"setVirtualMicVolume: volume:%d", (Object[])new Object[]{volume});
        MediaVideoProtocol mediaVideo = MediaVideoProtocol.Factory.get();
        return mediaVideo != null && mediaVideo.setVirtualMicVolume(volume);
    }

    private void playSoundEffect() {
        if (!this.isSoundEffectPlaying) {
            int size = this.soundEffectPathList.size();
            MLog.info((Object)TAG, (String)"playSoundEffect inner path list size:%d", (Object[])new Object[]{size});
            if (size > 0) {
                final String path = this.soundEffectPathList.get(0);
                if (this.currentPlayer == null) {
                    this.currentPlayer = new AudioFilePlayerWrapper();
                    if (this.volume >= 0L) {
                        this.currentPlayer.setPlayerVolume(this.volume);
                    }
                    MLog.info((String)TAG, (String)("AudioFilePlayer = " + this.currentPlayer));
                }
                this.currentPlayer.open(path);
                this.currentPlayer.setFeedBackToMicMode(2L);
                this.currentPlayer.setPlayerEndHandle(new PlayerEndNotifyWrapper(){

                    public void onPlayerEnd() {
                        MLog.info((String)SoundEffectDelegate.TAG, (String)"AudioFilePlayer onPlayEnd");
                        SoundEffectDelegate.this.safeMediaCoreDispatchHandler.post(new Runnable(){

                            @Override
                            public void run() {
                                if (SoundEffectDelegate.this.currentPlayer != null) {
                                    SoundEffectDelegate.this.currentPlayer.stop();
                                }
                                RxBus.getDefault().post((Object)new ILiveClient_onSoundEffectPlayEnd_EventArgs(path));
                                SoundEffectDelegate.this.soundEffectPathList.remove(path);
                                SoundEffectDelegate.this.isSoundEffectPlaying = false;
                                SoundEffectDelegate.this.playSoundEffect();
                            }
                        });
                    }
                });
                this.currentPlayer.enablePublish(true);
                this.currentPlayer.play();
                this.isSoundEffectPlaying = true;
            }
        } else {
            MLog.error((String)TAG, (String)"playSoundEffect isSoundEffectPlaying is true");
        }
    }
}

