/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.livebizwrapper.flowmanagement.compatiblecore.anchor;

import com.yy.mobile.livebizwrapper.flowmanagement.compatiblecore.BaseDelegate;
import com.yy.mobile.startlive.api.manager.StartLiveManager;
import com.yy.mobile.util.log.MLog;
import java.util.List;
import tv.athena.live.api.entity.VideoQuality;

public class AnchorVideoQualityDelegate
extends BaseDelegate {
    private static final String TAG = "AnchorVideoQualityDelegate";
    private int mLastLevel = -1;

    public AnchorVideoQualityDelegate() {
        this.onEventBind();
    }

    public int getLiveVideoQuality() {
        if (this.mLastLevel != -1) {
            return this.mLastLevel;
        }
        List videoQualities = StartLiveManager.getInstance().getQualities();
        MLog.info((String)TAG, (String)("getLiveVideoQuality called, videoQualities = " + videoQualities));
        if (videoQualities != null && videoQualities.size() > 0) {
            int gear = ((VideoQuality)videoQualities.get(0)).getGear();
            for (VideoQuality videoQuality : videoQualities) {
                if (videoQuality.getGear() != 2) continue;
                gear = 2;
                break;
            }
            this.mLastLevel = gear;
        }
        return this.mLastLevel;
    }

    public void changeCurrentLiveVideoQuality(int level) {
        this.mLastLevel = level;
        MLog.info((Object)TAG, (String)"changeCurrentLiveVideoQuality: target level:%d, current level:%d", (Object[])new Object[]{level, this.getLiveVideoQuality()});
        StartLiveManager.getInstance().switchQuality(level);
    }

    public void reset() {
        MLog.info((String)TAG, (String)"reset called");
        this.mLastLevel = -1;
    }
}

