/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.livebizwrapper.component;

import androidx.annotation.NonNull;
import com.yy.mobile.livebizwrapper.component.BaseLiveBizComponentHolder;
import com.yy.mobile.util.log.MLog;
import java.util.concurrent.CopyOnWriteArrayList;

public enum LiveBizComponentLinkProvider {
    INSTANCE;

    private static final String TAG = "LiveBizComponentLinkProvider";
    private CopyOnWriteArrayList<Class<? extends BaseLiveBizComponentHolder>> holderClasses = new CopyOnWriteArrayList();
    private CopyOnWriteArrayList<OnHolderCreatedListener<? extends BaseLiveBizComponentHolder>> listeners = new CopyOnWriteArrayList();

    public void registHolderClass(Class<? extends BaseLiveBizComponentHolder> holderClass) {
        if (null == holderClass) {
            return;
        }
        this.holderClasses.add(holderClass);
        for (OnHolderCreatedListener<? extends BaseLiveBizComponentHolder> listener2 : this.listeners) {
            try {
                if (!listener2.getHolderClass().isAssignableFrom(holderClass)) continue;
                BaseLiveBizComponentHolder holder = this.createHolder(holderClass);
                if (null != holder) {
                    listener2.onHolderCreated(holder);
                }
                this.listeners.remove(listener2);
            }
            catch (Exception e) {
                MLog.error((Object)TAG, (String)"filterHolder error", (Throwable)e, (Object[])new Object[0]);
            }
        }
    }

    public <T extends BaseLiveBizComponentHolder> void callCreateHolder(OnHolderCreatedListener<T> listener2) {
        this.callCreateHolder(listener2, null);
    }

    public <T extends BaseLiveBizComponentHolder> void callCreateHolder(OnHolderCreatedListener<T> listener2, Class<? extends T> defaultHolderClass) {
        if (null == listener2) {
            return;
        }
        try {
            Class<? extends BaseLiveBizComponentHolder> holderClass = null;
            for (Class<? extends BaseLiveBizComponentHolder> clz : this.holderClasses) {
                if (!listener2.getHolderClass().isAssignableFrom(clz)) continue;
                holderClass = clz;
                break;
            }
            if (null == holderClass) {
                this.listeners.add(listener2);
                if (null != defaultHolderClass && listener2 instanceof OnHolderCreatedWithDefaultListener) {
                    T defaultHolder = this.createHolder(defaultHolderClass);
                    ((OnHolderCreatedWithDefaultListener)listener2).onDefaultHolderCreated(defaultHolder);
                }
                return;
            }
            T holder = this.createHolder(holderClass);
            if (holder == null) {
                return;
            }
            listener2.onHolderCreated(holder);
        }
        catch (Exception e) {
            MLog.error((Object)TAG, (String)"callCreateHolder error", (Throwable)e, (Object[])new Object[0]);
        }
    }

    public void cancelCreateHolder(OnHolderCreatedListener listener2) {
        this.listeners.remove(listener2);
    }

    private <T extends BaseLiveBizComponentHolder> T createHolder(Class<? extends T> holderClass) {
        try {
            return (T)((BaseLiveBizComponentHolder)holderClass.newInstance());
        }
        catch (Exception e) {
            MLog.error((Object)TAG, (String)"createHolder error", (Throwable)e, (Object[])new Object[0]);
            return null;
        }
    }

    public static interface OnHolderCreatedWithDefaultListener<T extends BaseLiveBizComponentHolder>
    extends OnHolderCreatedListener<T> {
        public void onDefaultHolderCreated(@NonNull T var1);
    }

    public static interface OnHolderCreatedListener<T extends BaseLiveBizComponentHolder> {
        public void onHolderCreated(@NonNull T var1);

        public Class<T> getHolderClass();
    }
}

