/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.livebizwrapper.chatscreen.view;

import android.app.Activity;
import android.content.Context;
import android.graphics.Point;
import android.graphics.Rect;
import android.os.Build;
import android.view.WindowManager;
import android.widget.RelativeLayout;
import com.duowan.mobile.basemedia.api.channel.ChannelApi;
import com.duowan.mobile.basemedia.api.template.ViewingRoomApi;
import com.duowan.mobile.basemedia.api.video.VideoLayoutApi;
import com.duowan.mobile.basemedia.watchlive.MediaVideoViewSiteCompat;
import com.duowan.mobile.basemedia.watchlive.template.BaseViewScene;
import com.duowan.mobile.basemedia.watchlive.template.IViewScene;
import com.duowan.mobile.livebasebiz.events.IMediaVideoBasicClient_onMediaVideoBasicStopFlagSwitch_EventArgs;
import com.duowan.mobile.livebasebiz.events.IPKClient_onPKStart_EventArgs;
import com.duowan.mobile.livebasebiz.events.IPKClient_onPKStop_EventArgs;
import com.duowan.mobile.livebasebiz.publicmessage.ICommonScreenCore;
import com.yy.android.sniper.annotation.inject.BusEvent;
import com.yy.android.sniper.api.event.EmptyEventCompat;
import com.yy.android.sniper.api.event.EventBinder;
import com.yy.mobile.config.BasicConfig;
import com.yy.mobile.event.video.MediaVideoViewSiteChangeEvent;
import com.yy.mobile.livebizwrapper.chatscreen.event.IPublicCha_onUpdatePublicScreenHeight_EventArgs;
import com.yy.mobile.livebizwrapper.chatscreen.event.IPublicChatBroadcastClient_onUpdateChatLayoutParams_EventArgs;
import com.yy.mobile.livebizwrapper.chatscreen.view.IPublicScreenView;
import com.yy.mobile.livebizwrapper.chatscreen.view.PublicScreenLayoutHelper$$EventBinder;
import com.yy.mobile.livebizwrapper.utils.CommonUtils;
import com.yy.mobile.sdkwrapper.flowmanagement.api.audience.metadata.AudienceMetadataManager;
import com.yy.mobile.sdkwrapper.flowmanagement.event.audience.playstatus.AudienceVideoPlayStatusEvent;
import com.yy.mobile.sdkwrapper.flowmanagement.event.audience.videosize.VideoDecodeSizeChangeEvent;
import com.yy.mobile.ui.meidabasicvideoview.MediaVideoViewSite;
import com.yy.mobile.util.ScreenUtil;
import com.yy.mobile.util.log.MLog;
import com.yymobile.core.CoreFactory;
import com.yymobile.core.media.IMediaCoreForAudience;

public class PublicScreenLayoutHelper
extends EmptyEventCompat {
    private static String TAG = "PublicScreenLayoutHelper";
    private Context context;
    private int screenWidth;
    private int screenHeight;
    private IPublicScreenView publicScreenView;
    private EventBinder mEventBinder;

    public void onCreate(IPublicScreenView view, Context context) {
        this.context = context;
        this.publicScreenView = view;
        this.onEventBind();
        MLog.info((String)TAG, (String)"onCreate");
        this.relayout();
    }

    public void onOrientationChanged(boolean isLandscape) {
        if (!isLandscape) {
            MLog.info((String)TAG, (String)("onOrientationChanged: " + isLandscape));
            this.relayout();
        }
    }

    public void onDestroy() {
        this.onEventUnBind();
    }

    public void relayout() {
        if ("true".equals(VideoLayoutApi.getInstance().getExtend().get("is_listener_guess")) || "true".equals(VideoLayoutApi.getInstance().getExtend().get("is_vote")) || "true".equals(VideoLayoutApi.getInstance().getExtend().get("is_topic"))) {
            MLog.info((String)TAG, (String)"[xyj][relayout][\u804a\u5929\u5ba4\u73a9\u6cd5\u4e2d\u4e0d\u9700\u8981\u91cd\u65b0\u53d8\u516c\u5c4f\u9ad8\u5ea6]");
            return;
        }
        this.initScreenWidthAndHeight();
        MLog.info((String)TAG, (String)"relayout publicScreen");
        if (this.isMultiVideo()) {
            this.layoutForMultiVideo();
        } else {
            this.layoutForSingleVideo();
        }
    }

    public void relayoutV2() {
        if ("true".equals(VideoLayoutApi.getInstance().getExtend().get("is_listener_guess")) || "true".equals(VideoLayoutApi.getInstance().getExtend().get("is_vote")) || "true".equals(VideoLayoutApi.getInstance().getExtend().get("is_topic"))) {
            MLog.info((String)TAG, (String)"[xyj][relayout][\u804a\u5929\u5ba4\u73a9\u6cd5\u4e2d\u4e0d\u9700\u8981\u91cd\u65b0\u53d8\u516c\u5c4f\u9ad8\u5ea6]");
            return;
        }
        this.initScreenWidthAndHeight();
        MLog.info((String)TAG, (String)"relayout publicScreen");
        if (this.isMultiVideo()) {
            this.layoutForMultiVideo();
        } else {
            this.layoutForSingleVideoV2();
        }
    }

    public void layoutForSingleVideo() {
        MLog.debug((String)TAG, (String)"layout For Single Video");
        int width = this.getDefaultLayoutWidth();
        int height = this.getLayoutHeightParams();
        if (this.isSocialTmpAndHasHeight()) {
            height = this.getHeightForOtherSet();
            MLog.debug((String)TAG, (String)("social tmp has set " + height));
        } else if (this.isFullStyle() || this.isNoVideoStream()) {
            MLog.debug((String)TAG, (String)"layout full style");
            height = ScreenUtil.getInstance().dip2px(170);
        }
        if (this.publicScreenView != null) {
            this.publicScreenView.setPublicScreenSize(width, height);
        }
    }

    public void layoutForSingleVideoV2() {
        MLog.debug((String)TAG, (String)"layout For Single Video");
        int width = this.getDefaultLayoutWidth();
        int height = this.getLayoutHeightParams();
        if (this.isSocialTmpAndHasHeight()) {
            height = this.getHeightForOtherSet();
            MLog.debug((String)TAG, (String)("social tmp has set " + height));
        } else if (this.isFullStyle() || this.isNoVideoStream()) {
            MLog.debug((String)TAG, (String)"layout full style");
            height = ScreenUtil.getInstance().dip2px(170);
        }
        if (this.publicScreenView != null) {
            this.publicScreenView.setPublicScreenSize(width, height -= ScreenUtil.getInstance().dip2px(95));
        }
    }

    private boolean isSocialTmpAndHasHeight() {
        IViewScene scene = ViewingRoomApi.Factory.get().getCurrentScene();
        return scene == BaseViewScene.SOCIAL && this.getHeightForOtherSet() > 0;
    }

    private boolean isNoVideoStream() {
        return ((IMediaCoreForAudience)CoreFactory.getCore(IMediaCoreForAudience.class)).getStreamListSize() == 0;
    }

    private void layoutForMultiVideo() {
        MLog.debug((String)TAG, (String)"layout For Multi Video");
        int width = this.getDefaultLayoutWidth();
        int h = this.getLayoutHeightParams();
        if (this.publicScreenView != null) {
            this.publicScreenView.setPublicScreenSize(width, h);
        }
    }

    protected int getLayoutHeightParams() {
        int height = this.getHeightForOtherSet();
        if (height > 0) {
            return height;
        }
        return this.calculateHeight();
    }

    protected int getHeightForOtherSet() {
        RelativeLayout.LayoutParams params;
        int height = 0;
        String businessId = ChannelApi.Factory.get().getBusinessId();
        MLog.info((String)TAG, (String)("getLayoutHeightDefaultParams called, businessId = " + businessId));
        if (businessId != null && (params = ((ICommonScreenCore)CoreFactory.getCore(ICommonScreenCore.class)).getVerticalParams(businessId)) != null) {
            MLog.info((String)TAG, (String)(" getLayoutHeightDefaultParams : height = " + params.height + " width = " + params.width));
            height = params.height;
        }
        return height;
    }

    public int getDefaultLayoutWidth() {
        return this.screenWidth * 3 / 4 - 50;
    }

    public int getDefaultLayoutHeight() {
        int height = this.screenHeight - ScreenUtil.getInstance().dip2px(140) - this.screenWidth * 3 / 4;
        return height;
    }

    public int calculateHeight() {
        int height = this.getDefaultLayoutHeight();
        MediaVideoViewSite videoSite = MediaVideoViewSiteCompat.getInstance().getFirstVideoViewFrame();
        if (videoSite != null && videoSite.mVideoHeight > 0) {
            height = this.screenHeight - videoSite.getViewY() - videoSite.mVideoHeight - ScreenUtil.getInstance().dip2px(55) - ScreenUtil.getStatusBarHeight() - this.getNavBarHeight();
            MLog.info((String)TAG, (String)("on calculateHeight: " + height + " VideoY:" + videoSite.getViewY() + " VideoHeight:" + videoSite.mVideoHeight + " hasNavBar:" + this.isShowNavBar(this.context) + " getNavBarHeight()\uff1a" + this.getNavBarHeight()));
        } else {
            MLog.info((Object)TAG, (String)"calculateHeight: default height:%d", (Object[])new Object[]{height});
        }
        return height;
    }

    private int getNavBarHeight() {
        if (this.isAndroidQ()) {
            return CommonUtils.getNavigationBarHeight(this.context);
        }
        if (this.isShowNavBar(this.context)) {
            return CommonUtils.getNavigationBarHeight(this.context);
        }
        return 0;
    }

    private boolean isAndroidQ() {
        return Build.VERSION.SDK_INT >= 30;
    }

    private void initScreenWidthAndHeight() {
        if (this.context == null) {
            return;
        }
        WindowManager wm = (WindowManager)this.context.getSystemService("window");
        this.screenWidth = wm.getDefaultDisplay().getWidth();
        this.screenHeight = this.getRealHeight();
        try {
            int decorHeight = ((Activity)this.context).getWindow().getDecorView().getMeasuredHeight();
            MLog.info((String)TAG, (String)("initScreenWidthAndHeight decorHeight = " + decorHeight));
            if (decorHeight > this.screenHeight) {
                this.screenHeight = decorHeight;
            }
        }
        catch (Exception e) {
            MLog.error((String)TAG, (String)e.getMessage());
        }
        MLog.info((String)TAG, (String)("initScreenWidthAndHeight getScreenWidth = " + this.screenWidth + " screenHeight = " + this.screenHeight));
    }

    @BusEvent
    public void onVideoPlayStatusChanged(AudienceVideoPlayStatusEvent event) {
        MLog.info((String)TAG, (String)("onVideoPlayStatusChanged called with: event = [" + event + "]"));
        switch (event.playStatus) {
            case PLAYING: {
                this.relayout();
                break;
            }
            case STOP: {
                this.relayout();
                break;
            }
        }
    }

    @BusEvent
    public void onMediaVideoBasicStopFlagSwitch(IMediaVideoBasicClient_onMediaVideoBasicStopFlagSwitch_EventArgs busEventArgs) {
        boolean stopFlag = busEventArgs.getStopFlag();
        MLog.info((String)TAG, (String)("[onMediaVideoBasicStopFlagSwitch] stopFlag = " + stopFlag));
    }

    @BusEvent
    public void onUpdateChatLayoutParams(IPublicChatBroadcastClient_onUpdateChatLayoutParams_EventArgs busEventArgs) {
        RelativeLayout.LayoutParams params = busEventArgs.getParams();
        MLog.info((String)TAG, (String)("onUpdateChatLayoutParams params height = :" + (params != null ? Integer.valueOf(params.height) : null)));
        if (this.publicScreenView != null && params != null) {
            this.publicScreenView.setPublicScreenSize(this.getDefaultLayoutWidth(), params.height);
        }
    }

    @BusEvent
    public void onUpdatePublicScreenHeight(IPublicCha_onUpdatePublicScreenHeight_EventArgs args) {
        int height = args.getHeight();
        MLog.info((String)TAG, (String)("onUpdatePublicScreenHeight height = :" + height));
        if (height <= 0) {
            this.relayout();
        } else {
            this.publicScreenView.setPublicScreenSize(this.getDefaultLayoutWidth(), height);
        }
    }

    @BusEvent
    public void onMediaVideoViewSiteChange(MediaVideoViewSiteChangeEvent event) {
        if (!this.isLandScape()) {
            MLog.info((String)TAG, (String)"onMediaVideoViewSiteChange");
            this.relayout();
        }
    }

    @BusEvent
    public void onPKStart(IPKClient_onPKStart_EventArgs busEventArgs) {
        MLog.info((String)TAG, (String)"on PK Start");
        this.relayout();
    }

    @BusEvent
    public void onPKStop(IPKClient_onPKStop_EventArgs busEventArgs) {
        MLog.info((String)TAG, (String)"on PK Stop");
        this.relayout();
    }

    private boolean isMultiVideo() {
        return ((IMediaCoreForAudience)CoreFactory.getCore(IMediaCoreForAudience.class)).getStreamListSize() >= 2;
    }

    @BusEvent(busType=1, busName="FlowRxBus")
    public void onVideoDecodeSizeChange(VideoDecodeSizeChangeEvent event) {
        if (!this.isLandScape()) {
            MLog.info((String)TAG, (String)("onVideoDecodeSizeChange: " + event.getVideoSizeInfo().toString()));
            this.relayout();
        }
    }

    private boolean isFullStyle() {
        Boolean isMobileLive = AudienceMetadataManager.getInstance().isFirstMicMobileLiveStreaming();
        if (isMobileLive != null && isMobileLive.booleanValue()) {
            MediaVideoViewSite videoSite = MediaVideoViewSiteCompat.getInstance().getFirstVideoViewFrame();
            if (videoSite != null) {
                MLog.debug((String)TAG, (String)("viewSite info: " + videoSite.toString()));
                return videoSite.getVideoHeight() > videoSite.getVideoWidth();
            }
            return false;
        }
        return false;
    }

    private boolean isLandScape() {
        return this.context.getResources().getConfiguration().orientation == 2;
    }

    public boolean isShowNavBar(Context context) {
        if (null == context) {
            return false;
        }
        Rect outRect1 = new Rect();
        try {
            ((Activity)context).getWindow().getDecorView().getWindowVisibleDisplayFrame(outRect1);
        }
        catch (ClassCastException e) {
            e.printStackTrace();
            return false;
        }
        int activityHeight = outRect1.height();
        int statuBarHeight = ScreenUtil.getStatusBarHeight();
        int remainHeight = this.getRealHeight() - statuBarHeight;
        return activityHeight != remainHeight;
    }

    public int getRealHeight() {
        WindowManager wm = (WindowManager)BasicConfig.getInstance().getAppContext().getSystemService("window");
        Point point = new Point();
        if (Build.VERSION.SDK_INT >= 17) {
            wm.getDefaultDisplay().getRealSize(point);
        } else {
            wm.getDefaultDisplay().getSize(point);
        }
        return point.y;
    }

    public void onEventBind() {
        super.onEventBind();
        if (this.mEventBinder == null) {
            this.mEventBinder = new PublicScreenLayoutHelper$$EventBinder();
        }
        this.mEventBinder.bindEvent((Object)this);
    }

    public void onEventUnBind() {
        super.onEventUnBind();
        if (this.mEventBinder != null) {
            this.mEventBinder.unBindEvent();
        }
    }
}

