/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.livebizwrapper.chatscreen.view;

import android.content.Context;
import android.os.Bundle;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;
import com.duowan.mobile.basemedia.api.channel.IChannelJumpDiversity;
import com.duowan.mobile.livebasebiz.event.IChatEmotionClient_onShowChatInputBroadcast_EventArgs;
import com.duowan.mobile.livebasebiz.privatechat.IChatEmotionCore;
import com.yy.android.sniper.annotation.inject.BusEvent;
import com.yy.android.sniper.api.event.EventBinder;
import com.yy.mobile.livebizwrapper.R;
import com.yy.mobile.livebizwrapper.chatinput.ChatInputBizProvider;
import com.yy.mobile.livebizwrapper.chatinput.IPublicMessageBizHolder;
import com.yy.mobile.livebizwrapper.chatinput.ShowChatPresenter;
import com.yy.mobile.livebizwrapper.chatscreen.AirTicketDelayReport;
import com.yy.mobile.livebizwrapper.chatscreen.BasicPublicScreenComponent;
import com.yy.mobile.livebizwrapper.chatscreen.BasicPublicScreenPresenter;
import com.yy.mobile.livebizwrapper.chatscreen.PublicMessageHelper;
import com.yy.mobile.livebizwrapper.chatscreen.event.AirTicketClickEvent;
import com.yy.mobile.livebizwrapper.chatscreen.event.ShowChatInputPopEvent;
import com.yy.mobile.livebizwrapper.chatscreen.view.IPublicScreenView;
import com.yy.mobile.livebizwrapper.chatscreen.view.PopCarPublicScreenComponent$$EventBinder;
import com.yy.mobile.livebizwrapper.chatscreen.view.PublicScreenLayoutHelper;
import com.yy.mobile.livebizwrapper.chatscreen.view.PublicScreenListView;
import com.yy.mobile.livebizwrapper.events.ChatInputPopStatusChangeEvent;
import com.yy.mobile.livebizwrapper.guideview.GuideLiveTaskContainer;
import com.yy.mobile.livebizwrapper.guideview.GuideViewContainer;
import com.yy.mobile.livebizwrapper.guideview.followguide.LoginFollowGuideManager;
import com.yy.mobile.plugin.homepage.ui.utils.dialog.IBaseDialog;
import com.yy.mobile.plugin.homepage.ui.utils.dialog.OkCancelDialog;
import com.yy.mobile.plugin.homepage.ui.utils.dialog.OkCancelDialogListener;
import com.yy.mobile.ui.dialog.DialogLinkManager;
import com.yy.mobile.util.ResolutionUtils;
import com.yy.mobile.util.log.MLog;
import com.yymobile.core.CoreFactory;
import com.yymobile.core.ICoreManagerBase;
import com.yymobile.core.live.livecore.JoinChannelIntent;
import com.yymobile.core.mobilelive.IMobileLiveCore;
import java.util.List;

public class PopCarPublicScreenComponent<P extends BasicPublicScreenPresenter<V>, V extends IPublicScreenView>
extends BasicPublicScreenComponent<P, V>
implements ChatInputBizProvider.OnHolderCreatedListener {
    private static final String TAG = "PopCarPublicScreenComponent";
    private DialogLinkManager dialogFactory;
    protected PublicScreenLayoutHelper layoutHelper = new PublicScreenLayoutHelper();
    protected GuideViewContainer mGuideContainter;
    protected GuideLiveTaskContainer mLiveTaskContainer;
    protected IPublicMessageBizHolder mPublicMessageBizHolder;
    private ShowChatPresenter showChatInputPresenter = null;
    private EventBinder mEventBinder;

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.layoutHelper.onCreate(this, (Context)this.getActivity());
        ((IChatEmotionCore)CoreFactory.getCore(IChatEmotionCore.class)).setPublicScreenType(this.getScreenType());
        this.showChatInputPresenter = new ShowChatPresenter();
        this.showChatInputPresenter.onCreate();
        ChatInputBizProvider.INSTANCE.createChatInputBizHolder(this);
    }

    @Override
    public void onHolderCreated(IPublicMessageBizHolder holder) {
        MLog.info((String)TAG, (String)"IChatInputBizHolder created ");
        holder.bindLifecycle((Fragment)this, this.getLifecycle());
        this.mPublicMessageBizHolder = holder;
        holder.initAssist(this.getScreenType());
    }

    protected int getScreenType() {
        return 0;
    }

    @Override
    protected int getLayoutResId() {
        return R.layout.fragment_live_public_screen;
    }

    @Override
    protected void initView(ViewGroup rootView) {
        this.listView = (PublicScreenListView)rootView.findViewById(R.id.basic_live_plugin_chat_screen);
        this.listLayout = (RelativeLayout)rootView.findViewById(R.id.chatlist_layout);
        this.revenueLayout = (ViewGroup)rootView.findViewById(R.id.public_chat_revenue);
        this.mGuideContainter = (GuideViewContainer)rootView.findViewById(R.id.live_biz_guide_view);
        this.mLiveTaskContainer = (GuideLiveTaskContainer)rootView.findViewById(R.id.live_biz_task_tips_view);
    }

    @Override
    public void onViewCreated(View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.layoutHelper.relayout();
        LoginFollowGuideManager.instance().initFollowGuideCarrier(TAG);
        if (this.mGuideContainter != null) {
            this.mGuideContainter.onCreate();
        }
        if (this.mLiveTaskContainer != null) {
            this.mLiveTaskContainer.onCreate();
        }
    }

    @Override
    public void onOrientationChanged(boolean isLandscape) {
        super.onOrientationChanged(isLandscape);
        this.layoutHelper.onOrientationChanged(isLandscape);
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        ChatInputBizProvider.INSTANCE.cancelCreateChatinputHolder(this);
        if (this.showChatInputPresenter != null) {
            this.showChatInputPresenter.onDestroy();
        }
        if (null != this.mPublicMessageBizHolder) {
            this.mPublicMessageBizHolder.unBindLifecycle(this.getLifecycle());
        }
        if (this.dialogFactory != null) {
            this.dialogFactory.dismissDialog();
        }
        this.layoutHelper.onDestroy();
        if (this.mGuideContainter != null) {
            this.mGuideContainter.onDestroy();
        }
        if (this.mLiveTaskContainer != null) {
            this.mLiveTaskContainer.onDestroy();
        }
    }

    @BusEvent
    public void onShowChatInputBroadcast(IChatEmotionClient_onShowChatInputBroadcast_EventArgs busEventArgs) {
        boolean showChatInput = busEventArgs.getShowChatInput();
        if (showChatInput && this.showChatInputPresenter != null) {
            this.showChatInputPresenter.showChatInputComponent(this.getParentFragment(), "", this.isHideInputPopWhenSuccess());
        }
    }

    @BusEvent
    public void onShowChatInput(ShowChatInputPopEvent args) {
        if (this.showChatInputPresenter != null) {
            this.showChatInputPresenter.showChatInputComponent(this.getParentFragment(), args.getContent(), this.isHideInputPopWhenSuccess());
        }
    }

    @BusEvent
    public void onChanLeftBubbleHeight(final ChatInputPopStatusChangeEvent event) {
        MLog.info((Object)TAG, (String)"onChanLeftBubbleHeight show:%s", (Object[])new Object[]{event.show});
        final List hotWordList = ((IChatEmotionCore)CoreFactory.getCore(IChatEmotionCore.class)).fetchHotWord();
        if (this.mGuideContainter != null) {
            this.mGuideContainter.post(new Runnable(){

                @Override
                public void run() {
                    if (event.show && hotWordList != null && hotWordList.size() > 0) {
                        PopCarPublicScreenComponent.setMargins((View)PopCarPublicScreenComponent.this.mGuideContainter, 0, 0, 0, (int)ResolutionUtils.convertDpToPixel((float)18.0f, (Context)PopCarPublicScreenComponent.this.getContext()));
                    } else {
                        PopCarPublicScreenComponent.setMargins((View)PopCarPublicScreenComponent.this.mGuideContainter, 0, 0, 0, (int)ResolutionUtils.convertDpToPixel((float)10.0f, (Context)PopCarPublicScreenComponent.this.getContext()));
                    }
                }
            });
        }
    }

    public static void setMargins(View v, int l, int t, int r, int b) {
        if (v.getLayoutParams() instanceof ViewGroup.MarginLayoutParams) {
            ViewGroup.MarginLayoutParams p = (ViewGroup.MarginLayoutParams)v.getLayoutParams();
            p.setMargins(l, t, r, b);
            v.requestLayout();
        }
    }

    protected boolean isHideInputPopWhenSuccess() {
        return this.isLandScape();
    }

    protected boolean isReplay() {
        return false;
    }

    @BusEvent
    public void onAirTicketClick(final AirTicketClickEvent event) {
        MLog.info((String)TAG, (String)("onAirTicketClick event = " + event));
        boolean enable = ((IChannelJumpDiversity)ICoreManagerBase.getCore(IChannelJumpDiversity.class)).isJumpChannelEnable();
        if (!enable) {
            MLog.info((String)TAG, (String)"jumpChannel enable = false");
            return;
        }
        if (this.dialogFactory != null) {
            this.dialogFactory.dismissDialog();
        }
        if (this.dialogFactory == null) {
            this.dialogFactory = new DialogLinkManager(this.getContext());
        }
        if (CoreFactory.getCore(IMobileLiveCore.class) != null && ((IMobileLiveCore)CoreFactory.getCore(IMobileLiveCore.class)).isLoginUserMobileLive()) {
            this.toChannel(event);
        } else {
            this.dialogFactory.showDialog((IBaseDialog)new OkCancelDialog((CharSequence)"\u60a8\u786e\u5b9a\u8981\u79bb\u5f00\u6b64\u76f4\u64ad\u95f4\u5417\uff1f", (CharSequence)"\u786e\u5b9a", (CharSequence)"\u53d6\u6d88", true, true, new OkCancelDialogListener(){

                public void onCancel() {
                }

                public void onOk() {
                    PopCarPublicScreenComponent.this.toChannel(event);
                }
            }));
        }
    }

    private void toChannel(AirTicketClickEvent event) {
        if (event != null && event.getTopSid() > 0L) {
            PublicMessageHelper.setSlipParam(4, null);
            JoinChannelIntent.instance((long)event.getTopSid(), (long)event.getSubSid()).src(90001).build().joinChannel(this.getContext());
            AirTicketDelayReport.getInstance().clickToChannel(event.getTopSid());
        }
    }

    @Override
    public void onEventBind() {
        super.onEventBind();
        if (this.mEventBinder == null) {
            this.mEventBinder = new PopCarPublicScreenComponent$$EventBinder();
        }
        this.mEventBinder.bindEvent((Object)this);
    }

    @Override
    public void onEventUnBind() {
        super.onEventUnBind();
        if (this.mEventBinder != null) {
            this.mEventBinder.unBindEvent();
        }
    }
}

