/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.livebizwrapper.chatscreen.view;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.res.Configuration;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.Nullable;
import com.duowan.mobile.livebasebiz.pluginsconfig.IPluginPropertyCore;
import com.duowan.mobile.livebasebiz.pluginsconfig.PluginLivePropKey;
import com.duowan.mobile.livebasebiz.publicmessage.ICommonScreenCore;
import com.yy.mobile.livebizwrapper.chatinput.IPublicMessageBizHolder;
import com.yy.mobile.livebizwrapper.chatscreen.IPublicChatDataModel;
import com.yy.mobile.livebizwrapper.chatscreen.model.PublicChatBaseModel;
import com.yy.mobile.livebizwrapper.chatscreen.model.PublicScreenBannedCtrl;
import com.yy.mobile.livebizwrapper.chatscreen.presenter.LivePublicScreenPresenter;
import com.yy.mobile.livebizwrapper.chatscreen.view.ILivePublicScreenView;
import com.yy.mobile.livebizwrapper.chatscreen.view.PopCarPublicScreenComponent;
import com.yy.mobile.livebizwrapper.chatscreen.view.PublicScreenListView;
import com.yy.mobile.startlive.api.anchor.LiveBizTypeHolder;
import com.yy.mobile.util.RxUtils;
import com.yy.mobile.util.log.MLog;
import com.yymobile.core.CoreFactory;
import com.yymobile.core.channel.ChannelMessage;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.Consumer;
import java.util.List;

public class LivePublicScreenComponent
extends PopCarPublicScreenComponent<LivePublicScreenPresenter, ILivePublicScreenView>
implements ILivePublicScreenView {
    private static final String TAG = "LivePublicScreenComponent";
    private boolean needCreateRevenuController = false;
    private Disposable mDisposable;
    private PublicScreenBannedCtrl bannedCtrl = new PublicScreenBannedCtrl();

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.bannedCtrl.onCreate(this.getChatActivity());
    }

    @Override
    protected int getScreenType() {
        return 1;
    }

    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        super.onCreateView(inflater, container, savedInstanceState);
        if (this.mPublicMessageBizHolder == null) {
            MLog.info((String)TAG, (String)"onCreateView PublicMessageBizHolder not created, waiting");
            this.needCreateRevenuController = true;
        } else {
            this.needCreateRevenuController = false;
            this.createRevenueController(savedInstanceState);
        }
        return this.rootView;
    }

    @Override
    public void onHolderCreated(IPublicMessageBizHolder holder) {
        super.onHolderCreated(holder);
        if (this.needCreateRevenuController) {
            MLog.info((String)TAG, (String)"onHolder created then createRevenueController");
            this.createRevenueController(null);
        }
    }

    @SuppressLint(value={"CheckResult"})
    public void createRevenueController(Bundle savedInstanceState) {
        ViewGroup.LayoutParams params = this.revenueLayout.getLayoutParams();
        params.width = (Integer)((IPluginPropertyCore)CoreFactory.getCore(IPluginPropertyCore.class)).getCustomerConfig(PluginLivePropKey.RevenueMarqueWidth.getKey(), (Object)-1);
        this.revenueLayout.setLayoutParams(params);
        this.mDisposable = ((LivePublicScreenPresenter)this.getPresenter()).getDataModel().filter(dataModel -> dataModel instanceof PublicChatBaseModel).subscribe((Consumer)new Consumer<IPublicChatDataModel>(){

            public void accept(IPublicChatDataModel dateModel) throws Exception {
                LivePublicScreenComponent.this.mPublicMessageBizHolder.createPublicChatRevenueController((Activity)LivePublicScreenComponent.this.getActivity(), LivePublicScreenComponent.this.getRevenueContainer(), ((PublicChatBaseModel)dateModel).getParser());
                ((LivePublicScreenPresenter)LivePublicScreenComponent.this.getPresenter()).loadAsyncContentCardIfNeed();
            }
        }, RxUtils.errorConsumer((String)TAG));
        if (this.isLianMic() && this.listLayout.getLayoutParams() instanceof ViewGroup.MarginLayoutParams) {
            ViewGroup.MarginLayoutParams param = (ViewGroup.MarginLayoutParams)this.listLayout.getLayoutParams();
            param.bottomMargin = 0;
        }
    }

    @Override
    public void onViewCreated(View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
    }

    private boolean isLianMic() {
        return LiveBizTypeHolder.getInstance().isLinkMic();
    }

    @Override
    public void appendMsg(List<? extends ChannelMessage> data) {
        boolean isAddAsyncContentCard;
        boolean bl = isAddAsyncContentCard = this.listView != null && ((LivePublicScreenPresenter)this.getPresenter()).isAddAsyncContentCard(this.listView.getMessages(), data);
        if (isAddAsyncContentCard) {
            ((LivePublicScreenPresenter)this.getPresenter()).appendAsyncContentMsgToListView(data);
        } else {
            super.appendMsg(data);
        }
    }

    @Override
    public void onDestroyView() {
        super.onDestroyView();
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        this.bannedCtrl.onDestroy();
        if (this.mDisposable != null) {
            this.mDisposable.dispose();
        }
    }

    @Override
    public void setPublicScreenSize(int w, int h) {
        super.setPublicScreenSize(w, h);
        ((ICommonScreenCore)CoreFactory.getCore(ICommonScreenCore.class)).setPublicScreenHeight(h);
    }

    @Override
    public PublicScreenListView getChatListView() {
        return this.listView;
    }

    @Override
    public ViewGroup getRootView() {
        return this.rootView;
    }

    @Override
    public ViewGroup getRevenueContainer() {
        return this.revenueLayout;
    }

    public void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        if (this.mPublicMessageBizHolder != null) {
            this.mPublicMessageBizHolder.onConfigurationChanged(newConfig);
        }
    }
}

