/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.livebizwrapper.chatscreen.presenter;

import android.content.Context;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.duowan.mobile.basemedia.api.channel.ChannelApi;
import com.yy.mobile.RxBus;
import com.yy.mobile.livebizwrapper.R;
import com.yy.mobile.livebizwrapper.chatscreen.AbstractPublicScreenAdapter;
import com.yy.mobile.livebizwrapper.chatscreen.event.EnterMessageShowEvent;
import com.yy.mobile.livebizwrapper.chatscreen.model.channelmessage.GiftChannelMessage;
import com.yy.mobile.livebizwrapper.chatscreen.model.channelmessage.MergeChannelMessage;
import com.yy.mobile.util.ScreenUtil;
import com.yymobile.core.channel.ChannelMessage;
import java.lang.ref.WeakReference;

public class PublicScreenBaseAdapter
extends AbstractPublicScreenAdapter {
    private final int originX = ScreenUtil.getInstance().dip2px(4);
    private int mChatContentTextSize = 14;
    private int mChatContentLineSpace = 0;

    public PublicScreenBaseAdapter(Context context) {
        super(context);
    }

    @Override
    public void setEnlarge(boolean enlarge) {
        if (enlarge) {
            this.mChatContentTextSize = 20;
            this.mChatContentLineSpace = ScreenUtil.getInstance().dip2px(2.0f);
        } else {
            this.mChatContentTextSize = 14;
            this.mChatContentLineSpace = 0;
        }
    }

    @Override
    protected int getItemLayoutResId() {
        return R.layout.mobile_live_basic_live_bottom_chatkeyboard_item;
    }

    @Override
    public void onBindView(ChannelMessage message, TextView textView) {
        if (textView == null || message.spannable == null) {
            return;
        }
        textView.setTextSize(2, (float)this.mChatContentTextSize);
        textView.setLineSpacing((float)this.mChatContentLineSpace, 1.0f);
        textView.setText((CharSequence)message.spannable);
        this.setBgStyle(message, textView);
        if (this.isNewGeneralHint()) {
            if (ChannelMessage.ChannelMsgType.NOTICE_MESSAGE_TYPE == message.channelMessageType) {
                textView.setBackgroundResource(R.drawable.public_chat_msg_bg);
            } else {
                textView.setBackgroundResource(R.drawable.public_chat_msg_new_bg);
            }
        }
        if (message instanceof GiftChannelMessage) {
            textView.setTag((Object)String.valueOf(((GiftChannelMessage)message).giftTypeId));
            message.spannableTarget = new WeakReference<TextView>(textView);
        } else if (message instanceof MergeChannelMessage) {
            textView.setTag((Object)((MergeChannelMessage)message).uniqueId);
            message.spannableTarget = new WeakReference<TextView>(textView);
            int itemCount = this.getItemCount();
            if (itemCount > 0 && this.getItems().get(itemCount - 1) == message) {
                RxBus.getDefault().post((Object)new EnterMessageShowEvent((MergeChannelMessage)message));
            }
        }
    }

    private void setBgStyle(ChannelMessage msg, TextView tv) {
        if (msg != null) {
            msg.decorateMsgBgStyle(this.context, tv);
        }
        RelativeLayout.LayoutParams params = (RelativeLayout.LayoutParams)tv.getLayoutParams();
        params.leftMargin = this.originX;
        tv.setLayoutParams((ViewGroup.LayoutParams)params);
    }

    private boolean isNewGeneralHint() {
        String templateId = ChannelApi.Factory.get().getTemplateId();
        return templateId != null && templateId.equals("0");
    }
}

