/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.livebizwrapper.chatscreen.parser;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.Color;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.text.Spannable;
import android.text.SpannableString;
import android.text.SpannableStringBuilder;
import android.text.TextUtils;
import android.text.style.AbsoluteSizeSpan;
import android.text.style.ForegroundColorSpan;
import android.view.View;
import com.duowan.mobile.basemedia.api.channel.ChannelApi;
import com.duowan.mobile.livebasebiz.lianmai.ILianMaiCore;
import com.duowan.mobile.livebasebiz.publicmessage.IParser;
import com.yy.mobile.RxBus;
import com.yy.mobile.baseapi.chatroom.ChatRoomApi;
import com.yy.mobile.bizmodel.login.LoginUtil;
import com.yy.mobile.config.BasicConfig;
import com.yy.mobile.image.ImageConfig;
import com.yy.mobile.imageloader.ImageLoader;
import com.yy.mobile.imageloader.ImageUtil;
import com.yy.mobile.livebizwrapper.R;
import com.yy.mobile.livebizwrapper.chatscreen.PublicMessageHelper;
import com.yy.mobile.livebizwrapper.chatscreen.event.AirTicketClickEvent;
import com.yy.mobile.livebizwrapper.chatscreen.filter.ChannelChatFilter;
import com.yy.mobile.livebizwrapper.chatscreen.filter.OnepieceXmlFilter;
import com.yy.mobile.livebizwrapper.chatscreen.model.ParserUtil;
import com.yy.mobile.livebizwrapper.chatscreen.model.channelmessage.AssistMessage;
import com.yy.mobile.livebizwrapper.chatscreen.model.channelmessage.BscNoticeMessage;
import com.yy.mobile.livebizwrapper.chatscreen.model.channelmessage.ChannelMsgRecvFilter;
import com.yy.mobile.livebizwrapper.chatscreen.model.channelmessage.FlowerChinneMessage;
import com.yy.mobile.livebizwrapper.chatscreen.model.channelmessage.GiftChannelMessage;
import com.yy.mobile.livebizwrapper.chatscreen.model.channelmessage.HistoryPublicChatMessage;
import com.yy.mobile.livebizwrapper.chatscreen.model.channelmessage.MergeChannelMessage;
import com.yy.mobile.livebizwrapper.chatscreen.model.channelmessage.NewGameReminderMessage;
import com.yy.mobile.livebizwrapper.chatscreen.model.channelmessage.NickClickableSpan;
import com.yy.mobile.livebizwrapper.chatscreen.model.channelmessage.NobleLevelUpgradeChannelMessage;
import com.yy.mobile.livebizwrapper.chatscreen.parser.ChatRoomGiftMessageParse;
import com.yy.mobile.livebizwrapper.chatscreen.parser.NobleEmotionFilter;
import com.yy.mobile.livebizwrapper.chatscreen.parser.NobleEmotionParser;
import com.yy.mobile.livebizwrapper.chatscreen.parser.PublicChatMedalParseManage;
import com.yy.mobile.livebizwrapper.onepiece.OnepieceVipManager;
import com.yy.mobile.livebizwrapper.utils.RichTextUtil;
import com.yy.mobile.richtext.BaseChannelTicketFilter;
import com.yy.mobile.richtext.BaseRichTextFilter;
import com.yy.mobile.richtext.ChannelTicketFilter;
import com.yy.mobile.richtext.NewChannelTextManager;
import com.yy.mobile.richtext.RichTextManager;
import com.yy.mobile.richtext.VipEmoticonFilter;
import com.yy.mobile.richtext.XmlChannelMessage;
import com.yy.mobile.richtext.XmlFilter;
import com.yy.mobile.ui.utils.SingleToastUtil;
import com.yy.mobile.ui.widget.CustomImageSpan;
import com.yy.mobile.util.FP;
import com.yy.mobile.util.ResolutionUtils;
import com.yy.mobile.util.log.MLog;
import com.yymobile.core.CoreFactory;
import com.yymobile.core.channel.ChannelInfo;
import com.yymobile.core.channel.ChannelMessage;
import com.yymobile.core.channel.ChatMedalInfo;
import com.yymobile.core.channel.PublicChatMessage;
import com.yymobile.core.maskedkingbiz.MaskedKingApi;
import com.yymobile.core.medal.MedalBaseEntry;
import com.yymobile.core.medal.MedalNobleEntry;
import com.yymobile.core.medal.MedalTrueLoveEntry;
import com.yymobile.core.mobilelive.IMobileLiveCore;
import com.yymobile.core.user.IUserCore;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public class PublicChatBaseParser
implements IParser {
    private static final String TAG = "PublicChatBaseModel";
    protected Context mContext;
    private PublicChatMedalParseManage mMedalParseManage;
    protected NewChannelTextManager newChannelTextManager = new NewChannelTextManager();
    protected List<RichTextManager.Feature> features = new CopyOnWriteArrayList<RichTextManager.Feature>();
    private ChannelMsgRecvFilter mChannelMsgRecvFilter = new ChannelMsgRecvFilter();
    protected int mGiftMessageImageSize;
    private long topMicId = 0L;
    public BaseRichTextFilter.OnSpanClickListener airSpanClickListener = new BaseRichTextFilter.OnSpanClickListener(){

        public void onClick(View view, Object what) {
            if (what instanceof BaseChannelTicketFilter.ChannelTicketClickSpan) {
                BaseChannelTicketFilter.ChannelTicketClickSpan clickableSpan = (BaseChannelTicketFilter.ChannelTicketClickSpan)what;
                long topSid = clickableSpan.getTopSid();
                long subSid = clickableSpan.getSubSid();
                PublicChatBaseParser.this.onSpanClick(topSid, subSid);
            }
        }
    };

    public PublicChatBaseParser() {
        this.features.add(RichTextManager.Feature.CHANNELAIRTICKET);
        this.features.add(RichTextManager.Feature.EMOTICON);
        this.features.add(RichTextManager.Feature.GROUPTICKET);
        this.features.add(RichTextManager.Feature.NOBLEEMOTION);
        this.features.add(RichTextManager.Feature.NOBLEGIFEMOTION);
        this.mMedalParseManage = new PublicChatMedalParseManage(){

            @Override
            protected Spannable onPreCommonModeParse(Spannable spannable, ChannelMessage message, MedalBaseEntry entity) {
                return PublicChatBaseParser.this.doCommonModeParse(spannable, message, entity);
            }
        };
        this.mMedalParseManage.initModelType();
        this.topMicId = ChannelApi.Factory.get().getCurrentTopMicId();
    }

    public void onDestroy() {
        if (this.mMedalParseManage != null) {
            this.mMedalParseManage.onDestroy();
        }
    }

    public boolean parse(@NotNull ChannelMessage message) {
        String chatEmotionUri;
        message.text = message.text.trim();
        if (XmlFilter.checkValid((String)message.text)) {
            message = this.doXmlParse(message);
        } else if (message instanceof PublicChatMessage || ChannelTicketFilter.isChannelTicketMessage((CharSequence)message.text)) {
            message.pureText = message.text;
        }
        if (message instanceof PublicChatMessage) {
            message.pureText = message.text = ParserUtil.fixXmlString(message.text);
            if (TextUtils.isEmpty((CharSequence)message.text)) {
                MLog.info((String)TAG, (String)"filter empty message");
                return false;
            }
        }
        if (OnepieceVipManager.getInstance().checkIsVip(message.uid) != null) {
            if (message.commonMedals == null) {
                message.commonMedals = new ArrayList();
            }
            message.commonMedals.add(OnepieceVipManager.getInstance().checkIsVip(message.uid));
        }
        if (message.channelMessageType.equals((Object)ChannelMessage.ChannelMsgType.TURNTABLE_MESSAGE_TYPE)) {
            MLog.info((String)TAG, (String)"filter turntable message");
            return false;
        }
        if (!(ParserUtil.isNormalEnter(message) || message instanceof MergeChannelMessage || message.isEndorsementGroup || message instanceof BscNoticeMessage || message instanceof AssistMessage || this.topMicId == message.uid || !this.isNeedFilterMessage(message))) {
            MLog.info((String)TAG, (String)"filter message");
            return false;
        }
        String emotionStr = NobleEmotionParser.getInstance().getNobleEmotionStr(message.text);
        if (!FP.empty((CharSequence)emotionStr) && !FP.empty((CharSequence)(chatEmotionUri = NobleEmotionParser.getInstance().getChatEmotionUri(emotionStr)))) {
            message.gifUri = chatEmotionUri;
            message.channelMessageType = ChannelMessage.ChannelMsgType.NOBLEEMOTION_MESSAGE_TYPE;
        }
        message.text = VipEmoticonFilter.replaceVipEmoticonWithGivenStr((String)message.text, (String)"[\u4f1a\u5458\u8868\u60c5]");
        if (LoginUtil.isLogined() && message.uid == LoginUtil.getUid() && CoreFactory.getCore(IUserCore.class) != null && ((IUserCore)CoreFactory.getCore(IUserCore.class)).getCacheLoginUserInfo() != null) {
            message.nickname = ((IUserCore)CoreFactory.getCore(IUserCore.class)).getCacheLoginUserInfo().nickName;
        }
        this.appendMsgByType(message);
        return true;
    }

    private ChannelMessage appendMsgByType(ChannelMessage message) {
        if (message.channelMessageType.equals((Object)ChannelMessage.ChannelMsgType.CUSTOMS_MESSAGE_TYPE)) {
            return message;
        }
        if (message instanceof NewGameReminderMessage) {
            ((NewGameReminderMessage)message).build();
            return message;
        }
        if (message instanceof BscNoticeMessage || message instanceof AssistMessage) {
            return message;
        }
        Object spannable = null;
        if (message.medalEntryList.isEmpty()) {
            PublicMessageHelper.forceToPenetrateInfoEntry(message);
        }
        String body = message.text;
        boolean isMatch = false;
        MLog.debug((Object)TAG, (String)"#appendMsgByType isMatch = %s", (Object[])new Object[]{isMatch});
        if (!isMatch) {
            message.identity = "";
        }
        if (message instanceof GiftChannelMessage && this.isEntChatRoom()) {
            ChatRoomGiftMessageParse.INSTANCE.replaceGiftMessageText((GiftChannelMessage)message);
        }
        message.text = message.getFormatNick() + " " + message.text;
        int contentStart = message.medals.length() + message.nickname.length() + message.tail.length();
        if (message instanceof GiftChannelMessage) {
            this.parseLoadedGiftMessage(this.mContext, (GiftChannelMessage)message, message.nickname, contentStart);
        } else if (message instanceof NobleLevelUpgradeChannelMessage || message.channelMessageType.equals((Object)ChannelMessage.ChannelMsgType.TURE_LOVE_TYPE) || message.channelMessageType.equals((Object)ChannelMessage.ChannelMsgType.SUBSCRIBE_MESSAGE_TYPE) || message.channelMessageType.equals((Object)ChannelMessage.ChannelMsgType.SHARE_MESSAGE_TYPE) || message instanceof FlowerChinneMessage || message.channelMessageType.equals((Object)ChannelMessage.ChannelMsgType.NOBLEEMOTION_MESSAGE_TYPE)) {
            if (message instanceof FlowerChinneMessage) {
                spannable = this.onAppendFlowerChinneMessage(this.mContext, (FlowerChinneMessage)message);
                contentStart = 0;
            } else if (message.channelMessageType.equals((Object)ChannelMessage.ChannelMsgType.NOBLEEMOTION_MESSAGE_TYPE)) {
                HashMap entryMap = (HashMap)message.medalEntryList.get(100);
                if (entryMap != null) {
                    MedalNobleEntry entry = (MedalNobleEntry)entryMap.get(1);
                    spannable = entry.getNobleLevel() > 0 || entry.getActNobleType() > 0 ? this.newChannelTextManager.getSpannableString(this.mContext, (CharSequence)message.text, this.features) : new SpannableStringBuilder((CharSequence)message.text);
                }
            } else {
                spannable = new SpannableStringBuilder((CharSequence)message.text);
            }
            if (spannable != null && contentStart < message.text.length() && message.text.length() <= spannable.length()) {
                spannable.setSpan((Object)new ForegroundColorSpan(this.getColorByChannelMessage(message)), contentStart, message.text.length(), 33);
            }
        } else if (message.channelMessageType.equals((Object)ChannelMessage.ChannelMsgType.TURNCHAIR_MESSAGE_TYPE) || message.channelMessageType.equals((Object)ChannelMessage.ChannelMsgType.NOTICE_MESSAGE_TYPE)) {
            spannable = message.spannable;
        } else {
            if (!TextUtils.isEmpty((CharSequence)body)) {
                spannable = this.newChannelTextManager.getSpannableString(this.mContext, (CharSequence)body, this.features);
                spannable = new SpannableStringBuilder((CharSequence)message.getFormatNick()).append((CharSequence)" ").append((CharSequence)spannable);
            }
            spannable = this.handleMaskKingMsgIfNeeded(message, (Spannable)spannable);
            spannable = this.handleChatRoomMsgIfNeeded(message, (Spannable)spannable);
        }
        if (spannable != null) {
            message.spannable = this.parseMessageHeader(message, (Spannable)spannable);
        }
        return message;
    }

    @NotNull
    private Spannable handleMaskKingMsgIfNeeded(ChannelMessage message, Spannable spannable) {
        if (!this.isMaskingOtherChannelMsg(message)) {
            return spannable;
        }
        String content = "(\u975e\u672c\u76f4\u64ad\u95f4)";
        SpannableString otherChannelMsg = new SpannableString((CharSequence)content);
        otherChannelMsg.setSpan((Object)new ForegroundColorSpan(Color.parseColor((String)"#9affffff")), 0, content.length(), 33);
        otherChannelMsg.setSpan((Object)new AbsoluteSizeSpan(10, true), 0, content.length(), 33);
        spannable = new SpannableStringBuilder((CharSequence)spannable).append((CharSequence)"  ").append((CharSequence)otherChannelMsg);
        return spannable;
    }

    private boolean isMaskingOtherChannelMsg(ChannelMessage message) {
        long curTopSid = ChannelApi.Factory.get().getCurrentChannelInfo().topSid;
        return MaskedKingApi.getInstance().isMaskedKing() && message.sid != 0L && curTopSid != 0L && message.sid != curTopSid && !(message instanceof HistoryPublicChatMessage);
    }

    private boolean isEntChatRoomOtherChannelMsg(ChannelMessage message) {
        ChannelInfo info = ChannelApi.Factory.get().getCurrentChannelInfo();
        return ChatRoomApi.getInstance().isEntChatRoom(info.topSid, info.subSid, false) && message.sid != 0L && info.topSid != 0L && message.sid != info.topSid && message.sid != info.subSid && message.sid != info.topASid && !(message instanceof HistoryPublicChatMessage);
    }

    private boolean isEntChatRoom() {
        ChannelInfo info = ChannelApi.Factory.get().getCurrentChannelInfo();
        boolean isChatRoom = ChatRoomApi.getInstance().isEntChatRoom(info.topSid, info.subSid);
        MLog.debug((String)TAG, (String)("isCHatRoom:" + isChatRoom + "," + info.topSid + "," + info.subSid));
        return isChatRoom;
    }

    @NotNull
    private Spannable handleChatRoomMsgIfNeeded(ChannelMessage message, Spannable spannable) {
        if (!this.isEntChatRoomOtherChannelMsg(message)) {
            return spannable;
        }
        String content = "\u975e\u672c\u9891";
        SpannableString otherChannelMsg = new SpannableString((CharSequence)content);
        otherChannelMsg.setSpan((Object)new ForegroundColorSpan(Color.parseColor((String)"#9affffff")), 0, content.length(), 33);
        otherChannelMsg.setSpan((Object)new AbsoluteSizeSpan(10, true), 0, content.length(), 33);
        spannable = new SpannableStringBuilder((CharSequence)spannable).append((CharSequence)"  ").append((CharSequence)otherChannelMsg);
        return spannable;
    }

    public void onSpanClick(long topSid, long subSid) {
        MLog.info((String)TAG, (String)("onSpanClick : topSid=" + topSid + " ,subSid=" + subSid));
        if (subSid > 0L ? subSid == ChannelApi.Factory.get().getCurrentChannelInfo().subSid : topSid == ChannelApi.Factory.get().getCurrentChannelInfo().topSid && subSid == ChannelApi.Factory.get().getCurrentChannelInfo().subSid) {
            return;
        }
        if (((ILianMaiCore)CoreFactory.getCore(ILianMaiCore.class)).isOneToOneLianMai() && ChannelApi.Factory.get().getCurrentTopMicId() == LoginUtil.getUid()) {
            SingleToastUtil.showToast((String)"\u4f60\u76ee\u524d\u4e00\u5bf9\u4e00\u8d34\u5fc3\u966a\u4f34\u4e2d\uff0c\u4e0d\u80fd\u53bb\u522b\u7684\u76f4\u64ad\u95f4\u5f53\u89c2\u4f17\u54e6");
            return;
        }
        if (((IMobileLiveCore)CoreFactory.getCore(IMobileLiveCore.class)).isLoginUserMobileLive() && ChannelApi.Factory.get().getCurrentTopMicId() == LoginUtil.getUid()) {
            SingleToastUtil.showToast((String)"\u4f60\u76ee\u524d\u6b63\u5728\u76f4\u64ad\u4e2d\uff0c\u4e0d\u80fd\u53bb\u522b\u7684\u76f4\u64ad\u95f4\u5f53\u89c2\u4f17\u54e6");
            return;
        }
        RxBus.getDefault().post((Object)new AirTicketClickEvent(topSid, subSid));
    }

    public void initModel(Context context) {
        this.mContext = context;
        this.mGiftMessageImageSize = (int)ResolutionUtils.convertDpToPixel((float)20.0f, (Context)BasicConfig.getInstance().getAppContext());
        this.newChannelTextManager.init();
        this.newChannelTextManager.addGifFilterFeature((BaseRichTextFilter)new NobleEmotionFilter());
        this.newChannelTextManager.setSpanClickListener(RichTextManager.Feature.CHANNELAIRTICKET, this.airSpanClickListener);
    }

    public void deInitModel() {
        this.newChannelTextManager.dispose();
        this.features.clear();
    }

    protected SpannableStringBuilder onAppendFlowerChinneMessage(Context context, FlowerChinneMessage msg) {
        if (context == null) {
            return null;
        }
        int res = R.drawable.icon_xiao_hua;
        HashMap trueloveMap = (HashMap)msg.medalEntryList.get(200);
        if (trueloveMap != null && trueloveMap.get(2) != null && trueloveMap.get(2) instanceof MedalTrueLoveEntry) {
            MedalTrueLoveEntry entry = (MedalTrueLoveEntry)trueloveMap.get(2);
            if (entry.isTrueLoveLv) {
                res = R.drawable.icon_xiao_hua_rose;
            }
        }
        SpannableStringBuilder sp = new SpannableStringBuilder((CharSequence)msg.text);
        Pattern p = Pattern.compile("REPLACE_IMGE_FLAG");
        Matcher m = p.matcher(msg.text);
        while (m.find()) {
            if (msg.nickname.contains("REPLACE_IMGE_FLAG")) continue;
            BitmapDrawable bd = ImageUtil.getBitmapDrawableFromResource((int)this.mGiftMessageImageSize, (int)this.mGiftMessageImageSize, (int)res);
            bd.setBounds(0, 0, this.mGiftMessageImageSize, this.mGiftMessageImageSize);
            if (m.start() >= m.end() || m.end() > sp.length()) continue;
            CustomImageSpan imageSpan = new CustomImageSpan((Drawable)bd, 2.0f);
            sp.setSpan((Object)imageSpan, m.start(), m.end(), 33);
        }
        return sp;
    }

    protected Spannable parseMessageHeader(ChannelMessage message, Spannable spannable) {
        spannable = this.parseMessageHeaderIcon(message, spannable);
        spannable = this.nicknameClick(message, spannable);
        return spannable;
    }

    public Spannable parseMessageHeaderIcon(ChannelMessage message, Spannable spannable) {
        if (message == null || spannable == null || this.mContext == null || this.mMedalParseManage == null) {
            return spannable;
        }
        return this.mMedalParseManage.parseSpannable(this.mContext, message, spannable);
    }

    private Spannable doCommonModeParse(Spannable spannable, ChannelMessage message, MedalBaseEntry entity) {
        try {
            boolean isReplace;
            if (null != entity && !FP.empty((CharSequence)entity.getNote()) && (isReplace = ChannelApi.Factory.get().getSubscribedMutiChannelSSidList().contains(message.sid))) {
                int endIdx;
                boolean isSafeRange;
                int startIdx = spannable.toString().indexOf(entity.getNote());
                boolean bl = isSafeRange = startIdx < (endIdx = startIdx + entity.getNote().length()) && endIdx <= spannable.length();
                if (isSafeRange && startIdx > -1) {
                    if (spannable instanceof SpannableStringBuilder) {
                        ((SpannableStringBuilder)spannable).replace(startIdx, endIdx, (CharSequence)"");
                    }
                    boolean bl2 = isSafeRange = (startIdx = message.medals.indexOf(entity.getNote())) < (endIdx = startIdx + entity.getNote().length()) && endIdx <= message.medals.length();
                    if (isSafeRange && startIdx > -1) {
                        message.medals.replace(startIdx, endIdx, "");
                    }
                    message.text = message.text.replace(entity.getNote(), "");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            MLog.info((String)TAG, (String)("doCommonModeParse error :" + e.getMessage()));
        }
        return spannable;
    }

    public Spannable nicknameClick(ChannelMessage message, Spannable spannable) {
        if (message == null || spannable == null || this.mContext == null) {
            return null;
        }
        if (message.nickname.length() > 0) {
            int nickSpanColor = this.getNickColor();
            if (this.isGameType()) {
                if (!(message instanceof GiftChannelMessage) && message.channelMessageType.equals((Object)ChannelMessage.ChannelMsgType.COMMON_MESSAGE_TYPE)) {
                    nickSpanColor = Color.parseColor((String)"#999999");
                }
            } else if (message instanceof GiftChannelMessage) {
                nickSpanColor = ((GiftChannelMessage)message).nickSpanColor;
            }
            int start = spannable.toString().indexOf(message.nickname);
            int end = start + message.nickname.length();
            if (start >= 0 && end <= spannable.toString().length()) {
                spannable.setSpan((Object)new ForegroundColorSpan(nickSpanColor), start, end, 33);
            } else {
                MLog.info((String)TAG, (String)("Message sp value = " + spannable.toString()));
            }
            boolean isMatch = false;
            boolean isEndorsementGroup = message.isEndorsementGroup;
            MLog.debug((Object)TAG, (String)"#nicknameClick isMatch = %s, isEndorsementGroup = %s", (Object[])new Object[]{isMatch, isEndorsementGroup});
            NickClickableSpan nickClickableSpan = new NickClickableSpan(true, message.uid, (String)message.tailMap.get("hdid"), nickSpanColor, this.isOtherChannelMessage(message.sid));
            if (start >= 0 && end <= spannable.toString().length()) {
                spannable.setSpan((Object)nickClickableSpan, start, end, 33);
            }
        }
        return spannable;
    }

    public void parseLoadedGiftMessage(Context context, final GiftChannelMessage message, String nick, final int contentStart) {
        if (context == null) {
            return;
        }
        final String giftIconUrl = PublicMessageHelper.getGiftIconPathFromGiftConfigParser(message.giftTypeId);
        if (!FP.empty((CharSequence)giftIconUrl)) {
            BitmapDrawable drawable2 = ImageLoader.getBitmapFromCache((String)giftIconUrl, (ImageConfig)ImageConfig.smallImageConfig());
            final String name = nick;
            if (drawable2 != null) {
                this.parseGiftMessage(message, contentStart, name);
            } else {
                final Resources resources = BasicConfig.getInstance().getAppContext().getResources();
                this.parseGiftMessage(message, contentStart, name);
                ImageLoader.loadBitmap((Context)BasicConfig.getInstance().getAppContext(), (String)giftIconUrl, (ImageLoader.BitmapLoadListener)new ImageLoader.BitmapLoadListener(){

                    public void onLoadFailed(Exception e) {
                    }

                    public void onResourceReady(Bitmap bitmap) {
                        if (bitmap != null) {
                            ImageLoader.addBitmapToCache((String)giftIconUrl, (BitmapDrawable)new BitmapDrawable(resources, bitmap), (ImageConfig)ImageConfig.smallImageConfig());
                            PublicChatBaseParser.this.parseGiftMessage(message, contentStart, name);
                        }
                    }
                });
            }
        } else {
            this.parseGiftMessage(message, contentStart, nick);
        }
    }

    protected void parseGiftMessage(GiftChannelMessage message, int contentStart1, String name) {
        int idx;
        int zu;
        int x;
        if (message == null || this.mContext == null) {
            return;
        }
        SpannableStringBuilder sp = message.getSpannableString(this.mContext, R.drawable.lr_ic_default_gift, R.drawable.xunzhang_default_bitmap, this.mGiftMessageImageSize, this.mGiftMessageImageSize);
        if (sp == null) {
            return;
        }
        if (message.type == GiftChannelMessage.GiftType.ComboGift && (x = message.text.lastIndexOf("X")) + 1 < (zu = message.text.lastIndexOf("\u7ec4")) && zu <= sp.length()) {
            sp.setSpan((Object)new AbsoluteSizeSpan(19, true), x + 1, zu, 33);
        }
        try {
            message.nickSpanColor = this.getNickColor();
            if (!FP.empty(message.additional) && message.additional.containsKey("client_show_style_tag") && message.additional.get("client_show_style_tag").equals("1")) {
                int contentStart = (TextUtils.isEmpty((CharSequence)message.medals) ? 0 : message.medals.length()) + (TextUtils.isEmpty((CharSequence)message.nickname) ? 0 : message.nickname.length()) + (TextUtils.isEmpty((CharSequence)message.tail) ? 0 : message.tail.length());
                int index = contentStart + 3;
                sp.setSpan((Object)new ForegroundColorSpan(this.getGiftColor()), contentStart, TextUtils.isEmpty((CharSequence)message.text) ? 0 : message.text.length(), 33);
                sp.setSpan((Object)new ForegroundColorSpan(this.isGameType() ? this.getGiftColor() : this.getNickColor()), index, index + (TextUtils.isEmpty((CharSequence)message.toName) ? 0 : message.toName.length()), 33);
            } else if (!FP.empty(message.additional) && !FP.empty((CharSequence)message.additional.get("gift_template_type"))) {
                String type = message.additional.get("gift_template_type");
                String color2 = "#f1ad43";
                if ("7".equals(type)) {
                    color2 = "#57cc6a";
                    message.nickSpanColor = -11023254;
                } else if ("6".equals(type)) {
                    color2 = "#f1ad43";
                    message.nickSpanColor = -938685;
                }
                sp.setSpan((Object)new ForegroundColorSpan(Color.parseColor((String)color2)), 0, TextUtils.isEmpty((CharSequence)message.text) ? 0 : message.text.length(), 33);
            } else {
                int endLength;
                int start = (TextUtils.isEmpty((CharSequence)message.medals) ? 0 : message.medals.length()) + (TextUtils.isEmpty((CharSequence)message.nickname) ? 0 : message.nickname.length());
                int n = endLength = TextUtils.isEmpty((CharSequence)message.text) ? 0 : message.text.length();
                if (start > endLength) {
                    start = endLength;
                }
                sp.setSpan((Object)new ForegroundColorSpan(this.getGiftColor()), start, endLength, 33);
            }
        }
        catch (Throwable throwable) {
            MLog.error((Object)TAG, (Throwable)throwable);
        }
        message.spannable = this.parseMessageHeader(message, (Spannable)sp);
        if (message.additional != null && message.additional.containsKey("client_biz_type") && message.additional.get("client_biz_type").equals("neighbor") && (idx = message.spannable.toString().indexOf("\u901a\u8fc7\u53cb\u90bb")) >= 0) {
            message.spannable.setSpan((Object)new ForegroundColorSpan(Color.parseColor((String)"#FF0000")), idx, idx + 4, 33);
        }
    }

    protected ChannelInfo getCurrentChannelInfo() {
        return ChannelApi.Factory.get().getCurrentChannelInfo();
    }

    protected boolean isGameType() {
        return false;
    }

    protected int getNickColor() {
        return Color.parseColor((String)ChannelMessage.nickColor);
    }

    protected int getGiftColor() {
        return Color.parseColor((String)ChannelMessage.giftTxtColor);
    }

    protected boolean isNeedFilterMessage(ChannelMessage message) {
        return ChannelChatFilter.filter(message, this.mChannelMsgRecvFilter);
    }

    private int getColorByChannelMessage(ChannelMessage message) {
        if (message instanceof NobleLevelUpgradeChannelMessage || message.channelMessageType.equals((Object)ChannelMessage.ChannelMsgType.TURE_LOVE_TYPE)) {
            return Color.parseColor((String)ChannelMessage.giftTxtColor);
        }
        if (message.channelMessageType.equals((Object)ChannelMessage.ChannelMsgType.SUBSCRIBE_MESSAGE_TYPE) || message.channelMessageType.equals((Object)ChannelMessage.ChannelMsgType.SHARE_MESSAGE_TYPE) || message instanceof FlowerChinneMessage) {
            return this.getNickColor();
        }
        return 0;
    }

    private ChannelMessage doXmlParse(ChannelMessage message) {
        String filterText;
        String tempXmlStr = message.text;
        XmlChannelMessage xmlChannelMessage = OnepieceXmlFilter.parseOnepieceChannelMessage(message.text);
        message.text = xmlChannelMessage.text;
        if (message instanceof PublicChatMessage || ChannelTicketFilter.isChannelTicketMessage((CharSequence)message.text)) {
            message.pureText = xmlChannelMessage.text;
        }
        if (!TextUtils.isEmpty((CharSequence)(filterText = RichTextUtil.filterEmotion(message.text)))) {
            message.text = filterText;
        }
        if (!FP.empty((CharSequence)xmlChannelMessage.actMedalUrl)) {
            xmlChannelMessage.tailUid = message.uid;
        }
        PublicMessageHelper.parserPenetrateInfoV4(message, xmlChannelMessage, tempXmlStr);
        List commonMedals = xmlChannelMessage.commonMedals;
        if (commonMedals != null) {
            message.commonMedals = new ArrayList();
            for (Map map : commonMedals) {
                ChatMedalInfo info = new ChatMedalInfo(map);
                message.commonMedals.add(info);
            }
        }
        return message;
    }

    protected boolean isOtherChannelMessage(long sid) {
        return ChannelApi.Factory.get().getSubscribedMutiChannelSSidList().contains(sid);
    }

    public void decorateNickNameBeforeParse(ChannelMessage message) {
    }
}

