/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.livebizwrapper.chatscreen.parser;

import android.content.Context;
import android.graphics.Bitmap;
import android.text.TextUtils;
import com.yy.mobile.config.BasicConfig;
import com.yy.mobile.http.ProgressInfo;
import com.yy.mobile.http.ProgressListener;
import com.yy.mobile.http.RequestError;
import com.yy.mobile.http.RequestManager;
import com.yy.mobile.http.ResponseErrorListener;
import com.yy.mobile.http.ResponseListener;
import com.yy.mobile.image.ImageConfig;
import com.yy.mobile.imageloader.ImageLoader;
import com.yy.mobile.livebizwrapper.chatscreen.parser.ChatEmotion;
import com.yy.mobile.livebizwrapper.chatscreen.parser.EmotionSendFrequency;
import com.yy.mobile.util.FP;
import com.yy.mobile.util.YYFileUtils;
import com.yy.mobile.util.log.MLog;
import com.yy.mobile.util.pref.CommonPref;
import com.yy.mobile.util.taskexecutor.YYTaskExecutor;
import com.yymobile.core.noble.EntIdentity;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class NobleEmotionParser {
    private static final String TAG = "NobleEmotionParser";
    private static NobleEmotionParser nep;
    private List<ChatEmotion> chatEmotions = Collections.synchronizedList(new ArrayList());
    private List<EmotionSendFrequency> chatEmotionSend = Collections.synchronizedList(new ArrayList());
    private Map<String, String> emotionMap = Collections.synchronizedMap(new HashMap());
    private ImageConfig imageConfig;
    private volatile boolean parsingXml = false;
    private Map<String, Bitmap> nobleEmotionBitmaps = new HashMap<String, Bitmap>();

    private NobleEmotionParser() {
        YYTaskExecutor.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                String chatEmotionPropsUrl = CommonPref.instance().get("chatEmotionProps");
                if (!TextUtils.isEmpty((CharSequence)chatEmotionPropsUrl)) {
                    NobleEmotionParser.this.parseChatEmotionConfig(chatEmotionPropsUrl);
                }
            }
        }, (long)0L);
        this.imageConfig = new ImageConfig(ImageConfig.ImagePrecision.Big.getWidth(), ImageConfig.ImagePrecision.Big.getHeight());
    }

    public static synchronized NobleEmotionParser getInstance() {
        if (nep == null) {
            nep = new NobleEmotionParser();
        }
        return nep;
    }

    public void checkNobleChatEmotionConfig(final String configUrl) {
        if (FP.empty((CharSequence)configUrl)) {
            return;
        }
        MLog.info((String)TAG, (String)("[checkNobleChatEmotionConfig] configUrl=" + configUrl));
        String filePath = this.getChatEmotionConfigFilePath(configUrl);
        this.delIfFileInvalid(filePath);
        if (!YYFileUtils.isFileExisted((String)filePath)) {
            MLog.info((String)TAG, (String)("[checkNobleChatEmotionConfig], download nobleChatEmotionConfig configUrl = " + configUrl + ", save to " + filePath));
            this.downloadNobleEmotion(configUrl, filePath);
        } else if (!configUrl.equalsIgnoreCase(CommonPref.instance().get("chatEmotionProps"))) {
            this.downloadNobleEmotion(configUrl, filePath);
        } else {
            YYTaskExecutor.execute((Runnable)new Runnable(){

                @Override
                public void run() {
                    NobleEmotionParser.this.parseChatEmotionConfig(configUrl);
                }
            }, (long)0L);
        }
        CommonPref.instance().put("chatEmotionProps", configUrl);
    }

    public List<ChatEmotion> getChatEmotions() {
        if (this.chatEmotions != null && this.chatEmotions.size() > 0) {
            return this.chatEmotions;
        }
        return null;
    }

    public void downloadGifToNative() {
        List<ChatEmotion> chatEmotions = this.getChatEmotions();
        if (chatEmotions != null && chatEmotions.size() > 0) {
            for (ChatEmotion chatEmotion : chatEmotions) {
                String gifUrl = chatEmotion.getUrlPngMob();
                String gifFilePath = this.getChatEmotionConfigFilePath(gifUrl);
                if (MLog.isLogLevelAboveDebug()) {
                    MLog.debug((Object)this, (String)("[downloadGifToNative],gifUrl==%s,gifFilePath==&s" + gifUrl + gifFilePath), (Object[])new Object[0]);
                }
                if (YYFileUtils.isFileExisted((String)gifFilePath)) continue;
                RequestManager.instance().submitDownloadRequest(gifUrl, gifFilePath, new ResponseListener(){

                    public void onResponse(Object response) {
                    }
                }, new ResponseErrorListener(){

                    public void onErrorResponse(RequestError error) {
                        MLog.error((String)NobleEmotionParser.TAG, (String)("[downloadGifToNative], onErrorResponse: " + error.toString()));
                    }
                }, new ProgressListener(){

                    public void onProgress(ProgressInfo info) {
                    }
                });
            }
        }
    }

    public String getChatEmotionUri(String key) {
        if (this.emotionMap != null && key != null) {
            return this.emotionMap.get(key);
        }
        return null;
    }

    public String getNobleEmotionStr(String chatTxt) {
        String validEmotionStr = "";
        Matcher matcher = Pattern.compile("#\\d{2}").matcher(chatTxt);
        while (matcher.find()) {
            ChatEmotion chatEmotion = this.getNobleEmotion(this.chatEmotions, matcher.group());
            if (null == chatEmotion) continue;
            validEmotionStr = matcher.group();
            break;
        }
        return validEmotionStr;
    }

    private ChatEmotion getNobleEmotion(List<ChatEmotion> chatEmotions, String shortCut) {
        if (chatEmotions != null && chatEmotions.size() > 0 && shortCut != null) {
            for (ChatEmotion chatEmotion : chatEmotions) {
                if (!shortCut.equalsIgnoreCase(chatEmotion.getShortcut())) continue;
                return chatEmotion;
            }
        }
        return null;
    }

    private String getChatEmotionConfigFilePath(String url) {
        String fileName = url;
        int index = url.lastIndexOf(File.separatorChar);
        if (index != -1) {
            fileName = url.substring(index + 1);
        }
        String filePath = BasicConfig.getInstance().getConfigDir().getAbsolutePath() + File.separator + fileName;
        if (MLog.isLogLevelAboveDebug()) {
            MLog.debug((String)TAG, (String)("[getChatEmotionConfigFilePath], filePath = " + filePath));
        }
        return filePath;
    }

    private boolean delIfFileInvalid(String path) {
        if (FP.empty((CharSequence)path)) {
            return false;
        }
        File file = new File(path);
        long len = file.length();
        if (len > 1000L) {
            if (MLog.isLogLevelAboveDebug()) {
                MLog.debug((String)TAG, (String)("[delIfFileInvalid], file valid, length = " + len + " byte"));
            }
            return true;
        }
        if (file.exists()) {
            file.delete();
            MLog.error((String)TAG, (String)("[delIfFileInvalid], file inValid, length = " + len + " byte, delete it!"));
        }
        return false;
    }

    private void downloadNobleEmotion(final String url, String filePath) {
        RequestManager.instance().submitDownloadRequest(url, filePath, new ResponseListener(){

            public void onResponse(Object response) {
                NobleEmotionParser.this.parseChatEmotionConfig(url);
                NobleEmotionParser.this.downloadGifToNative();
            }
        }, new ResponseErrorListener(){

            public void onErrorResponse(RequestError error) {
                MLog.error((String)NobleEmotionParser.TAG, (String)("[checkNobleChatEmotionConfig], onErrorResponse: " + error.toString()));
            }
        }, new ProgressListener(){

            public void onProgress(ProgressInfo info) {
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseChatEmotionConfig(String url) {
        if (this.parsingXml) {
            return;
        }
        this.parsingXml = true;
        String fileName = this.getChatEmotionConfigFilePath(url);
        this.emotionMap.clear();
        this.chatEmotions.clear();
        MLog.info((String)TAG, (String)("parseChatEmotionConfig....fileName...." + fileName));
        File inputStream = null;
        try {
            inputStream = new File(fileName);
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(inputStream);
            Element root = document.getDocumentElement();
            this.parse(root);
        }
        catch (Exception e) {
            MLog.error((String)TAG, (String)("parseChatEmotionConfig error=" + e));
        }
        finally {
            this.parsingXml = false;
        }
    }

    private void parse(Element element) {
        NodeList personNodes = element.getElementsByTagName("faces");
        if (personNodes == null) {
            return;
        }
        if (personNodes.getLength() <= 0) {
            return;
        }
        for (int i = 0; i < personNodes.getLength(); ++i) {
            Element personElement = (Element)personNodes.item(i);
            NodeList personChilds = personElement.getChildNodes();
            for (int j = 0; j < personChilds.getLength(); ++j) {
                Element childElement;
                if (personChilds.item(j).getNodeType() != 1 || !(childElement = (Element)personChilds.item(j)).getNodeName().equalsIgnoreCase("face")) continue;
                final ChatEmotion chatEmotion = new ChatEmotion();
                NodeList otherChilds = childElement.getChildNodes();
                for (int m = 0; m < otherChilds.getLength(); ++m) {
                    if (otherChilds.item(m).getNodeType() != 1) continue;
                    Element childElement2 = (Element)otherChilds.item(m);
                    if (childElement2.getNodeName().equals("id")) {
                        String id2 = childElement2.getFirstChild().getNodeValue();
                        chatEmotion.setId(id2);
                        if (!MLog.isLogLevelAboveDebug()) continue;
                        MLog.debug((String)TAG, (String)("[parse],id = " + id2));
                        continue;
                    }
                    if (childElement2.getNodeName().equals("name")) {
                        String name = childElement2.getFirstChild().getNodeValue();
                        chatEmotion.setName(name);
                        if (!MLog.isLogLevelAboveDebug()) continue;
                        MLog.debug((String)TAG, (String)("[parse],name =" + name));
                        continue;
                    }
                    if (childElement2.getNodeName().equals("shortcut")) {
                        String shortcut = childElement2.getFirstChild().getNodeValue();
                        chatEmotion.setShortcut(shortcut);
                        if (!MLog.isLogLevelAboveDebug()) continue;
                        MLog.debug((String)TAG, (String)("[parse],shortcut = " + shortcut));
                        continue;
                    }
                    if (childElement2.getNodeName().equals("url_png_mob")) {
                        String urlPngMob = childElement2.getFirstChild().getNodeValue();
                        chatEmotion.setUrlPngMob(urlPngMob);
                        if (!MLog.isLogLevelAboveDebug()) continue;
                        MLog.debug((String)TAG, (String)("[parse],url_png_mob = " + urlPngMob));
                        continue;
                    }
                    if (!childElement2.getNodeName().equals("url_gif_mob")) continue;
                    String urlGifMob = childElement2.getFirstChild().getNodeValue();
                    chatEmotion.setUrlGifMob(urlGifMob);
                    if (!MLog.isLogLevelAboveDebug()) continue;
                    MLog.debug((String)TAG, (String)("[parse],url_gif_mob = " + urlGifMob));
                }
                this.chatEmotions.add(chatEmotion);
                this.emotionMap.put(chatEmotion.getShortcut(), chatEmotion.getUrlGifMob());
                if (this.nobleEmotionBitmaps.get(chatEmotion.getUrlPngMob()) != null) continue;
                ImageLoader.loadBitmap((Context)BasicConfig.getInstance().getAppContext(), (String)chatEmotion.getUrlPngMob(), (ImageLoader.BitmapLoadListener)new ImageLoader.BitmapLoadListener(){

                    public void onLoadFailed(Exception e) {
                        MLog.info((String)NobleEmotionParser.TAG, (String)"NOBLE EMOTION DOWNLOAD ERROR!");
                    }

                    public void onResourceReady(Bitmap bitmap) {
                        NobleEmotionParser.this.nobleEmotionBitmaps.put(chatEmotion.getUrlPngMob(), bitmap);
                    }
                });
            }
            if (!MLog.isLogLevelAboveDebug()) continue;
            MLog.debug((String)TAG, (String)("[parse]***chatEmotions size=***" + this.chatEmotions.size() + "" + this.chatEmotions));
        }
    }

    public List<EmotionSendFrequency> getChatEmotionSend() {
        if (this.chatEmotionSend != null && this.chatEmotionSend.size() > 0) {
            return this.chatEmotionSend;
        }
        return null;
    }

    public String getSendFrequency() {
        List<EmotionSendFrequency> nobleSend;
        long nobleLevel = EntIdentity.currentNobleGrowthInfo.honourLevel;
        if (MLog.isLogLevelAboveDebug()) {
            MLog.debug((String)TAG, (String)("[getSendFrequency()],nobleLevel:" + nobleLevel));
        }
        if ((nobleSend = NobleEmotionParser.getInstance().getChatEmotionSend()) != null && nobleSend.size() > 0) {
            for (EmotionSendFrequency emotionSendFrequency : nobleSend) {
                if (nobleLevel != Long.valueOf(emotionSendFrequency.getLevel())) continue;
                return emotionSendFrequency.getSec();
            }
        }
        return null;
    }

    public Bitmap getNobleBitmapFromCache(String url) {
        return this.nobleEmotionBitmaps.get(url);
    }

    public void saveNobleEmotionBitmapToCache(String url, Bitmap bitmap) {
        this.nobleEmotionBitmaps.put(url, bitmap);
    }
}

