/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.livebizwrapper.chatscreen.parser;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.text.Spannable;
import com.yy.mobile.config.BasicConfig;
import com.yy.mobile.image.ImageConfig;
import com.yy.mobile.imageloader.ImageLoader;
import com.yy.mobile.livebizwrapper.chatscreen.parser.ChatEmotion;
import com.yy.mobile.livebizwrapper.chatscreen.parser.NobleEmotionParser;
import com.yy.mobile.richtext.BaseRichTextFilter;
import com.yy.mobile.ui.widget.CustomImageSpan;
import com.yy.mobile.util.DimenConverter;
import com.yy.mobile.util.log.MLog;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class NobleEmotionFilter
extends BaseRichTextFilter {
    private Pattern mPattern = Pattern.compile("#\\d{2}");
    private int height = DimenConverter.dip2px((Context)BasicConfig.getInstance().getAppContext(), (float)23.0f);
    private ImageConfig imageConfig = new ImageConfig(ImageConfig.ImagePrecision.Big.getWidth(), ImageConfig.ImagePrecision.Big.getHeight());

    public void strToEmotion(Spannable spannable) {
        Matcher matcher = this.mPattern.matcher((CharSequence)spannable);
        List<ChatEmotion> chatEmotions = NobleEmotionParser.getInstance().getChatEmotions();
        while (matcher.find()) {
            Bitmap bitmap;
            BitmapDrawable bitmapDrawable;
            ChatEmotion chatEmotion = this.getNobleEmotion(chatEmotions, matcher.group());
            if (chatEmotion == null) continue;
            final String uri = chatEmotion.getUrlPngMob();
            if (MLog.isLogLevelAboveDebug()) {
                MLog.debug((String)"NobleEmotionFilter", (String)("uri = " + uri + " matcher.group() = " + matcher.group()));
            }
            BitmapDrawable bitmapDrawable2 = bitmapDrawable = (bitmap = NobleEmotionParser.getInstance().getNobleBitmapFromCache(uri)) == null ? null : new BitmapDrawable(bitmap);
            if (bitmapDrawable != null) {
                bitmapDrawable.setBounds(5, 0, bitmapDrawable.getIntrinsicWidth() * 3, bitmapDrawable.getIntrinsicHeight() * 3);
                CustomImageSpan imageSpan = new CustomImageSpan((Drawable)bitmapDrawable, 2.0f);
                spannable.setSpan((Object)imageSpan, matcher.start(), matcher.end(), 33);
                continue;
            }
            if (MLog.isLogLevelAboveDebug()) {
                MLog.debug((String)"NobleEmotionFilter", (String)(" download  uri = " + uri + " matcher.group() = " + matcher.group()));
            }
            ImageLoader.loadBitmap((Context)BasicConfig.getInstance().getAppContext(), (String)chatEmotion.getUrlPngMob(), (ImageLoader.BitmapLoadListener)new ImageLoader.BitmapLoadListener(){

                public void onLoadFailed(Exception e) {
                    MLog.info((String)"NobleEmotionFilter", (String)"NOBLE EMOTION DOWNLOAD ERROR!");
                }

                public void onResourceReady(Bitmap bitmap) {
                    NobleEmotionParser.getInstance().saveNobleEmotionBitmapToCache(uri, bitmap);
                }
            });
        }
    }

    private ChatEmotion getNobleEmotion(List<ChatEmotion> chatEmotions, String shortCut) {
        if (chatEmotions != null && chatEmotions.size() > 0 && shortCut != null) {
            for (ChatEmotion chatEmotion : chatEmotions) {
                if (!shortCut.equalsIgnoreCase(chatEmotion.getShortcut())) continue;
                return chatEmotion;
            }
        }
        return null;
    }

    public void parseSpannable(Context context, Spannable spannable, int maxWidth) {
        this.parseSpannable(context, spannable, maxWidth, null);
    }

    public void parseSpannable(Context context, Spannable spannable, int maxWidth, Object tag) {
        this.strToEmotion(spannable);
    }
}

