/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.livebizwrapper.chatscreen.model.channelmessage;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.text.style.ReplacementSpan;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.yy.mobile.util.ScreenUtil;

public class RoundBackgroundSpannable
extends ReplacementSpan {
    private int mBackgroundColor;
    private int mBackgroundRadius;

    public RoundBackgroundSpannable(int backgroundColor, int backgroundRadius) {
        this.mBackgroundColor = backgroundColor;
        this.mBackgroundRadius = backgroundRadius;
    }

    public int getSize(@NonNull Paint paint, CharSequence text, int start, int end, @Nullable Paint.FontMetricsInt fm) {
        return (int)paint.measureText(text, start, end) + ScreenUtil.getInstance().dip2px(20);
    }

    public void draw(@NonNull Canvas canvas, CharSequence text, int start, int end, float x, int top, int y, int bottom, @NonNull Paint paint) {
        int preColor = paint.getColor();
        paint.setColor(this.mBackgroundColor);
        paint.setTextSize((float)ScreenUtil.getInstance().sp2px(11.0f));
        int paddingStart = ScreenUtil.getInstance().dip2px(8);
        int marginStart = ScreenUtil.getInstance().dip2px(4);
        RectF rectF = new RectF(x + (float)marginStart, (float)top, x + (float)((int)paint.measureText(text, start, end)) + (float)(2 * paddingStart) + (float)marginStart, (float)bottom);
        canvas.drawRoundRect(rectF, (float)this.mBackgroundRadius, (float)this.mBackgroundRadius, paint);
        paint.setColor(-16777216);
        Paint.FontMetrics fontMetrics = paint.getFontMetrics();
        float textTop = fontMetrics.top;
        float textBottom = fontMetrics.bottom;
        float baseLineY = rectF.centerY() - textTop / 2.0f - textBottom / 2.0f;
        canvas.drawText(text, start, end, x + (float)paddingStart + (float)marginStart, baseLineY, paint);
        paint.setColor(preColor);
    }
}

