/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.livebizwrapper.chatscreen.model.channelmessage;

import android.app.Activity;
import android.graphics.Color;
import android.text.TextPaint;
import android.text.TextUtils;
import android.text.style.ClickableSpan;
import android.view.View;
import androidx.annotation.NonNull;
import com.duowan.mobile.basemedia.api.channel.ChannelApi;
import com.yy.hiidostatis.defs.obj.Property;
import com.yy.mobile.endorsementgroup.EndorsementGroupData;
import com.yy.mobile.endorsementgroup.EndorsementGroupStatistic;
import com.yy.mobile.util.FP;
import com.yy.mobile.util.log.MLog;
import com.yy.mobile.ylink.bridge.CoreApiManager;
import com.yy.mobile.ylink.bridge.coreapi.NavigationUtilApi;
import com.yymobile.core.CoreFactory;
import com.yymobile.core.EnvUriSetting;
import com.yymobile.core.channel.ChannelMessage;
import com.yymobile.core.mobilelive.IMobileLiveCore;
import com.yymobile.core.user.IUserCore;
import com.yymobile.core.user.UserInfo;
import java.io.Serializable;

public class NickClickableNewSpan
extends ClickableSpan {
    private static final String TAG = "NickClickableNewSpan";
    private ChannelMessage info;
    private int nickSpanColor = Color.parseColor((String)ChannelMessage.nickColor);

    public NickClickableNewSpan(ChannelMessage info, int nickSpanColor) {
        this.info = info;
        this.nickSpanColor = nickSpanColor;
    }

    public void onClick(@NonNull View widget) {
        if (this.info != null) {
            if (NickClickableNewSpan.isOtherChannelMessage(this.info.sid)) {
                MLog.info((String)TAG, (String)"click other channel userName return");
                return;
            }
            boolean isOnLive = ((IMobileLiveCore)CoreFactory.getCore(IMobileLiveCore.class)).isLoginUserMobileLive();
            Property property = new Property();
            property.putString("key5", String.valueOf(this.info.uid));
            property.putString("key1", String.valueOf(this.info.aid));
            property.putString("key2", String.valueOf(isOnLive ? 0 : 1));
            property.putString("key3", String.valueOf(this.info.shareRank));
            property.putString("key4", String.valueOf(this.info.effectFansNum));
            if (!TextUtils.isEmpty((CharSequence)this.info.text) && this.info.text.contains("\u5206\u4eab\u4e86\u8be5\u76f4\u64ad\u5230")) {
                EndorsementGroupStatistic.Companion.shareRunningWaterClick((Serializable)property);
            } else {
                EndorsementGroupStatistic.Companion.runningWaterClick((Serializable)property);
            }
            MLog.info((Object)TAG, (String)"#click rankUrl: %s", (Object[])new Object[]{this.getRankUrl()});
            ((NavigationUtilApi)CoreApiManager.getInstance().getApi(NavigationUtilApi.class)).toJSSupportedWebView((Activity)widget.getContext(), this.getRankUrl());
        }
    }

    public void updateDrawState(TextPaint ds) {
        super.updateDrawState(ds);
        ds.setColor(this.nickSpanColor);
        ds.setUnderlineText(false);
    }

    public static boolean isOtherChannelMessage(long sid) {
        return ChannelApi.Factory.get().getSubscribedMutiChannelSSidList().contains(sid);
    }

    private String getRankUrl() {
        StringBuilder rankSb = new StringBuilder();
        if (EnvUriSetting.getUriSetting() == EnvUriSetting.Test) {
            rankSb.append("https://webtest.yy.com/bringfans_sy201912/index.html?aid=");
        } else {
            rankSb.append("https://web.yy.com/bringfans_sy201912/index.html?aid=");
        }
        rankSb.append(EndorsementGroupData.Companion.getCurrentTopMicId());
        String nickName = EndorsementGroupData.Companion.getNick();
        if (TextUtils.isEmpty((CharSequence)nickName)) {
            nickName = this.getNickName(EndorsementGroupData.Companion.getCurrentTopMicId());
        }
        if (!TextUtils.isEmpty((CharSequence)nickName)) {
            rankSb.append("&nick=");
            rankSb.append(nickName);
        }
        return rankSb.toString();
    }

    private String getNickName(long uid) {
        UserInfo userInfo = ((IUserCore)CoreFactory.getCore(IUserCore.class)).getCacheUserInfoByUid(uid);
        if (userInfo == null) {
            ((IUserCore)CoreFactory.getCore(IUserCore.class)).requestDetailUserInfo(uid, true);
            return "";
        }
        if (!FP.empty((CharSequence)userInfo.reserve1)) {
            return userInfo.reserve1;
        }
        if (!FP.empty((CharSequence)userInfo.nickName)) {
            if (userInfo.nickName.length() > 12) {
                return userInfo.nickName.substring(0, 12);
            }
            return userInfo.nickName;
        }
        return "";
    }
}

