/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.livebizwrapper.chatscreen.model.channelmessage;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.text.SpannableString;
import android.text.SpannableStringBuilder;
import android.widget.TextView;
import com.yy.mobile.image.ImageConfig;
import com.yy.mobile.imageloader.ImageLoader;
import com.yy.mobile.imageloader.ImageUtil;
import com.yy.mobile.livebizwrapper.R;
import com.yy.mobile.livebizwrapper.chatscreen.PublicMessageHelper;
import com.yy.mobile.ui.widget.CustomImageSpan;
import com.yy.mobile.util.DontProguardClass;
import com.yy.mobile.util.FP;
import com.yy.mobile.util.ResolutionUtils;
import com.yy.mobile.util.log.MLog;
import com.yymobile.core.channel.ChannelMessage;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@DontProguardClass
public class GiftChannelMessage
extends ChannelMessage {
    private static final String TAG = "GiftChannelMessage";
    public GiftType type;
    public int giftTypeId;
    public String medalUrl;
    public String giftName = "";
    public String toName;
    public long toId;
    public Map<String, String> additional;
    public int nickSpanColor;
    public int giftNumber;
    public int giftComboNumber;
    public boolean isneighborGift = false;

    public GiftChannelMessage(GiftType type) {
        this.type = type;
    }

    public GiftChannelMessage(GiftType type, String medalUrl) {
        this.type = type;
        this.medalUrl = medalUrl;
    }

    public GiftChannelMessage() {
    }

    public GiftChannelMessage(GiftChannelMessage giftMsg) {
        super((ChannelMessage)giftMsg);
        this.type = giftMsg.type;
        this.toId = giftMsg.toId;
        this.toName = giftMsg.toName;
        this.additional = giftMsg.additional;
        this.giftNumber = giftMsg.giftNumber;
        this.giftComboNumber = giftMsg.giftComboNumber;
        this.isneighborGift = giftMsg.isneighborGift;
    }

    public void loadMedal(Context context, SpannableString sp, int defalutImgResId, int width, int height) {
        if (FP.empty((CharSequence)this.medalUrl)) {
            return;
        }
        ImageLoader.preloadBitmap((String)this.medalUrl, (ImageConfig)ImageConfig.fullImageConfig(), (int)defalutImgResId);
        BitmapDrawable medalDrawable = ImageLoader.getBitmapFromCache((String)this.medalUrl, (ImageConfig)ImageConfig.fullImageConfig());
        if (medalDrawable == null) {
            medalDrawable = ImageUtil.getBitmapDrawableFromResource((int)width, (int)height, (int)defalutImgResId);
        }
        int newWtich = (int)ResolutionUtils.convertDpToPixel((float)50.5f, (Context)context);
        int newHeight = (int)ResolutionUtils.convertDpToPixel((float)21.5f, (Context)context);
        medalDrawable.setBounds(0, 0, newWtich, newHeight);
        sp.setSpan((Object)new CustomImageSpan((Drawable)medalDrawable, 2.0f), 0, 1, 33);
    }

    public SpannableStringBuilder getSpannableString(Context context, int loadingImgResId, int defaultXZ, int width, int height) {
        return this.getSpannableString(context, 0, loadingImgResId, defaultXZ, width, height);
    }

    public SpannableStringBuilder getSpannableString(Context context, int nobleImgResId, int loadingImgResId, int defaultXZ, int width, int height) {
        if (FP.empty((CharSequence)this.text)) {
            return null;
        }
        SpannableStringBuilder sp = new SpannableStringBuilder((CharSequence)this.text);
        Pattern p = Pattern.compile("\\{\\d+\\}");
        Matcher m = p.matcher(this.text);
        while (m.find()) {
            BitmapDrawable giftDrawable;
            if (m.start() + 1 >= m.end() - 1) continue;
            int type = Integer.parseInt(this.text.substring(m.start() + 1, m.end() - 1));
            String giftIconUrl = PublicMessageHelper.getGiftIconPathFromGiftConfigParser(type);
            if (!FP.empty((CharSequence)giftIconUrl)) {
                ImageLoader.preloadBitmap((String)giftIconUrl, (ImageConfig)ImageConfig.smallImageConfig(), (int)loadingImgResId);
            }
            if ((giftDrawable = ImageLoader.getBitmapFromCache((String)(giftIconUrl + "" + width + ":" + height))) == null) {
                giftDrawable = ImageLoader.getBitmapFromCache((String)giftIconUrl, (ImageConfig)ImageConfig.smallImageConfig());
                if (giftDrawable == null || giftDrawable.getBitmap() == null || giftDrawable.getBitmap().isRecycled()) {
                    giftDrawable = ImageLoader.getBitmapFromCache((String)(loadingImgResId + "" + width + ":" + height));
                    if (giftDrawable == null) {
                        BitmapFactory.Options options = new BitmapFactory.Options();
                        options.inJustDecodeBounds = true;
                        options.inPreferredConfig = Bitmap.Config.RGB_565;
                        options.inSampleSize = ImageUtil.calculateInSampleSize((BitmapFactory.Options)options, (int)width, (int)height);
                        options.inJustDecodeBounds = false;
                        giftDrawable = new BitmapDrawable(context.getResources(), BitmapFactory.decodeResource((Resources)context.getResources(), (int)loadingImgResId, (BitmapFactory.Options)options));
                        ImageLoader.addBitmapToCache((String)(loadingImgResId + "" + width + ":" + height), (BitmapDrawable)giftDrawable);
                    }
                } else {
                    Bitmap bitmap = giftDrawable.getBitmap();
                    if (bitmap != null && !bitmap.isRecycled()) {
                        bitmap = Bitmap.createScaledBitmap((Bitmap)bitmap, (int)width, (int)height, (boolean)true);
                        giftDrawable = new BitmapDrawable(context.getResources(), bitmap);
                        ImageLoader.addBitmapToCache((String)(giftIconUrl + "" + width + ":" + height), (BitmapDrawable)giftDrawable);
                    } else {
                        if (MLog.isLogLevelAboveDebug()) {
                            MLog.debug((String)TAG, (String)(" recycle() giftIconUrl = " + giftIconUrl));
                        }
                        giftDrawable = ImageUtil.getBitmapDrawableFromResource((int)loadingImgResId, (ImageConfig)ImageConfig.smallImageConfig());
                    }
                }
            }
            giftDrawable.setBounds(0, 0, width, height);
            sp.setSpan((Object)new CustomImageSpan((Drawable)giftDrawable, 2, ResolutionUtils.convertDpToPixel((float)4.0f, (Context)context), 0.0f), m.start(), m.end(), 33);
        }
        return sp;
    }

    public String toString() {
        return "GiftChannelMessage{type=" + (Object)((Object)this.type) + ", giftTypeId=" + this.giftTypeId + ", medalUrl='" + this.medalUrl + '\'' + ", giftName='" + this.giftName + '\'' + ", nickSpanColor='" + this.nickSpanColor + '\'' + '}' + super.toString();
    }

    public ChannelMessage getInstanceCopy() {
        GiftChannelMessage giftChannelMessage = new GiftChannelMessage(this);
        giftChannelMessage.giftTypeId = this.giftTypeId;
        giftChannelMessage.medalUrl = this.medalUrl;
        giftChannelMessage.giftName = this.giftName;
        giftChannelMessage.additional = this.additional;
        giftChannelMessage.isReplay = this.isReplay;
        return giftChannelMessage;
    }

    public void decorateMsgBgStyle(Context context, TextView msgTv) {
        msgTv.setPadding((int)ResolutionUtils.convertDpToPixel((float)6.0f, (Context)context), (int)ResolutionUtils.convertDpToPixel((float)2.0f, (Context)context), (int)ResolutionUtils.convertDpToPixel((float)6.0f, (Context)context), (int)ResolutionUtils.convertDpToPixel((float)2.0f, (Context)context));
        this.setGifMessageBg(this, msgTv);
    }

    protected void setGifMessageBg(ChannelMessage msg, TextView tv) {
        GiftChannelMessage message = (GiftChannelMessage)msg;
        if (!FP.empty(message.additional) && !FP.empty((CharSequence)message.additional.get("gift_template_type"))) {
            String type = message.additional.get("gift_template_type");
            int color2 = 441961578;
            if ("6".equals(type)) {
                color2 = 452046147;
            } else if ("7".equals(type)) {
                color2 = 441961578;
            }
            tv.setBackgroundColor(color2);
        } else {
            tv.setBackgroundResource(R.drawable.public_chat_gift_message_bg);
        }
    }

    public static enum GiftType {
        FreeGift,
        PaidGift,
        ComboGift,
        UnionGift;

    }
}

