/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.livebizwrapper.chatscreen.model.channelmessage;

import android.util.LruCache;
import com.duowan.mobile.basemedia.api.channel.basechannel.PublicChatFilterStatisticSampling;
import com.yy.mobile.livebizwrapper.chatscreen.model.channelmessage.EnterChannelMessage;
import com.yy.mobile.livebizwrapper.chatscreen.model.channelmessage.FlowerChinneMessage;
import com.yy.mobile.livebizwrapper.chatscreen.model.channelmessage.GiftChannelMessage;
import com.yy.mobile.livebizwrapper.chatscreen.model.channelmessage.HistoryPublicChatMessage;
import com.yy.mobile.livebizwrapper.chatscreen.model.channelmessage.NobleChannelMessage;
import com.yy.mobile.livebizwrapper.chatscreen.model.channelmessage.NobleHonorChangeWithoutGiftMessage;
import com.yy.mobile.livebizwrapper.chatscreen.model.channelmessage.NobleLevelUpgradeChannelMessage;
import com.yy.mobile.util.log.MLog;
import com.yymobile.core.channel.ChannelMessage;
import com.yymobile.core.channel.NoticeMessage;

public class ChannelMsgRecvFilter {
    private static final String TAG = "ChannelMsgRecvFilter";
    public static final int MAX_UID_SIZE = 200;
    public static final int MAX_PUNISH_RATIO = 16;
    private MyLruCache mCachedMsgList = new MyLruCache(200);

    public boolean filter(ChannelMessage channelMsg, int interval) {
        if (channelMsg == null || interval == 0 || this.isSpecialMessage(channelMsg)) {
            return false;
        }
        Message msg = (Message)this.mCachedMsgList.get(channelMsg.uid);
        if (msg == null) {
            msg = new Message();
            msg.uid = channelMsg.uid;
            msg.timeStamp = this.getTime();
            msg.punishRatio = 1;
            this.mCachedMsgList.put(msg.uid, msg);
            return false;
        }
        long diff = this.getTime() - msg.timeStamp;
        if (diff < (long)(interval * 1000 * msg.punishRatio)) {
            MLog.warn((String)TAG, (String)("filter msg:" + msg + ", text:" + channelMsg.text + ", interval:" + interval + ", cachedSize:" + this.mCachedMsgList.size()));
            msg.punishRatio *= 2;
            msg.punishRatio = Math.min(msg.punishRatio, 16);
            PublicChatFilterStatisticSampling.getInstance().addSpeakGap(msg.uid);
            return true;
        }
        msg.timeStamp = this.getTime();
        msg.punishRatio = 1;
        this.mCachedMsgList.put(msg.uid, msg);
        return false;
    }

    private boolean isSpecialMessage(ChannelMessage channelMsg) {
        return channelMsg instanceof FlowerChinneMessage || channelMsg instanceof GiftChannelMessage || channelMsg instanceof NobleChannelMessage || channelMsg instanceof NobleLevelUpgradeChannelMessage || channelMsg instanceof NoticeMessage || channelMsg instanceof EnterChannelMessage || channelMsg instanceof HistoryPublicChatMessage || channelMsg instanceof NobleHonorChangeWithoutGiftMessage || !channelMsg.channelMessageType.equals((Object)ChannelMessage.ChannelMsgType.COMMON_MESSAGE_TYPE);
    }

    public void clear() {
        this.mCachedMsgList.evictAll();
    }

    private long getTime() {
        return System.currentTimeMillis();
    }

    private class MyLruCache
    extends LruCache<Long, Message> {
        MyLruCache(int maxSize) {
            super(maxSize);
        }

        protected int sizeOf(Long key, Message value) {
            return 1;
        }
    }

    public static class Message {
        public long timeStamp;
        public long uid;
        public int punishRatio = 1;

        public String toString() {
            return "Message{timeStamp=" + this.timeStamp + ", uid=" + this.uid + ", punishRatio=" + this.punishRatio + '}';
        }
    }
}

