/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.livebizwrapper.chatscreen.model;

import android.content.Context;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.text.Spannable;
import android.text.SpannableStringBuilder;
import android.text.style.ClickableSpan;
import android.text.style.ForegroundColorSpan;
import android.text.style.ImageSpan;
import android.view.View;
import androidx.core.content.ContextCompat;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.yy.mobile.config.BasicConfig;
import com.yy.mobile.livebasebiz.IChatScreenDiversity;
import com.yy.mobile.livebizwrapper.R;
import com.yy.mobile.livebizwrapper.chatscreen.model.ParserUtil;
import com.yy.mobile.livebizwrapper.chatscreen.model.TinyVideoEnterInfo;
import com.yy.mobile.livebizwrapper.chatscreen.model.channelmessage.EnterChannelMessage;
import com.yy.mobile.livebizwrapper.chatscreen.model.channelmessage.NickClickableSpan;
import com.yy.mobile.livebizwrapper.chatscreen.parser.PublicChatBaseParser;
import com.yy.mobile.ui.widget.CustomImageSpan;
import com.yy.mobile.util.ResolutionUtils;
import com.yy.mobile.util.log.MLog;
import com.yymobile.core.CoreFactory;
import com.yymobile.core.ICoreManagerBase;
import com.yymobile.core.channel.ChannelMessage;
import com.yymobile.core.mobilelive.IMobileLiveCore;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\tH\u0002J\u0010\u0010\n\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\tH\u0002J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\u0006H\u0002J\u0010\u0010\r\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\tH\u0002J\u0010\u0010\u000e\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\u0006H\u0002J\u0010\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\tH\u0002J\u0018\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002\u00a8\u0006\u0012"}, d2={"Lcom/yy/mobile/livebizwrapper/chatscreen/model/PublicChatParser;", "Lcom/yy/mobile/livebizwrapper/chatscreen/parser/PublicChatBaseParser;", "()V", "parse", "", "message", "Lcom/yymobile/core/channel/ChannelMessage;", "parseChatRoomEnterMessage", "", "Lcom/yy/mobile/livebizwrapper/chatscreen/model/channelmessage/EnterChannelMessage;", "parseChatRoomMessage", "parseEnterMessage", "msg", "parseExposureCardMessage", "parseTinyVideoEnter", "parseZhuiKanMessage", "resource", "Landroid/graphics/drawable/Drawable;", "livebizwrapper_release"})
public class PublicChatParser
extends PublicChatBaseParser {
    @Override
    public boolean parse(@NotNull ChannelMessage message) {
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        if (message instanceof EnterChannelMessage) {
            if (((IChatScreenDiversity)ICoreManagerBase.getCore(IChatScreenDiversity.class)).enableAsyncEnterChannelMessage()) {
                if (ParserUtil.isTinyVideoEnter(message)) {
                    this.parseTinyVideoEnter(message);
                } else if (!ParserUtil.isAsyncContentFlow(message)) {
                    if (ParserUtil.isFromChatRoomEnter(message)) {
                        MLog.info((String)"[\u804a\u5929\u5ba4]", (String)"[xyj][parse]\u516c\u5c4f\u6d88\u606f");
                        this.parseChatRoomEnterMessage((EnterChannelMessage)message);
                    } else if (ParserUtil.isComeFromChatRoom(message)) {
                        this.parseChatRoomMessage((EnterChannelMessage)message);
                    } else if (ParserUtil.isComeFromZhuiKan(message)) {
                        Object object = CoreFactory.getCore(IMobileLiveCore.class);
                        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"CoreFactory.getCore(IMobileLiveCore::class.java)");
                        if (((IMobileLiveCore)object).isLoginUserMobileLive()) {
                            MLog.info((String)"[\u8ffd\u770b]", (String)"[xyj][parse]\u516c\u5c4f\u6d88\u606f->\u662f\u4e3b\u64ad\u5728\u5f00\u64ad");
                            this.parseZhuiKanMessage((EnterChannelMessage)message);
                        } else {
                            MLog.info((String)"[\u8ffd\u770b]", (String)"[xyj][parse]\u516c\u5c4f\u6d88\u606f->\u662f\u4e3b\u64ad\u672a\u5f00\u64ad");
                        }
                    } else if (ParserUtil.isExposureCardEnter(message)) {
                        Object object = CoreFactory.getCore(IMobileLiveCore.class);
                        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"CoreFactory.getCore(IMobileLiveCore::class.java)");
                        if (((IMobileLiveCore)object).isLoginUserMobileLive()) {
                            MLog.info((String)"[exposureCard]", (String)"\u516c\u5c4f\u6d88\u606f->\u662f\u4e3b\u64ad\u5728\u5f00\u64ad");
                            this.parseExposureCardMessage((EnterChannelMessage)message);
                        } else {
                            MLog.info((String)"[exposureCard]", (String)"\u516c\u5c4f\u6d88\u606f->\u662f\u4e3b\u64ad\u672a\u5f00\u64ad");
                            this.parseEnterMessage(message);
                        }
                    } else {
                        this.parseEnterMessage(message);
                    }
                }
            } else {
                this.parseEnterMessage(message);
            }
        }
        return super.parse(message);
    }

    private final void parseTinyVideoEnter(ChannelMessage msg) {
        block2: {
            String fromTinyVideoEnter = (String)msg.tailMap.get("fromTinyVideoEnter");
            TinyVideoEnterInfo tinyVideoEnterInfo = null;
            try {
                Gson gson = new GsonBuilder().create();
                tinyVideoEnterInfo = (TinyVideoEnterInfo)gson.fromJson(fromTinyVideoEnter, TinyVideoEnterInfo.class);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            TinyVideoEnterInfo tinyVideoEnterInfo2 = tinyVideoEnterInfo;
            if (tinyVideoEnterInfo2 == null) break block2;
            TinyVideoEnterInfo tinyVideoEnterInfo3 = tinyVideoEnterInfo2;
            boolean bl = false;
            boolean bl2 = false;
            TinyVideoEnterInfo it = tinyVideoEnterInfo3;
            boolean bl3 = false;
            ParserUtil.appendChannelMessageForTinyVideoEnter(msg, tinyVideoEnterInfo, this.mContext);
        }
    }

    private final void parseEnterMessage(ChannelMessage msg) {
        msg.spannable = (Spannable)ParserUtil.generateEnterSpannable(msg);
    }

    private final void parseChatRoomEnterMessage(EnterChannelMessage message) {
        String nickname = message.nickname;
        String title = " \u901a\u8fc7\u804a\u5929\u5ba4\u8fdb\u5165";
        String text = nickname + title;
        SpannableStringBuilder spannable = new SpannableStringBuilder((CharSequence)text);
        String string2 = spannable.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"spannable.toString()");
        CharSequence charSequence = string2;
        String string3 = message.nickname;
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"message.nickname");
        int start = StringsKt.indexOf$default((CharSequence)charSequence, (String)string3, (int)0, (boolean)false, (int)6, null);
        int end = start + message.nickname.length();
        if (start >= 0 && end <= spannable.toString().length()) {
            spannable.setSpan((Object)new NickClickableSpan(true, message.uid, (String)message.tailMap.get("hdid"), this.isOtherChannelMessage(message.sid)), start, end, 33);
        }
        spannable.setSpan((Object)new ForegroundColorSpan(Color.parseColor((String)ChannelMessage.nickColor)), start, end, 33);
        spannable.setSpan((Object)new ForegroundColorSpan(Color.parseColor((String)ChannelMessage.giftTxtColor)), end, spannable.length(), 33);
        message.spannable = (Spannable)spannable;
    }

    private final void parseChatRoomMessage(EnterChannelMessage message) {
        String nickname = message.nickname;
        String title = " \u901a\u8fc7[icon]\u8fdb\u5165\u76f4\u64ad\u95f4";
        String text = nickname + title;
        SpannableStringBuilder spannable = new SpannableStringBuilder((CharSequence)text);
        String string2 = spannable.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"spannable.toString()");
        CharSequence charSequence = string2;
        String string3 = message.nickname;
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"message.nickname");
        int start = StringsKt.indexOf$default((CharSequence)charSequence, (String)string3, (int)0, (boolean)false, (int)6, null);
        int end = start + message.nickname.length();
        if (start >= 0 && end <= spannable.toString().length()) {
            spannable.setSpan((Object)new NickClickableSpan(true, message.uid, (String)message.tailMap.get("hdid"), this.isOtherChannelMessage(message.sid)), start, end, 33);
        }
        spannable.setSpan((Object)new ForegroundColorSpan(Color.parseColor((String)ChannelMessage.nickColor)), start, spannable.length(), 33);
        String string4 = spannable.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"spannable.toString()");
        start = StringsKt.indexOf$default((CharSequence)string4, (String)"[icon]", (int)0, (boolean)false, (int)6, null);
        spannable.setSpan((Object)new ClickableSpan(){

            public void onClick(@NotNull View widget) {
                Intrinsics.checkParameterIsNotNull((Object)widget, (String)"widget");
            }
        }, start, start + "[icon]".length(), 34);
        BasicConfig basicConfig = BasicConfig.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)basicConfig, (String)"BasicConfig.getInstance()");
        spannable.setSpan((Object)new ImageSpan(basicConfig.getAppContext(), R.drawable.chat_room), start, start + "[icon]".length(), 34);
        message.spannable = (Spannable)spannable;
    }

    private final void parseZhuiKanMessage(EnterChannelMessage message) {
        block0: {
            Drawable resource;
            BasicConfig basicConfig = BasicConfig.getInstance();
            Intrinsics.checkExpressionValueIsNotNull((Object)basicConfig, (String)"BasicConfig.getInstance()");
            Drawable drawable2 = resource = ContextCompat.getDrawable((Context)basicConfig.getAppContext(), (int)R.drawable.icon_zhuikan);
            if (drawable2 == null) break block0;
            Drawable drawable3 = drawable2;
            boolean bl = false;
            boolean bl2 = false;
            Drawable it = drawable3;
            boolean bl3 = false;
            this.parseZhuiKanMessage(message, it);
        }
    }

    private final void parseZhuiKanMessage(EnterChannelMessage message, Drawable resource) {
        String nickname = message.nickname;
        String title = " \u901a\u8fc7[icon]\u8fdb\u5165\u76f4\u64ad\u95f4";
        String text = nickname + title;
        SpannableStringBuilder spannable = new SpannableStringBuilder((CharSequence)text);
        String string2 = spannable.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"spannable.toString()");
        CharSequence charSequence = string2;
        String string3 = message.nickname;
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"message.nickname");
        int start = StringsKt.indexOf$default((CharSequence)charSequence, (String)string3, (int)0, (boolean)false, (int)6, null);
        int end = start + message.nickname.length();
        if (start >= 0 && end <= spannable.toString().length()) {
            spannable.setSpan((Object)new NickClickableSpan(true, message.uid, (String)message.tailMap.get("hdid"), this.isOtherChannelMessage(message.sid)), start, end, 33);
        }
        spannable.setSpan((Object)new ForegroundColorSpan(Color.parseColor((String)ChannelMessage.nickColor)), start, end, 33);
        spannable.setSpan((Object)new ForegroundColorSpan(Color.parseColor((String)ChannelMessage.nickColor)), end, spannable.length(), 33);
        String string4 = spannable.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"spannable.toString()");
        start = StringsKt.indexOf$default((CharSequence)string4, (String)"[icon]", (int)0, (boolean)false, (int)6, null);
        BasicConfig basicConfig = BasicConfig.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)basicConfig, (String)"BasicConfig.getInstance()");
        int n = (int)ResolutionUtils.convertDpToPixel((float)55.0f, (Context)basicConfig.getAppContext());
        BasicConfig basicConfig2 = BasicConfig.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)basicConfig2, (String)"BasicConfig.getInstance()");
        resource.setBounds(0, 0, n, (int)ResolutionUtils.convertDpToPixel((float)16.0f, (Context)basicConfig2.getAppContext()));
        BasicConfig basicConfig3 = BasicConfig.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)basicConfig3, (String)"BasicConfig.getInstance()");
        float f = ResolutionUtils.convertDpToPixel((float)4.0f, (Context)basicConfig3.getAppContext());
        BasicConfig basicConfig4 = BasicConfig.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)basicConfig4, (String)"BasicConfig.getInstance()");
        spannable.setSpan((Object)new CustomImageSpan(resource, 2, f, ResolutionUtils.convertDpToPixel((float)4.0f, (Context)basicConfig4.getAppContext())), start, start + "[icon]".length(), 33);
        message.spannable = (Spannable)spannable;
    }

    private final void parseExposureCardMessage(EnterChannelMessage message) {
        String nickname = message.nickname;
        String title = " \u901a\u8fc7[icon]\u8fdb\u5165\u76f4\u64ad\u95f4";
        String text = nickname + title;
        SpannableStringBuilder spannable = new SpannableStringBuilder((CharSequence)text);
        String string2 = spannable.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"spannable.toString()");
        CharSequence charSequence = string2;
        String string3 = message.nickname;
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"message.nickname");
        int start = StringsKt.indexOf$default((CharSequence)charSequence, (String)string3, (int)0, (boolean)false, (int)6, null);
        int end = start + message.nickname.length();
        if (message.uid != 0L && start >= 0 && end <= spannable.toString().length()) {
            spannable.setSpan((Object)new NickClickableSpan(true, message.uid, (String)message.tailMap.get("hdid"), this.isOtherChannelMessage(message.sid)), start, end, 33);
        }
        spannable.setSpan((Object)new ForegroundColorSpan(Color.parseColor((String)ChannelMessage.nickColor)), start, end, 33);
        spannable.setSpan((Object)new ForegroundColorSpan(Color.parseColor((String)ChannelMessage.nickColor)), end, spannable.length(), 33);
        String string4 = spannable.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"spannable.toString()");
        start = StringsKt.indexOf$default((CharSequence)string4, (String)"[icon]", (int)0, (boolean)false, (int)6, null);
        BasicConfig basicConfig = BasicConfig.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)basicConfig, (String)"BasicConfig.getInstance()");
        spannable.setSpan((Object)new ImageSpan(basicConfig.getAppContext(), R.drawable.icon_exposure_card), start, start + "[icon]".length(), 34);
        message.spannable = (Spannable)spannable;
    }
}

