/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.livebizwrapper.chatscreen.model;

import android.content.Context;
import android.content.res.Resources;
import com.duowan.mobile.basemedia.api.LiveRoomRxBus;
import com.duowan.mobile.basemedia.api.channel.ChannelApi;
import com.duowan.mobile.livebasebiz.privatechat.IChatEmotionCore;
import com.yy.android.sniper.api.event.EventCompat;
import com.yy.mobile.config.BasicConfig;
import com.yy.mobile.livebasebiz.IChatScreenDiversity;
import com.yy.mobile.livebizwrapper.chatscreen.IPublicScreenDataObserver;
import com.yy.mobile.livebizwrapper.chatscreen.PublicMessageHelper;
import com.yy.mobile.livebizwrapper.chatscreen.model.ParserUtil;
import com.yy.mobile.livebizwrapper.chatscreen.model.PublicChatBaseModel;
import com.yy.mobile.livebizwrapper.chatscreen.model.PublicChatEventReceiver;
import com.yy.mobile.livebizwrapper.chatscreen.model.PublicChatParser;
import com.yy.mobile.livebizwrapper.chatscreen.model.PublicChatSettingPref;
import com.yy.mobile.livebizwrapper.chatscreen.model.PublicChatStatisticUtils;
import com.yy.mobile.livebizwrapper.chatscreen.model.TailManager;
import com.yy.mobile.livebizwrapper.chatscreen.model.channelmessage.EnterChannelMessage;
import com.yy.mobile.livebizwrapper.chatscreen.model.channelmessage.HistoryPublicChatMessage;
import com.yy.mobile.livebizwrapper.chatscreen.model.channelmessage.MergeChannelMessage;
import com.yy.mobile.livebizwrapper.chatscreen.model.channelmessage.MergeMessageManager;
import com.yy.mobile.livebizwrapper.chatscreen.parser.PublicChatBaseParser;
import com.yy.mobile.plugin.main.events.IChannelLinkClient_onJoinChannelSuccess_EventArgs;
import com.yy.mobile.richtext.ChannelAirTicketParser;
import com.yy.mobile.richtext.ChannelTicketFilter;
import com.yy.mobile.richtext.ChannelTicketInfo;
import com.yy.mobile.sdkwrapper.yylive.event.ReceiveChannelHistoryMsgEventArgs;
import com.yy.mobile.util.FP;
import com.yy.mobile.util.RxUtils;
import com.yy.mobile.util.StringUtils;
import com.yy.mobile.util.log.MLog;
import com.yymobile.core.CoreFactory;
import com.yymobile.core.ICoreManagerBase;
import com.yymobile.core.channel.ChannelMessage;
import com.yymobile.core.channel.IPublicChatConfig;
import com.yymobile.core.channel.PublicChatMessage;
import com.yymobile.core.mobilelive.IMobileLiveCore;
import com.yymobile.core.truelove.TrueLoveMessage;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.annotations.NonNull;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.Consumer;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class PublicChatLiveModel
extends PublicChatBaseModel
implements EventCompat {
    private static final String TAG = "PublicChatLiveModel";
    private String tinyVideoResInfo = null;
    private String from = null;
    private Disposable mHistoryEventDisposable;
    private boolean needRequestHistoryMsg = true;
    private boolean isFirstAddedNoticeMessage = false;
    private long mCurrentSSid = 0L;
    private PublicChatSettingPref settingPref = new PublicChatSettingPref();
    private PublicChatEventReceiver publicChatEventReceiver = new PublicChatEventReceiver();
    private MergeMessageManager enterMergeManager = new MergeMessageManager();

    @Override
    protected PublicChatBaseParser onCreateParser() {
        return new PublicChatParser();
    }

    @Override
    public void onCreate(Context context, IPublicScreenDataObserver observer) {
        super.onCreate(context, observer);
        this.settingPref.onCreate();
        this.publicChatEventReceiver.onCreate(this.parseManager);
        MLog.info((String)TAG, (String)"onCreate initMessage");
        this.initMessage(true);
    }

    private void initMessage(boolean isOnCreate) {
        ChannelApi channelLinkCore = ChannelApi.Factory.get();
        if (isOnCreate) {
            if (this.parseManager != null) {
                this.parseManager.clearPreData();
                this.enterMergeManager.onCreate(this.parseManager);
                this.addOfficialNoticeMessage();
                this.isFirstAddedNoticeMessage = true;
            }
        } else if (!this.isFirstAddedNoticeMessage) {
            this.enterMergeManager.onCreate(this.parseManager);
            this.addOfficialNoticeMessage();
        } else {
            this.isFirstAddedNoticeMessage = false;
            MLog.info((String)TAG, (String)"not the first to joinChannelSuccess");
        }
        if (channelLinkCore == null || this.mCurrentSSid == channelLinkCore.getCurrentChannelInfo().subSid) {
            MLog.warn((String)TAG, (String)("this sid has initMessage: " + this.mCurrentSSid));
            return;
        }
        this.mCurrentSSid = channelLinkCore.getCurrentChannelInfo().subSid;
        MLog.info((String)TAG, (String)("initMessage SSid = " + this.mCurrentSSid));
        this.requestHistoryMsgAndSendEnterMsg();
    }

    private void addOfficialNoticeMessage() {
        IChatScreenDiversity screenDiversity = (IChatScreenDiversity)ICoreManagerBase.getCore(IChatScreenDiversity.class);
        if (screenDiversity != null) {
            String msg = screenDiversity.createAgreementMessage();
            MLog.debug((String)TAG, (String)("createAgreementMessage =" + msg));
            if (!StringUtils.isNullOrEmpty((String)msg)) {
                this.parseManager.add((ChannelMessage)this.createAgreementMessage(msg));
            }
        }
        this.parseManager.add((ChannelMessage)this.createRuleNoticeMessage());
        this.parseManager.add((ChannelMessage)this.createSafeNoticeMessage());
    }

    private void requestHistoryMsgAndSendEnterMsg() {
        if (!this.needRequestHistoryMsg) {
            return;
        }
        String templateId = ChannelApi.Factory.get().getTemplateId();
        if (!"0".equals(templateId)) {
            this.enterChannelTextRequest();
        }
        this.requestHistoryMsg();
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        MLog.info((String)TAG, (String)"onDestroy");
        this.mCurrentSSid = 0L;
        this.isFirstAddedNoticeMessage = false;
        RxUtils.dispose((Disposable)this.mHistoryEventDisposable);
        this.tinyVideoResInfo = null;
        this.from = null;
        this.settingPref.onDestroy();
        this.publicChatEventReceiver.onDestroy();
        this.enterMergeManager.onDestroy();
    }

    @Override
    public boolean onInterceptBeforeShow(ChannelMessage message) {
        if (message instanceof EnterChannelMessage && ParserUtil.isNormalEnter(message)) {
            boolean mergeSuccess = this.enterMergeManager.mergeMessage(message, MergeChannelMessage.MergeMessageType.ENTER);
            return mergeSuccess;
        }
        if (message instanceof TrueLoveMessage) {
            return true;
        }
        if (ChannelTicketFilter.isChannelTicketMessage((CharSequence)message.text)) {
            ChannelTicketInfo info;
            List infos;
            Resources mRes;
            boolean isPortrait = false;
            Context mCtx = BasicConfig.getInstance().getAppContext();
            if (mCtx != null && mCtx.getResources() != null && (mRes = mCtx.getResources()) != null && mRes.getConfiguration().orientation == 1) {
                isPortrait = true;
            }
            if (isPortrait && (infos = ChannelAirTicketParser.parseChannelTicket((String)message.text)) != null && !infos.isEmpty() && (info = (ChannelTicketInfo)infos.get(0)) != null) {
                PublicChatStatisticUtils.reportChatAirTicketExposure(info.sid);
            }
        }
        if (message instanceof PublicChatMessage) {
            PublicMessageHelper.onReceivePublicChatMessage(this.supportFollowUp(), (PublicChatMessage)message);
        }
        return super.onInterceptBeforeShow(message);
    }

    protected boolean supportFollowUp() {
        return true;
    }

    @Override
    public boolean onInterceptBeforeParse(@NotNull ChannelMessage message) {
        if (message == null || message.text == null) {
            return true;
        }
        return message.onInterceptBeforeParse((IPublicChatConfig)this.settingPref);
    }

    @Override
    public void onJoinChannelSuccess(IChannelLinkClient_onJoinChannelSuccess_EventArgs event) {
        MLog.info((String)TAG, (String)"onJoinChannelSuccess  initMessage");
        this.initMessage(event.getChangeSubChannel());
    }

    @Override
    public void onLeaveCurrentChannel() {
        this.isFirstAddedNoticeMessage = false;
        this.mCurrentSSid = 0L;
        if (this.mHistoryEventDisposable != null && !this.mHistoryEventDisposable.isDisposed()) {
            this.mHistoryEventDisposable.dispose();
        }
        this.enterMergeManager.onDestroy();
        this.tinyVideoResInfo = null;
        this.from = null;
    }

    private boolean isMobileLive() {
        return ((IMobileLiveCore)CoreFactory.getCore(IMobileLiveCore.class)).isLoginUserMobileLive(true);
    }

    private void enterChannelTextRequest() {
        if (!((IMobileLiveCore)CoreFactory.getCore(IMobileLiveCore.class)).isLoginUserMobileLive()) {
            HashMap extendInfo = ChannelApi.Factory.get().getExtendInfo();
            if (this.tinyVideoResInfo == null && extendInfo.containsKey("TinyVideoData")) {
                this.tinyVideoResInfo = (String)extendInfo.get("TinyVideoData");
                extendInfo.remove("TinyVideoData");
            }
            if (this.from == null && extendInfo.containsKey("channel_from")) {
                this.from = (String)extendInfo.get("channel_from");
            }
            PublicMessageHelper.enterChannelTextRequest(TailManager.getInstatnce().isSongPrivilegeChannel() ? "\u70b9\u6b4c\u7279\u6743\u7528\u6237\uff0c\u6b22\u8fce\u6765\u5230\u76f4\u64ad\u95f4" : null, this.tinyVideoResInfo, this.from);
        }
    }

    protected void requestHistoryMsg() {
        ChannelApi channelLinkCore = ChannelApi.Factory.get();
        if (channelLinkCore == null) {
            MLog.warn((String)TAG, (String)"channelLinkCore is null ");
            return;
        }
        IChatEmotionCore chatEmotionCore = (IChatEmotionCore)CoreFactory.getCore(IChatEmotionCore.class);
        if (chatEmotionCore != null) {
            chatEmotionCore.requestHistoryMsg(channelLinkCore.getCurrentChannelInfo().topSid, channelLinkCore.getCurrentChannelInfo().subSid);
            MLog.info((String)TAG, (String)("request history SSid = " + this.mCurrentSSid));
            this.subscribeHistoryEvent();
        }
    }

    private void subscribeHistoryEvent() {
        if (this.mHistoryEventDisposable != null && !this.mHistoryEventDisposable.isDisposed()) {
            return;
        }
        this.mHistoryEventDisposable = LiveRoomRxBus.getInstance().register(ReceiveChannelHistoryMsgEventArgs.class).observeOn(AndroidSchedulers.mainThread()).subscribe((Consumer)new Consumer<ReceiveChannelHistoryMsgEventArgs>(){

            public void accept(@NonNull ReceiveChannelHistoryMsgEventArgs receiveChannelMsgEventArgs) throws Exception {
                if (FP.empty((Collection)receiveChannelMsgEventArgs.historyTexts)) {
                    return;
                }
                MLog.debug((String)PublicChatLiveModel.TAG, (String)"on ReceiveChannelHistoryMsgEventArgs");
                for (ReceiveChannelHistoryMsgEventArgs.MsgTextChat msgTextChat : receiveChannelMsgEventArgs.historyTexts) {
                    HistoryPublicChatMessage message = new HistoryPublicChatMessage();
                    message.uid = msgTextChat.uid;
                    message.sid = msgTextChat.sid;
                    message.nickname = msgTextChat.nickname;
                    message.text = msgTextChat.text;
                    PublicChatLiveModel.this.parseManager.add((ChannelMessage)message);
                }
            }
        }, RxUtils.errorConsumer((String)TAG, (String)"ReceiveChannelHistoryMsgEventArgs error"));
    }
}

