/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.livebizwrapper.chatscreen.model;

import android.content.Context;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.text.SpannableStringBuilder;
import android.text.TextUtils;
import android.text.style.ForegroundColorSpan;
import androidx.annotation.NonNull;
import com.duowan.mobile.basemedia.api.channel.ChannelApi;
import com.duowan.mobile.basemedia.api.template.ViewingRoomApi;
import com.duowan.mobile.basemedia.watchlive.template.BaseViewScene;
import com.duowan.mobile.livebasebiz.events.IChannelLinkClient_onAppendChannelMsg_EventArgs;
import com.duowan.mobile.livebasebiz.utils.StringUtil;
import com.yy.android.sniper.annotation.inject.BusEvent;
import com.yy.android.sniper.api.event.EmptyEventCompat;
import com.yy.android.sniper.api.event.EventBinder;
import com.yy.datacenter.LiveRoomDataCenter;
import com.yy.datacenter.LiveRoomDataState;
import com.yy.ent.mobile.memeda.domain.mobile.pb.nano.PersonalInfoCardPro;
import com.yy.mobile.bizmodel.login.LoginUtil;
import com.yy.mobile.config.BasicConfig;
import com.yy.mobile.livebizwrapper.R;
import com.yy.mobile.livebizwrapper.chatscreen.event.INewGameReminder_EventArgs;
import com.yy.mobile.livebizwrapper.chatscreen.model.ParserUtil;
import com.yy.mobile.livebizwrapper.chatscreen.model.PublicChatEventReceiver$$EventBinder;
import com.yy.mobile.livebizwrapper.chatscreen.model.channelmessage.NewGameReminderMessage;
import com.yy.mobile.livebizwrapper.chatscreen.model.channelmessage.NickClickableSpan;
import com.yy.mobile.livebizwrapper.chatscreen.parser.PublicChatParseManager;
import com.yy.mobile.plugin.main.events.IChannelLinkClient_updateCurrentChannelMessage_EventArgs;
import com.yy.mobile.ui.utils.DimensUtils;
import com.yy.mobile.ui.widget.CustomImageSpan;
import com.yy.mobile.util.log.MLog;
import com.yymobile.core.CoreFactory;
import com.yymobile.core.basechannel.SessOnText;
import com.yymobile.core.channel.ChannelMessage;
import com.yymobile.core.channel.NoticeMessage;
import com.yymobile.core.channel.PublicChatMessage;
import com.yymobile.core.mobilelive.IMobileLiveCore;

public final class PublicChatEventReceiver
extends EmptyEventCompat {
    private static final String TAG = "PublicChatEventReceiver";
    private final int dp2 = DimensUtils.dip2pixel((Context)BasicConfig.getInstance().getAppContext(), (float)2.0f);
    private PublicChatParseManager parseManager;
    private EventBinder mEventBinder;

    public void onCreate(PublicChatParseManager parseManager) {
        MLog.debug((String)TAG, (String)"PublicChatEventReceiver onCreate");
        this.onEventBind();
        this.parseManager = parseManager;
    }

    public void onDestroy() {
        MLog.debug((String)TAG, (String)"PublicChatEventReceiver onDestroy");
        this.onEventUnBind();
    }

    private void appendMsg(ChannelMessage message) {
        if (this.parseManager != null) {
            this.parseManager.add(message);
        }
    }

    @BusEvent
    public void updateCurrentChannelMessage(IChannelLinkClient_updateCurrentChannelMessage_EventArgs busEventArgs) {
        SessOnText sessOnText = busEventArgs.getEtSessOnText();
        MLog.debug((String)TAG, (String)("updateCurrentChannelMessage:" + sessOnText.text));
        PublicChatMessage message = new PublicChatMessage();
        message.uid = sessOnText.uid;
        message.sid = sessOnText.subSid;
        message.nickname = sessOnText.nickname;
        message.text = sessOnText.text;
        this.appendMsg(message.getInstanceCopy());
    }

    @BusEvent
    public void onReceiveNewGameReminderMsg(INewGameReminder_EventArgs eventArgs) {
        MLog.debug((String)TAG, (String)("onReceiveNewGameReminderMsg:" + eventArgs));
        if (!PublicChatEventReceiver.isMyselfAnchor()) {
            return;
        }
        NewGameReminderMessage newGameReminderMessage = new NewGameReminderMessage();
        newGameReminderMessage.sid = ChannelApi.Factory.get().getCurrentChannelInfo().subSid;
        newGameReminderMessage.mNewGameReminderInfo = eventArgs.mNewGameReminderInfo;
        newGameReminderMessage.mClickableSpan = eventArgs.mClickableSpan;
        newGameReminderMessage.build();
        this.appendMsg(newGameReminderMessage);
    }

    private static boolean isMyselfAnchor() {
        return ChannelApi.Factory.get().getCurrentTopMicId() == LoginUtil.getUid();
    }

    @BusEvent
    public void onAppendChannelMsg(IChannelLinkClient_onAppendChannelMsg_EventArgs busEventArgs) {
        ChannelMessage message = busEventArgs.getMessage();
        MLog.debug((String)TAG, (String)(" onAppendChannelMsg = " + message + "   " + ((Object)((Object)this)).hashCode()));
        this.appendMsg(message.getInstanceCopy());
    }

    @BusEvent
    public void onReceiveChannelMsg(PersonalInfoCardPro.ChannelPubMsgBroadcast channelPubMsg) {
        if (null == channelPubMsg) {
            return;
        }
        MLog.debug((String)TAG, (String)("onReceiveChannelMsg:" + channelPubMsg.nick));
        NoticeMessage noticeMessage = new NoticeMessage();
        String type = channelPubMsg.type;
        if (TextUtils.equals((CharSequence)type, (CharSequence)"memeda")) {
            noticeMessage.spannable = this.getMemedaMsg(channelPubMsg);
        } else if (TextUtils.equals((CharSequence)type, (CharSequence)"chok")) {
            noticeMessage.spannable = this.getChokMsg(channelPubMsg);
        } else if (TextUtils.equals((CharSequence)type, (CharSequence)"micUp")) {
            noticeMessage.spannable = this.getMicUpMsg(channelPubMsg);
        }
        noticeMessage.channelMessageType = ChannelMessage.ChannelMsgType.CUSTOMS_MESSAGE_TYPE;
        noticeMessage.uid = channelPubMsg.uid;
        noticeMessage.sid = channelPubMsg.sid;
        noticeMessage.nickname = channelPubMsg.nick;
        noticeMessage.text = channelPubMsg.type;
        noticeMessage.priority = 3;
        this.appendMsg(noticeMessage.getInstanceCopy());
    }

    private SpannableStringBuilder getMicUpMsg(@NonNull PersonalInfoCardPro.ChannelPubMsgBroadcast channelPubMsg) {
        String nick = StringUtil.cutOffString((String)channelPubMsg.nick, (int)10);
        String text = nick + " \u88ab\u62b1\u4e0a\u4e86\u9ea6\u5e8f";
        SpannableStringBuilder spannable = new SpannableStringBuilder((CharSequence)text);
        int lastIndexOf = text.lastIndexOf(nick);
        if (lastIndexOf >= 0 && lastIndexOf + nick.length() < spannable.length()) {
            spannable.setSpan((Object)new NickClickableSpan(true, channelPubMsg.uid, null, this.isOtherChannelMessage(channelPubMsg.sid)), lastIndexOf, lastIndexOf + nick.length(), 33);
        }
        spannable.setSpan((Object)new ForegroundColorSpan(Color.parseColor((String)ChannelMessage.noticeColor)), 0, spannable.length(), 33);
        return spannable;
    }

    private SpannableStringBuilder getChokMsg(@NonNull PersonalInfoCardPro.ChannelPubMsgBroadcast channelPubMsg) {
        String nick = StringUtil.cutOffString((String)channelPubMsg.nick, (int)10);
        String chokDesc = "[chok]";
        String text = ((IMobileLiveCore)CoreFactory.getCore(IMobileLiveCore.class)).isLoginUserMobileLive() || this.isVoiceRoomAnchor() ? "\u4f60\u6233\u4e86" + chokDesc + nick + "\u4e00\u4e0b" : "\u4e3b\u64ad\u6233\u4e86" + chokDesc + nick + "\u4e00\u4e0b";
        SpannableStringBuilder spannable = new SpannableStringBuilder((CharSequence)text);
        int lastIndexOf = text.lastIndexOf(nick);
        if (lastIndexOf >= 0 && lastIndexOf + nick.length() < spannable.length()) {
            spannable.setSpan((Object)new NickClickableSpan(true, channelPubMsg.uid, null, this.isOtherChannelMessage(channelPubMsg.sid)), lastIndexOf, lastIndexOf + nick.length(), 33);
        }
        spannable.setSpan((Object)new ForegroundColorSpan(Color.parseColor((String)ChannelMessage.nickColor)), 0, spannable.length(), 33);
        Drawable drawable2 = ParserUtil.createBusinessIconDrawable(R.drawable.icon_liveroom_finger, 16, 16);
        if (null == drawable2) {
            return spannable;
        }
        int indexOf = text.indexOf(chokDesc);
        spannable.setSpan((Object)new CustomImageSpan(drawable2, 2, (float)this.dp2, (float)this.dp2), indexOf, indexOf + chokDesc.length(), 33);
        return spannable;
    }

    private SpannableStringBuilder getMemedaMsg(@NonNull PersonalInfoCardPro.ChannelPubMsgBroadcast channelPubMsg) {
        String nick = StringUtil.cutOffString((String)channelPubMsg.nick, (int)10);
        String memeDesc = "[memeda]";
        String text = ((IMobileLiveCore)CoreFactory.getCore(IMobileLiveCore.class)).isLoginUserMobileLive() || this.isVoiceRoomAnchor() ? "\u4f60\u7ed9 " + nick + " \u4e00\u4e2a\u4e48\u4e48\u54d2" + memeDesc : "\u4e3b\u64ad\u7ed9 " + nick + " \u4e00\u4e2a\u4e48\u4e48\u54d2" + memeDesc;
        SpannableStringBuilder spannable = new SpannableStringBuilder((CharSequence)text);
        int indexOf = text.lastIndexOf(nick);
        if (indexOf >= 0 && indexOf + nick.length() < spannable.length()) {
            spannable.setSpan((Object)new NickClickableSpan(true, channelPubMsg.uid, null, this.isOtherChannelMessage(channelPubMsg.sid)), indexOf, indexOf + nick.length(), 33);
        }
        spannable.setSpan((Object)new ForegroundColorSpan(Color.parseColor((String)ChannelMessage.nickColor)), 0, spannable.length(), 33);
        Drawable drawable2 = ParserUtil.createBusinessIconDrawable(R.drawable.icon_liveroom_lips, 16, 16);
        if (null == drawable2) {
            return spannable;
        }
        indexOf = text.indexOf(memeDesc);
        spannable.setSpan((Object)new CustomImageSpan(drawable2, 2, (float)this.dp2, (float)this.dp2), indexOf, indexOf + memeDesc.length(), 33);
        return spannable;
    }

    private boolean isOtherChannelMessage(long sid) {
        return ChannelApi.Factory.get().getSubscribedMutiChannelSSidList().contains(sid);
    }

    private boolean isVoiceRoomAnchor() {
        return ViewingRoomApi.Factory.get().getCurrentScene() == BaseViewScene.VOICEROOM && LoginUtil.getUid() == ((LiveRoomDataState)LiveRoomDataCenter.INSTANCE.getState()).getCurrentVoiceRoomOwnerUid();
    }

    public void onEventBind() {
        super.onEventBind();
        if (this.mEventBinder == null) {
            this.mEventBinder = new PublicChatEventReceiver$$EventBinder();
        }
        this.mEventBinder.bindEvent((Object)this);
    }

    public void onEventUnBind() {
        super.onEventUnBind();
        if (this.mEventBinder != null) {
            this.mEventBinder.unBindEvent();
        }
    }
}

