/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.livebizwrapper.chatscreen.model;

import android.content.Context;
import android.text.SpannableStringBuilder;
import android.text.style.ForegroundColorSpan;
import com.duowan.mobile.basemedia.api.channel.ChannelApi;
import com.duowan.mobile.basemedia.watchlive.event.OnJoinChannelSuccessForBaseMedia;
import com.duowan.mobile.livebasebiz.privatechat.IChatEmotionCore;
import com.yy.android.sniper.annotation.inject.BusEvent;
import com.yy.android.sniper.api.event.EmptyEventCompat;
import com.yy.android.sniper.api.event.EventBinder;
import com.yy.mobile.bizmodel.login.LoginUtil;
import com.yy.mobile.livebasebiz.IChatScreenDiversity;
import com.yy.mobile.livebizwrapper.R;
import com.yy.mobile.livebizwrapper.chatscreen.IPublicChatDataModel;
import com.yy.mobile.livebizwrapper.chatscreen.IPublicScreenDataObserver;
import com.yy.mobile.livebizwrapper.chatscreen.bean.EnterRuleNoticeMessage;
import com.yy.mobile.livebizwrapper.chatscreen.model.PublicChatBaseModel$$EventBinder;
import com.yy.mobile.livebizwrapper.chatscreen.parser.PublicChatBaseParser;
import com.yy.mobile.livebizwrapper.chatscreen.parser.PublicChatParseManager;
import com.yy.mobile.plugin.main.events.IChannelLinkClient_leaveCurrentChannel_EventArgs;
import com.yy.mobile.plugin.main.events.IChannelLinkClient_onJoinChannelSuccess_EventArgs;
import com.yy.mobile.util.log.MLog;
import com.yymobile.core.CoreFactory;
import com.yymobile.core.ICoreManagerBase;
import com.yymobile.core.channel.ChannelMessage;
import com.yymobile.core.channel.NoticeMessage;
import com.yymobile.core.channel.PublicChatMessage;
import com.yymobile.core.sensitivewords.ISensitiveWordsCore;
import io.reactivex.subjects.BehaviorSubject;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class PublicChatBaseModel
extends EmptyEventCompat
implements IPublicChatDataModel,
PublicChatParseManager.ParseListener {
    private static final String TAG = "PublicChatBaseModel";
    protected Context mContext;
    protected PublicChatParseManager parseManager;
    private PublicChatBaseParser parser;
    protected IPublicScreenDataObserver observer;
    private BehaviorSubject<Boolean> isPublicChatCreatedSubject = BehaviorSubject.createDefault((Object)false);
    private EventBinder mEventBinder;

    public PublicChatBaseModel() {
        this.parser = this.onCreateParser();
        this.parseManager = this.createParseManager();
    }

    public void setParser(PublicChatBaseParser parser) {
        if (parser != null) {
            this.parser = parser;
        }
    }

    public PublicChatBaseParser getParser() {
        return this.parser;
    }

    @NotNull
    protected PublicChatBaseParser onCreateParser() {
        return new PublicChatBaseParser();
    }

    private PublicChatParseManager createParseManager() {
        return new PublicChatParseManager();
    }

    @Override
    public void onCreate(Context context, IPublicScreenDataObserver observer) {
        MLog.info((String)TAG, (String)("Model onCreate" + this));
        this.onEventBind();
        this.mContext = context;
        this.parser.initModel(context);
        this.parseManager.addParseListener(this, this.parser);
        this.observer = observer;
        ((IChatEmotionCore)CoreFactory.getCore(IChatEmotionCore.class)).observeIsPublicChatCreated().onNext((Object)true);
    }

    @Override
    public void onDestroy() {
        MLog.info((String)TAG, (String)("Model onDestroy" + this));
        ((IChatEmotionCore)CoreFactory.getCore(IChatEmotionCore.class)).observeIsPublicChatCreated().onNext((Object)false);
        this.onEventUnBind();
        this.parseManager.removeParseListener(this);
        this.parser.onDestroy();
    }

    @Override
    public boolean onInterceptBeforeParse(@NotNull ChannelMessage message) {
        this.onProcessBeforeParse(message);
        return false;
    }

    protected void onProcessBeforeParse(ChannelMessage message) {
        this.parser.decorateNickNameBeforeParse(message);
    }

    @Override
    public boolean onInterceptBeforeShow(ChannelMessage message) {
        this.checkSensitiveWordAndNotice(message);
        return false;
    }

    protected void onJoinChannelSuccess(IChannelLinkClient_onJoinChannelSuccess_EventArgs event) {
    }

    protected void onLeaveCurrentChannel() {
    }

    private void checkSensitiveWordAndNotice(ChannelMessage message) {
        if (this.isContainSensitiveWord(message)) {
            ChannelMessage notice = this.createNoticeMessage();
            this.parseManager.add(notice);
        }
    }

    private boolean isContainSensitiveWord(ChannelMessage message) {
        if (message.uid != LoginUtil.getUid() && message instanceof PublicChatMessage) {
            return ((ISensitiveWordsCore)CoreFactory.getCore(ISensitiveWordsCore.class)).containFinanceSensitiveWord(message.pureText);
        }
        return false;
    }

    private ChannelMessage createNoticeMessage() {
        NoticeMessage noticeMessage = new NoticeMessage();
        noticeMessage.channelMessageType = ChannelMessage.ChannelMsgType.NOTICE_MESSAGE_TYPE;
        String noticeMsg = "YY\u5b89\u5168\u63d0\u793a\uff1a\u5b98\u65b9\u65e0\u5145\u503c\u8fd4\u5229\u6d3b\u52a8\uff0c\u8bf7\u52ff\u8f7b\u4fe1\u4ed6\u4eba\uff0c\u8c28\u9632\u56e0\u5192\u5145\u4e3b\u64ad\u7ba1\u7406\u53d7\u9a97\u3002\u7559\u610f\u6700\u65b0\u8bc8\u9a97\u65b9\u5f0f\u3002";
        if (ICoreManagerBase.getCore(IChatScreenDiversity.class) != null) {
            noticeMsg = ((IChatScreenDiversity)ICoreManagerBase.getCore(IChatScreenDiversity.class)).createNoticeMessage();
        }
        noticeMessage.text = noticeMsg;
        int noticeMsgColor = this.mContext.getResources().getColor(R.color.biz_chat_screen_notice_message_color);
        SpannableStringBuilder spannable = new SpannableStringBuilder((CharSequence)noticeMessage.text);
        spannable.setSpan((Object)new ForegroundColorSpan(noticeMsgColor), 0, noticeMessage.text.length(), 33);
        noticeMessage.spannable = spannable;
        return noticeMessage;
    }

    protected NoticeMessage createAgreementMessage(String noticeMsg) {
        EnterRuleNoticeMessage message = new EnterRuleNoticeMessage();
        message.channelMessageType = ChannelMessage.ChannelMsgType.NOTICE_MESSAGE_TYPE;
        message.uid = 0L;
        message.sid = ChannelApi.Factory.get().getCurrentChannelInfo().topSid;
        message.text = noticeMsg;
        int noticeMsgColor = this.mContext.getResources().getColor(R.color.biz_chat_screen_notice_message_color);
        SpannableStringBuilder spannable = new SpannableStringBuilder((CharSequence)message.text);
        if (message.text.length() <= spannable.length()) {
            spannable.setSpan((Object)new ForegroundColorSpan(noticeMsgColor), 0, message.text.length(), 33);
        }
        message.spannable = spannable;
        return message;
    }

    protected NoticeMessage createSafeNoticeMessage() {
        EnterRuleNoticeMessage message = new EnterRuleNoticeMessage();
        message.channelMessageType = ChannelMessage.ChannelMsgType.NOTICE_MESSAGE_TYPE;
        message.uid = 0L;
        message.sid = ChannelApi.Factory.get().getCurrentChannelInfo().topSid;
        String noticeMsg = "YY\u5b89\u5168\u63d0\u793a\uff1a\u5b98\u65b9\u65e0\u5145\u503c\u8fd4\u5229\u6d3b\u52a8\uff0c\u8bf7\u52ff\u8f7b\u4fe1\u4ed6\u4eba\uff0c\u8c28\u9632\u56e0\u5192\u5145\u4e3b\u64ad\u7ba1\u7406\u53d7\u9a97\u3002\u7559\u610f\u6700\u65b0\u8bc8\u9a97\u65b9\u5f0f\u3002";
        if (ICoreManagerBase.getCore(IChatScreenDiversity.class) != null) {
            noticeMsg = ((IChatScreenDiversity)ICoreManagerBase.getCore(IChatScreenDiversity.class)).createSafeNoticeMessage();
        }
        message.text = noticeMsg;
        int noticeMsgColor = this.mContext.getResources().getColor(R.color.biz_chat_screen_notice_message_color);
        SpannableStringBuilder spannable = new SpannableStringBuilder((CharSequence)message.text);
        if (message.text.length() <= spannable.length()) {
            spannable.setSpan((Object)new ForegroundColorSpan(noticeMsgColor), 0, message.text.length(), 33);
        }
        message.spannable = spannable;
        return message;
    }

    protected NoticeMessage createRuleNoticeMessage() {
        EnterRuleNoticeMessage message = new EnterRuleNoticeMessage();
        message.channelMessageType = ChannelMessage.ChannelMsgType.NOTICE_MESSAGE_TYPE;
        message.uid = 0L;
        message.sid = ChannelApi.Factory.get().getCurrentChannelInfo().topSid;
        message.nickname = "";
        String noticeMsg = "YY\u5b89\u5168\u63d0\u793a\uff1a\u5bf9\u76f4\u64ad\u5185\u5bb9\u8fdb\u884c24\u5c0f\u65f6\u5728\u7ebf\u5de1\u67e5\u3002\u4efb\u4f55\u4f20\u64ad\u8fdd\u6cd5\u3001\u8fdd\u89c4\u3001\u4f4e\u4fd7\u3001\u66b4\u529b\u7b49\u4e0d\u826f\u4fe1\u606f\u5c06\u4f1a\u5c01\u505c\u8d26\u53f7\u3002";
        if (ICoreManagerBase.getCore(IChatScreenDiversity.class) != null) {
            noticeMsg = ((IChatScreenDiversity)ICoreManagerBase.getCore(IChatScreenDiversity.class)).createRuleNoticeMessage();
        }
        message.text = noticeMsg;
        int noticeMsgColor = this.mContext.getResources().getColor(R.color.biz_chat_screen_notice_message_color);
        SpannableStringBuilder spannable = new SpannableStringBuilder((CharSequence)message.text);
        if (message.text.length() <= spannable.length()) {
            spannable.setSpan((Object)new ForegroundColorSpan(noticeMsgColor), 0, message.text.length(), 33);
        }
        message.spannable = spannable;
        return message;
    }

    @BusEvent
    public final void onJoinChannelSuccess(OnJoinChannelSuccessForBaseMedia busEventArgs) {
        MLog.info((String)TAG, (String)"onJoinChannelSuccess");
        this.parseManager.onJoinChannelSuccess();
        this.onJoinChannelSuccess(busEventArgs.getEvent());
    }

    @BusEvent
    public final void leaveCurrentChannel(IChannelLinkClient_leaveCurrentChannel_EventArgs eventArgs) {
        MLog.info((String)TAG, (String)"onLeaveCurrentChannel");
        this.parseManager.onLeaveCurrentChannel();
        this.onLeaveCurrentChannel();
    }

    @Override
    public void onParseResult(@NotNull List<? extends ChannelMessage> messages) {
        if (this.observer != null) {
            this.observer.onNotify(messages);
        }
    }

    public void onEventBind() {
        super.onEventBind();
        if (this.mEventBinder == null) {
            this.mEventBinder = new PublicChatBaseModel$$EventBinder();
        }
        this.mEventBinder.bindEvent((Object)this);
    }

    public void onEventUnBind() {
        super.onEventUnBind();
        if (this.mEventBinder != null) {
            this.mEventBinder.unBindEvent();
        }
    }
}

