/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.livebizwrapper.chatscreen.model;

import android.content.Context;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.text.SpannableStringBuilder;
import android.text.TextUtils;
import android.text.style.ClickableSpan;
import android.text.style.ForegroundColorSpan;
import android.view.View;
import com.duowan.mobile.basemedia.api.channel.ChannelApi;
import com.duowan.mobile.basemedia.api.channel.ChannelLoginPowerApi;
import com.google.gson.Gson;
import com.yy.mobile.bizmodel.login.LoginUtil;
import com.yy.mobile.config.BasicConfig;
import com.yy.mobile.livebasebiz.IChatScreenDiversity;
import com.yy.mobile.livebizwrapper.R;
import com.yy.mobile.livebizwrapper.chatscreen.PublicMessageHelper;
import com.yy.mobile.livebizwrapper.chatscreen.model.TinyVideoEnterInfo;
import com.yy.mobile.livebizwrapper.chatscreen.model.channelmessage.EnterChannelMessage;
import com.yy.mobile.livebizwrapper.chatscreen.model.channelmessage.NickClickableSpan;
import com.yy.mobile.livebizwrapper.onepiece.OnepieceVipManager;
import com.yy.mobile.livebizwrapper.utils.LiveRoomLoadDrawableWrapper;
import com.yy.mobile.livebizwrapper.utils.PublicChatUtils;
import com.yy.mobile.ui.widget.CustomImageSpan;
import com.yy.mobile.util.FP;
import com.yy.mobile.util.ResolutionUtils;
import com.yy.mobile.util.log.MLog;
import com.yy.mobile.ylink.bridge.CoreApiManager;
import com.yy.mobile.ylink.bridge.coreapi.NavigationUtilApi;
import com.yymobile.core.CoreFactory;
import com.yymobile.core.ICoreManagerBase;
import com.yymobile.core.channel.ChannelMessage;
import com.yymobile.core.channel.ChatMedalInfo;
import com.yymobile.core.medal.MedalBaseEntry;
import com.yymobile.core.medal.MedalNobleEntry;
import com.yymobile.core.medal.MedalTailEntry;
import com.yymobile.core.mobilelive.IMobileLiveCore;
import com.yymobile.core.statistic.IHiidoStatisticCore;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public final class ParserUtil {
    private static final String TAG = "ParserUtil";
    private static int mMedalIconSize = (int)ResolutionUtils.convertDpToPixel((float)16.0f, (Context)BasicConfig.getInstance().getAppContext());

    public static void appendChannelMessageForTinyVideoEnter(ChannelMessage message, final TinyVideoEnterInfo tinyVideoEnterInfo, final Context mContext) {
        MedalNobleEntry entry;
        String nickname = message.nickname;
        String text = message.nickname + " \u901a\u8fc7" + "[tinyVideoIcon]" + "\u8fdb\u5165\u76f4\u64ad\u95f4";
        SpannableStringBuilder spannable = new SpannableStringBuilder((CharSequence)text);
        int lastIndexOf = text.lastIndexOf(nickname);
        if (lastIndexOf >= 0 && lastIndexOf + nickname.length() < spannable.length()) {
            spannable.setSpan((Object)new NickClickableSpan(true, message.uid, (String)message.tailMap.get("hdid"), ParserUtil.isOtherChannelMessage(message.sid)), lastIndexOf, lastIndexOf + nickname.length(), 33);
        }
        spannable.setSpan((Object)new ForegroundColorSpan(Color.parseColor((String)ChannelMessage.nickColor)), 0, spannable.length(), 33);
        HashMap entryMap = (HashMap)message.medalEntryList.get(100);
        if (entryMap != null && ((entry = (MedalNobleEntry)entryMap.get(1)).getNobleLevel() > 0 || entry.getActNobleType() > 0)) {
            Drawable nobleDrawable;
            int nobleLv = entry.getNobleLevel() == 0 ? entry.getActNobleType() : entry.getNobleLevel();
            int startIdx = text.indexOf("[noblelv]");
            if (startIdx > -1 && (nobleDrawable = LiveRoomLoadDrawableWrapper.INSTANCE.getDrawableWithCache(BasicConfig.getInstance().getAppContext(), PublicChatUtils.getPublicNobleMedalIcon(nobleLv))) != null) {
                if (ParserUtil.isShowIcon(message)) {
                    nobleDrawable.setBounds(0, 0, PublicChatUtils.nobleIconWidth, PublicChatUtils.nobleIconHeight);
                    spannable.setSpan((Object)new CustomImageSpan(nobleDrawable, 2, 0.0f, ResolutionUtils.convertDpToPixel((float)6.0f, (Context)BasicConfig.getInstance().getAppContext())), startIdx, startIdx + "[noblelv]".length(), 33);
                } else {
                    spannable.replace(startIdx, startIdx + "[noblelv]".length(), (CharSequence)"");
                }
            }
        }
        if (tinyVideoEnterInfo != null && tinyVideoEnterInfo.resId != 0L) {
            ((IHiidoStatisticCore)CoreFactory.getCore(IHiidoStatisticCore.class)).sendEventStatistic(LoginUtil.getUid(), "51035", "0001");
            int idx = spannable.toString().indexOf("[tinyVideoIcon]");
            if (idx > -1) {
                Drawable tinyVideoDrawable = LiveRoomLoadDrawableWrapper.INSTANCE.getDrawableWithCache(BasicConfig.getInstance().getAppContext(), R.drawable.chat_tiny_video_icon);
                if (tinyVideoDrawable != null) {
                    tinyVideoDrawable.setBounds(0, 0, (int)ResolutionUtils.convertDpToPixel((float)50.0f, (Context)BasicConfig.getInstance().getAppContext()), (int)ResolutionUtils.convertDpToPixel((float)16.0f, (Context)BasicConfig.getInstance().getAppContext()));
                }
                spannable.setSpan((Object)new ClickableSpan(){

                    public void onClick(View widget) {
                        if (!ChannelLoginPowerApi.Factory.get().isChannelOW() && !TextUtils.isEmpty((CharSequence)tinyVideoEnterInfo.dpi)) {
                            ((IHiidoStatisticCore)CoreFactory.getCore(IHiidoStatisticCore.class)).sendEventStatistic(LoginUtil.getUid(), "51035", "0002");
                            try {
                                float dpi;
                                if (tinyVideoEnterInfo.dpi.contains("\\*")) {
                                    dpi = ParserUtil.getRatio(tinyVideoEnterInfo.dpi);
                                } else {
                                    dpi = Float.parseFloat(tinyVideoEnterInfo.dpi);
                                    if (dpi > 2.0f) {
                                        dpi = 2.0f;
                                    } else if (dpi < 0.5f) {
                                        dpi = 0.5f;
                                    }
                                }
                                ((NavigationUtilApi)CoreApiManager.getInstance().getApi(NavigationUtilApi.class)).toShortVideoDisplayActivity(mContext, tinyVideoEnterInfo.resId, tinyVideoEnterInfo.videoUrl, dpi, tinyVideoEnterInfo.coverUrl, new HashMap());
                            }
                            catch (Throwable e) {
                                MLog.info((String)ParserUtil.TAG, (String)("tiny video click error: " + e.getMessage()));
                            }
                        }
                    }
                }, idx, idx + "[tinyVideoIcon]".length(), 33);
                spannable.setSpan((Object)new CustomImageSpan(tinyVideoDrawable, 2, ResolutionUtils.convertDpToPixel((float)5.0f, (Context)BasicConfig.getInstance().getAppContext()), ResolutionUtils.convertDpToPixel((float)5.0f, (Context)BasicConfig.getInstance().getAppContext())), idx, idx + "[tinyVideoIcon]".length(), 33);
            }
        }
        message.spannable = spannable;
    }

    public static float getRatio(String dpi) {
        try {
            String[] strings = dpi.split("\\*");
            float width = Float.parseFloat(strings[0]);
            float height = Float.parseFloat(strings[1]);
            float ratio = height / width;
            if (ratio > 2.0f) {
                ratio = 2.0f;
            } else if (ratio < 0.5f) {
                ratio = 0.5f;
            }
            return ratio;
        }
        catch (Throwable e) {
            return 0.75f;
        }
    }

    public static SpannableStringBuilder generateEnterSpannable(ChannelMessage info) {
        ChatMedalInfo medalInfo;
        int idx;
        String text = " \u6765\u4e86";
        if (info == null) {
            return new SpannableStringBuilder((CharSequence)text);
        }
        int medalWallMedalId = 0;
        StringBuilder nickname = new StringBuilder(info.nickname);
        for (Map.Entry entryPriority : info.medalEntryList.entrySet()) {
            HashMap medalsMap = (HashMap)entryPriority.getValue();
            for (Map.Entry entry : medalsMap.entrySet()) {
                MedalBaseEntry entity = (MedalBaseEntry)entry.getValue();
                if (entity.getParserType() != 5) continue;
                nickname.append(entity.getNote());
                medalWallMedalId = ((MedalTailEntry)entity).getUserMedalWallMaxPriorityId();
            }
        }
        text = nickname.append(text).toString();
        boolean isMatch = false;
        boolean isEndorsementGroup = info.isEndorsementGroup;
        MLog.debug((Object)TAG, (String)"#generateEnterSpannable isMatch = %s, isEndorsementGroup = %s, isHeatActMsg = %s", (Object[])new Object[]{isMatch, isEndorsementGroup, info.isHeatActMsg});
        String from = "";
        if (info.tailMap.containsKey("from")) {
            from = (String)info.tailMap.get("from");
        }
        if (String.valueOf(6).equals(from) && !isEndorsementGroup && ((IChatScreenDiversity)ICoreManagerBase.getCore(IChatScreenDiversity.class)).enableNearByEnterChannelMessage()) {
            text = "\u9644\u8fd1\u7684 " + text;
        }
        if (info.isHeatActMsg) {
            text = info.text;
        }
        SpannableStringBuilder spannable = new SpannableStringBuilder((CharSequence)text);
        int start = spannable.toString().indexOf(info.nickname);
        int end = start + info.nickname.length();
        if (start >= 0 && end <= spannable.toString().length()) {
            spannable.setSpan((Object)new NickClickableSpan(true, info.uid, (String)info.tailMap.get("hdid"), ParserUtil.isOtherChannelMessage(info.sid)), start, end, 33);
        }
        spannable.setSpan((Object)new ForegroundColorSpan(Color.parseColor((String)ChannelMessage.nickColor)), 0, spannable.length(), 33);
        if (medalWallMedalId > 0 && (idx = spannable.toString().indexOf("[knight]")) > -1) {
            Drawable songDrawable = PublicMessageHelper.getMedalDrawable(medalWallMedalId);
            int paddingLeft = PublicChatUtils.tailMarginLeft;
            int paddingRight = PublicChatUtils.tailMarginRight;
            if (songDrawable != null) {
                songDrawable.setBounds(0, 0, mMedalIconSize, mMedalIconSize);
            } else {
                paddingLeft = 0;
                paddingRight = 0;
                songDrawable = LiveRoomLoadDrawableWrapper.INSTANCE.getDrawableWithCache(BasicConfig.getInstance().getAppContext(), R.drawable.xunzhang_default_bitmap);
                if (songDrawable != null) {
                    songDrawable.setBounds(0, 0, 1, 1);
                }
            }
            spannable.setSpan((Object)new CustomImageSpan(songDrawable, 2, (float)paddingLeft, (float)paddingRight), idx, idx + "[knight]".length(), 33);
        }
        if ((medalInfo = OnepieceVipManager.getInstance().checkIsVip(info.uid)) != null) {
            String imgKey = medalInfo.imgKey;
            int imgId = PublicMessageHelper.getChatMedalImgId(imgKey);
            Drawable drawable2 = LiveRoomLoadDrawableWrapper.INSTANCE.getDrawableWithCache(BasicConfig.getInstance().getAppContext(), imgId);
            if (drawable2 != null) {
                drawable2.setBounds(0, 0, drawable2.getIntrinsicWidth(), drawable2.getIntrinsicHeight());
                SpannableStringBuilder span = new SpannableStringBuilder((CharSequence)("[" + imgKey + "]"));
                span.setSpan((Object)new CustomImageSpan(drawable2, 2, 0.0f, ResolutionUtils.convertDpToPixel((float)4.0f, (Context)BasicConfig.getInstance().getAppContext())), 0, span.length(), 33);
                spannable = span.append((CharSequence)spannable);
            }
        }
        MLog.debug((Object)TAG, (String)"#generateEnterSpannable spannable = %s", (Object[])new Object[]{spannable.toString()});
        return spannable;
    }

    public static Drawable createBusinessIconDrawable(int resId, int widthDp, int heightDp) {
        if (0 == resId || widthDp == 0 || heightDp == 0) {
            return null;
        }
        Drawable businessDrawable = LiveRoomLoadDrawableWrapper.INSTANCE.getDrawableWithCache(BasicConfig.getInstance().getAppContext(), resId);
        if (businessDrawable != null && widthDp > 0 && heightDp > 0) {
            businessDrawable.setBounds(0, 0, (int)ResolutionUtils.convertDpToPixel((float)widthDp, (Context)BasicConfig.getInstance().getAppContext()), (int)ResolutionUtils.convertDpToPixel((float)heightDp, (Context)BasicConfig.getInstance().getAppContext()));
        }
        return businessDrawable;
    }

    public static boolean isOtherChannelMessage(long sid) {
        return ChannelApi.Factory.get().getSubscribedMutiChannelSSidList().contains(sid);
    }

    public static boolean isShowIcon(ChannelMessage message) {
        return true;
    }

    public static boolean isNormalEnter(ChannelMessage message) {
        if (message instanceof EnterChannelMessage) {
            if (!FP.empty((Collection)message.tagsList) && ((IMobileLiveCore)CoreFactory.getCore(IMobileLiveCore.class)).isLoginUserLoveLive()) {
                return false;
            }
            if (ParserUtil.isTinyVideoEnter(message)) {
                return false;
            }
            if (ParserUtil.isFromSoundPlayEnter(message)) {
                return false;
            }
            if (ParserUtil.isEndorsementGroupEnter(message)) {
                return false;
            }
            return !ParserUtil.isComeFromChatRoom(message);
        }
        return false;
    }

    public static boolean isEndorsementGroupEnter(ChannelMessage msg) {
        MLog.debug((Object)TAG, (String)"#isEndorsementGroupEnter isEndorsementGroup = %s", (Object[])new Object[]{msg.isEndorsementGroup});
        return msg.isEndorsementGroup;
    }

    public static boolean isComeFromChatRoom(ChannelMessage msg) {
        String templateId = (String)msg.tailMap.get("templateId");
        return "99999998".equals(templateId);
    }

    public static boolean isComeFromZhuiKan(ChannelMessage msg) {
        String fromAppId = (String)msg.tailMap.get("fromAppId");
        return "yylite".equals(fromAppId);
    }

    public static boolean isTinyVideoEnter(ChannelMessage msg) {
        String fromTinyVideoEnter = (String)msg.tailMap.get("fromTinyVideoEnter");
        TinyVideoEnterInfo tinyVideoEnterInfo = null;
        try {
            Gson gson = new Gson();
            tinyVideoEnterInfo = (TinyVideoEnterInfo)gson.fromJson(fromTinyVideoEnter, TinyVideoEnterInfo.class);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return tinyVideoEnterInfo != null && tinyVideoEnterInfo.resId != 0L;
    }

    public static boolean isFromSoundPlayEnter(ChannelMessage msg) {
        String enterType = (String)msg.tailMap.get("from");
        return String.valueOf(21).equals(enterType);
    }

    public static boolean isFromChatRoomEnter(ChannelMessage msg) {
        String enterType = (String)msg.tailMap.get("from");
        return String.valueOf(108).equals(enterType);
    }

    public static boolean isExposureCardEnter(ChannelMessage msg) {
        String enterType = (String)msg.tailMap.get("from");
        return String.valueOf(110).equals(enterType);
    }

    public static boolean isAsyncContentFlow(ChannelMessage message) {
        String isAsyncContentFlow;
        if (message.tailMap.containsKey("isAsyncContentFlow") && (isAsyncContentFlow = (String)message.tailMap.get("isAsyncContentFlow")) != null && isAsyncContentFlow.equals("1")) {
            MLog.info((String)TAG, (String)("is async content flow, spannable: " + message.spannable));
            return true;
        }
        return false;
    }

    public static String fixXmlString(String string2) {
        if (string2 == null || string2.length() == 0) {
            return string2;
        }
        try {
            string2 = string2.replaceAll("&lt;", "<");
            string2 = string2.replaceAll("&gt;", ">");
            string2 = string2.replaceAll("&apos;", "'");
            string2 = string2.replaceAll("&quot;", "\"");
        }
        catch (Throwable throwable) {
            MLog.error((String)"XmlFilter", (String)("fixXmlString error!" + throwable));
        }
        return string2;
    }
}

